/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.fi.ssc.extpoint.disRebuild.IAfterDisService;
import kd.sdk.fi.ssc.extpoint.disRebuild.IDataPrepareService;
import kd.sdk.fi.ssc.extpoint.disRebuild.INotifyWfService;
import kd.sdk.fi.ssc.extpoint.disRebuild.IStateChangeService;
import kd.sdk.fi.ssc.extpoint.disRebuild.ITaskSaveService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTaskSourceEnum;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.exception.TaskErrorCodeEnum;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.task.business.service.credit.CreditDelayService;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.dis.ApplyCreditLevel;
import kd.ssc.task.dis.BillCusFilter;
import kd.ssc.task.dis.BillNumPersonPOJO;
import kd.ssc.task.dis.CreditDelayDis;
import kd.ssc.task.dis.CusDisRule;
import kd.ssc.task.dis.CusDisrulePojo;
import kd.ssc.task.dis.HisTaskDisRule;
import kd.ssc.task.dis.QulityJob;
import kd.ssc.task.dis.WorkLoad;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.disenum.DisExceptionEnum;
import kd.ssc.task.disRebuild.disenum.MatchRulePluginTypeEnum;
import kd.ssc.task.disRebuild.disenum.TaskAttributeEnum;
import kd.ssc.task.disRebuild.engine.Distribution4Ask;
import kd.ssc.task.disRebuild.engine.Distribution4DifferentSSC;
import kd.ssc.task.disRebuild.engine.Distribution4MonitorRetry;
import kd.ssc.task.disRebuild.engine.Distribution4Redist;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.pojo.ProxyPOJO;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.service.impl.after.IAfterDisServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.INotifyWfServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.IStateChangeServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.ITaskSaveServiceImpl;
import kd.ssc.task.disRebuild.service.impl.before.IDataPrepareServiceImpl;
import kd.ssc.task.disRebuild.util.DisExceptionUtil;
import kd.ssc.task.disRebuild.util.OtherUtil;
import kd.ssc.task.disRebuild.util.RobertUserGroupUtil;
import kd.ssc.task.dto.approve.DecisionResult;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.helper.MutexCacheHelper;
import kd.ssc.task.service.distask.WorkLoadService;

public class Distribution {
    private static final Log log = LogFactory.getLog(Distribution.class);
    private static final ThreadPool pool = ThreadPools.newFixedThreadPool((String)"SSC_Task_Distribution", (int)4);

    public static void autoDistribution(QFilter unDisFilter, DisTaskSourceEnum disTaskSource, boolean sync) {
        log.info("\u81ea\u52a8\u5206\u914d\u5f00\u59cb");
        long begin = System.currentTimeMillis();
        Map<Long, List<DynamicObject>> disTaskMap = Distribution.getSscUnDisTaskMap(unDisFilter, disTaskSource);
        long end = System.currentTimeMillis();
        log.info("\u81ea\u52a8\u5206\u914d\uff0c\u51c6\u5907\u6570\u636e\u65f6\u95f4\uff1a" + (end - begin));
        if (disTaskMap == null || disTaskMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> allTasks = new ArrayList<DynamicObject>();
        disTaskMap.forEach((k, v) -> allTasks.addAll((Collection<DynamicObject>)v));
        DisRequestCtx baseCtx = Distribution.constructDisRequestCtx4AutoDisBase(allTasks);
        try {
            for (Map.Entry<Long, List<DynamicObject>> entry : disTaskMap.entrySet()) {
                List<DynamicObject> unDisTaskList = entry.getValue();
                if (CollectionUtils.isEmpty(unDisTaskList)) continue;
                DisRequestCtx ctx = Distribution.constructDisRequestCtx4AutoDis(entry.getKey(), baseCtx);
                List<Long> taskIdSet = unDisTaskList.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
                Distribution4DifferentSSC distribution4DifferentSSC = new Distribution4DifferentSSC(entry.getKey(), ctx, taskIdSet);
                if (sync) {
                    distribution4DifferentSSC.run();
                    continue;
                }
                pool.execute((Runnable)distribution4DifferentSSC);
            }
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u5206\u914d\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u81ea\u52a8\u5206\u914d\u7ed3\u675f");
    }

    public static Map<Long, Set<Long>> manualDistribution(long disTaskId, DynamicObject[] rules, boolean isRectification, List<Long> errRuleDyns) {
        Map<Long, Set<Long>> rtn = Collections.emptyMap();
        try {
            DisRequestCtx ctx = Distribution.constructDisRequestCtx4ManualDis(disTaskId, rules);
            rtn = Distribution4Redist.matchAllRule4Single(ctx, disTaskId, isRectification, errRuleDyns);
        }
        catch (Throwable e) {
            DisExceptionUtil.saveMonitorException(disTaskId, DisTypeEnum.MANUAL_DIS, e);
        }
        return rtn;
    }

    public static List<Long> manualDisTaskDeal4Batch(Long userGroup, Long userId, List<DynamicObject> taskDynList) {
        ArrayList<Long> successTaskIds = new ArrayList<Long>(taskDynList.size());
        boolean isRobertGroup = UserGroupUtil.isRobotGroup(userGroup);
        ArrayList<DynamicObject> disTaskList = new ArrayList<DynamicObject>(16);
        ProxyPOJO proxy = new ProxyPOJO();
        for (DynamicObject task : taskDynList) {
            try {
                DynamicObject taskAllInfo = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)"task_task");
                boolean result = Distribution.manualDisTaskDeal4Single(userGroup, userId, taskAllInfo, isRobertGroup, proxy);
                if (!result) continue;
                successTaskIds.add((Long)task.getPkValue());
                disTaskList.add(taskAllInfo);
            }
            catch (Exception e) {
                long taskId = (Long)task.getPkValue();
                DisExceptionUtil.saveMonitorException(taskId, DisTypeEnum.MANUAL_DIS, e);
            }
        }
        OtherUtil.afterDisBatch(DisTypeEnum.MANUAL_DIS, disTaskList);
        return successTaskIds;
    }

    public static List<Long> trans2Redist(Map<Long, DecisionResult> taskDecisionResult) {
        ArrayList<Long> successTaskIds = new ArrayList<Long>(taskDecisionResult.size());
        try {
            Distribution.trans2Redistribute(taskDecisionResult, successTaskIds);
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u5ba1\u6838\u8f6c\u4eba\u5de5\u5206\u914d\u5931\u8d25", (Throwable)e);
        }
        return successTaskIds;
    }

    private static void trans2Redistribute(Map<Long, DecisionResult> taskDecisionResult, List<Long> successTaskIds) {
        Map<Long, DynamicObject> taskMap = Distribution.buildTaskMap(taskDecisionResult.keySet());
        if (taskMap.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> taskGroupBySSCMap = Distribution.buildTaskGroupBySSCMap(taskMap);
        for (Map.Entry<Long, List<DynamicObject>> entry : taskGroupBySSCMap.entrySet()) {
            Long sscid = entry.getKey();
            List<DynamicObject> taskList = entry.getValue();
            DisRequestCtx ctx = Distribution.constructDisRequestCtx4TransRedist(sscid, taskList);
            for (DynamicObject task : taskList) {
                Long taskId = (Long)task.getPkValue();
                String innerMsg = taskDecisionResult.get(taskId).getErrorInfo();
                if (!StringUtils.isEmpty((Object)innerMsg) && innerMsg.length() > 2000) {
                    innerMsg = innerMsg.substring(0, 2000);
                }
                task.set("innermsg", (Object)innerMsg);
                ctx.setDisTaskId(taskId);
                ctx.setDisTask(task);
                boolean result = Distribution4Redist.distribute4Single(ctx, taskId);
                if (!result) continue;
                successTaskIds.add(taskId);
            }
        }
    }

    public static List<Long> askTaskDistribution(Long userId, Long sscid, int taskNum) {
        return Distribution.askTaskDistribution(userId, sscid, null, taskNum);
    }

    public static List<Long> askTaskDistribution(Long userId, Long sscid, QFilter taskExtFilter, int taskNum) {
        long begin = System.currentTimeMillis();
        List<DynamicObject> allTaskIds = Distribution.getAllTask(sscid, taskExtFilter);
        DisRequestCtx ctx = Distribution.constructDisRequestCtx4AskTask(userId, sscid, allTaskIds);
        long end = System.currentTimeMillis();
        log.info("\u4e3b\u52a8\u83b7\u53d6\uff0c\u5f53\u524d\u64cd\u4f5c\u7684\u7528\u6237\uff1a" + userId + " \u6ee1\u8db3\u6761\u4ef6\u7684\u4efb\u52a1\u6570\uff1a" + allTaskIds.size() + " \u6570\u636e\u6784\u5efa\u65f6\u95f4\uff1a" + (end - begin));
        return Distribution4Ask.distribute4GivenUser(ctx, allTaskIds.stream().map(t -> (Long)t.getPkValue()).collect(Collectors.toList()), taskNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean manualDisTaskDeal4Single(Long userGroupId, Long userId, DynamicObject task, boolean isRobertGroup, ProxyPOJO proxy) {
        long taskId = (Long)task.getPkValue();
        boolean locked = Distribution.getLock(taskId);
        if (!locked) {
            throw new KDException(new ErrorCode(DisExceptionEnum.SYNCHRONIZEDERROR.getCode(), Distribution.getSyncError(taskId)), new Object[0]);
        }
        try {
            Map<String, Object> oldState = Distribution.transDyn(userGroupId, userId, task, isRobertGroup);
            Distribution.notifyWf(task, proxy);
            Distribution.saveTask(task, proxy);
            Distribution.stateChange(task, oldState, proxy);
            Distribution.afterDisSingle(task, proxy);
        }
        finally {
            Distribution.releaseLock(taskId);
        }
        return true;
    }

    public static boolean retryDistribution(long taskId, int disType) {
        DisRequestCtx ctx;
        DynamicObject disTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
        ArrayList<DynamicObject> allTasks = new ArrayList<DynamicObject>(8);
        allTasks.add(disTask);
        long sscId = disTask.getLong("sscid.id");
        if (DisTypeEnum.AUTO_DIS.getValue() == disType) {
            DisRequestCtx baseCtx = Distribution.constructDisRequestCtx4AutoDisBase(allTasks);
            ctx = Distribution.constructDisRequestCtx4AutoDis((Long)sscId, baseCtx);
        } else if (DisTypeEnum.NOPASS_DIS.getValue() == disType) {
            ctx = Distribution.constructDisRequestCtx4TransRedist(sscId, allTasks);
        } else {
            return false;
        }
        ctx.setDisTaskId(taskId);
        ctx.setDisTask(disTask);
        return Distribution4MonitorRetry.distribute4Single(ctx, taskId);
    }

    private static String getBizError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u914d\u5f02\u5e38\uff0c\u4efb\u52a1id\uff1a%s", (String)"CoreDistributionSyncWrapper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private static String getNotExistBizError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5f85\u5206\u914d\u4efb\u52a1\uff0c\u4efb\u52a1id\uff1a%s", (String)"Distribution_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private static String getNotExistRuleError() {
        return ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9002\u5408\u5f53\u524d\u7528\u6237\u7684\u5206\u914d\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u5206\u914d\u89c4\u5219\u8bbe\u7f6e", (String)"Distribution_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
    }

    private static void afterDisSingle(DynamicObject task, ProxyPOJO proxy) {
        PluginProxy pluginProxy = proxy.getAdPluginProxy();
        if (pluginProxy == null) {
            IAfterDisServiceImpl iAfterDisService = new IAfterDisServiceImpl();
            pluginProxy = PluginProxy.create((Object)iAfterDisService, IAfterDisService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.afterDisExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterDisSingle(DisTypeEnum.MANUAL_DIS, task, true);
            return null;
        });
    }

    private static void stateChange(DynamicObject task, Map<String, Object> oldState, ProxyPOJO proxy) {
        PluginProxy pluginProxy = proxy.getStPluginProxy();
        if (pluginProxy == null) {
            IStateChangeServiceImpl iStateChangeService = new IStateChangeServiceImpl();
            pluginProxy = PluginProxy.create((Object)iStateChangeService, IStateChangeService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.stateChangeExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.stateChange(DisTypeEnum.MANUAL_DIS, task, true, oldState);
            return null;
        });
    }

    private static void saveTask(DynamicObject task, ProxyPOJO proxy) {
        PluginProxy pluginProxy = proxy.getSvPluginProxy();
        if (pluginProxy == null) {
            ITaskSaveServiceImpl iTaskSaveService = new ITaskSaveServiceImpl();
            pluginProxy = PluginProxy.create((Object)iTaskSaveService, ITaskSaveService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.saveTaskExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.saveTask(DisTypeEnum.MANUAL_DIS, task, true);
            return null;
        });
    }

    private static void notifyWf(DynamicObject task, ProxyPOJO proxy) {
        PluginProxy pluginProxy = proxy.getNfPluginProxy();
        if (pluginProxy == null) {
            INotifyWfServiceImpl iNotifyWfService = new INotifyWfServiceImpl();
            pluginProxy = PluginProxy.create((Object)iNotifyWfService, INotifyWfService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.notifyWfExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.notifyWf(DisTypeEnum.MANUAL_DIS, task, true);
            return null;
        });
    }

    private static List<DynamicObject> prepareData(QFilter unDisFilter, DisTaskSourceEnum disTaskSource) {
        IDataPrepareServiceImpl iDataPrepareService = new IDataPrepareServiceImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)iDataPrepareService, IDataPrepareService.class, (String)"kd.ssc.task.disRebuild.engine.Distribution.prepareDataExt");
        List allPluginResult = pluginProxy.callReplaceIfPresent(p -> p.prepareData(unDisFilter, disTaskSource));
        ArrayList<DynamicObject> allTaskList = new ArrayList<DynamicObject>(16);
        if (!CollectionUtils.isEmpty((Collection)allPluginResult)) {
            for (List itemList : allPluginResult) {
                if (CollectionUtils.isEmpty((Collection)itemList)) continue;
                allTaskList.addAll(itemList);
            }
        }
        return allTaskList;
    }

    private static Map<String, Object> transDyn(Long userGroupId, Long userId, DynamicObject task, boolean isRobertGroup) {
        HashMap<String, Object> oldState = new HashMap<String, Object>();
        oldState.put("usergroup", task.getLong("usergroup.id"));
        long oldPersonId = task.getLong("personid.id");
        oldState.put("personid", oldPersonId);
        oldState.put("state", task.getString("state"));
        oldState.put("pooltype", task.getString("pooltype"));
        oldState.put("allocatedpersonid", userId);
        task.set("usergroup", (Object)userGroupId);
        long sampleLib = task.getLong("qualitysamplelibrary.id");
        boolean isQuality = sampleLib > 0L;
        task.set("personid", (Object)userId);
        if (isQuality) {
            task.set("orignalperson", (Object)userId);
        }
        Date date = new Date();
        if (!userId.equals(oldPersonId)) {
            task.set("receivetime", (Object)date);
        }
        String curPoolType = task.getString("pooltype");
        if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(curPoolType)) {
            if (isQuality) {
                task.set("state", (Object)TaskStateEnum.CHECKING.getValue());
            } else {
                task.set("state", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
                Object firstreceivetime = task.get("firstreceivetime");
                if (firstreceivetime == null) {
                    task.set("firstreceivetime", (Object)date);
                }
            }
        }
        task.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        task.set("autoprocess", (Object)isRobertGroup);
        task.set("matchrule", (Object)0L);
        return oldState;
    }

    private static String getSyncError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u88ab\u5206\u914d\uff0c\u4efb\u52a1id\uff1a%s", (String)"CoreDistributionSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private static boolean getLock(long taskId) {
        if (MutexCacheHelper.containsMutexCache4Dist(taskId)) {
            return false;
        }
        MutexCacheHelper.putMutexCache4Dist(taskId);
        return true;
    }

    private static void releaseLock(long taskId) {
        MutexCacheHelper.removeMutexCache4Dist(taskId);
    }

    private static Map<Long, List<DynamicObject>> buildTaskGroupBySSCMap(Map<Long, DynamicObject> taskMap) {
        HashMap<Long, List<DynamicObject>> rtnMap = new HashMap<Long, List<DynamicObject>>();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            DynamicObject value = entry.getValue();
            List taskList = rtnMap.computeIfAbsent(value.getLong("sscid.id"), k -> new ArrayList());
            taskList.add(value);
        }
        return rtnMap;
    }

    private static Map<Long, DynamicObject> buildTaskMap(Set<Long> taskIdSet) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"task_task");
        DynamicObject[] taskDos = BusinessDataServiceHelper.load((Object[])taskIdSet.toArray(new Object[0]), (DynamicObjectType)dynamicObject.getDynamicObjectType());
        if (taskDos == null || taskDos.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, DynamicObject> taskMap = new HashMap<Long, DynamicObject>(taskIdSet.size());
        for (DynamicObject task : taskDos) {
            taskMap.put((Long)task.getPkValue(), task);
        }
        return taskMap;
    }

    private static DisRequestCtx constructDisRequestCtx4TransRedist(long sscid, List<DynamicObject> taskList) {
        DisRequestCtx requestCtx = Distribution.constructDisRequestCtx4AutoDis((Long)sscid, taskList);
        requestCtx.setDisType(DisTypeEnum.NOPASS_DIS);
        return requestCtx;
    }

    private static DisRequestCtx constructDisRequestCtx4AskTask(Long userId, Long sscId, List<DynamicObject> allTaskIds) {
        long begin = System.currentTimeMillis();
        DynamicObject[] unDisTaskcol = allTaskIds.toArray(new DynamicObject[0]);
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.MANUAL_GET);
        disRequestCtx.setUserId(userId);
        Set<Long> qualityTaskIdSet = Arrays.stream(unDisTaskcol).filter(p -> p.getLong("qualitysamplelibrary.id") > 0L).map(p -> p.getLong("id")).collect(Collectors.toSet());
        disRequestCtx.setQualityTaskIds(qualityTaskIdSet);
        HisTaskDisRule hisTaskDisRule = new HisTaskDisRule(unDisTaskcol);
        hisTaskDisRule.prepareBaseData();
        List<BillNumPersonPOJO> billNumPersonList = hisTaskDisRule.getBillNumPersonList();
        disRequestCtx.setReturnMatchRulePojos(billNumPersonList);
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel(unDisTaskcol);
        applyCreditLevel.prepareData();
        disRequestCtx.setApplyCreditLevel(applyCreditLevel);
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData();
        disRequestCtx.setSourceBillMatch(billCusFilter);
        WorkLoadService workLoad = Distribution.loadWorkLoadService();
        workLoad.setRobortRepulseRule(null);
        workLoad.prepareData();
        workLoad.prepareWorkflowPersons(unDisTaskcol);
        disRequestCtx.setWorkload(workLoad);
        QulityJob qulityJob = new QulityJob(unDisTaskcol);
        qulityJob.prepareData();
        disRequestCtx.setQualityJob(qulityJob);
        ArrayList<CusDisrulePojo> cusDisRuleList = Distribution.getDisRules(sscId, userId);
        if (cusDisRuleList == null || cusDisRuleList.isEmpty()) {
            throw new KDException(new ErrorCode(DisExceptionEnum.NOTMATCHED.getCode(), Distribution.getNotExistRuleError()), new Object[0]);
        }
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = cusDisRuleList.stream().collect(Collectors.toMap(CusDisrulePojo::getId, v -> v, (p1, p2) -> p1));
        disRequestCtx.setRuleInfos(cusDisRulePojoMap);
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        Map<Long, DynamicObject> robertGroupMap = RobertUserGroupUtil.getRobertGroupMap(sscId);
        disRequestCtx.setRobertGroupMap(robertGroupMap);
        ProxyPOJO proxy = new ProxyPOJO();
        disRequestCtx.setProxy(proxy);
        Map<String, List<MatchRuleService>> allAuditPluginMap = Distribution.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        Map<String, List<MatchRuleService>> allQualityPluginMap = Distribution.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.QUALITY);
        disRequestCtx.setAllQualityPlugins(allQualityPluginMap);
        Map<Long, WorkerStatusPojo> group2WorkerStatusPojo = OtherUtil.getWordLoad4CurUserInPerGroup(userId);
        disRequestCtx.setGroup2WorkerStatusPojo(group2WorkerStatusPojo);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        long end = System.currentTimeMillis();
        log.info("\u4e3b\u52a8\u83b7\u53d6\uff0c\u89c4\u5219\u51c6\u5907\u65f6\u95f4\uff1a" + (end - begin));
        return disRequestCtx;
    }

    private static DisRequestCtx constructDisRequestCtx4ManualDis(Long disTaskId, DynamicObject[] rules) {
        boolean isExisted = QueryServiceHelper.exists((String)"task_task", (Object)disTaskId);
        if (!isExisted) {
            throw new KDException(new ErrorCode(DisExceptionEnum.BIZERROR.getCode(), Distribution.getNotExistBizError(disTaskId)), new Object[0]);
        }
        long begin = System.currentTimeMillis();
        DynamicObject disTask = BusinessDataServiceHelper.loadSingle((Object)disTaskId, (String)"task_task");
        long sscId = disTask.getLong("sscid.id");
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.MANUAL_DIS);
        HisTaskDisRule hisTaskDisRule = new HisTaskDisRule(new DynamicObject[]{disTask});
        hisTaskDisRule.prepareBaseData();
        List<BillNumPersonPOJO> billNumPersonList = hisTaskDisRule.getBillNumPersonList();
        disRequestCtx.setReturnMatchRulePojos(billNumPersonList);
        HashSet<Long> qualityTaskIdSet = new HashSet<Long>();
        if (disTask.getLong("qualitysamplelibrary.id") > 0L) {
            qualityTaskIdSet.add(disTaskId);
        }
        disRequestCtx.setQualityTaskIds(qualityTaskIdSet);
        QulityJob qulityJob = new QulityJob(new DynamicObject[]{disTask});
        qulityJob.prepareData();
        disRequestCtx.setQualityJob(qulityJob);
        ArrayList<CusDisrulePojo> cusDisRuleList = CusDisrulePojo.buildDisRulePOJOListExcludeGroups(rules);
        if (cusDisRuleList == null || cusDisRuleList.isEmpty()) {
            throw new KDException(new ErrorCode(DisExceptionEnum.NOTMATCHED.getCode(), Distribution.getNotExistRuleError()), new Object[0]);
        }
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = cusDisRuleList.stream().collect(Collectors.toMap(CusDisrulePojo::getId, v -> v, (p1, p2) -> p1));
        disRequestCtx.setRuleInfos(cusDisRulePojoMap);
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel(new DynamicObject[]{disTask});
        applyCreditLevel.prepareData();
        disRequestCtx.setApplyCreditLevel(applyCreditLevel);
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData();
        disRequestCtx.setSourceBillMatch(billCusFilter);
        Map<String, List<MatchRuleService>> allAuditPluginMap = Distribution.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        Map<String, List<MatchRuleService>> allQualityPluginMap = Distribution.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.QUALITY);
        disRequestCtx.setAllQualityPlugins(allQualityPluginMap);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        Map<Long, DynamicObject> robertGroupMap = RobertUserGroupUtil.getRobertGroupMap(sscId);
        disRequestCtx.setRobertGroupMap(robertGroupMap);
        long end = System.currentTimeMillis();
        log.info("\u624b\u5de5\u5206\u914d\uff0c\u89c4\u5219\u51c6\u5907\u65f6\u95f4\uff1a" + (end - begin));
        return disRequestCtx;
    }

    private static DisRequestCtx constructDisRequestCtx4AutoDis(Long sscId, List<DynamicObject> unDisTaskList) {
        DisRequestCtx disRequestCtx = Distribution.constructDisRequestCtx4AutoDisBase(unDisTaskList);
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.AUTO_DIS);
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = disRequestCtx.getRuleInfos();
        if (cusDisRulePojoMap != null) {
            HashMap<Long, CusDisrulePojo> newCusDisRulePojoMap = new HashMap<Long, CusDisrulePojo>();
            for (Map.Entry<Long, CusDisrulePojo> entry : cusDisRulePojoMap.entrySet()) {
                if (!sscId.equals(entry.getValue().getSscId())) continue;
                newCusDisRulePojoMap.put(entry.getKey(), entry.getValue());
            }
            disRequestCtx.setRuleInfos(newCusDisRulePojoMap);
        }
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        Map<Long, DynamicObject> robertGroupMap = RobertUserGroupUtil.getRobertGroupMap(sscId);
        disRequestCtx.setRobertGroupMap(robertGroupMap);
        ProxyPOJO proxy = new ProxyPOJO();
        disRequestCtx.setProxy(proxy);
        Map<String, List<MatchRuleService>> allAuditPluginMap = Distribution.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        Map<String, List<MatchRuleService>> allQualityPluginMap = Distribution.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.QUALITY);
        disRequestCtx.setAllQualityPlugins(allQualityPluginMap);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        return disRequestCtx;
    }

    private static DisRequestCtx constructDisRequestCtx4AutoDis(Long sscId, DisRequestCtx baseCtx) {
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.AUTO_DIS);
        disRequestCtx.setQualityTaskIds(baseCtx.getQualityTaskIds());
        disRequestCtx.setReturnMatchRulePojos(baseCtx.getReturnMatchRulePojos());
        disRequestCtx.setApplyCreditLevel(baseCtx.getApplyCreditLevel());
        disRequestCtx.setSourceBillMatch(baseCtx.getSourceBillMatch());
        disRequestCtx.setWorkload(baseCtx.getWorkload());
        disRequestCtx.setGroupInfos(baseCtx.getGroupInfos());
        disRequestCtx.setQualityJob(baseCtx.getQualityJob());
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = baseCtx.getRuleInfos();
        if (cusDisRulePojoMap != null) {
            HashMap<Long, CusDisrulePojo> newCusDisRulePojoMap = new HashMap<Long, CusDisrulePojo>();
            for (Map.Entry<Long, CusDisrulePojo> entry : cusDisRulePojoMap.entrySet()) {
                if (!sscId.equals(entry.getValue().getSscId())) continue;
                newCusDisRulePojoMap.put(entry.getKey(), entry.getValue());
            }
            disRequestCtx.setRuleInfos(newCusDisRulePojoMap);
        }
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        Map<Long, DynamicObject> robertGroupMap = RobertUserGroupUtil.getRobertGroupMap(sscId);
        disRequestCtx.setRobertGroupMap(robertGroupMap);
        disRequestCtx.setProxy(baseCtx.getProxy());
        Map<String, List<MatchRuleService>> allAuditPluginMap = Distribution.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        Map<String, List<MatchRuleService>> allQualityPluginMap = Distribution.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.QUALITY);
        disRequestCtx.setAllQualityPlugins(allQualityPluginMap);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        return disRequestCtx;
    }

    private static DisRequestCtx constructDisRequestCtx4AutoDisBase(List<DynamicObject> unDisTaskList) {
        long begin = System.currentTimeMillis();
        DynamicObject[] unDisTaskcol = unDisTaskList.toArray(new DynamicObject[0]);
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        Set<Long> qualityTaskIdSet = Arrays.stream(unDisTaskcol).filter(p -> p.getLong("qualitysamplelibrary.id") > 0L).map(p -> p.getLong("id")).collect(Collectors.toSet());
        disRequestCtx.setQualityTaskIds(qualityTaskIdSet);
        HisTaskDisRule hisTaskDisRule = new HisTaskDisRule(unDisTaskcol);
        hisTaskDisRule.prepareBaseData();
        List<BillNumPersonPOJO> billNumPersonList = hisTaskDisRule.getBillNumPersonList();
        disRequestCtx.setReturnMatchRulePojos(billNumPersonList);
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel(unDisTaskcol);
        applyCreditLevel.prepareData();
        disRequestCtx.setApplyCreditLevel(applyCreditLevel);
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData();
        disRequestCtx.setSourceBillMatch(billCusFilter);
        WorkLoadService workLoad = Distribution.loadWorkLoadService();
        workLoad.setRobortRepulseRule(null);
        workLoad.prepareData();
        workLoad.prepareWorkflowPersons(unDisTaskcol);
        disRequestCtx.setWorkload(workLoad);
        Map<Long, Set<Long>> groupInfoMap = Distribution.loadAllGroupInfoMap(workLoad);
        disRequestCtx.setGroupInfos(groupInfoMap);
        QulityJob qulityJob = new QulityJob(unDisTaskcol);
        qulityJob.prepareData();
        disRequestCtx.setQualityJob(qulityJob);
        CusDisRule cusDisRule = new CusDisRule(applyCreditLevel, billCusFilter, workLoad, null, qulityJob);
        cusDisRule.prepareData();
        List<CusDisrulePojo> cusDisRuleList = cusDisRule.getCusDisRuleList();
        if (!CollectionUtils.isEmpty(cusDisRuleList)) {
            Map<Long, CusDisrulePojo> cusDisRulePojoMap = cusDisRuleList.stream().collect(Collectors.toMap(CusDisrulePojo::getId, v -> v, (p1, p2) -> p1));
            disRequestCtx.setRuleInfos(cusDisRulePojoMap);
        }
        ProxyPOJO proxy = new ProxyPOJO();
        disRequestCtx.setProxy(proxy);
        long end = System.currentTimeMillis();
        log.info("\u81ea\u52a8\u5206\u914d\uff0c\u89c4\u5219\u51c6\u5907\u65f6\u95f4\uff1a" + (end - begin));
        return disRequestCtx;
    }

    private static CreditDelayService loadCreditDelayService(DynamicObject[] unDisTaskcol) {
        DynamicObjectCollection creditDelayDisCollection = Distribution.getImplementClass("CreditDelayService");
        CreditDelayDis creditDelayService = new CreditDelayDis();
        if (!CollectionUtils.isEmpty((Collection)creditDelayDisCollection)) {
            try {
                String value = (String)((DynamicObject)creditDelayDisCollection.get(0)).get("implementname");
                Class<?> aClass = Class.forName(value);
                creditDelayService = (CreditDelayService)aClass.newInstance();
            }
            catch (Exception e) {
                log.error("kd.ssc.task.disRebuild.engine.Distribution: \u53cd\u5c04CreditDelayService\u5b9e\u73b0\u7c7b\u5f02\u5e38", (Throwable)e);
                throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)TaskErrorCodeEnum.C_REFLECT_EXCEPTION.getCode(), (String)ResManager.loadKDString((String)"\u53cd\u5c04CreditDelayService\u5b9e\u73b0\u7c7b\u5f02\u5e38\u3002", (String)"ExceptionTaskReflect_0", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
            }
        }
        QFilter poolTypeFil = new QFilter("pooltype", "in", (Object)new String[]{TaskPoolTypeEnum.TO_BE_DIS.getValue(), TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue()});
        QFilter recycleFil = new QFilter("state", "!=", (Object)TaskStateEnum.RECYCLE.getValue());
        QFilter manualDisFil = new QFilter("state", "!=", (Object)TaskStateEnum.TO_BE_MANUAL_DIS.getValue());
        QFilter taskBaseFilter = poolTypeFil.and(manualDisFil).and(recycleFil);
        creditDelayService.setTaskBaseFilter(taskBaseFilter);
        creditDelayService.setUnDisTaskCol(unDisTaskcol);
        creditDelayService.prepareData();
        return creditDelayService;
    }

    private static WorkLoadService loadWorkLoadService() {
        DynamicObjectCollection workLoadServices = Distribution.getImplementClass("WorkLoadService");
        WorkLoadService workLoad = new WorkLoad();
        if (!CollectionUtils.isEmpty((Collection)workLoadServices)) {
            try {
                String value = (String)((DynamicObject)workLoadServices.get(0)).get("implementname");
                Class<?> aClass = Class.forName(value);
                workLoad = (WorkLoadService)aClass.newInstance();
            }
            catch (Exception e) {
                log.error("kd.ssc.task.disRebuild.engine.Distribution: \u53cd\u5c04WorkLoadService\u5b9e\u73b0\u7c7b\u5f02\u5e38", (Throwable)e);
                throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)TaskErrorCodeEnum.C_REFLECT_EXCEPTION.getCode(), (String)ResManager.loadKDString((String)"\u53cd\u5c04WorkLoadService\u5b9e\u73b0\u7c7b\u5f02\u5e38\uff01", (String)"ExceptionTaskReflect_2", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
            }
        }
        return workLoad;
    }

    private static List<DynamicObject> delay(List<DynamicObject> taskList) {
        if (!CollectionUtils.isEmpty(taskList)) {
            DynamicObject[] disTaskDos = taskList.toArray(new DynamicObject[0]);
            CreditDelayService creditDelayService = Distribution.loadCreditDelayService(disTaskDos);
            taskList = taskList.stream().filter(arg_0 -> ((CreditDelayService)creditDelayService).match(arg_0)).collect(Collectors.toList());
        }
        return taskList;
    }

    private static List<DynamicObject> getAllTask(Long sscid, QFilter qFilter) {
        QFilter sscFilter = new QFilter("sscid", "=", (Object)sscid);
        if (qFilter != null) {
            sscFilter.and(qFilter);
        }
        return Distribution.prepareData(sscFilter, DisTaskSourceEnum.GET_DIS_1);
    }

    private static DynamicObjectCollection getImplementClass(String className) {
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("interfacename", "=", (Object)className);
        return QueryServiceHelper.query((String)"task_interfaceconfig", (String)"implementname", (QFilter[])new QFilter[]{qFilter1, qFilter2});
    }

    private static Map<String, List<MatchRuleService>> loadMatchRuleService(DisRequestCtx disRequestCtx, TaskAttributeEnum taskAttributeEnum) {
        HashMap<String, List<MatchRuleService>> matchRuleServiceMap = new HashMap<String, List<MatchRuleService>>(8);
        matchRuleServiceMap.put(MatchRulePluginTypeEnum.SYSTEM.getValue(), new ArrayList(8));
        matchRuleServiceMap.put(MatchRulePluginTypeEnum.RULE.getValue(), new ArrayList(8));
        matchRuleServiceMap.put(MatchRulePluginTypeEnum.GROUP.getValue(), new ArrayList(8));
        matchRuleServiceMap.put(MatchRulePluginTypeEnum.USER.getValue(), new ArrayList(8));
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("attribute", "like", (Object)("%," + taskAttributeEnum.getValue() + ",%"));
        DynamicObject[] matchRulePluginDos = BusinessDataServiceHelper.load((String)"task_matchruleplugin", (String)"id,ssc,plugintype,attribute,pluginpath", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"plugintype asc,pluginseq asc");
        if (matchRulePluginDos != null && matchRulePluginDos.length > 0) {
            for (DynamicObject matchRulePluginDo : matchRulePluginDos) {
                String pluginType = matchRulePluginDo.getString("plugintype");
                String pluginPath = matchRulePluginDo.getString("pluginpath");
                try {
                    Class<?> aClass = Class.forName(pluginPath);
                    MatchRuleService matchRuleService = (MatchRuleService)aClass.newInstance();
                    matchRuleService.setRequestCtx(disRequestCtx);
                    List matchRulePluginList = matchRuleServiceMap.computeIfAbsent(pluginType, k -> new ArrayList(8));
                    matchRulePluginList.add(matchRuleService);
                    matchRuleServiceMap.put(pluginType, matchRulePluginList);
                }
                catch (Exception e) {
                    log.error("kd.ssc.task.disRebuild.engine.Distribution.loadMatchRuleService: \u53cd\u5c04MatchRuleService\u5b9e\u73b0\u7c7b\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return matchRuleServiceMap;
    }

    private static Map<Long, List<DynamicObject>> getSscUnDisTaskMap(QFilter unDisFilter, DisTaskSourceEnum disTaskSource) {
        log.info("kd.ssc.task.disRebuild.engine.Distribution.getSscUnDisTaskMap:\u5f00\u59cb\u83b7\u53d6\u5f85\u5206\u914d\u4efb\u52a1");
        List<DynamicObject> allTaskList = Distribution.prepareData(unDisFilter, disTaskSource);
        HashMap<Long, List<DynamicObject>> sscTaskMap = new HashMap<Long, List<DynamicObject>>(8);
        if (!CollectionUtils.isEmpty(allTaskList)) {
            if (disTaskSource.getValue() == DisTaskSourceEnum.AUTO_DIS_1.getValue()) {
                allTaskList = Distribution.delay(allTaskList);
            }
            if (!CollectionUtils.isEmpty(allTaskList)) {
                for (DynamicObject taskDo : allTaskList) {
                    Long sscId = taskDo.getLong("sscid.id");
                    List taskList = sscTaskMap.computeIfAbsent(sscId, k -> new ArrayList(16));
                    taskList.add(taskDo);
                }
            }
        }
        return sscTaskMap;
    }

    private static Map<Long, Set<Long>> loadAllGroupInfoMap(WorkLoadService workLoad) {
        HashMap<Long, Set<Long>> groupInfoMap = new HashMap<Long, Set<Long>>(8);
        Map<Long, List<WorkerStatusPojo>> groupPersonMap = workLoad.getGroupPersonMap();
        if (groupPersonMap != null && groupPersonMap.size() != 0) {
            for (Map.Entry<Long, List<WorkerStatusPojo>> entry : groupPersonMap.entrySet()) {
                Long userGroupId = entry.getKey();
                List<WorkerStatusPojo> workerStatusPojoList = entry.getValue();
                if (CollectionUtils.isEmpty(workerStatusPojoList)) continue;
                HashSet<Long> userIdSet = new HashSet<Long>(8);
                for (WorkerStatusPojo workerStatusPojo : workerStatusPojoList) {
                    userIdSet.add(workerStatusPojo.getUserId());
                }
                groupInfoMap.put(userGroupId, userIdSet);
            }
        }
        return groupInfoMap;
    }

    private static ArrayList<CusDisrulePojo> getDisRules(Long sscId, Long userId) {
        List<Long> groupIDs = Distribution.getGroupIncludeCurrentUser(userId);
        if (groupIDs.isEmpty()) {
            return null;
        }
        QFilter disruleEnbaleQFilter = CommonFilterUtil.getEnableDisRuleQFilter();
        QFilter userFilter = new QFilter("entryentity1.usergroup", "in", groupIDs).and(new QFilter("ssccenter", "=", (Object)sscId));
        DynamicObject[] taskDisRules = BusinessDataServiceHelper.load((String)"task_disrule", (String)"id,number,entryentity.id,ssccenter,entryentity1.id,tasktype,priority,entryentity.billtype,entryentity.billtype.externalerp.number,entryentity.filterrulejson_tag,entryentity.filterrulejson,entryentity.applycreditleveljoson_tag,entryentity.applycreditleveljoson,entryentity1.orgrange,entryentity1.usergroup", (QFilter[])new QFilter[]{userFilter, disruleEnbaleQFilter}, (String)"priority");
        return CusDisrulePojo.buildDisRulePOJOListIncludeGroups(taskDisRules, groupIDs);
    }

    private static List<Long> getGroupIncludeCurrentUser(long userId) {
        ORM orm = ORM.create();
        QFilter userFilter = new QFilter("entryentity.userfield", "=", (Object)userId);
        userFilter.and("enable", "=", (Object)EnableStatusEnum.Enable.getValue()).and("entryentity.usestatus", "=", (Object)EnableStatusEnum.Enable.getValue());
        ArrayList<Long> groupIDs = new ArrayList<Long>();
        try (DataSet groupDS = orm.queryDataSet(Distribution.class.getName() + ".query usergroup for ask Tasks", "task_usergroup", "id", new QFilter[]{userFilter});){
            for (Row row : groupDS) {
                groupIDs.add(row.getLong("id"));
            }
        }
        return groupIDs;
    }
}

