/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.task.dis.BillNumPersonPOJO;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.service.MatchRuleResult;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.util.RobertUserGroupUtil;
import kd.ssc.task.service.distask.WorkLoadService;

public class TaskReturnMatchRuleServiceImpl
implements MatchRuleService {
    private DisRequestCtx ctx;

    @Override
    public MatchRuleResult match(long taskId, MatchRuleResult result) {
        result.setSuccess(false);
        long sscid = this.getRequestCtx().getSscid();
        assert (sscid != 0L);
        List<BillNumPersonPOJO> returnPersonList = this.getRequestCtx().getReturnMatchRulePojos();
        assert (returnPersonList != null);
        WorkLoadService workLoad = this.getRequestCtx().getWorkload();
        assert (workLoad != null);
        DynamicObject task = this.getRequestCtx().getDisTask();
        assert (task != null && task.getLong("qualitysamplelibrary.id") == 0L);
        long taskTypeId = task.getLong("tasktypeid.id");
        String billId = task.getString("billid");
        String billNumber = task.getString("billnumber");
        assert (taskTypeId != 0L && !StringUtils.isEmpty((String)billId));
        Map.Entry<Long, Long> personAndGroup = this.getSamebillIdPerson(returnPersonList, workLoad, sscid, billId, billNumber, taskTypeId);
        long group = personAndGroup.getKey();
        long person = personAndGroup.getValue();
        if (group == -1L) {
            result.setSuccess(false);
        } else {
            result.setSuccess(true);
            result.setMatchRuleId(-1L);
            result.setMatchGroupId(group);
            result.setMatchPersonId(person);
            result.setMessage(ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f\uff1a\u5206\u914d\u7ed9\u539f\u5ba1\u6838\u4eba\u5ba1\u5355", (String)"TaskReturnMatchRuleServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    @Override
    public DisRequestCtx getRequestCtx() {
        return this.ctx;
    }

    @Override
    public void setRequestCtx(DisRequestCtx ctx) {
        this.ctx = ctx;
    }

    private Map.Entry<Long, Long> getSamebillIdPerson(List<BillNumPersonPOJO> returnPersonList, WorkLoadService workLoad, long sscId, String billId, String billNumber, long taskTypeId) {
        long matchGroup = -1L;
        long matchPerson = -1L;
        for (BillNumPersonPOJO billNumPersonPOJO : returnPersonList) {
            boolean checkWorkLoad;
            boolean checkRedistribution;
            if (!Objects.equals(billNumPersonPOJO.getBillId(), billId) || taskTypeId != billNumPersonPOJO.getTaskTypeId()) continue;
            long group = billNumPersonPOJO.getUsergroup();
            long person = billNumPersonPOJO.getPerson();
            boolean isRobot = RobertUserGroupUtil.isRobort(sscId, group, person);
            DisTypeEnum disType = this.getRequestCtx().getDisType();
            if (disType == DisTypeEnum.AUTO_DIS) {
                checkRedistribution = false;
                if (isRobot) {
                    checkRedistribution = RobertUserGroupUtil.checkRedistribution(true, person, group);
                } else {
                    String autoProcessResult = billNumPersonPOJO.getAutoProcessResult();
                    checkRedistribution = this.checkRedistribution2Human(autoProcessResult);
                }
                checkWorkLoad = this.checkWorkLoad(isRobot, group, person, workLoad, billNumber);
                if (!checkRedistribution || !checkWorkLoad) continue;
                matchGroup = group;
                matchPerson = person;
                return new AbstractMap.SimpleEntry<Long, Long>(matchGroup, matchPerson);
            }
            if (disType != DisTypeEnum.NOPASS_DIS) continue;
            checkRedistribution = !isRobot;
            checkWorkLoad = this.checkWorkLoad(isRobot, group, person, workLoad, billNumber);
            if (!checkRedistribution || !checkWorkLoad) continue;
            matchGroup = group;
            matchPerson = person;
            return new AbstractMap.SimpleEntry<Long, Long>(matchGroup, matchPerson);
        }
        return new AbstractMap.SimpleEntry<Long, Long>(matchGroup, matchPerson);
    }

    private boolean checkWorkLoad(boolean isRobot, long group, long person, WorkLoadService workLoad, String billnumber) {
        Map<String, Object> appParameterMap;
        Boolean isRobotsDistriOnDuty;
        if (isRobot && !(isRobotsDistriOnDuty = (Boolean)(appParameterMap = this.getRequestCtx().getAppParameterMap()).getOrDefault("robotsdistrionduty", Boolean.FALSE)).booleanValue()) {
            return true;
        }
        return workLoad.isPresent(person + "_" + group, billnumber);
    }

    private boolean checkRedistribution2Human(String autoProcessResult) {
        if (!StringUtils.isEmpty((String)autoProcessResult)) {
            Map<Long, DynamicObject> robertGroupMap = this.ctx.getRobertGroupMap();
            for (Map.Entry<Long, DynamicObject> entry : robertGroupMap.entrySet()) {
                DynamicObject robotGroup = entry.getValue();
                String redistributionNew = robotGroup.getString("redistributionnew");
                boolean openLocalNodeRedistribute = StringUtils.isNotEmpty((String)redistributionNew) && redistributionNew.contains("0");
                if (!openLocalNodeRedistribute) continue;
                return false;
            }
        }
        return true;
    }
}

