/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl.after;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.IAfterDisService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.eventSend.entity.PersonChangeTypeEnum;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.disRebuild.util.OtherUtil;
import kd.ssc.task.helper.MessageHelper;

public class IAfterDisServiceImpl
implements IAfterDisService {
    Log log = LogFactory.getLog(IAfterDisServiceImpl.class);

    public void afterDisSingle(DisTypeEnum disType, DynamicObject disTask, boolean isSuccess) {
        if (disType == null || disTask == null) {
            this.log.error("\u5206\u914d\u7c7b\u578b\u6216\u5206\u914d\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (!isSuccess || OtherUtil.isUpImageTask(disTask)) {
            return;
        }
        switch (disType) {
            case AUTO_DIS: {
                this.afterDisSingleByAutoDis(disTask);
                break;
            }
            case MANUAL_DIS: {
                this.afterDisSingleByManualDis(disTask);
                break;
            }
            case MANUAL_GET: {
                this.afterDisSingleByManualGet(disTask);
                break;
            }
            case NOPASS_DIS: {
                this.afterDisSingleByNoPassDis(disTask);
                break;
            }
            default: {
                this.log.error("\u65e0\u6548\u5206\u914d\u7c7b\u578b:" + disType);
            }
        }
    }

    public void afterDisBatch(DisTypeEnum disType, List<DynamicObject> disTaskList) {
        disTaskList = disTaskList.stream().filter(d -> !OtherUtil.isUpImageTask(d)).collect(Collectors.toList());
        if (disType == null || CollectionUtils.isEmpty(disTaskList)) {
            this.log.error("\u5206\u914d\u7c7b\u578b\u6216\u5206\u914d\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        switch (disType) {
            case AUTO_DIS: {
                this.taskSyncDataByDis(disTaskList);
                MessageHelper.sendMessage((DynamicObject[])disTaskList.toArray(new DynamicObject[0]));
                break;
            }
            case MANUAL_DIS: {
                this.taskSyncDataByDis(disTaskList);
                MessageHelper.sendMessage((DynamicObject[])disTaskList.toArray(new DynamicObject[0]));
                break;
            }
            case MANUAL_GET: {
                this.taskSyncDataByDis(disTaskList);
                break;
            }
            case NOPASS_DIS: {
                this.taskSyncDataByDis(disTaskList);
                break;
            }
            default: {
                this.log.error("\u65e0\u6548\u5206\u914d\u7c7b\u578b:" + disType);
            }
        }
    }

    private void taskSyncDataByDis(List<DynamicObject> disTaskList) {
        Iterator iterator;
        if (CollectionUtils.isEmpty(disTaskList)) {
            return;
        }
        HashMap taskIdMap = new HashMap(8);
        for (DynamicObject disTask : disTaskList) {
            List<Long> taskIdList;
            String taskProperty = disTask.getString("tasktypeid.qualityjudge");
            if (TaskPropertyEnum.QUACHECKTASK.getValue().equals(taskProperty)) continue;
            Long sscId = disTask.getLong("sscid.id");
            Long taskId = disTask.getLong("id");
            if (taskIdMap.containsKey(sscId)) {
                taskIdList = (List)taskIdMap.get(sscId);
                taskIdList.add(taskId);
                continue;
            }
            taskIdList = new ArrayList();
            taskIdList.add(taskId);
            taskIdMap.put(sscId, taskIdList);
        }
        if (taskIdMap.size() != 0 && (iterator = taskIdMap.entrySet().iterator()).hasNext()) {
            Map.Entry entry = iterator.next();
            Long sscId = (Long)entry.getKey();
            List taskIdList = (List)entry.getValue();
            SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.UPDATE, (Long)sscId, (List)taskIdList);
        }
    }

    private void afterDisSingleByAutoDis(DynamicObject disTask) {
        Long taskId = disTask.getLong("id");
        if (OtherUtil.isQualityTask(disTask)) {
            long sampleLibraryId = disTask.getLong("qualitysamplelibrary.id");
            this.setStartTimeBatch(disTask);
            this.setPlanEndTime(disTask);
            HashSet<Long> sampleLibraryIdSet = new HashSet<Long>();
            sampleLibraryIdSet.add(sampleLibraryId);
            QualityCheckSchemeUtil.changeQualitySampleLib4DisTask(sampleLibraryIdSet);
        } else {
            SscEventDistributor.personChangeNotify((Long)taskId, (PersonChangeTypeEnum)PersonChangeTypeEnum.AUTO_DIS);
        }
    }

    private void setStartTimeBatch(DynamicObject disTask) {
        Date receiveTime = disTask.getDate("receivetime");
        QFilter qFilter = new QFilter("id", "=", (Object)disTask.getLong("qualitysamplelibrary.id"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"task_qualitysamplelibrary", (String)"checkscheme,checkbegintime,planFinishTime", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject == null || dynamicObject.get("checkbegintime") != null) {
            return;
        }
        dynamicObject.set("checkbegintime", (Object)receiveTime);
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private void setPlanEndTime(DynamicObject disTask) {
        long sampleLibraryId = disTask.getLong("qualitysamplelibrary.id");
        QFilter idFilter = new QFilter("qualitysamplelibrary", "=", (Object)sampleLibraryId);
        QFilter poolTypeFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        boolean notLastDis = QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{idFilter, poolTypeFilter});
        if (!notLastDis) {
            DynamicObject checkScheme = QualityCheckSchemeUtil.getQualityCheckScheme(sampleLibraryId);
            Date receiveTime = disTask.getDate("receivetime");
            Date planFinishTime = QualityCheckSchemeUtil.getPlanFinishTime(checkScheme, receiveTime);
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"task_qualitysamplelibrary");
            dyo.set("id", (Object)sampleLibraryId);
            dyo.set("planFinishTime", (Object)planFinishTime);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dyo});
        }
    }

    private void afterDisSingleByManualDis(DynamicObject disTask) {
        Long id = disTask.getLong("id");
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(id);
        this.deletePriorityLog(idList);
        if (OtherUtil.isQualityTask(disTask)) {
            long sampleLibraryId = disTask.getLong("qualitysamplelibrary.id");
            HashSet<Long> sampleLibraryIdSet = new HashSet<Long>();
            sampleLibraryIdSet.add(sampleLibraryId);
            QualityCheckSchemeUtil.changeQualitySampleLib4DisTask(sampleLibraryIdSet);
        } else {
            SscEventDistributor.personChangeNotify((Long)id, (PersonChangeTypeEnum)PersonChangeTypeEnum.MANUAL_DIS);
        }
    }

    private void afterDisSingleByManualGet(DynamicObject disTask) {
        Long taskId = disTask.getLong("id");
        if (OtherUtil.isQualityTask(disTask)) {
            long sampleLibraryId = disTask.getLong("qualitysamplelibrary.id");
            HashSet<Long> sampleLibraryIdSet = new HashSet<Long>();
            sampleLibraryIdSet.add(sampleLibraryId);
            QualityCheckSchemeUtil.changeQualitySampleLib4DisTask(sampleLibraryIdSet);
        } else {
            SscEventDistributor.personChangeNotify((Long)taskId, (PersonChangeTypeEnum)PersonChangeTypeEnum.MANUAL_GET);
        }
    }

    private void afterDisSingleByNoPassDis(DynamicObject disTask) {
        Long taskId = disTask.getLong("id");
        SscEventDistributor.personChangeNotify((Long)taskId, (PersonChangeTypeEnum)PersonChangeTypeEnum.NOPASS_DIS);
    }

    public void deletePriorityLog(List<Long> jobId) {
        QFilter fjobId = new QFilter("job", "in", jobId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"ssc.deletePriorityLog", (String)"task_prioritychangerecord", (String)"id,job", (QFilter[])fjobId.toArray(), null);
        if (col != null && col.size() > 0) {
            Object[] pks = new Object[col.size()];
            int i = 0;
            for (DynamicObject obj : col) {
                pks[i++] = obj.getLong("id");
            }
            BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"task_prioritychangerecord"), (Object[])pks);
        }
    }
}

