/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl.after;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.IStateChangeService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.disRebuild.util.OtherUtil;

public class IStateChangeServiceImpl
implements IStateChangeService {
    Log log = LogFactory.getLog(IStateChangeServiceImpl.class);

    public void stateChange(DisTypeEnum disType, DynamicObject disTask, boolean isSuccess, Map<String, Object> disTaskOldValue) {
        if (disType == null || disTask == null) {
            this.log.error("\u5206\u914d\u7c7b\u578b\u6216\u5206\u914d\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (!isSuccess || OtherUtil.isUpImageTask(disTask)) {
            return;
        }
        DynamicObject stateChangeDyObj = null;
        switch (disType) {
            case AUTO_DIS: {
                stateChangeDyObj = this.stateChangeByAutoDis(disTask, disTaskOldValue);
                break;
            }
            case MANUAL_DIS: {
                stateChangeDyObj = this.stateChangeByManualDis(disTask, disTaskOldValue);
                break;
            }
            case MANUAL_GET: {
                stateChangeDyObj = this.stateChangeByManualGet(disTask, disTaskOldValue);
                break;
            }
            case NOPASS_DIS: {
                stateChangeDyObj = this.stateChangeByNoPassDis(disTask, disTaskOldValue);
                break;
            }
            default: {
                this.log.error("\u65e0\u6548\u5206\u914d\u7c7b\u578b:" + disType);
            }
        }
        if (stateChangeDyObj != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stateChangeDyObj});
        }
    }

    private DynamicObject stateChangeByAutoDis(DynamicObject disTask, Map<String, Object> disTaskOldValue) {
        Object state;
        if (disTaskOldValue == null || disTaskOldValue.isEmpty()) {
            return null;
        }
        String oldState = (String)this.getTaskOldValue(disTask, disTaskOldValue, "state");
        if (disTaskOldValue != null && (state = disTaskOldValue.get("state")) != null) {
            oldState = (String)state;
        }
        String newState = IStateChangeServiceImpl.getNewState(disTask);
        Long allocatedpersonid = (Long)disTaskOldValue.get("allocatedpersonid");
        return this.newSateChangeAfterDis(disTask, 0L, 8L, oldState, newState, null, allocatedpersonid);
    }

    private DynamicObject stateChangeByManualDis(DynamicObject disTask, Map<String, Object> disTaskOldValue) {
        if (disTaskOldValue == null || disTaskOldValue.isEmpty()) {
            return null;
        }
        String oldState = (String)this.getTaskOldValue(disTask, disTaskOldValue, "state");
        String newState = null;
        String curPoolType = (String)this.getTaskOldValue(disTask, disTaskOldValue, "pooltype");
        long operation = 6L;
        if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(curPoolType)) {
            operation = 6L;
            newState = IStateChangeServiceImpl.getNewState(disTask);
        } else if (TaskPoolTypeEnum.PROCESSING.getValue().equals(curPoolType)) {
            operation = 7L;
            newState = oldState;
        }
        Long allocatedpersonid = (Long)disTaskOldValue.get("allocatedpersonid");
        return this.newSateChangeAfterDis(disTask, RequestContext.get().getCurrUserId(), operation, oldState, newState, null, allocatedpersonid);
    }

    private DynamicObject stateChangeByManualGet(DynamicObject disTask, Map<String, Object> disTaskOldValue) {
        if (disTaskOldValue == null || disTaskOldValue.isEmpty()) {
            return null;
        }
        String oldState = (String)this.getTaskOldValue(disTask, disTaskOldValue, "state");
        String newState = IStateChangeServiceImpl.getNewState(disTask);
        long operation = 14L;
        Long allocatedpersonid = (Long)disTaskOldValue.get("allocatedpersonid");
        return this.newSateChangeAfterDis(disTask, RequestContext.get().getCurrUserId(), operation, oldState, newState, null, allocatedpersonid);
    }

    private DynamicObject stateChangeByNoPassDis(DynamicObject disTask, Map<String, Object> disTaskOldValue) {
        String oldState;
        if (disTaskOldValue == null || disTaskOldValue.isEmpty()) {
            return null;
        }
        String newState = oldState = (String)this.getTaskOldValue(disTask, disTaskOldValue, "state");
        Long personId = (Long)this.getTaskOldValue(disTask, disTaskOldValue, "personid");
        String innerMsg = (String)this.getTaskOldValue(disTask, disTaskOldValue, "innermsg");
        Long allocatedpersonid = (Long)disTaskOldValue.get("allocatedpersonid");
        return this.newSateChangeAfterDis(disTask, personId, 25L, oldState, newState, innerMsg, allocatedpersonid);
    }

    private static String getNewState(DynamicObject disTask) {
        boolean isQualityTask;
        String newState = TaskStateEnum.TO_BE_AUDIT.getValue();
        boolean bl = isQualityTask = disTask.getLong("qualitysamplelibrary.id") > 0L;
        if (isQualityTask) {
            newState = TaskStateEnum.CHECKING.getValue();
        }
        return newState;
    }

    private Object getTaskOldValue(DynamicObject disTask, Map<String, Object> disTaskOldValue, String propertyName) {
        Object propertyOld;
        Object property = disTask.get(propertyName);
        if (disTaskOldValue != null && (propertyOld = disTaskOldValue.get(propertyName)) != null) {
            property = propertyOld;
        }
        return property;
    }

    private DynamicObject newSateChangeAfterDis(DynamicObject disTask, long operatorId, long operation, String oldState, String newState, String innerMsg, Long person) {
        ORM orm = ORM.create();
        DynamicObject stateChangeDyObj = orm.newDynamicObject("task_statechange");
        stateChangeDyObj.set("jobid", disTask.get("id"));
        stateChangeDyObj.set("newjobstate", (Object)newState);
        stateChangeDyObj.set("oldjobstate", (Object)oldState);
        stateChangeDyObj.set("changetime", (Object)new Date());
        stateChangeDyObj.set("operatorid", (Object)operatorId);
        stateChangeDyObj.set("allocatedpersonid", (Object)person);
        stateChangeDyObj.set("operation", (Object)operation);
        stateChangeDyObj.set("tasktype", disTask.get("tasktypeid"));
        stateChangeDyObj.set("billtype", disTask.get("billtype"));
        stateChangeDyObj.set("innermsg", (Object)innerMsg);
        return stateChangeDyObj;
    }
}

