/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.IAfterDisService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.dis.WorkLoadUtil;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.service.impl.after.IAfterDisServiceImpl;

public class OtherUtil {
    private static final Log log = LogFactory.getLog(OtherUtil.class);

    public static void afterDisBatch(DisTypeEnum disType, List<DynamicObject> disTaskList) {
        if (disTaskList == null || disTaskList.isEmpty()) {
            return;
        }
        try {
            IAfterDisServiceImpl iAfterDisService = new IAfterDisServiceImpl();
            PluginProxy pluginProxy = PluginProxy.create((Object)iAfterDisService, IAfterDisService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.afterDisExt");
            pluginProxy.callReplaceIfPresent(p -> {
                p.afterDisBatch(disType, disTaskList);
                return null;
            });
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u5206\u914d\u540e\u6279\u91cf\u5904\u7406\u62a5\u9519", (Throwable)e);
        }
    }

    public static Map<Long, WorkerStatusPojo> getWordLoad4CurUserInPerGroup(long userId) {
        DynamicObjectCollection userGroups = QueryServiceHelper.query((String)"task_usergroup", (String)"id,entryentity.curtasknum_e", (QFilter[])new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue()).and("entryentity.userfield", "=", (Object)userId).and("entryentity.usestatus", "=", (Object)EnableStatusEnum.Enable.getValue()).toArray());
        if (userGroups == null) {
            return Collections.emptyMap();
        }
        QFilter disedTKFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()).and(new QFilter("personid", "=", (Object)userId));
        QFilter stateExFilter = WorkLoadUtil.getWorkloadStateExFilter();
        if (stateExFilter != null) {
            disedTKFilter.and(stateExFilter);
        }
        DynamicObjectCollection processingTasks = QueryServiceHelper.query((String)"task_task", (String)"id,usergroup", (QFilter[])new QFilter[]{disedTKFilter});
        Map<Long, List<DynamicObject>> group2Tasks = processingTasks.stream().collect(Collectors.groupingBy(k -> k.getLong("usergroup")));
        HashMap<Long, WorkerStatusPojo> rtnMap = new HashMap<Long, WorkerStatusPojo>(userGroups.size());
        for (DynamicObject userGroup : userGroups) {
            Long gId = userGroup.getLong("id");
            WorkerStatusPojo workerStatusPojo = new WorkerStatusPojo();
            workerStatusPojo.setUserGroupId(gId);
            workerStatusPojo.setTaskUpper(userGroup.getInt("entryentity.curtasknum_e"));
            List<DynamicObject> tasks = group2Tasks.get(gId);
            workerStatusPojo.setTaskTotal(tasks != null ? tasks.size() : 0);
            rtnMap.put(gId, workerStatusPojo);
        }
        return rtnMap;
    }

    public static boolean isUpImageTask(DynamicObject disTask) {
        String poolType = disTask.getString("pooltype");
        return TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue().equals(poolType);
    }

    public static boolean isQualityTask(DynamicObject disTask) {
        long sampleLibraryId = disTask.getLong("qualitysamplelibrary.id");
        return sampleLibraryId > 0L;
    }
}

