/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BillPropertyTreePlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
ClickListener {
    private Map<String, String> complexPropCache = null;
    private Map<String, String> treeNodeCache = null;
    private Map<String, Map<String, String>> propNameCache = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl("propTree");
        tree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Button ok = (Button)this.getControl("ok");
        ok.addClickListener((ClickListener)this);
        Button cancel = (Button)this.getControl("cancel");
        cancel.addClickListener((ClickListener)this);
    }

    private void initPropTree() {
        TreeView tree = (TreeView)this.getView().getControl("propTree");
        FormShowParameter paramter = this.getView().getFormShowParameter();
        TreeNode root = this.createEntityPropertyTree((String)paramter.getCustomParam("entityKey"), (String)paramter.getCustomParam("entityName"), null, (String)paramter.getCustomParam("fieldconfiguration"));
        TreeNode rootchild = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)paramter.getCustomParam("entityKey").toString());
        Map mapEntry = entityType.getAllEntities();
        for (Map.Entry entry : mapEntry.entrySet()) {
            rootchild = new TreeNode();
            EntityType entityTypeEntry = (EntityType)entry.getValue();
            String key = (String)entry.getKey();
            if (paramter.getCustomParam("entityKey").toString().equals(key)) continue;
            rootchild = this.createEntityPropertyTree(key, entityTypeEntry.getDisplayName().toString(), entityTypeEntry, (String)paramter.getCustomParam("fieldconfiguration"));
            root.addChild(rootchild);
        }
        root.setIsOpened(true);
        tree.addNode(root);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        Map treeNodeCache;
        String entityNumber;
        String nodeid = (String)evt.getNodeId();
        TreeView treeview = (TreeView)this.getControl("propTree");
        String treeNodecahceString = this.getPageCache().get("treeNodeCache");
        if (treeNodecahceString != null && (entityNumber = (String)(treeNodeCache = (Map)SerializationUtils.fromJsonString((String)treeNodecahceString, Map.class)).get(nodeid)) != null) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection proColl = entityType.getProperties();
            List<TreeNode> children = this.generatePropChildren(entityNumber, nodeid, proColl, true, null);
            String complexPropCacheString = this.getPageCache().get("complexPropCache");
            if (complexPropCacheString != null) {
                Map complexPropCache = (Map)SerializationUtils.fromJsonString((String)complexPropCacheString, Map.class);
                TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)((String)complexPropCache.get(nodeid)), TreeNode.class);
                node.setChildren(children);
                treeview.updateNode(node);
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.initPropTree();
    }

    private TreeNode createEntityPropertyTree(String entityNumber, String entityName, EntityType entityTypeEntry, String fieldconfiguration) {
        TreeNode root;
        block5: {
            root = new TreeNode();
            try {
                MainEntityType entityType = null;
                DataEntityPropertyCollection proColl = null;
                if (entityTypeEntry == null) {
                    root.setId("root");
                    root.setText(entityName);
                    entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    proColl = entityType.getProperties();
                } else {
                    if (entityTypeEntry instanceof SubEntryType && entityTypeEntry.getParent() != null && entityTypeEntry.getParent().getParent() != null) {
                        entityNumber = entityTypeEntry.getParent().getName() + "." + entityNumber;
                    }
                    root.setId(entityNumber);
                    root.setText(entityName);
                    proColl = entityTypeEntry.getProperties();
                }
                List<TreeNode> children = this.generatePropChildren(entityNumber, root.getId(), proColl, true, fieldconfiguration);
                root.setChildren(children);
            }
            catch (KDException e) {
                root.setId("root");
                if (!e.getErrorCode().equals((Object)BosErrorCode.entityMetaDataNotExist)) break block5;
                root.setText(e.getLocalizedMessage());
            }
        }
        return root;
    }

    private List<TreeNode> generatePropChildren(String entityNumber, String parentID, DataEntityPropertyCollection proColl, boolean generateChildren, String fieldconfiguration) {
        String treeNodecahceString = this.getPageCache().get("treeNodeCache");
        if (this.treeNodeCache == null) {
            this.treeNodeCache = treeNodecahceString != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)treeNodecahceString, Map.class) : new HashMap<String, String>();
        }
        String complexPropCacheString = this.getPageCache().get("complexPropCache");
        if (this.complexPropCache == null) {
            this.complexPropCache = complexPropCacheString != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)complexPropCacheString, Map.class) : new HashMap<String, String>();
        }
        String propNameCacheString = this.getPageCache().get("propNameCache");
        if (this.propNameCache == null) {
            this.propNameCache = propNameCacheString != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)propNameCacheString, Map.class) : new HashMap<String, Map<String, String>>();
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (IDataEntityProperty prop : proColl) {
            DynamicProperty dp;
            if (prop instanceof DynamicLocaleProperty || prop instanceof PKFieldProp || prop instanceof EntryProp || "80".equals(fieldconfiguration) && !(prop instanceof BasedataProp)) continue;
            TreeNode node = new TreeNode();
            node.setParentid(parentID);
            if ("root".equals(parentID)) {
                node.setId(prop.getName());
            } else {
                node.setId(parentID + "." + prop.getName());
            }
            node.setText(prop.getName());
            if (prop instanceof DynamicProperty && (dp = (DynamicProperty)prop).getDisplayName() != null) {
                node.setText(dp.getDisplayName().toString());
            }
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("type", prop.getPropertyType().getName());
            propMap.put("mark", node.getId());
            if (this.propNameCache.get(parentID) != null) {
                Map<String, String> propMapParent = this.propNameCache.get(parentID);
                propMap.put("name", propMapParent.get("name") + "." + node.getText());
            } else {
                propMap.put("name", node.getText());
            }
            this.propNameCache.put(node.getId(), propMap);
            if (prop instanceof DynamicComplexProperty && !"80".equals(fieldconfiguration)) {
                DynamicComplexProperty dcp = (DynamicComplexProperty)prop;
                IDataEntityType det = dcp.getComplexType();
                if (det == null) continue;
                String entityTypeName = det.getName();
                if (dcp instanceof FlexProp && "002".equals(entityTypeName)) {
                    entityTypeName = "bd_asstacttype";
                }
                this.treeNodeCache.put(node.getId(), entityTypeName);
                this.complexPropCache.put(node.getId(), SerializationUtils.toJsonString((Object)node));
                if (generateChildren) {
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityTypeName);
                    DataEntityPropertyCollection proColl1 = entityType.getProperties();
                    List<TreeNode> children = this.generatePropChildren(entityTypeName, node.getId(), proColl1, false, null);
                    node.setChildren(children);
                }
            }
            nodeList.add(node);
        }
        if (generateChildren) {
            this.getPageCache().put("complexPropCache", SerializationUtils.toJsonString(this.complexPropCache));
            this.getPageCache().put("treeNodeCache", SerializationUtils.toJsonString(this.treeNodeCache));
            this.getPageCache().put("propNameCache", SerializationUtils.toJsonString(this.propNameCache));
        }
        return nodeList;
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String propNameCacheString = this.getPageCache().get("propNameCache");
        if (propNameCacheString != null) {
            Map propNameCache = (Map)SerializationUtils.fromJsonString((String)propNameCacheString, Map.class);
            this.getPageCache().put("NodeID", (String)arg0.getNodeId());
            Map propMap = (Map)propNameCache.get(arg0.getNodeId());
            if (propMap == null) {
                return;
            }
            if ("kd.bos.dataentity.entity.DynamicObject".equalsIgnoreCase((String)propMap.get("type"))) {
                return;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        HashMap retMap = new HashMap();
        String key = ((Control)evt.getSource()).getKey();
        this.getPageCache().get("NodeID");
        if ("ok".equals(key)) {
            String propNameCacheString = this.getPageCache().get("propNameCache");
            if (propNameCacheString != null) {
                Map propNameCache = (Map)SerializationUtils.fromJsonString((String)propNameCacheString, Map.class);
                Map propMap = (Map)propNameCache.get(this.getPageCache().get("NodeID"));
                if (propMap == null) {
                    return;
                }
                FormShowParameter parameter = this.getView().getFormShowParameter();
                if (parameter.getCustomParam("includeEntity") == null && "kd.bos.dataentity.entity.DynamicObject".equalsIgnoreCase((String)propMap.get("type"))) {
                    return;
                }
                retMap.put("alias", propMap.get("name"));
                retMap.put("type", propMap.get("type"));
                retMap.put("mark", propMap.get("mark"));
            }
            retMap.put("key", this.getPageCache().get("NodeID"));
            this.getView().returnDataToParent(retMap);
            this.getView().close();
        } else {
            this.getView().close();
        }
    }
}

