/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.formplugin.imports.TaskAbstractListPlugin;

public class DecisionItemListPlugin
extends TaskAbstractListPlugin
implements ItemClickListener {
    private static final String CACHEKEY_DECISIONITEM_SSCCENTER = "sscid";
    private static final String FORM_ASSIGNDECISIONITEM = "task_assigndecisionitem";
    private static final String KEY_ECISIONITEM_OPENDDIALOG = "assigndecisionitem";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String sscid = (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_DECISIONITEM_SSCCENTER);
        if (sscid != null) {
            List qFilters = e.getQFilters();
            QFilter filter = new QFilter(CACHEKEY_DECISIONITEM_SSCCENTER, "=", (Object)Long.parseLong(sscid));
            qFilters.add(filter);
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String ssc = this.getPageCache().get(CACHEKEY_DECISIONITEM_SSCCENTER);
        if (ssc == null) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!commonFilterColumn.getFieldName().contains("useorg")) continue;
                List list = commonFilterColumn.getDefaultValues();
                if (list.size() > 0) {
                    String sscid = (String)list.get(0);
                    this.getPageCache().put(CACHEKEY_DECISIONITEM_SSCCENTER, sscid);
                    break;
                }
                String sscidCus = (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_DECISIONITEM_SSCCENTER);
                if (sscidCus != null) break;
                List comboItems = commonFilterColumn.getComboItems();
                ComboItem comboItem = (ComboItem)comboItems.get(0);
                String sscid = comboItem.getValue();
                commonFilterColumn.setDefaultValue(sscid);
                this.getPageCache().put(CACHEKEY_DECISIONITEM_SSCCENTER, sscid);
                break;
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && "useorg.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
            this.getPageCache().put(CACHEKEY_DECISIONITEM_SSCCENTER, String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            String opKey = e.getOperateKey();
            if ("btnassign".equalsIgnoreCase(opKey)) {
                this.openDecisionItemDialog();
            } else if ("btnsearch".equalsIgnoreCase(opKey)) {
                this.openDecisionItemListForm();
            } else if ("enable".equalsIgnoreCase(opKey)) {
                this.syncState4DistributedDecision(true);
            } else if ("disable".equalsIgnoreCase(opKey)) {
                this.syncState4DistributedDecision(false);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (KEY_ECISIONITEM_OPENDDIALOG.equalsIgnoreCase(e.getActionId())) {
            String retData = (String)e.getReturnData();
            if ("assignok".equalsIgnoreCase(retData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"DecisionItemListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else if ("assignfail".equalsIgnoreCase(retData)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DecisionItemListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openDecisionItemDialog() {
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectrow = list.getSelectedRows();
        if (selectrow.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DecisionItemListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : selectrow) {
            ids.add((Long)listSelectedRow.getPrimaryKeyValue());
        }
        if (!this.validateStateIsEnable(ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u64cd\u4f5c\uff0c\u8bf7\u5148\u542f\u7528\u6570\u636e\u3002", (String)"DecisionItemListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String sscid = this.getPageCache().get(CACHEKEY_DECISIONITEM_SSCCENTER);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u51b3\u7b56\u9879\u5206\u914d", (String)"DecisionItemListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        showParameter.setFormId(FORM_ASSIGNDECISIONITEM);
        showParameter.setCustomParam("decisionitemlist", ids);
        showParameter.setCustomParam(CACHEKEY_DECISIONITEM_SSCCENTER, (Object)sscid);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_ECISIONITEM_OPENDDIALOG);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private boolean validateStateIsEnable(List<Long> ids) {
        ORM orm = ORM.create();
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        return !orm.exists("task_decisionitem", new QFilter[]{idFilter, enableFilter});
    }

    private void openDecisionItemListForm() {
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectrow = list.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (selectrow != null && selectrow.size() > 0) {
            for (ListSelectedRow listSelectedRow : selectrow) {
                ids.add((Long)listSelectedRow.getPrimaryKeyValue());
            }
            if (!this.validateStateIsEnable(ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u64cd\u4f5c\uff0c\u8bf7\u5148\u542f\u7528\u6570\u636e\u3002", (String)"DecisionItemListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String sscid = this.getPageCache().get(CACHEKEY_DECISIONITEM_SSCCENTER);
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("task_decisionitem_re");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("tabap");
        para.setCustomParam(CACHEKEY_DECISIONITEM_SSCCENTER, (Object)sscid);
        para.setHasRight(true);
        if (ids.size() > 0) {
            ListFilterParameter filter = new ListFilterParameter();
            filter.setFilter(new QFilter("decisionitem", "in", ids).and(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscid))));
            para.setListFilterParameter(filter);
        }
        this.getView().showForm((FormShowParameter)para);
    }

    private void syncState4DistributedDecision(boolean isEnable) {
        String val = isEnable ? "1" : "0";
        IListView list = (IListView)this.getView();
        StringBuilder sb = new StringBuilder(128);
        sb.append("update t_tk_decisionitemre set fenable = ");
        sb.append(val);
        sb.append(" where fdecisionitem in (");
        for (ListSelectedRow selectedRow : list.getSelectedRows()) {
            sb.append(selectedRow.getPrimaryKeyValue()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1).append(')');
        DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sb.toString());
    }
}

