/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.common.CommonFilterUtil;

public class DecisionItemRelationlListPlugin
extends AbstractListPlugin {
    private List<FilterColumn> commFilCols = new ArrayList<FilterColumn>();
    private static final String CACHE_KEY_SSC = "sscid";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String sscId = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_SSC);
        if (StringUtils.isEmpty((CharSequence)sscId)) {
            return;
        }
        this.commFilCols = args.getCommonFilterColumns();
        String appId = this.getView().getFormShowParameter().getAppId();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setCanRemove(false);
            if (!"ssccenter.name".equals(commonFilterColumn.getFieldName())) continue;
            CommonFilterUtil.filterContainerInitDefMainOrg((FilterContainer)this.getControl("filtercontainerap"), commonFilterColumn, "task_decisionitem", sscId, appId);
        }
        this.setFilterColumn(this.commFilCols, sscId);
    }

    private void setFilterColumn(List<FilterColumn> commFilCols, String ssccenter) {
        IPageCache pageCache = this.getPageCache();
        for (FilterColumn filColumn : commFilCols) {
            QFilter qFilter;
            CommonFilterColumn commCol = (CommonFilterColumn)filColumn;
            String fieldName = commCol.getFieldName();
            if ("decisionitem.name".equals(fieldName)) {
                qFilter = new QFilter("createorg", "=", (Object)Long.valueOf(ssccenter));
                CommonFilterUtil.resetComboItems(pageCache, "task_decision_decision", commCol, "task_decisionitem", qFilter, ssccenter, false);
                continue;
            }
            if ("tasktypeid.name".equals(fieldName)) {
                qFilter = new QFilter("orgfield", "=", (Object)Long.valueOf(ssccenter));
                QFilter qualityJudge = new QFilter("qualityjudge", "=", (Object)"0");
                CommonFilterUtil.resetComboItems(pageCache, "task_decision_tasktype", commCol, "task_tasktype", qFilter.and(qualityJudge), ssccenter, false);
                continue;
            }
            if (!"billtypeid.name".equals(fieldName)) continue;
            qFilter = new QFilter("ssccenter", "=", (Object)Long.valueOf(ssccenter));
            CommonFilterUtil.resetComboItems(this.getPageCache(), "task_decision_billtype", commCol, "task_taskbill", qFilter, ssccenter, false);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filValues = args.getFilterValues();
        List customFils = (List)filValues.get("customfilter");
        if (customFils == null || customFils.size() == 0) {
            return;
        }
        String ssccenter = null;
        Map curFilterField = args.getCurrentCommonFilter();
        List curFieldNames = (List)curFilterField.get("FieldName");
        boolean isRequiredClear = false;
        if ("ssccenter.id".equals(curFieldNames.get(0))) {
            isRequiredClear = true;
        }
        for (int i = 0; i < customFils.size(); ++i) {
            Map customFil = (Map)customFils.get(i);
            String fieldName = (String)((List)customFil.get("FieldName")).get(0);
            List val = (List)customFil.get("Value");
            if ("ssccenter.id".equals(fieldName)) {
                ssccenter = (String)val.get(0);
                continue;
            }
            if (!isRequiredClear || !"decisionitem.id".equals(fieldName) && !"tasktypeid.id".equals(fieldName) && !"billtypeid.id".equals(fieldName)) continue;
            val.clear();
        }
        this.getPageCache().put(CACHE_KEY_SSC, ssccenter);
        this.setFilterColumn(this.commFilCols, ssccenter);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String ssccenter = this.getPageCache().get(CACHE_KEY_SSC);
        if (StringUtils.isEmpty((CharSequence)ssccenter)) {
            ssccenter = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_SSC);
        }
        if (StringUtils.isEmpty((CharSequence)ssccenter)) {
            return;
        }
        List qfilters = args.getQfilters();
        String name = args.getFieldName();
        if ("decisionitem.id".equals(name)) {
            qfilters.add(new QFilter("createorg", "=", (Object)Long.valueOf(ssccenter)));
        } else if ("tasktypeid.id".equals(name)) {
            qfilters.add(new QFilter("orgfield", "=", (Object)Long.valueOf(ssccenter)));
            qfilters.add(new QFilter("qualityjudge", "=", (Object)"0"));
        } else if ("billtypeid.id".equals(name)) {
            qfilters.add(new QFilter("ssccenter", "=", (Object)Long.valueOf(ssccenter)));
        } else if (name.contains("ssccenter")) {
            CommonFilterUtil.filterContainerBeforeOrgF7Select((FilterContainer)this.getControl("filtercontainerap"), args.getQfilters(), "task_decisionitem", this.getView().getFormShowParameter().getAppId());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof StatusConvert) {
            DynamicObjectCollection decisions;
            Set decisionIds;
            ListSelectedRowCollection listSelectedData = ((StatusConvert)args.getSource()).getListSelectedData();
            Set ids = listSelectedData.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
            ORM orm = ORM.create();
            boolean exist = orm.exists("task_decisionitem", new QFilter("id", "in", decisionIds = (decisions = orm.query("task_decisionitem_re", "id,decisionitem", new QFilter("id", "in", ids).toArray())).stream().map(d -> d.getLong("decisionitem")).collect(Collectors.toSet())).and("enable", "=", (Object)"0").toArray());
            if (exist) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DecisionItemRelationlListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

