/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.ssc.task.business.helper.WorkflowApproveRecordHelper;
import org.apache.commons.lang3.StringUtils;

public class DecisionRejectionListPlugin
extends AbstractBillPlugIn
implements ItemClickListener {
    public void beforeBindData(EventObject e) {
        this.showDecisionRejectionList();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("btn_ok".equals(operateKey) && (selectRows = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows()).length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u9a73\u56de\u81f3\u7684\u8282\u70b9\u3002", (String)"DecisionRejectionListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("btn_ok".equals(operateKey)) {
            HashMap<String, String> returnDataMap = new HashMap<String, String>(8);
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows != null && selectRows.length != 0) {
                int selectRow = selectRows[0];
                String nodeItemId = (String)this.getModel().getValue("nodeitemid", selectRow);
                String nodeName = (String)this.getModel().getValue("nodename", selectRow);
                String nodeUserName = (String)this.getModel().getValue("nodeusername", selectRow);
                String nodeShowName = nodeName;
                if (StringUtils.isNotBlank((CharSequence)nodeUserName)) {
                    nodeShowName = nodeName + "-" + nodeUserName;
                }
                returnDataMap.put("nodeShowName", nodeShowName);
                returnDataMap.put("nodeItemId", nodeItemId);
            }
            String jsonString = JSON.toJSONString(returnDataMap);
            this.getView().returnDataToParent((Object)jsonString);
        }
    }

    private void showDecisionRejectionList() {
        List<DecisionRejectionGrid> gridList = this.getDecisionRejectionData();
        this.setDecisionRejectionData(gridList);
    }

    private List<DecisionRejectionGrid> getDecisionRejectionData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskId = Long.valueOf((String)formShowParameter.getCustomParam("taskId"));
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id,billid,billtype,assignid,itemid", (QFilter[])new QFilter[]{idFilter});
        Long workFlowId = dynamicObject.getLong("assignid");
        String billId = dynamicObject.getString("billid");
        String decisionValue = (String)formShowParameter.getCustomParam("decisionValue");
        ArrayList<DecisionRejectionGrid> gridList = new ArrayList<DecisionRejectionGrid>();
        List rejectNodeList = WorkflowServiceHelper.getRejectNodes((Long)workFlowId, (String)decisionValue);
        Map latestApprovalRecordMap = WorkflowApproveRecordHelper.getLatestApprovalRecordMap((String)billId);
        if (CollectionUtils.isNotEmpty((Collection)rejectNodeList)) {
            for (WFRejectNodesModel wfRejectNodesModel : rejectNodeList) {
                DecisionRejectionGrid rejectionGrid = new DecisionRejectionGrid();
                String itemId = wfRejectNodesModel.getItemId();
                ApprovalRecordItem approvalRecordItem = (ApprovalRecordItem)latestApprovalRecordMap.get(itemId);
                if (approvalRecordItem != null) {
                    rejectionGrid.setNodeItemId(itemId);
                    rejectionGrid.setNodeName(approvalRecordItem.getActivityName());
                    rejectionGrid.setNodeUserName(approvalRecordItem.getAssignee());
                    rejectionGrid.setApprovalRecord(approvalRecordItem.getTime() + " " + approvalRecordItem.getResult());
                    gridList.add(rejectionGrid);
                    continue;
                }
                rejectionGrid.setNodeItemId(itemId);
                rejectionGrid.setNodeName(wfRejectNodesModel.getName());
                gridList.add(rejectionGrid);
            }
        }
        return gridList;
    }

    private void setDecisionRejectionData(List<DecisionRejectionGrid> gridList) {
        if (CollectionUtils.isNotEmpty(gridList)) {
            IDataModel dataModel = this.getModel();
            String nodeItemId = (String)this.getView().getFormShowParameter().getCustomParam("nodeItemId");
            ArrayList<Integer> selectRows = new ArrayList<Integer>();
            dataModel.batchCreateNewEntryRow("entryentity", gridList.size());
            int size = gridList.size();
            for (int i = 0; i < size; ++i) {
                DecisionRejectionGrid decisionRejectionGrid = gridList.get(i);
                dataModel.setValue("nodeitemid", (Object)decisionRejectionGrid.getNodeItemId(), i);
                dataModel.setValue("nodename", (Object)decisionRejectionGrid.getNodeName(), i);
                dataModel.setValue("nodeusername", (Object)decisionRejectionGrid.getNodeUserName(), i);
                dataModel.setValue("approvalrecord", (Object)decisionRejectionGrid.getApprovalRecord(), i);
                if (nodeItemId == null || !nodeItemId.equals(decisionRejectionGrid.getNodeItemId())) continue;
                selectRows.add(i);
            }
            if (CollectionUtils.isNotEmpty(selectRows)) {
                this.getPageCache().put("selectRows", SerializationUtils.toJsonString(selectRows));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String selected = this.getPageCache().get("selectRows");
        if (!StringUtils.isBlank((CharSequence)selected)) {
            int[] selectRows = (int[])SerializationUtils.fromJsonString((String)selected, int[].class);
            AbstractGrid entryGrid = (AbstractGrid)this.getControl("entryentity");
            entryGrid.selectRows(selectRows, selectRows[0]);
        }
        this.getPageCache().remove("selectRows");
    }

    private static class DecisionRejectionGrid {
        private String nodeItemId;
        private String nodeName;
        private String nodeUserName;
        private String approvalRecord;

        private DecisionRejectionGrid() {
        }

        public String getNodeItemId() {
            return this.nodeItemId;
        }

        public void setNodeItemId(String nodeItemId) {
            this.nodeItemId = nodeItemId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeUserName() {
            return this.nodeUserName;
        }

        public void setNodeUserName(String nodeUserName) {
            this.nodeUserName = nodeUserName;
        }

        public String getApprovalRecord() {
            return this.approvalRecord;
        }

        public void setApprovalRecord(String approvalRecord) {
            this.approvalRecord = approvalRecord;
        }
    }
}

