/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Delete;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.common.DisRuleDataSyncHelper;
import kd.ssc.task.formplugin.imports.TaskAbstractListPlugin;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DisRuleListPlugin
extends TaskAbstractListPlugin {
    private static final Log log = LogFactory.getLog(DisRuleListPlugin.class);
    public static final String DISMODE_CONFIG = "2VX1BCLSNX1=";
    private DynamicObject paramObj = null;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String ssc = this.getPageCache().get("sscid");
        if (ssc == null) {
            for (FilterColumn filCol : args.getCommonFilterColumns()) {
                if (!"ssccenter.name".equals(filCol.getFieldName())) continue;
                List ssccenters = filCol.getDefaultValues();
                if (ssccenters.size() == 0) {
                    return;
                }
                this.getPageCache().put("sscid", (String)ssccenters.get(0));
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && "ssccenter.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
            this.getPageCache().put("sscid", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            if (e.getSource() instanceof Delete) {
                List delIDs = e.getOperationResult().getSuccessPkIds();
                QFilter delFilter = new QFilter("task_disrule", "in", (Object)delIDs);
                DeleteServiceHelper.delete((String)"task_disrule_query", (QFilter[])new QFilter[]{delFilter});
            }
            if (e.getOperateKey().equals("disrule_query")) {
                boolean isInitCompleted = this.checkInitializeCompleted();
                if (!isInitCompleted) {
                    this.initDisRuleQuery();
                }
                this.openDisRuleQueryView();
            }
            if (e.getOperateKey().equals("dismode_config")) {
                String sscId = this.getPageCache().get("sscid");
                if (StringUtils.isBlank((CharSequence)sscId) || "0".equals(sscId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"DisRuleListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                String appId = this.getView().getFormShowParameter().getAppId();
                Long userId = RequestContext.get().getCurrUserId();
                int isPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)Long.parseLong(sscId), (String)"12", (String)appId, (String)"task_disrule", (String)DISMODE_CONFIG);
                if (isPermission != 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4efb\u52a1\u5206\u914d\u89c4\u5219\u201d\u7684\u201c\u5206\u914d\u6a21\u5f0f\u914d\u7f6e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DisRuleListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject disMode = this.getDisModeBySscId(Long.parseLong(sscId));
                Long disModeId = null;
                if (disMode != null) {
                    disModeId = disMode.getLong("id");
                }
                this.showDisModeBill(disModeId);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private DynamicObject getDisModeBySscId(Long sscId) {
        QFilter qFilter = new QFilter("scenter.id", "=", (Object)sscId);
        Object[] disModeObjs = BusinessDataServiceHelper.load((String)"task_dis_mode", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (ArrayUtils.isNotEmpty((Object[])disModeObjs)) {
            return disModeObjs[0];
        }
        return null;
    }

    private void showDisModeBill(Long disModeId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("task_dis_mode");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> customParams = new HashMap<String, String>();
        if (disModeId != null && disModeId != 0L) {
            billShowParameter.setPkId((Object)disModeId);
            billShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            customParams.put("sscId", this.getPageCache().get("sscid"));
            billShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        billShowParameter.setCustomParams(customParams);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void openDisRuleQueryView() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("task_disrule_query");
        showParameter.setFormId("bos_list");
        showParameter.setCustomParam("sscid", (Object)this.getPageCache().get("sscid"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean checkInitializeCompleted() {
        boolean isInitCompleted = true;
        String entityName = "task_paramcontrol";
        String selectProp = "paramname,paramvalue";
        QFilter nameFilter = new QFilter("paramname", "=", (Object)"isInitDisRule");
        this.paramObj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProp, (QFilter[])new QFilter[]{nameFilter});
        if (this.paramObj == null) {
            log.error("\u5171\u4eab\u7cfb\u7edf\u63a7\u5236\u53c2\u6570isInitDisRule\u4e22\u5931\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002");
            return isInitCompleted;
        }
        String isInitDisRule = this.paramObj.getString("paramvalue");
        if (kd.bos.util.StringUtils.isNotEmpty((String)isInitDisRule) && "0".equals(isInitDisRule)) {
            isInitCompleted = false;
        }
        return isInitCompleted;
    }

    private void initDisRuleQuery() {
        QFilter disRuleFilter = null;
        new DisRuleDataSyncHelper().keepDataSync(disRuleFilter);
        if (this.paramObj != null) {
            this.paramObj.set("paramvalue", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.paramObj});
        }
    }
}

