/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;

public class DisRuleOrgUserInput
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(DisRuleOrgUserInput.class);
    private static String ORGTYPE = "10";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"imgorginput"});
        BasedataEdit usergroup = (BasedataEdit)this.getControl("usergroup");
        usergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("imgorginput".equalsIgnoreCase(key)) {
            this.showSelecteOrgF7();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String sscID = (String)this.getView().getFormShowParameter().getCustomParam("sscid");
        if (StringUtils.isEmpty((String)sscID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"DisRuleOrgUserInput_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("useorg", (Object)sscID);
        Object editMap = this.getView().getFormShowParameter().getCustomParam("dis_editmap");
        Map paramMap = (Map)editMap;
        if (editMap != null) {
            this.getModel().setValue("remark1", paramMap.get("remark"));
            this.getModel().setValue("usergroup", (Object)Long.valueOf(paramMap.get("usergroup").toString()));
            List orgRangeIDList = (List)paramMap.get("orgrang");
            this.buildOrgEntryCardByDisOrgIDs(this.fromLongToStr(orgRangeIDList));
            this.getPageCache().put("rowindex", paramMap.get("rowindex").toString());
            this.getPageCache().put("remark", paramMap.get("remark").toString());
        }
    }

    private List<Long> fromLongToStr(List<String> LongList) {
        ArrayList<Long> longList = new ArrayList<Long>(10);
        for (String s : LongList) {
            longList.add(Long.valueOf(s));
        }
        return longList;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals("btnorginput")) {
            this.showSelecteOrgF7();
        } else if (itemKey.equals("btnok")) {
            if (!this.validateInput()) {
                return;
            }
            HashMap<String, Object> returnParamMap = new HashMap<String, Object>();
            DynamicObject usergroupObj = (DynamicObject)this.getModel().getValue("usergroup");
            String remark = this.getModel().getValue("remark1").toString();
            List<Long> orgUserList = this.getEntryCardInfo();
            returnParamMap.put("usergroupid", usergroupObj.getString("id"));
            returnParamMap.put("remark", remark);
            returnParamMap.put("orglist", orgUserList);
            String rowindex = this.getPageCache().get("rowindex");
            if (rowindex != null) {
                returnParamMap.put("rowindex", rowindex);
            }
            this.getView().returnDataToParent(returnParamMap);
            this.getView().close();
        } else if (itemKey.equals("baritemap1")) {
            this.closed();
        }
    }

    private List<Long> getEntryCardInfo() {
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        int orgUserCardsize = cardEntry.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < orgUserCardsize; ++i) {
            DynamicObject org = (DynamicObject)cardEntry.getModel().getValue("orgname", i);
            orgList.add(org.getLong("id"));
        }
        return orgList;
    }

    private boolean validateInput() {
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        int orgUserCardsize = cardEntry.getModel().getEntryRowCount("entryentity");
        if (orgUserCardsize < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DisRuleOrgUserInput_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject usergroupObj = (DynamicObject)this.getModel().getValue("usergroup");
        if (usergroupObj == null || usergroupObj.getString("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DisRuleOrgUserInput_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showSelecteOrgF7() {
        String sscIdStr = (String)this.getView().getFormShowParameter().getCustomParam("sscid");
        ListShowParameter lsp = OrgF7ViewShowHelper.buildOrgShowFormParameter((boolean)true, null, (Long)Long.parseLong(sscIdStr));
        List<Long> orgUserList = this.getEntryCardInfo();
        if (orgUserList.size() > 0) {
            lsp.setSelectedRows(orgUserList.toArray());
        }
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "orgrangeSelected"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals("orgrangeSelected")) {
            List<Long> disOrgIdList = this.getSelectedOrgIDs(e);
            this.buildOrgEntryCardByDisOrgIDs(disOrgIdList);
        }
    }

    private void buildOrgEntryCardByDisOrgIDs(List<Long> disOrgIdList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("orgname", new Object[0]);
        for (long dptID : disOrgIdList) {
            vs.addRow(new Object[]{dptID});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private List<Long> getSelectedOrgIDs(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (ListSelectedRow row : returnData) {
            Long id = (Long)row.getPrimaryKeyValue();
            orgIdList.add(id);
        }
        return orgIdList;
    }

    public void closed() {
        IDataModel model = this.getModel();
        if (this.ischangeremark() || model.getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"DisRuleOrgUserInput_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"DisRuleOrgUserInput_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"DisRuleOrgUserInput_7", (String)"ssc-task-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DisRuleOrgUserInput_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.closeView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (e.getResult() == MessageBoxResult.Yes) {
            this.closeView();
        }
    }

    public void closeView() {
        this.getView().close();
    }

    private boolean ischangeremark() {
        String remark1 = this.getModel().getValue("remark1").toString();
        String remark = this.getPageCache().get("remark");
        if (StringUtils.isEmpty((String)remark1) && StringUtils.isEmpty((String)remark)) {
            return false;
        }
        if (StringUtils.isEmpty((String)remark1)) {
            return !remark.equals(remark1);
        }
        return !remark1.equals(remark);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String key = edit.getKey();
        if ("usergroup".equals(key)) {
            e.addCustomQFilter(new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue()));
        }
    }
}

