/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.ssc.task.business.quality.credit.CreditFilterCondition;
import kd.ssc.task.business.quality.credit.QualityCheckCreditHelper;
import kd.ssc.task.formplugin.PriorityrulePlugin;

public class QualityCheckScaleFieldF7Plugin
extends AbstractBillPlugIn
implements BeforeFilterF7SelectListener {
    private static final Log log = LogFactory.getLog(PriorityrulePlugin.class);
    private static final String taskParams = "personid.number,personid.name,subject,tasklevelid.name,createtime,imageuploadtime,receivetime,completetime,expirestate,innermsg,apprevalmessage";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        FilterGrid taskfiltergrid = (FilterGrid)this.getControl("taskfiltergridap");
        taskfiltergrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        FilterGrid creditFilterGrid = (FilterGrid)this.getControl("creditfiltergridap");
        creditFilterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        if (event.getFieldName().equals("tasklevelid.name")) {
            String ssc = this.getView().getFormShowParameter().getCustomParam("ssc") + "";
            if (StringUtils.isBlank((CharSequence)ssc)) {
                log.info("QualityCheckScaleFieldF7Plugin#beforeF7Select:\u83b7\u53d6\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3anull");
                ssc = "-1";
            }
            QFilter filter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"task_tasklevel", (Long)Long.parseLong(ssc));
            event.addCustomQFilter(filter);
        } else if ("creditlevel.name".equals(event.getFieldName())) {
            event.addCustomParam("showDisabledCheckbox", (Object)Boolean.FALSE);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (key.equals("save")) {
            boolean isBill = (Boolean)this.getView().getFormShowParameter().getCustomParam("isBill");
            Map<Object, Object> map = new HashMap(16);
            if (isBill) {
                map = this.saveTaskBillFilter();
                map.putAll(this.saveCreditFilter());
            } else {
                map = this.saveTaskFilter();
            }
            log.info("QualityCheckScaleFieldF7Plugin \u56de\u4f20\u7ed9\u4e1a\u52a1\u5355\u636emap:" + map);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean isBill = (Boolean)this.getView().getFormShowParameter().getCustomParam("isBill");
        if (isBill) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"task"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bill", "credit"});
            this.createBillFilterGrid();
            this.createCreditFilterGrid();
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"task"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bill", "credit"});
            this.createTaskFilterGrid();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter paramter = this.getView().getFormShowParameter();
        boolean isBill = (Boolean)paramter.getCustomParam("isBill");
        String json = (String)paramter.getCustomParam("json");
        String creditJson = (String)paramter.getCustomParam("creditJson");
        String appObj = (String)paramter.getCustomParam("appObj");
        if (!isBill) {
            if (StringUtils.isEmpty((CharSequence)json)) {
                return;
            }
            FilterCondition taskfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getControl("taskfiltergridap");
            filterGrid.SetValue(taskfilterCondition);
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            FilterCondition billfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            filterGrid.SetValue(billfilterCondition);
        }
        if (StringUtils.isNotEmpty((CharSequence)creditJson) && StringUtils.isNotEmpty((CharSequence)appObj)) {
            FilterGrid creditFilterGridap = (FilterGrid)this.getControl("creditfiltergridap");
            CreditFilterCondition creditfilterCondition = (CreditFilterCondition)SerializationUtils.fromJsonString((String)creditJson, CreditFilterCondition.class);
            creditFilterGridap.SetValue((FilterCondition)creditfilterCondition);
        }
    }

    public void createTaskFilterGrid() {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        FilterGrid filterGrid = (FilterGrid)this.getControl("taskfiltergridap");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_task");
        List<String> taskParamList = Arrays.asList(taskParams.split(","));
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType).stream().filter(column -> taskParamList.contains(column.get("fieldName"))).collect(Collectors.toList());
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(filterColumns);
    }

    public void createBillFilterGrid() {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String taskBill = (String)paramter.getCustomParam("taskBill");
        log.info(String.format("\u62bd\u68c0\u8303\u56f4\u8fc7\u6ee4\u6761\u4ef6\u4f20\u9012\u7684taskBill %s", taskBill));
        if (taskBill != null) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)taskBill);
            List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(filterColumns);
        }
    }

    public void createCreditFilterGrid() {
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String appObj = (String)paramter.getCustomParam("appObj");
        if (StringUtils.isEmpty((CharSequence)appObj)) {
            return;
        }
        String taskBill = (String)paramter.getCustomParam("taskBill");
        String appObjName = QualityCheckCreditHelper.queryAppObjName((String)taskBill, (String)appObj);
        FilterGrid filterGrid = (FilterGrid)this.getControl("creditfiltergridap");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_qualityscalef7credit");
        filterGrid.setEntityNumber(entityType.getName());
        ArrayList<Map> filterColumns = new ArrayList<Map>(10);
        FilterField creditLevelFilterField = FilterField.create((MainEntityType)entityType, (String)"creditlevel.name");
        Map creditLevelFilterColumn = creditLevelFilterField.createFilterColumn();
        creditLevelFilterColumn.put("fieldCaption", StringUtils.join((Object[])new String[]{appObjName, ".", ResManager.loadKDString((String)"\u4fe1\u7528\u7b49\u7ea7\u540d\u79f0", (String)"QualityCheckScaleFieldF7Plugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0])}));
        filterColumns.add(creditLevelFilterColumn);
        FilterField creditValueFilterField = FilterField.create((MainEntityType)entityType, (String)"creditvalue");
        Map creditValueFilterColumn = creditValueFilterField.createFilterColumn();
        creditValueFilterColumn.put("fieldCaption", StringUtils.join((Object[])new String[]{appObjName, ".", ResManager.loadKDString((String)"\u4fe1\u7528\u5206\u6570", (String)"QualityCheckScaleFieldF7Plugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0])}));
        filterColumns.add(creditValueFilterColumn);
        filterGrid.setFilterColumns(filterColumns);
    }

    private String getAppObjName() {
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String appObj = (String)paramter.getCustomParam("appObj");
        String taskBill = (String)paramter.getCustomParam("taskBill");
        String displayName = QualityCheckCreditHelper.queryAppObjName((String)taskBill, (String)appObj);
        return displayName;
    }

    private Map<String, String> saveTaskBillFilter() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String taskBill = (String)this.getView().getFormShowParameter().getCustomParam("taskBill");
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)taskBill);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(dataType, fc, false);
        filterBuilder.buildFilter(false);
        String billparamfiler = filterBuilder.getFilterObject().getFilter();
        if (StringUtils.isNotEmpty((CharSequence)billparamfiler)) {
            map.put("filter", billparamfiler);
            map.put("filterCondition", SerializationUtils.toJsonString((Object)fc));
        }
        return map;
    }

    private Map<String, String> saveCreditFilter() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)"task_qualityscalef7credit");
        FilterGrid creditFilterGrid = (FilterGrid)this.getControl("creditfiltergridap");
        FilterCondition fc = creditFilterGrid.getFilterGridState().getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(dataType, fc, false);
        filterBuilder.buildFilter(false);
        String paramFilter = filterBuilder.getFilterObject().getFilter();
        String creditParamFilter = this.buildCreditParamFilter(paramFilter);
        CreditFilterCondition creditFilterCondition = this.buildCreditFilterCondition(fc);
        if (StringUtils.isNotEmpty((CharSequence)paramFilter)) {
            map.put("creditFilter", creditParamFilter);
            map.put("creditFilterCondition", SerializationUtils.toJsonString((Object)creditFilterCondition));
        }
        return map;
    }

    private CreditFilterCondition buildCreditFilterCondition(FilterCondition fc) {
        String jsonString = SerializationUtils.toJsonString((Object)fc);
        CreditFilterCondition creditFilterCondition = (CreditFilterCondition)JSONObject.parseObject((String)jsonString, CreditFilterCondition.class);
        String appObj = (String)this.getView().getFormShowParameter().getCustomParam("appObj");
        creditFilterCondition.setAppObj(appObj);
        return creditFilterCondition;
    }

    private String buildCreditParamFilter(String paramFilter) {
        if (StringUtils.isEmpty((CharSequence)paramFilter)) {
            return "";
        }
        String appObjName = this.getAppObjName();
        String creditValueName = ResManager.loadKDString((String)"\u4fe1\u7528\u5206\u6570", (String)"QualityCheckScaleFieldF7Plugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        String creditLevelName = ResManager.loadKDString((String)"\u4fe1\u7528\u7b49\u7ea7", (String)"QualityCheckScaleFieldF7Plugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        String desc = paramFilter.replaceAll(creditValueName, StringUtils.join((Object[])new String[]{appObjName, ".", creditValueName}));
        return desc.replaceAll(creditLevelName + "\\.", appObjName + "\\.");
    }

    private Map<String, String> saveTaskFilter() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)"task_task");
        FilterGrid filterGrid = (FilterGrid)this.getControl("taskfiltergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(dataType, fc, false);
        filterBuilder.buildFilter(false);
        String taskparamfiler = filterBuilder.getFilterObject().getFilter();
        if (StringUtils.isNotEmpty((CharSequence)taskparamfiler)) {
            map.put("filter", taskparamfiler);
            map.put("filterCondition", SerializationUtils.toJsonString((Object)fc));
        }
        return map;
    }
}

