/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.util.SscLicenseUtil;

public class QualityCheckSchemeListPlugin
extends AbstractListPlugin
implements ItemClickListener {
    private static final Log log = LogFactory.getLog(QualityCheckSchemeListPlugin.class);
    private int sum = 0;
    private static final String KEY_QUALITYCHECKSCHEME_FIRSTROAD = "qualityCheckSchemeFirstRoad";
    private List<FilterColumn> commonFilters;

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if ("excutedonothing".equalsIgnoreCase(args.getVarMap().get("source.operateKey").toString())) {
            args.setCancel(true);
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckSchemeListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6bcf\u6b21\u9009\u62e9\u4e00\u4e2a\u8d28\u68c0\u65b9\u6848\u6267\u884c\u3002", (String)"QualityCheckSchemeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("btnimplement", (IFormPlugin)this);
            String strDeleteConfirmTip = ResManager.loadKDString((String)"\u201c\u7acb\u5373\u6267\u884c\u201d\u5c06\u4ea7\u751f\u8d28\u68c0\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u6267\u884c\uff1f", (String)"QualityCheckSchemeListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && "deletedonothing".equalsIgnoreCase(e.getOperateKey())) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckSchemeListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("deletescheme", (IFormPlugin)this);
            String strDeleteConfirmTip = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"QualityCheckSchemeListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if ("deletescheme".equalsIgnoreCase(arg0.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                Object[] ids = selectedRows.getPrimaryKeyValues();
                QFilter filterId = new QFilter("id", "in", (Object)ids);
                DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"task_qualitycheckscheme", (String)"id,name,status,enable", (QFilter[])new QFilter[]{filterId});
                if (schemes == null || schemes.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8d28\u68c0\u65b9\u6848\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"QualityCheckSchemeListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                Boolean enable = Boolean.FALSE;
                String shemeName = "";
                for (DynamicObject dynamicObject : schemes) {
                    enable = dynamicObject.getBoolean("enable");
                    shemeName = dynamicObject.getString("name");
                    if (enable.booleanValue()) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"QualityCheckSchemeListPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]), shemeName));
                    return;
                }
                DynamicObject[] libs = QualityCheckSchemeUtil.getSampleLibrarysBySchemeId(ids);
                List<String> processStateList = Arrays.asList("1", "5", "4");
                ArrayList<Long> libsId = new ArrayList<Long>();
                if (libs != null && libs.length > 0) {
                    for (DynamicObject item : libs) {
                        Long libId = item.getLong("id");
                        libsId.add(libId);
                        Object state = item.get("state");
                        String number = item.getString("number");
                        String schemeName = item.getString("checkscheme.name");
                        if (processStateList.contains(state)) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u540d\u79f0\u201c%1$s\u201d\u751f\u6210\u7684\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u6837\u672c\u5e93\u6ca1\u6709\u201c\u5f85\u5206\u914d\u201d\u7684\u8d28\u68c0\u4efb\u52a1,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"QualityCheckSchemeListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName, number));
                            return;
                        }
                        if (!"0".equals(state) || !QualityCheckSchemeUtil.isExistProcessQualityCheckTask(libId)) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u540d\u79f0\u201c%1$s\u201d\u751f\u6210\u7684\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u6837\u672c\u5e93\u6ca1\u6709\u201c\u5f85\u5206\u914d\u201d\u7684\u8d28\u68c0\u4efb\u52a1,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"QualityCheckSchemeListPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName, number));
                        return;
                    }
                }
                try (TXHandle tXHandle = TX.required((String)(((Object)((Object)this)).getClass().getName() + "delete"));){
                    try {
                        DeleteServiceHelper.delete((String)"task_qualitycheckscheme", (QFilter[])new QFilter[]{filterId});
                        QFilter filterLibId = new QFilter("id", "in", libsId);
                        QFilter filterState = new QFilter("state", "=", (Object)"0");
                        DeleteServiceHelper.delete((String)"task_qualitysamplelibrary", (QFilter[])new QFilter[]{filterLibId, filterState});
                        QFilter filterTaskLibId = new QFilter("qualitysamplelibrary", "in", libsId);
                        QFilter filterUnassignedState = new QFilter("qualitystate", "=", (Object)"0");
                        DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{filterTaskLibId, filterUnassignedState});
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u5220\u9664\u6210\u529f\u3002", (String)"QualityCheckSchemeListPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    }
                    catch (Throwable e) {
                        tXHandle.markRollback();
                        log.error("\u8d28\u68c0\u65b9\u6848\u5220\u9664\u5931\u8d25!", e);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8d28\u68c0\u65b9\u6848\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QualityCheckSchemeListPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    }
                }
                this.getView().invokeOperation("refresh");
            }
        } else if ("btnimplement".equalsIgnoreCase(arg0.getCallBackId()) && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            IListView view = (IListView)this.getView();
            view.setEnable(Boolean.FALSE, new String[]{"implement"});
            DynamicObject checkSchemeInfo = this.getCheckScheme((Long)selectedRows.get(0).getPrimaryKeyValue());
            if (checkSchemeInfo == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u6267\u884c\u5931\u8d25\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QualityCheckSchemeListPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                view.setEnable(Boolean.TRUE, new String[]{"implement"});
                this.getView().invokeOperation("refresh");
                return;
            }
            Boolean enable = checkSchemeInfo.getBoolean("enable");
            String schemeName = checkSchemeInfo.getString("name");
            if (!enable.booleanValue()) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u3002", (String)"QualityCheckSchemeListPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName));
                view.setEnable(Boolean.TRUE, new String[]{"implement"});
                this.getView().invokeOperation("refresh");
                return;
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"excutedonothing", (String)"task_qualitycheckscheme", (Object[])new Object[]{checkSchemeInfo.getLong("id")}, (OperateOption)OperateOption.create());
            Map result = (Map)SerializationUtils.fromJsonString((String)operationResult.getMessage(), HashMap.class);
            String message = ResManager.loadKDString((String)"\u672a\u62bd\u53d6\u5230\u8d28\u68c0\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u62bd\u68c0\u53c2\u6570\u3002", (String)"QualityCheckSchemeListPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            if (!result.isEmpty()) {
                int num = Integer.parseInt(result.get("num") + "");
                if (num > -1) {
                    if (num > 0) {
                        message = String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u201c%1$s\u201d\u5df2\u6267\u884c\u7ed3\u675f\uff0c\u5171\u751f\u6210%2$s\u6761\u8d28\u68c0\u4efb\u52a1\u3002", (String)"QualityCheckSchemeListPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName, num);
                    }
                } else {
                    message = String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u201c%1$s\u201d\u6267\u884c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"QualityCheckSchemeListPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName, result.get("error"));
                }
            }
            view.showMessage(message);
            view.setEnable(Boolean.TRUE, new String[]{"implement"});
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        String sscid = "";
        Long sscidl = 0L;
        String cacheSscKey = CacheKey.getSSCKey((Object)KEY_QUALITYCHECKSCHEME_FIRSTROAD);
        if (this.getPageCache().get(cacheSscKey) == null) {
            for (FilterColumn filterColumn : this.commonFilters) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("ssccenter.name".equals(fieldName)) {
                    List sscValueList;
                    Map sscidMap = commonFilterColumn.getDefaultFilter();
                    if (sscidMap == null || sscidMap.size() <= 0 || (sscValueList = (List)sscidMap.get("Value")) == null || sscValueList.size() <= 0) continue;
                    sscid = (String)sscValueList.get(0);
                    sscidl = Long.valueOf(sscid);
                    this.getPageCache().put(cacheSscKey, "true");
                    this.getPageCache().put("qualityCheckScheme_sscid", sscid);
                    continue;
                }
                if ("tasktype.name".equalsIgnoreCase(fieldName)) {
                    QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                    QFilter idFilter = new QFilter("orgfield.id", "=", (Object)sscidl);
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckScheme_taskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscid, false);
                    continue;
                }
                if (!"taskbill.name".equalsIgnoreCase(fieldName)) continue;
                QFilter filter = new QFilter("ssccenter.id", "=", (Object)sscidl);
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckScheme_billType", commonFilterColumn, "task_taskbill", filter, sscid, false);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List<String> nullFieldValues = Arrays.asList("tasktype.id", "taskbill.id");
        Object sscId = CommonFilterUtil.handleCommonFilterNullWhenClickSwitchSSC(args, "ssccenter.id", nullFieldValues);
        if (sscId != null) {
            this.getPageCache().put("qualityCheckScheme_sscid", sscId.toString());
        }
        if (this.commonFilters != null && this.commonFilters.size() > 0) {
            for (FilterColumn filterColumn : this.commonFilters) {
                Long sscidl;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("tasktype.name".equalsIgnoreCase(fieldName)) {
                    if (sscId == null) continue;
                    sscidl = Long.valueOf(sscId + "");
                    QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                    QFilter idFilter = new QFilter("orgfield.id", "=", (Object)sscidl);
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckScheme_taskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscId, false);
                    continue;
                }
                if (!"taskbill.name".equalsIgnoreCase(fieldName) || sscId == null) continue;
                sscidl = Long.valueOf(sscId + "");
                QFilter filter = new QFilter("ssccenter.id", "=", (Object)sscidl);
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckScheme_billType", commonFilterColumn, "task_taskbill", filter, sscId, false);
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List filters = event.getQFilters();
        for (QFilter filter : filters) {
            if (!filter.getProperty().equals("taskbill.id")) continue;
            filter.or(new QFilter("taskbillentry.multaskbill.id", "=", filter.getValue()));
        }
        event.setOrderBy("createtime desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynObjs = super.getData(start, limit);
                dynObjs.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("taskbillname", String.class, null));
                List ids = dynObjs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_qualitycheckscheme"));
                HashMap schemeMap = new HashMap(16);
                Arrays.stream(schemes).forEach(scheme -> schemeMap.put(scheme.getPkValue(), scheme));
                dynObjs.forEach(dyn -> {
                    DynamicObject scheme = (DynamicObject)schemeMap.get(dyn.getPkValue());
                    DynamicObjectCollection mulTaskBill = scheme.getDynamicObjectCollection("taskbillentry");
                    if (CollectionUtils.isEmpty((Collection)mulTaskBill)) {
                        Object taskBill2 = scheme.get("taskbill");
                        if (taskBill2 != null) {
                            dyn.set("taskbillname", ((DynamicObject)taskBill2).get("name"));
                        }
                    } else {
                        dyn.set("taskbillname", (Object)mulTaskBill.stream().map(taskBill -> taskBill.getString("multaskbill.name")).collect(Collectors.joining(";")));
                    }
                });
                return dynObjs;
            }
        });
    }

    private DynamicObject getCheckScheme(long checkSchemeID) {
        DynamicObject checkScheme = BusinessDataServiceHelper.loadSingle((Object)checkSchemeID, (String)"task_qualitycheckscheme");
        DynamicObjectCollection taskBillEntry = checkScheme.getDynamicObjectCollection("taskbillentry");
        if (taskBillEntry.size() < 1) {
            log.info("\u591a\u9009\u4e1a\u52a1\u5355\u636e\uff0c\u6267\u884c\u8be5\u8d28\u68c0\u65b9\u6848\u65f6\u5148\u4fdd\u5b58\uff0c\u517c\u5bb9\u65e7\u6570\u636e" + checkScheme.getPkValue());
            DynamicObject taskBill = checkScheme.getDynamicObject("taskbill");
            if (taskBill == null) {
                log.info("\u8be5\u8d28\u68c0\u65b9\u6848\u5f15\u7528\u7684\u4e1a\u52a1\u5355\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c" + checkScheme.getPkValue());
                return null;
            }
            DynamicObject mulTaskBill = taskBillEntry.addNew();
            String condition = checkScheme.getString("taskbillcondiontion");
            String conditionJson = checkScheme.getString("taskbillcondiontionjson");
            mulTaskBill.set("multaskbill", taskBill.getPkValue());
            mulTaskBill.set("scale", (Object)checkScheme.getString("percentage"));
            mulTaskBill.set("samplenum", (Object)checkScheme.getString("samplesize"));
            if (StringUtils.isNotEmpty((CharSequence)condition) && StringUtils.isNotEmpty((CharSequence)conditionJson)) {
                Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionJson, Map.class);
                String taskFilterJson = (String)filterConditionMap.get("taskparamfiler");
                String billFilterJson = (String)filterConditionMap.get("billparamfiler");
                if (StringUtils.isEmpty((CharSequence)billFilterJson) && StringUtils.isEmpty((CharSequence)taskFilterJson)) {
                    mulTaskBill.set("conditionjson", (Object)billFilterJson);
                    mulTaskBill.set("condition", (Object)condition);
                    checkScheme.set("taskbillcondiontion", null);
                    checkScheme.set("taskbillcondiontionjson", null);
                }
                if (StringUtils.isNotEmpty((CharSequence)billFilterJson) && StringUtils.isBlank((CharSequence)taskFilterJson)) {
                    mulTaskBill.set("conditionjson", (Object)billFilterJson);
                    mulTaskBill.set("condition", (Object)condition.replaceAll("\\(", "").replaceAll("\\)", ""));
                    checkScheme.set("taskbillcondiontionjson", null);
                    checkScheme.set("taskbillcondiontion", null);
                }
                if (StringUtils.isEmpty((CharSequence)billFilterJson) && StringUtils.isNotEmpty((CharSequence)taskFilterJson)) {
                    mulTaskBill.set("conditionjson", null);
                    mulTaskBill.set("condition", null);
                    checkScheme.set("taskbillcondiontionjson", (Object)taskFilterJson);
                    checkScheme.set("taskbillcondiontion", (Object)condition.replaceAll("\\(", "").replaceAll("\\)", ""));
                }
                if (StringUtils.isNotEmpty((CharSequence)billFilterJson) && StringUtils.isNotEmpty((CharSequence)taskFilterJson)) {
                    mulTaskBill.set("conditionjson", (Object)billFilterJson);
                    checkScheme.set("taskbillcondiontionjson", (Object)taskFilterJson);
                    String and = ResManager.loadKDString((String)"\u5e76\u4e14", (String)"QualityCheckSchemePlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    String or = ResManager.loadKDString((String)"\u6216\u8005", (String)"QualityCheckSchemePlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    String splitTextAnd = ")" + and + "(";
                    String splitTextOr = ")" + or + "(";
                    String splitTextAnd2 = "\\)" + and + "\\(";
                    String splitTextOr2 = "\\)" + or + "\\(";
                    if (condition.contains(splitTextAnd)) {
                        String billCondition = condition.split(splitTextAnd2)[0];
                        String taskCondition = condition.split(splitTextAnd2)[1];
                        mulTaskBill.set("condition", (Object)billCondition.replaceAll("\\(", ""));
                        checkScheme.set("taskbillcondiontion", (Object)taskCondition.replaceAll("\\)", ""));
                    } else if (condition.contains(splitTextOr)) {
                        String billCondition = condition.split(splitTextOr2)[0];
                        String taskCondition = condition.split(splitTextOr2)[1];
                        mulTaskBill.set("condition", (Object)billCondition.replaceAll("\\(", ""));
                        checkScheme.set("taskbillcondiontion", (Object)taskCondition.replaceAll("\\)", ""));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkScheme});
        }
        return checkScheme;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperlinkclickargs) {
        super.billListHyperLinkClick(hyperlinkclickargs);
        HyperLinkClickEvent args = hyperlinkclickargs.getHyperLinkClickEvent();
        String fileldName = args.getFieldName();
        if ("operate".equals(fileldName)) {
            ListSelectedRow selectedRow = ((BillList)this.getView().getControl("billlistap")).getCurrentSelectedRowInfo();
            if (selectedRow == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"QualityCheckSchemeListPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String checkschemeid = selectedRow.getPrimaryKeyValue().toString();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("checkschemeid", checkschemeid);
            params.put("source", "checkscheme");
            params.put("ssccenterid", QualityCheckSchemeUtil.getSSCIDByQualityScheme(selectedRow.getPrimaryKeyValue()));
            this.navigateOtherForm(hyperlinkclickargs, params);
        }
    }

    private void navigateOtherForm(HyperLinkClickArgs args, Map<String, Object> map) {
        args.setCancel(true);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParams(map);
        listShowParameter.setBillFormId("task_qualitysamplelibrary");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u6837\u672c\u5e93", (String)"QualityCheckSchemeListPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc;
        if (e.getSource() instanceof ColumnDesc && "operate".equals((columnDesc = (ColumnDesc)e.getSource()).getKey())) {
            e.setFormatValue((Object)ResManager.loadKDString((String)"\u67e5\u770b\u8d28\u68c0\u6837\u672c\u5e93", (String)"QualityCheckSchemeListPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        List qfilters = args.getQfilters();
        String name = args.getFieldName();
        String sscId = this.getPageCache().get("qualityCheckScheme_sscid");
        if ("taskbill.id".equals(name)) {
            if (kd.bos.util.StringUtils.isNotEmpty((String)sscId)) {
                qfilters.add(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscId)));
            }
            args.addCustomParam("showDisabledCheckbox", (Object)Boolean.FALSE);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String formId = "task_qualitycheckscheme";
        boolean hasLicense = SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)formId);
        if (!hasLicense) {
            return;
        }
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), formId, e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u83dc\u5355\u65e0\u6743\u9650\u3002", (String)"QualityCheckSchemeListPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

