/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.formplugin.QualityCheckTaskParentPlugin;
import kd.ssc.task.formplugin.quality.QualityApprovalPendingHelper;

public class QualityCheckTaskRectifyingPlugin
extends QualityCheckTaskParentPlugin
implements ClickListener,
ItemClickListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(QualityCheckTaskRectifyingPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid entryentity = (AbstractGrid)this.getControl("entryentityfail");
        AbstractGrid entryentitysuccess = (AbstractGrid)this.getControl("entryentitysuccess");
        AbstractGrid entryentityreform = (AbstractGrid)this.getControl("entryentityreform");
        entryentity.addRowClickListener((RowClickEventListener)this);
        entryentitysuccess.addRowClickListener((RowClickEventListener)this);
        entryentityreform.addRowClickListener((RowClickEventListener)this);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSelectTab();
        this.initPointName();
        this.initFirstQualityAdvice();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        String taskId = this.getPageCache().get("taskid");
        long taskIdInt = Long.parseLong(taskId);
        String personid = this.getPageCache().get("personid");
        String sampraryLibId = this.getPageCache().get("sampraryLibId");
        long sampraryLibIdInt = Long.parseLong(sampraryLibId);
        DynamicObjectCollection checks = model.getEntryEntity("entryentityfail");
        if (checks == null || checks.size() == 0) {
            return;
        }
        if ("save".equals(key)) {
            super.saveMessage(checks, false, taskIdInt, "1", TaskStateEnum.RECTIFYING.getValue());
            this.fireSaveAttachments("rectifyattachment", taskIdInt, 1L);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"QualityCheckTaskRectifyingPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else if ("checksubmit".equals(key)) {
            for (DynamicObject item : checks) {
                String name = item.getString("name");
                String rectifydeclare = item.getString("checkinfo");
                if (!StringUtils.isBlank((CharSequence)rectifydeclare)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u68c0\u70b9\u201c%s\u201d\u7684\u6574\u6539\u56de\u590d\u3002", (String)"QualityCheckTaskRectifyingPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), name));
                return;
            }
            boolean isSubmitSuccess = false;
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "checksubmit"));){
                try {
                    boolean issuccess = super.saveMessage(checks, true, taskIdInt, "1", TaskStateEnum.RECTIFYING.getValue());
                    if (issuccess) {
                        HashMap<String, Object> changeData = new HashMap<String, Object>();
                        changeData.put("isnewmessage", 0);
                        this.updateMessageState(checks, taskIdInt, "0", TaskStateEnum.RECTIFYING.getValue(), changeData);
                    }
                    DynamicObject task = this.getTask(taskIdInt, sampraryLibIdInt);
                    long orignalpersonId = task.getLong("orignalperson.id");
                    super.saveTask(taskIdInt, orignalpersonId, TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.REVIEW.getValue(), null, null);
                    if (!this.isExistToDoQualityCheckTask(sampraryLibIdInt)) {
                        HashMap<String, Object> changeData = new HashMap<String, Object>();
                        changeData.put("state", "1");
                        this.changeQualitySampleLib(sampraryLibIdInt, changeData);
                    }
                    this.getView().returnDataToParent((Object)"hasreturnorignalperson");
                    isSubmitSuccess = true;
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u63d0\u4ea4\u51fa\u9519", e);
                    isSubmitSuccess = false;
                }
            }
            if (isSubmitSuccess) {
                this.fireSaveAttachments("rectifyattachment", taskIdInt, 1L);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"QualityCheckTaskRectifyingPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if ("bar_pending".equalsIgnoreCase(key)) {
            if (this.isPendingState(taskIdInt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u5df2\u6682\u6302\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"QualityCheckTaskRectifyingPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            super.openQualityPendingDialog(taskIdInt);
        } else if ("bar_cancelpause".equalsIgnoreCase(key)) {
            if (!this.isPendingState(taskIdInt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u6682\u6302\u7684\u8d28\u68c0\u4efb\u52a1\u64cd\u4f5c\u53d6\u6d88\u6682\u6302\u3002", (String)"QualityCheckTaskRectifyingPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            ArrayList<Long> taskIds = new ArrayList<Long>(8);
            taskIds.add(taskIdInt);
            Map<String, Object> returnData = QualityApprovalPendingHelper.qualityCancelPending(taskIds);
            this.qualityCancelPauseAction(taskIdInt, personid, returnData);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        this.initCheckRecordTab(key);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("checkappeal".equalsIgnoreCase(propName) || "checkdone".equalsIgnoreCase(propName)) {
            boolean newValue;
            IDataModel model = this.getModel();
            ChangeData changeData = e.getChangeSet()[0];
            int index = changeData.getRowIndex();
            boolean bl = newValue = changeData.getNewValue() != null && (Boolean)changeData.getNewValue() != false;
            if ("checkappeal".equalsIgnoreCase(propName)) {
                model.setValue("checkdone", (Object)(!newValue ? 1 : 0), index);
            } else if ("checkdone".equalsIgnoreCase(propName)) {
                model.setValue("checkappeal", (Object)(!newValue ? 1 : 0), index);
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        this.initCheckRecordTab(key);
    }

    private void initCheckRecordTab(String key) {
        int index;
        IDataModel model = this.getModel();
        long taskid = Long.parseLong(this.getPageCache().get("taskid"));
        String pointStr = null;
        Object cpName = null;
        if ("entryentityfail".equals(key) || "qcfailtab".equalsIgnoreCase(key)) {
            index = model.getEntryCurrentRowIndex("entryentityfail");
            pointStr = model.getValue("pointid", index) == null ? null : model.getValue("pointid", index).toString();
            cpName = model.getValue("name", index);
        } else if ("entryentitysuccess".equalsIgnoreCase(key) || "qcsuccesstab".equalsIgnoreCase(key)) {
            index = model.getEntryCurrentRowIndex("entryentitysuccess");
            pointStr = model.getValue("pointid1", index) == null ? null : model.getValue("pointid1", index).toString();
            cpName = model.getValue("name1", index);
        } else if ("entryentityreform".equalsIgnoreCase(key) || "qcreformpasstab".equalsIgnoreCase(key)) {
            index = model.getEntryCurrentRowIndex("entryentityreform");
            pointStr = model.getValue("pointid2", index) == null ? null : model.getValue("pointid2", index).toString();
            cpName = model.getValue("name2", index);
        }
        if (StringUtils.isEmpty((CharSequence)pointStr)) {
            return;
        }
        if (null != cpName) {
            model.setValue("cpname", (Object)String.format(ResManager.loadKDString((String)"%s\u8d28\u68c0\u8bb0\u5f55\u8be6\u60c5\uff1a", (String)"QualityCheckTaskRectifyingPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]), cpName));
        }
        long point = Long.parseLong(pointStr);
        this.initCheckRecord(point, taskid, Arrays.asList("0", "1", "2"));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("action_quality_pause".equalsIgnoreCase(actionId)) {
            Object returnData = e.getReturnData();
            if (returnData == null) {
                return;
            }
            this.qualityPauseAction((Map)returnData);
        }
    }

    private void qualityPauseAction(Map<String, Object> returnData) {
        IDataModel model = this.getModel();
        Map<String, Object> dataMap = returnData;
        Integer totalSuccessCount = (Integer)dataMap.get("totalSuccessCount");
        String errorMsg = (String)dataMap.get("errorMsg");
        if (totalSuccessCount == 1) {
            String personid = this.getPageCache().get("personid");
            String taskId = this.getPageCache().get("taskid");
            long taskIdInt = Long.parseLong(taskId);
            DynamicObjectCollection checks = model.getEntryEntity("entryentityfail");
            boolean isSaveSuccess = false;
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "bar_pending"));){
                try {
                    super.saveMessage(checks, false, taskIdInt, "1", TaskStateEnum.RECTIFYING.getValue());
                    super.saveTask(taskIdInt, Long.parseLong(personid), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), null, null);
                    isSaveSuccess = true;
                }
                catch (Throwable ex) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u6682\u6302\u540e\u8fdb\u884c\u4fdd\u5b58\u9519\u8bef", ex);
                    isSaveSuccess = false;
                }
            }
            if (isSaveSuccess) {
                this.fireSaveAttachments("rectifyattachment", taskIdInt, 1L);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u6302\u6210\u529f\u3002", (String)"QualityCheckTaskRectifyingPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.setPageControlState(false, TaskStateEnum.RECTIFYING.getValue());
            model.setValue("qcpend", (Object)1);
        } else {
            this.getView().showErrorNotification(errorMsg);
            model.setValue("qcpend", (Object)0);
        }
    }

    private void qualityCancelPauseAction(long taskIdInt, String personid, Map<String, Object> returnData) {
        IDataModel model = this.getModel();
        Map<String, Object> dataMap = returnData;
        Integer totalSuccessCount = (Integer)dataMap.get("totalSuccessCount");
        String errorMsg = (String)dataMap.get("errorMsg");
        if (totalSuccessCount == 1) {
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "bar_cancelpause"));){
                try {
                    super.saveTask(taskIdInt, Long.parseLong(personid), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.RECTIFYING.getValue(), null, null);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u53d6\u6d88\u6682\u6302\u540e\u8fdb\u884c\u4fdd\u5b58\u9519\u8bef", e);
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"QualityCheckTaskRectifyingPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.setPageControlState(true, TaskStateEnum.RECTIFYING.getValue());
            model.setValue("qcpend", (Object)0);
        } else {
            this.getView().showErrorNotification(errorMsg);
            model.setValue("qcpend", (Object)1);
        }
    }
}

