/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.business.helper.TaskCreditHelper;
import kd.ssc.task.formplugin.QualityCheckTaskParentPlugin;
import kd.ssc.task.formplugin.quality.QualityApprovalPendingHelper;

public class QualityCheckTaskReviewPlugin
extends QualityCheckTaskParentPlugin
implements ClickListener,
ItemClickListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(QualityCheckTaskReviewPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid entryentity = (AbstractGrid)this.getControl("entryentityfail");
        AbstractGrid entryentitysuccess = (AbstractGrid)this.getControl("entryentitysuccess");
        AbstractGrid entryentityreform = (AbstractGrid)this.getControl("entryentityreform");
        entryentity.addRowClickListener((RowClickEventListener)this);
        entryentitysuccess.addRowClickListener((RowClickEventListener)this);
        entryentityreform.addRowClickListener((RowClickEventListener)this);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String poolType = this.getPageCache().get("pooltype");
        this.initSelectTab();
        this.initPointName();
        if (TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
            this.hideControlsWhenComplete();
        }
        this.initFirstQualityAdvice();
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        this.initCheckRecordTab(key);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        String personid = this.getPageCache().get("personid");
        Long personidInt = Long.valueOf(personid);
        String taskId = this.getPageCache().get("taskid");
        long taskIdInt = Long.parseLong(taskId);
        String sampraryLibId = this.getPageCache().get("sampraryLibId");
        long sampraryLibIdInt = Long.parseLong(sampraryLibId);
        DynamicObjectCollection checks = model.getEntryEntity("entryentityfail");
        DynamicObjectCollection checkSuccessDos = model.getEntryEntity("entryentitysuccess");
        if (checks == null || checks.size() == 0) {
            return;
        }
        boolean isAllPass = true;
        if ("checksubmit".equalsIgnoreCase(key)) {
            String name;
            for (DynamicObject item : checks) {
                name = item.getString("name");
                String rectifydeclare = item.getString("checkinfo");
                if (StringUtils.isBlank((CharSequence)rectifydeclare)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u7ed9\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8d28\u68c0\u70b9\u586b\u5199\u590d\u6838\u56de\u590d\u3002", (String)"QualityCheckTaskReviewPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), name));
                    return;
                }
                boolean isreback = item.getBoolean("checkreback");
                if (!isreback) continue;
                isAllPass = false;
            }
            for (DynamicObject checkSuccessDo : checkSuccessDos) {
                name = checkSuccessDo.getString("name1");
                boolean checknopass = checkSuccessDo.getBoolean("checknopass");
                String rectifydeclare = checkSuccessDo.getString("checkinfo3");
                if (!checknopass) continue;
                if (StringUtils.isBlank((CharSequence)rectifydeclare)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u7ed9\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8d28\u68c0\u70b9\u586b\u5199\u590d\u6838\u56de\u590d\u3002", (String)"QualityCheckTaskReviewPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), name));
                    return;
                }
                isAllPass = false;
            }
        }
        if ("save".equals(key)) {
            super.saveMessage(checks, false, taskIdInt, "0", TaskStateEnum.REVIEW.getValue());
            this.saveCheckSuccessMessage(taskIdInt, checkSuccessDos);
            this.fireSaveAttachments("qcattachment", taskIdInt, 0L);
            this.fireSaveAttachments("rectifyattachment", taskIdInt, 1L);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"QualityCheckTaskReviewPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else if ("checksubmit".equalsIgnoreCase(key)) {
            TXHandle h;
            boolean isSubmitSuccess = false;
            Object newTaskId = null;
            if (isAllPass) {
                h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "checksubmit"));
                Throwable throwable = null;
                try {
                    try {
                        this.updateMessageByReviewSubmit(taskIdInt, checks, checkSuccessDos);
                        super.saveTask(taskIdInt, personidInt, TaskPoolTypeEnum.COMPLETE.getValue(), TaskStateEnum.QUA_CHECK_COMPLETED.getValue(), null, null);
                        this.updateCheckResult(taskIdInt);
                        newTaskId = this.saveQualityHistoryTask(taskIdInt);
                        HashMap<String, Object> changeData = new HashMap<String, Object>(3);
                        changeData.put("addnum", 1);
                        if (this.isCompleteQualityCheckLibrary(sampraryLibIdInt)) {
                            changeData.put("checkcompletetime", new Date());
                            changeData.put("state", "4");
                        }
                        this.changeQualitySampleLib(sampraryLibIdInt, changeData);
                        this.dealQualitySubScore((Long)newTaskId);
                        this.getView().returnDataToParent((Object)"hasreviewd");
                        isSubmitSuccess = true;
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        log.error("\u8d28\u68c0\u4efb\u52a1\u590d\u6838\u63d0\u4ea4\u51fa\u9519", e);
                        isSubmitSuccess = false;
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                finally {
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable e) {
                                throwable.addSuppressed(e);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
                this.changeReformNum(sampraryLibIdInt, newTaskId);
            } else {
                h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "checksubmit"));
                Throwable throwable = null;
                try {
                    try {
                        this.updateMessageByReviewSubmit(taskIdInt, checks, checkSuccessDos);
                        DynamicObject task = this.getTask(taskIdInt, sampraryLibIdInt);
                        long reformpersonId = task.getLong("reformperson.id");
                        super.saveTask(Long.parseLong(taskId), reformpersonId, TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.RECTIFYING.getValue(), null, null);
                        this.getView().returnDataToParent((Object)"returncheck");
                        isSubmitSuccess = true;
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        log.error("\u8d28\u68c0\u4efb\u52a1\u590d\u6838\u63d0\u4ea4\u51fa\u9519", e);
                        isSubmitSuccess = false;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            if (isSubmitSuccess) {
                if (newTaskId != null) {
                    taskIdInt = (Long)newTaskId;
                }
                this.fireSaveAttachments("qcattachment", taskIdInt, 0L);
                this.fireSaveAttachments("rectifyattachment", taskIdInt, 1L);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u590d\u6838\u63d0\u4ea4\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\u3002", (String)"QualityCheckTaskReviewPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if ("bar_pending".equalsIgnoreCase(key)) {
            if (this.isPendingState(taskIdInt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d28\u68c0\u4efb\u52a1\u5df2\u5904\u4e8e\u6682\u6302\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"QualityCheckTaskReviewPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            super.openQualityPendingDialog(taskIdInt);
        } else if ("bar_cancelpause".equalsIgnoreCase(key)) {
            if (!this.isPendingState(taskIdInt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u6682\u6302\u7684\u8d28\u68c0\u4efb\u52a1\u6267\u884c\u53d6\u6d88\u6682\u6302\u64cd\u4f5c\u3002", (String)"QualityCheckTaskReviewPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            ArrayList<Long> taskIds = new ArrayList<Long>(8);
            taskIds.add(taskIdInt);
            Map<String, Object> returnData = QualityApprovalPendingHelper.qualityCancelPending(taskIds);
            this.qualityCancelPauseAction(taskIdInt, personid, returnData);
        }
    }

    private void updateCheckResult(Long taskId) {
        QFilter taskIdFilter = new QFilter("qualitycheck", "=", (Object)taskId);
        QFilter handleMethodFilter = new QFilter("handlemethod", "=", (Object)"1");
        boolean checkResult = QueryServiceHelper.exists((String)"task_qualitymessagerecord", (QFilter[])new QFilter[]{taskIdFilter, handleMethodFilter});
        QFilter filterId = new QFilter("id", "=", (Object)taskId);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id,qualityresult", (QFilter[])new QFilter[]{filterId});
        if (task != null) {
            task.set("qualityresult", (Object)(checkResult ? 0 : 1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        }
    }

    private void saveCheckSuccessMessage(long taskIdInt, DynamicObjectCollection checkSuccessDos) {
        DynamicObjectCollection toUnPassDos = new DynamicObjectCollection();
        DynamicObjectCollection passDos = new DynamicObjectCollection();
        for (DynamicObject p : checkSuccessDos) {
            if (p.getBoolean("checknopass")) {
                toUnPassDos.add((Object)p);
                continue;
            }
            passDos.add((Object)p);
        }
        super.saveMessage(toUnPassDos, false, taskIdInt, "0", TaskStateEnum.REVIEW.getValue(), "qcsuccesstab");
        this.deleteMessage(passDos, taskIdInt, "0", "qcsuccesstab");
    }

    private void updateMessageByReviewSubmit(long taskIdInt, DynamicObjectCollection checks, DynamicObjectCollection checkSuccessDos) {
        HashMap<String, Object> changeData;
        DynamicObjectCollection toUnPassDos = new DynamicObjectCollection();
        DynamicObjectCollection passDos = new DynamicObjectCollection();
        for (DynamicObject p : checkSuccessDos) {
            if (p.getBoolean("checknopass")) {
                toUnPassDos.add((Object)p);
                continue;
            }
            passDos.add((Object)p);
        }
        boolean isSaveSuccess = super.saveMessage(checks, true, taskIdInt, "0", TaskStateEnum.REVIEW.getValue());
        boolean isSaveSuccess2 = super.saveMessage(toUnPassDos, true, taskIdInt, "0", TaskStateEnum.REVIEW.getValue(), "qcsuccesstab");
        boolean isDelete = this.deleteMessage(passDos, taskIdInt, "0", "qcsuccesstab");
        log.info("\u8d28\u68c0\u4efb\u52a1\u5904\u7406\u590d\u6838-\u4fdd\u5b58\u8d28\u68c0\u4fe1\u606f\u8bb0\u5f55end\uff0c\u4e0d\u5408\u683c\u9875\u7b7e:" + isSaveSuccess + ",\u5408\u683c\u9875\u7b7e:", (Object)(isSaveSuccess2 + ",isDelete:"), (Object)isDelete);
        if (isSaveSuccess) {
            changeData = new HashMap<String, Object>();
            changeData.put("isnewmessage", 0);
            this.updateMessageState(checks, taskIdInt, "1", TaskStateEnum.REVIEW.getValue(), changeData);
            HashMap<String, Object> changeCheckData = new HashMap<String, Object>();
            changeCheckData.put("isnewmessage", 1);
            changeCheckData.put("updateCheckResult", true);
            this.updateMessageState(checks, taskIdInt, "0", TaskStateEnum.REVIEW.getValue(), changeCheckData);
        }
        if (isSaveSuccess2) {
            changeData = new HashMap();
            changeData.put("isnewmessage", 0);
            QFilter filterHandleMethod = new QFilter("handlemethod", "=", (Object)Character.valueOf(' '));
            QFilter filterReviewMethod = new QFilter("reviewmethod", "=", (Object)Character.valueOf(' '));
            changeData.put("otherFilter", filterHandleMethod.and(filterReviewMethod));
            this.updateMessageState(toUnPassDos, taskIdInt, "0", TaskStateEnum.REVIEW.getValue(), changeData, "qcsuccesstab");
            HashMap<String, Object> changeCheckData = new HashMap<String, Object>();
            changeCheckData.put("isnewmessage", 1);
            changeCheckData.put("updateCheckResult", true);
            QFilter filterReviewMethod2 = new QFilter("reviewmethod", "=", (Object)"4");
            changeCheckData.put("otherFilter", filterReviewMethod2);
            this.updateMessageState(toUnPassDos, taskIdInt, "0", TaskStateEnum.REVIEW.getValue(), changeCheckData, "qcsuccesstab");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("checkpass".equalsIgnoreCase(propName) || "checkreback".equalsIgnoreCase(propName)) {
            IDataModel model = this.getModel();
            ChangeData changeData = e.getChangeSet()[0];
            int index = changeData.getRowIndex();
            boolean newValue = changeData.getNewValue() != null && (Boolean)changeData.getNewValue() != false;
            String handlemethod = String.valueOf(model.getValue("handlemethod", index));
            String checkinfo = "";
            checkinfo = "2".equals(handlemethod) ? ResManager.loadKDString((String)"\u7533\u8bc9\u901a\u8fc7", (String)"QualityCheckTaskReviewPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6574\u6539\u901a\u8fc7", (String)"QualityCheckTaskReviewPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            if ("checkpass".equalsIgnoreCase(propName)) {
                if (newValue) {
                    model.setValue("checkinfo", (Object)checkinfo, index);
                } else {
                    model.setValue("checkinfo", (Object)"", index);
                }
                model.setValue("checkreback", (Object)(!newValue ? 1 : 0), index);
            } else if ("checkreback".equalsIgnoreCase(propName)) {
                if (!newValue) {
                    model.setValue("checkinfo", (Object)checkinfo, index);
                }
                model.setValue("checkpass", (Object)(!newValue ? 1 : 0), index);
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        this.initCheckRecordTab(key);
    }

    private void initCheckRecordTab(String key) {
        int index;
        IDataModel model = this.getModel();
        long taskid = Long.parseLong(this.getPageCache().get("taskid"));
        String pointStr = null;
        Object cpName = null;
        if ("entryentityfail".equals(key) || "qcfailtab".equalsIgnoreCase(key)) {
            index = model.getEntryCurrentRowIndex("entryentityfail");
            pointStr = model.getValue("pointid", index) == null ? null : model.getValue("pointid", index).toString();
            cpName = model.getValue("name", index);
        } else if ("entryentitysuccess".equalsIgnoreCase(key) || "qcsuccesstab".equalsIgnoreCase(key)) {
            index = model.getEntryCurrentRowIndex("entryentitysuccess");
            pointStr = model.getValue("pointid1", index) == null ? null : model.getValue("pointid1", index).toString();
            cpName = model.getValue("name1", index);
        } else if ("entryentityreform".equalsIgnoreCase(key) || "qcreformpasstab".equalsIgnoreCase(key)) {
            index = model.getEntryCurrentRowIndex("entryentityreform");
            pointStr = model.getValue("pointid2", index) == null ? null : model.getValue("pointid2", index).toString();
            cpName = model.getValue("name2", index);
        }
        if (StringUtils.isEmpty((CharSequence)pointStr)) {
            return;
        }
        if (null != cpName) {
            model.setValue("cpname", (Object)String.format(ResManager.loadKDString((String)"%s\u8d28\u68c0\u8bb0\u5f55\u8be6\u60c5\uff1a", (String)"QualityCheckTaskReviewPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]), cpName));
        }
        long point = Long.parseLong(pointStr);
        this.initCheckRecord(point, taskid, Arrays.asList("0", "1", "2"));
    }

    private void hideControlsWhenComplete() {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"save", "checksubmit", "bar_pending"});
        view.setEnable(Boolean.FALSE, new String[]{"qcattachment"});
        view.setEnable(Boolean.FALSE, new String[]{"rectifyattachment"});
    }

    private void changeReformNum(Long sampleLibId, Object qualityTaskId) {
        QFilter filterCheck = new QFilter("qualitycheck", "=", qualityTaskId);
        filterCheck.and(new QFilter("reviewmethod", "=", (Object)"1"));
        boolean checkResult = QueryServiceHelper.exists((String)"task_qualitymessagerecord", (QFilter[])new QFilter[]{filterCheck});
        QFilter filter = new QFilter("id", "=", (Object)sampleLibId);
        filter.and(new QFilter("issmart", "=", (Object)"1"));
        String selectFields = "id,reformnum";
        DynamicObject sampleLib = BusinessDataServiceHelper.loadSingle((String)"task_qualitysamplelibrary", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (sampleLib != null && checkResult) {
            sampleLib.set("reformnum", (Object)(sampleLib.getInt("reformnum") + 1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sampleLib});
        }
    }

    private void dealQualitySubScore(long taskId) {
        QFilter filterCheck = new QFilter("qualitycheck", "=", (Object)taskId);
        DynamicObject[] checkPointCols = BusinessDataServiceHelper.load((String)"task_qualitymessagerecord", (String)"point,qualitycheck,ischeckok,rebackcount,handlemethod,reviewmethod, entryentity.message,entryentity.datetime,entryentity.messagetype,entryentity.usercheck, entryentity.isnewmessage", (QFilter[])new QFilter[]{filterCheck});
        if (checkPointCols == null || checkPointCols.length == 0) {
            return;
        }
        HashSet<Long> handleSet = new HashSet<Long>(5);
        for (DynamicObject record : checkPointCols) {
            if (!"1".equals(record.getString("reviewmethod"))) continue;
            handleSet.add(record.getLong("point"));
        }
        if (handleSet.size() == 0) {
            return;
        }
        this.creditSubScore(taskId, new ArrayList<Long>(handleSet));
    }

    private void creditSubScore(long historyTaskId, List<Long> failPointIds) {
        if (failPointIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection qryResults = QueryServiceHelper.query((String)"task_checkingpoint", (String)"subscorerule.id", (QFilter[])new QFilter[]{new QFilter("id", "in", failPointIds)});
        if (CollectionUtils.isEmpty((Collection)qryResults)) {
            return;
        }
        ArrayList subScoreRuleIds = new ArrayList();
        for (DynamicObject point : qryResults) {
            Optional.ofNullable(point.getLong("subscorerule.id")).ifPresent(subscoreruleId -> subScoreRuleIds.add(subscoreruleId));
        }
        if (subScoreRuleIds.isEmpty()) {
            return;
        }
        String description = ResManager.loadKDString((String)"\u8d28\u68c0\u4e0d\u5408\u683c", (String)"QualityCheckTaskHandlingPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        TaskCreditHelper.dispatch2FircmDeductPoint((String)description, (long)historyTaskId, subScoreRuleIds);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("action_quality_pause".equalsIgnoreCase(actionId)) {
            this.qualityPauseAction((Map)returnData);
        }
    }

    private void qualityPauseAction(Map<String, Object> returnData) {
        IDataModel model = this.getModel();
        Map<String, Object> dataMap = returnData;
        Integer totalSuccessCount = (Integer)dataMap.get("totalSuccessCount");
        String errorMsg = (String)dataMap.get("errorMsg");
        if (totalSuccessCount == 1) {
            String personid = this.getPageCache().get("personid");
            String taskId = this.getPageCache().get("taskid");
            long taskIdInt = Long.parseLong(taskId);
            DynamicObjectCollection checks = model.getEntryEntity("entryentityfail");
            DynamicObjectCollection checkSuccessDos = model.getEntryEntity("entryentitysuccess");
            boolean isSaveSuccess = false;
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "bar_pending"));){
                try {
                    super.saveMessage(checks, false, taskIdInt, "0", TaskStateEnum.REVIEW.getValue());
                    this.saveCheckSuccessMessage(taskIdInt, checkSuccessDos);
                    super.saveTask(taskIdInt, Long.parseLong(personid), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue(), null, null);
                    isSaveSuccess = true;
                }
                catch (Throwable ex) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u6682\u6302\u540e\u8fdb\u884c\u4fdd\u5b58\u9519\u8bef", ex);
                    isSaveSuccess = false;
                }
            }
            if (isSaveSuccess) {
                this.fireSaveAttachments("qcattachment", taskIdInt, 0L);
                this.fireSaveAttachments("rectifyattachment", taskIdInt, 1L);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u6302\u6210\u529f\uff01", (String)"QualityCheckTaskReviewPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.setPageControlState(false, TaskStateEnum.REVIEW.getValue());
            model.setValue("qcpend", (Object)1);
        } else {
            this.getView().showErrorNotification(errorMsg);
            model.setValue("qcpend", (Object)0);
        }
    }

    private void qualityCancelPauseAction(long taskIdInt, String personid, Map<String, Object> returnData) {
        IDataModel model = this.getModel();
        Map<String, Object> dataMap = returnData;
        Integer totalSuccessCount = (Integer)dataMap.get("totalSuccessCount");
        String errorMsg = (String)dataMap.get("errorMsg");
        if (totalSuccessCount == 1) {
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "bar_cancelpause"));){
                try {
                    super.saveTask(taskIdInt, Long.parseLong(personid), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.REVIEW.getValue(), null, null);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u53d6\u6d88\u6682\u6302\u540e\u8fdb\u884c\u4fdd\u5b58\u9519\u8bef", e);
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"QualityCheckTaskReviewPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.setPageControlState(true, TaskStateEnum.REVIEW.getValue());
            model.setValue("qcpend", (Object)0);
        } else {
            this.getView().showErrorNotification(errorMsg);
            model.setValue("qcpend", (Object)1);
        }
    }
}

