/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.formplugin.util.MetadataUtil;
import org.apache.commons.lang3.StringUtils;

public class QualityCheckingPointEditPlugin
extends AbstractBillPlugIn {
    private static final String CACHE_KEY_NAME_BEFORE_SAVE = "nameBeforeSave";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.saveCurrNameAndDescInCache();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        Object source = args.getSource();
        if (source instanceof Save) {
            Object createOrg = model.getValue("createorg");
            model.setValue("ssccenter", createOrg);
            String name = this.getModel().getValue("name").toString();
            if (StringUtils.isBlank((CharSequence)name)) {
                return;
            }
            String confirmYes = this.getPageCache().get("confirmYes");
            if (!"true".equals(confirmYes) && this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT) && this.nameUpdated()) {
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u88ab\u5f15\u7528\u7684\u8d28\u68c0\u65b9\u6848\u53ca\u5386\u53f2\u4efb\u52a1\u5c06\u540c\u6b65\u66f4\u65b0\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"QualityCheckingPointEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirmSave", (IFormPlugin)this));
            }
        }
    }

    private boolean nameUpdated() {
        String currName = this.getModel().getValue("name").toString();
        String cachedName = this.getPageCache().get(CACHE_KEY_NAME_BEFORE_SAVE);
        return !cachedName.equals(currName);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmSave".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getPageCache().put("confirmYes", "true");
            this.getView().invokeOperation("save");
        }
    }

    private void saveCurrNameAndDescInCache() {
        String name = this.getModel().getValue("name").toString();
        name = name == null ? "" : name;
        this.getView().getPageCache().put(CACHE_KEY_NAME_BEFORE_SAVE, name);
    }

    public void afterCopyData(EventObject e) {
        DynamicObject subscoreruleDy;
        long id;
        DynamicObject dynamicObject;
        String enable;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        boolean exists = MetadataUtil.existEntity("fircm_subscorerule");
        if (!exists) {
            return;
        }
        Object subscorerule = model.getValue("subscorerule");
        if (!Objects.isNull(subscorerule) && "0".equals(enable = (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)(id = (subscoreruleDy = (DynamicObject)subscorerule).getLong("id")), (String)"fircm_subscorerule")).getString("enable"))) {
            model.setValue("subscorerule", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save && args.getOperationResult().isSuccess()) {
            this.saveCurrNameAndDescInCache();
            this.getPageCache().remove("confirmSave");
        }
    }
}

