/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.util.SscLicenseUtil;

public class QualitySampleLibraryListPlugin
extends AbstractListPlugin
implements ItemClickListener {
    private static final Log log = LogFactory.getLog(QualitySampleLibraryListPlugin.class);
    private static Set<String> processStateList = new HashSet<String>(Arrays.asList("1", "5", "4"));
    private static final String KEY_QUALITYCHECKLIBRARY_FIRSTROAD = "qualityCheckLibraryFirstRoad";
    private List<FilterColumn> commonFilters;

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynObjs = super.getData(start, limit);
                dynObjs.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("cmplrate", String.class, null));
                DecimalFormat format = new DecimalFormat("#%");
                for (DynamicObject dynObj : dynObjs) {
                    BigDecimal cmplNum = BigDecimal.valueOf(dynObj.getLong("completednum"));
                    BigDecimal totalNum = BigDecimal.valueOf(dynObj.getInt("totalnum"));
                    if (totalNum.compareTo(BigDecimal.ZERO) != 0) {
                        dynObj.set("cmplrate", (Object)format.format(cmplNum.divide(totalNum, 2, RoundingMode.HALF_UP)));
                        continue;
                    }
                    dynObj.set("cmplrate", (Object)"--");
                }
                return dynObjs;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            if ("closelibdonothing".equals(e.getOperateKey())) {
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                if (selectedRows == null || selectedRows.size() == 0) {
                    return;
                }
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u5173\u95ed\u4e00\u6761\u8d28\u68c0\u6837\u672c\u5e93\u3002", (String)"QualitySampleLibraryListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                int sum = 0;
                HashMap<String, Object> changeMap = new HashMap<String, Object>();
                changeMap.put("state", "5");
                StringBuilder sbMsg = new StringBuilder();
                for (ListSelectedRow listSelectedRow : selectedRows) {
                    long sampleLibId = (Long)listSelectedRow.getPrimaryKeyValue();
                    DynamicObject sampleLib = this.getQualityCheckSampleLib(sampleLibId);
                    String number = sampleLib.getString("number");
                    String state = sampleLib.getString("state");
                    if ("4".equals(state)) {
                        int unCompleteCount = QualityCheckSchemeUtil.getUnCompleteQualityCheckTask(sampleLibId);
                        if (unCompleteCount == 0) {
                            TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "closesamplelibrary"));
                            Throwable throwable = null;
                            try {
                                try {
                                    QualityCheckSchemeUtil.changeQualityCheckHistoryTaskState(sampleLibId, changeMap);
                                    QualityCheckSchemeUtil.changeQualitySampleLib(sampleLibId, changeMap);
                                    ++sum;
                                }
                                catch (Throwable ex) {
                                    h.markRollback();
                                    log.error("\u5173\u95ed\u6837\u672c\u5e93\u51fa\u9519\uff0c", ex);
                                    sbMsg.append(String.format(ResManager.loadKDString((String)"\u6837\u672c\u5e93%s\u5173\u95ed\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QualitySampleLibraryListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), number));
                                }
                                continue;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (h == null) continue;
                                if (throwable != null) {
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                h.close();
                                continue;
                            }
                        }
                        sbMsg.append(String.format(ResManager.loadKDString((String)"\u6837\u672c\u5e93\u201c%1$s\u201c\u5b58\u5728%2$s\u6761\u672a\u5b8c\u6210\u7684\u8d28\u68c0\u4efb\u52a1\uff0c\u65e0\u6cd5\u5173\u95ed\u3002", (String)"QualitySampleLibraryListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), number, unCompleteCount));
                        continue;
                    }
                    sbMsg.append(String.format(ResManager.loadKDString((String)"\u6837\u672c\u5e93%s\u5173\u95ed\u5931\u8d25\uff0c\u53ea\u6709\u5df2\u5b8c\u6210\u7684\u6837\u672c\u5e93\u624d\u53ef\u5173\u95ed\u3002", (String)"QualitySampleLibraryListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), number));
                }
                if (sbMsg.length() == 0) {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u603b\u5171\u5173\u95ed%s\u6761\u8d28\u68c0\u6837\u672c\u5e93\u3002", (String)"QualitySampleLibraryListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), sum));
                } else {
                    this.getView().showErrorNotification(sbMsg.toString());
                }
                this.getView().invokeOperation("refresh");
            } else if ("deletedonothing".equalsIgnoreCase(e.getOperateKey())) {
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                if (selectedRows == null || selectedRows.size() == 0) {
                    return;
                }
                ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("deletelibrary", (IFormPlugin)this);
                String strDeleteConfirmTip = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"QualitySampleLibraryListPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if (arg0.getCallBackId().equals("deletelibrary") && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Object[] ids = selectedRows.getPrimaryKeyValues();
            QFilter filterId = new QFilter("id", "in", (Object)ids);
            DynamicObject[] libs = BusinessDataServiceHelper.load((String)"task_qualitysamplelibrary", (String)"id,checkscheme,state", (QFilter[])new QFilter[]{filterId});
            if (libs == null || libs.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6837\u672c\u5e93\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"QualitySampleLibraryListPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Object> checkschemeList = new ArrayList<Object>();
            for (DynamicObject item : libs) {
                Long libId = item.getLong("id");
                Object state = item.get("state");
                Object checkscheme = item.get("checkscheme.id");
                if (processStateList.contains(state)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u672a\u5206\u914d\u72b6\u6001\u4e0b\u7684\u6837\u672c\u5e93\u3002", (String)"QualitySampleLibraryListPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("0".equals(state) && QualityCheckSchemeUtil.isExistProcessQualityCheckTask(libId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6837\u672c\u5e93\u5b58\u5728\u975e\u5f85\u5206\u914d\u72b6\u6001\u4e0b\u7684\u8d28\u68c0\u4efb\u52a1\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"QualitySampleLibraryListPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (checkschemeList.contains(checkscheme)) continue;
                checkschemeList.add(checkscheme);
            }
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "delete"));){
                try {
                    DeleteServiceHelper.delete((String)"task_qualitysamplelibrary", (QFilter[])new QFilter[]{filterId});
                    QualityCheckSchemeUtil.deleteUnassignedTask(ids);
                    this.updateQualityCheckSchemeState(checkschemeList);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6837\u672c\u5e93\u5220\u9664\u6210\u529f\u3002", (String)"QualitySampleLibraryListPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u6837\u672c\u5e93\u5220\u9664\u5931\u8d25", e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6837\u672c\u5e93\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QualitySampleLibraryListPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("createtime desc, planfinishtime desc,checkbegintime desc, checkcompletetime desc");
    }

    private DynamicObject getQualityCheckSampleLib(long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"task_qualitysamplelibrary");
    }

    private boolean updateQualityCheckSchemeState(List<Object> schemeIds) {
        QFilter filterSchemeId;
        if (schemeIds == null || schemeIds.size() == 0) {
            return false;
        }
        ORM orm = ORM.create();
        if (orm.exists("task_qualitysamplelibrary", new QFilter[]{filterSchemeId = new QFilter("checkscheme", "in", schemeIds)})) {
            return false;
        }
        QFilter filterQualitySchemeId = new QFilter("id", "in", schemeIds);
        QFilter filterQualitySchemeState = new QFilter("status", "=", (Object)"C");
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"task_qualitycheckscheme", (String)"id,status", (QFilter[])new QFilter[]{filterQualitySchemeId, filterQualitySchemeState});
        if (schemes == null || schemes.length == 0) {
            return false;
        }
        for (DynamicObject item : schemes) {
            item.set("status", (Object)"A");
        }
        Object[] rets = SaveServiceHelper.save((DynamicObject[])schemes);
        return rets != null && rets.length > 0;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperlinkclickargs) {
        super.billListHyperLinkClick(hyperlinkclickargs);
        hyperlinkclickargs.setCancel(true);
        HyperLinkClickEvent args = hyperlinkclickargs.getHyperLinkClickEvent();
        String fileldName = args.getFieldName();
        int rowIndex = hyperlinkclickargs.getHyperLinkClickEvent().getRowIndex();
        if ("number".equals(fileldName)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getView().getControl("billlistap")).getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"QualitySampleLibraryListPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Object id = this.getSelectRowId(selectedRows, rowIndex);
            DynamicObject sampleLibrary = this.getQualitySampleLibrary(id);
            if (sampleLibrary == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"QualitySampleLibraryListPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            String sampleLibId = sampleLibrary.getPkValue() == null ? null : sampleLibrary.getPkValue().toString();
            boolean isSmartCheckScheme = Optional.ofNullable(sampleLibrary.getString("issmart")).equals(Optional.of("true"));
            String sampleLibNumber = sampleLibrary.getString("number");
            String sampleLibState = sampleLibrary.getString("state");
            Object checkScheme = sampleLibrary.get(isSmartCheckScheme ? "smartcheckscheme" : "checkscheme");
            if (checkScheme == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u5173\u8054\u7684\u8d28\u68c0\u65b9\u6cd5\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"QualitySampleLibraryListPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dyCheckScheme = (DynamicObject)checkScheme;
            DynamicObject dyCheckSchemeFull = this.getQualityCheckScheme(dyCheckScheme.getPkValue(), isSmartCheckScheme);
            if (dyCheckSchemeFull == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u5173\u8054\u7684\u8d28\u68c0\u65b9\u6cd5\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"QualitySampleLibraryListPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String qualitychecktasktype = dyCheckSchemeFull.getString("qualitychecktasktype.id");
            String checkschemename = dyCheckSchemeFull.getString("name");
            Long sscId = dyCheckSchemeFull.getLong("ssccenter.id");
            List<Long> sscIds = Collections.singletonList(sscId);
            List<String> qualitystateList = QualityCheckSchemeUtil.getQualityState(Collections.singletonList(sampleLibState));
            String billFormId = "task_task";
            if (qualitystateList.contains("5") || qualitystateList.contains("4")) {
                billFormId = "task_taskhistory";
            }
            params.put("sampleLibid", sampleLibId);
            params.put("samplelibnumber", sampleLibNumber);
            params.put("pooltype", Collections.singletonList(QualityCheckSchemeUtil.stateTransfer(sampleLibState)));
            params.put("qualitysscid", sscIds);
            params.put("checkschemeid", dyCheckScheme.getPkValue().toString());
            params.put("checkschemename", checkschemename);
            params.put("qualitychecktasktype", qualitychecktasktype);
            params.put("sources", "qualitysamplelibrary");
            params.put("billformid", billFormId);
            this.navigateOtherForm(hyperlinkclickargs, params, billFormId);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        this.rebuildCommonFilter(this.commonFilters);
    }

    private void rebuildCommonFilter(List<FilterColumn> commonFilters) {
        Map<String, Object> paramMap = this.getCustomParams();
        String originalType = paramMap.get("source") == null ? "" : paramMap.get("source").toString();
        String checkschemeid = paramMap.get("checkschemeid") == null ? "" : paramMap.get("checkschemeid").toString();
        String sscId = paramMap.get("ssccenterid") == null ? "-1" : paramMap.get("ssccenterid").toString();
        String sscKey = CacheKey.getSSCKey((Object)KEY_QUALITYCHECKLIBRARY_FIRSTROAD);
        if (this.getPageCache().get(sscKey) == null) {
            for (FilterColumn filterColumn : commonFilters) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("checkscheme.ssccenter.name".equals(fieldName)) {
                    if (StringUtils.isEmpty((CharSequence)originalType)) {
                        List sscItems = commonFilterColumn.getComboItems();
                        Long orgId = RequestContext.get().getOrgId();
                        sscId = TaskRptHelper.getDefSscId(sscItems, orgId);
                    }
                    commonFilterColumn.setDefaultValue(sscId);
                    this.getPageCache().put(sscKey, "true");
                    this.getPageCache().put("CACHE_QUALITYCHECKMANAGEMENT_SSCID", sscId);
                    continue;
                }
                if (!"checkscheme.number".equals(fieldName)) continue;
                Long sscidl = Long.valueOf(sscId);
                QFilter filter = new QFilter("ssccenter.id", "=", (Object)sscidl);
                filter.and(new QFilter("status", "=", (Object)"C"));
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckLibrary_schemeId", commonFilterColumn, "task_qualitycheckscheme", filter, "createtime desc", sscId, false);
                if (!"checkscheme".equals(originalType)) continue;
                commonFilterColumn.setDefaultValue(checkschemeid);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List<String> nullFieldValues = Collections.singletonList("checkscheme.id");
        Object sscId = CommonFilterUtil.handleCommonFilterNullWhenClickSwitchSSC(args, "checkscheme.ssccenter.id", nullFieldValues);
        if (sscId != null) {
            this.getPageCache().put("CACHE_QUALITYCHECKMANAGEMENT_SSCID", sscId + "");
        }
        if (this.commonFilters != null && this.commonFilters.size() > 0) {
            for (FilterColumn filterColumn : this.commonFilters) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!"checkscheme.number".equalsIgnoreCase(fieldName) || sscId == null) continue;
                Long sscidl = Long.valueOf(sscId + "");
                QFilter filter = new QFilter("ssccenter.id", "=", (Object)sscidl);
                filter.and(new QFilter("status", "=", (Object)"C"));
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckLibrary_schemeId", commonFilterColumn, "task_qualitycheckscheme", filter, "createtime desc", sscId, false);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String sscId;
        super.filterContainerBeforeF7Select(args);
        List qfilters = args.getQfilters();
        String name = args.getFieldName();
        if ("checkscheme.id".equals(name) && StringUtils.isNotEmpty((CharSequence)(sscId = this.getPageCache().get("CACHE_QUALITYCHECKMANAGEMENT_SSCID")))) {
            qfilters.add(new QFilter("ssccenter", "=", (Object)Long.parseLong(sscId)));
        }
    }

    private Map<String, Object> getCustomParams() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        return paramMap;
    }

    private void navigateOtherForm(HyperLinkClickArgs args, Map<String, Object> map, String billFormId) {
        args.setCancel(true);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParams(map);
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.setFormId("task_doqualitymanagement");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406", (String)"QualitySampleLibraryListPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private DynamicObject getQualitySampleLibrary(Object id) {
        if (id == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"task_qualitysamplelibrary");
    }

    private DynamicObject getQualityCheckScheme(Object id, boolean isSmartCheckScheme) {
        if (id == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)(isSmartCheckScheme ? "task_smartcheckscheme" : "task_qualitycheckscheme"));
    }

    private Object getSelectRowId(ListSelectedRowCollection selectedRows, int rowIndex) {
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow listSelectedRow = selectedRows.get(i);
            int rowKey = listSelectedRow.getRowKey();
            if (rowIndex != rowKey) continue;
            return selectedRows.get(i).getPrimaryKeyValue();
        }
        return 0L;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String formId = "task_qualitysamplelibrary";
        boolean hasLicense = SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)formId);
        if (!hasLicense) {
            return;
        }
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), formId, e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"QualitySampleLibraryListPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

