/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.sql.Timestamp;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.ssc.enums.TaskStateEnum;

public class RescanFormPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener {
    public void initialize() {
        Button btn = (Button)this.getView().getControl("btncancel");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            String rescanmsg = (String)this.getModel().getValue("rescanmsg");
            if (StringUtils.isEmpty((String)((String)this.getModel().getValue("rescanmsg")))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5904\u7406\u610f\u89c1\u3002", (String)"RescanFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = this.getView().getFormShowParameter();
            List selectedRowIds = (List)fsp.getCustomParam("selectedRowIds");
            for (Object selectedRowId : selectedRowIds) {
                Long taskid = Long.valueOf(selectedRowId.toString());
                this.updateTaskMsg(rescanmsg, taskid);
                this.insertStateChange(rescanmsg, taskid);
            }
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
    }

    private void updateTaskMsg(String msg, Long taskId) {
        ORM orm = ORM.create();
        DynamicObject obj = orm.newDynamicObject("task_task");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection collection = orm.query("task_task", "id, innerMsg", filters);
        obj = (DynamicObject)collection.get(0);
        obj.set("state", (Object)TaskStateEnum.RESCAN.getValue());
        obj.set("innerMsg", (Object)msg);
        orm.update(obj);
    }

    private void insertStateChange(String rescanmsg, Long taskId) {
        DynamicObjectCollection col = this.getDataTasklist(taskId);
        long billtypeid = (Long)((DynamicObject)col.get(0)).get("billtype");
        long tasktypeid = (Long)((DynamicObject)col.get(0)).get("tasktypeid");
        Timestamp changetime = new Timestamp(System.currentTimeMillis());
        long operatorid = Integer.parseInt(RequestContext.get().getUserId());
        ORM orm = ORM.create();
        DynamicObject stateChangeobj = orm.newDynamicObject("task_statechange");
        stateChangeobj.set("message", (Object)rescanmsg);
        stateChangeobj.set("operatorid", (Object)operatorid);
        stateChangeobj.set("operation", (Object)"5");
        stateChangeobj.set("changetime", (Object)changetime);
        stateChangeobj.set("jobid", (Object)taskId);
        stateChangeobj.set("tasktype", (Object)tasktypeid);
        stateChangeobj.set("billtype", (Object)billtypeid);
        orm.insert(stateChangeobj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection getDataTasklist(Long pkid) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)pkid);
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet dataset = orm.queryDataSet("tasklist", "task_task", "billtype,oprt,billid,pooltype,state,subject,tasktypeid,bizdata_tag", filters);){
            DynamicObjectCollection collection;
            DynamicObjectCollection dynamicObjectCollection = collection = ORMUtil.toDynamicObjectCollection((DataSet)dataset, (String)"task_task");
            return dynamicObjectCollection;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.getView().returnDataToParent(this.getCurrentSelector());
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("rescanmsg", (String)this.getModel().getValue("rescanmsg"));
        return ret;
    }
}

