/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.ssc.enums.PoolType;
import kd.ssc.task.util.ObjectCloneUtil;

public class StateChangeShow
extends AbstractBillPlugIn
implements ItemClickListener {
    private static final String TASK_META = "task_task";
    private static final String HISTASK_META = "task_taskhistory";
    private static final String TASK_STATE_META = "task_statechange";
    private static final String TASK_STATE_HIS_META = "task_statechangehis";

    public void beforeBindData(EventObject e) {
        this.showStateChange();
    }

    private void showStateChange() {
        List<TaskStateChangeGrid> gridList = this.getStateTraceData();
        this.setStateGridData(gridList);
    }

    private List<TaskStateChangeGrid> getStateTraceData() {
        ORM orm = ORM.create();
        ArrayList<TaskStateChangeGrid> gridList = new ArrayList<TaskStateChangeGrid>();
        if (this.isQueryHisTask()) {
            this.getHisJobStateChangeTraceData(orm, gridList);
        } else {
            this.getJobStateChangeTraceData(orm, gridList);
        }
        return gridList;
    }

    private void getJobStateChangeTraceData(ORM orm, List<TaskStateChangeGrid> gridList) {
        List taskidList = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        QFilter taskStateFilter = new QFilter("jobid", "in", (Object)taskidList);
        QFilter[] taskStateFilters = new QFilter[]{taskStateFilter};
        QFilter taskFilter = new QFilter("id", "in", (Object)taskidList);
        QFilter[] taskFilters = new QFilter[]{taskFilter};
        DynamicObjectCollection taskColl = null;
        DynamicObjectCollection stateColl = null;
        try (DataSet taskStateChangeDS = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query task state change", TASK_STATE_META, "jobid,operation,decision,message,innermsg,operatorid,allocatedpersonid,changetime", taskStateFilters, "changetime desc");
             DataSet taskDS = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query task state name", TASK_META, "id,tasktypeid.name,billtype.name", taskFilters);){
            taskColl = ORMUtil.toDynamicObjectCollection((DataSet)taskDS, (String)TASK_META);
            stateColl = ORMUtil.toDynamicObjectCollection((DataSet)taskStateChangeDS, (String)TASK_STATE_META);
            this.buildStateChangeGrid(gridList, stateColl, taskColl, false);
        }
    }

    private void getHisJobStateChangeTraceData(ORM orm, List<TaskStateChangeGrid> gridList) {
        List taskidList = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        QFilter taskFilter = new QFilter("id", "in", (Object)taskidList);
        QFilter[] taskFilters = new QFilter[]{taskFilter};
        DynamicObjectCollection hisTaskColl = null;
        DynamicObjectCollection stateColl = null;
        try (DataSet hisTaskDS = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query task state name", HISTASK_META, "id,tasktypeid.name,billtype.name,sourcetaskid", taskFilters);){
            hisTaskColl = ORMUtil.toDynamicObjectCollection((DataSet)hisTaskDS, (String)HISTASK_META);
        }
        QFilter jobIDFilter = new QFilter("jobid", "in", (Object)taskidList);
        QFilter[] stateJobIDFilters = new QFilter[]{jobIDFilter};
        try (DataSet taskStateChangeDS = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query task state change", TASK_STATE_HIS_META, "jobid,operation,decision,message,innermsg,operatorid,allocatedpersonid,changetime", stateJobIDFilters, "changetime desc");){
            stateColl = ORMUtil.toDynamicObjectCollection((DataSet)taskStateChangeDS, (String)TASK_STATE_HIS_META);
            this.buildStateChangeGrid(gridList, stateColl, hisTaskColl, true);
        }
    }

    private void setStateGridData(List<TaskStateChangeGrid> gridList) {
        IDataModel dataModel = this.getModel();
        if (gridList.size() != 0) {
            dataModel.batchCreateNewEntryRow("entryentity", gridList.size());
            int size = gridList.size();
            for (int i = 0; i < size; ++i) {
                TaskStateChangeGrid taskStateChangeGrid = gridList.get(i);
                dataModel.setValue("taskname", (Object)taskStateChangeGrid.getTaskName(), i);
                dataModel.setValue("operation", (Object)taskStateChangeGrid.getHandleType(), i);
                dataModel.setValue("handleopinion", (Object)taskStateChangeGrid.getHandleMessage(), i);
                dataModel.setValue("descriptionrecord", (Object)taskStateChangeGrid.getInnermsg(), i);
                dataModel.setValue("billhandler", (Object)Long.valueOf(taskStateChangeGrid.getOperatorid()), i);
                dataModel.setValue("allocatedperson", (Object)Long.valueOf(taskStateChangeGrid.getAllocatedpersonid()), i);
                dataModel.setValue("processingtime", (Object)taskStateChangeGrid.getHandleTime(), i);
            }
        }
    }

    private boolean isQueryHisTask() {
        String stateTraceInvokeFrom = (String)this.getView().getFormShowParameter().getCustomParam("state_trace_invoke_from");
        String string = stateTraceInvokeFrom = stateTraceInvokeFrom == null ? "" : stateTraceInvokeFrom;
        if (stateTraceInvokeFrom.equals("state_trace_from_mytask")) {
            String poolType = (String)this.getView().getFormShowParameter().getCustomParam("state_trace_pooltype");
            if ((PoolType.Complete.getValue() + "").equals(poolType)) {
                return true;
            }
        }
        if (stateTraceInvokeFrom.equals("state_trace_from_taskadmin")) {
            String pooltype = (String)this.getView().getFormShowParameter().getCustomParam("state_trace_pooltype");
            String string2 = pooltype = pooltype == null ? "1" : pooltype;
            if (pooltype.equals("2")) {
                return true;
            }
        }
        return false;
    }

    private void buildStateChangeGrid(List<TaskStateChangeGrid> gridList, DynamicObjectCollection stateColl, DynamicObjectCollection taskColl, boolean isQueryHis) {
        HashMap<String, String> taskIDNameMap = new HashMap<String, String>();
        for (DynamicObject taskDyobj : taskColl) {
            String taskName = taskDyobj.getString("tasktypeid.name") + taskDyobj.getString("billtype.name");
            taskIDNameMap.put(taskDyobj.getString("id"), taskName);
        }
        for (DynamicObject taskStateChangeDyobj : stateColl) {
            TaskStateChangeGrid taskStateChangeGrid = new TaskStateChangeGrid();
            taskStateChangeGrid.setTaskName((String)taskIDNameMap.get(taskStateChangeDyobj.getString("jobid")));
            taskStateChangeGrid.setHandleType(taskStateChangeDyobj.getString("operation"));
            taskStateChangeGrid.setHandleDecision(taskStateChangeDyobj.getString("decision"));
            taskStateChangeGrid.setHandleMessage(taskStateChangeDyobj.getString("message"));
            taskStateChangeGrid.setInnermsg("null".equals(taskStateChangeDyobj.getString("innermsg")) ? "" : taskStateChangeDyobj.getString("innermsg"));
            taskStateChangeGrid.setOperatorid(taskStateChangeDyobj.getString("operatorid"));
            taskStateChangeGrid.setAllocatedpersonid(taskStateChangeDyobj.getString("allocatedpersonid"));
            taskStateChangeGrid.setHandleTime(taskStateChangeDyobj.getDate("changetime"));
            gridList.add(taskStateChangeGrid);
        }
    }

    private static class TaskStateChangeGrid {
        private String taskName;
        private String handleType;
        private String handleDecision;
        private String handleMessage;
        private String innermsg;
        private String operatorid;
        private String allocatedpersonid;
        private Date handleTime;

        private TaskStateChangeGrid() {
        }

        public Date getHandleTime() {
            return (Date)ObjectCloneUtil.cloneObject((Object)this.handleTime);
        }

        public void setHandleTime(Date handleTime) {
            this.handleTime = (Date)ObjectCloneUtil.cloneObject((Object)handleTime);
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getHandleType() {
            return this.handleType;
        }

        public void setHandleType(String handleType) {
            this.handleType = handleType;
        }

        public String getHandleDecision() {
            return this.handleDecision;
        }

        public void setHandleDecision(String handleDecision) {
            this.handleDecision = handleDecision;
        }

        public String getHandleMessage() {
            return this.handleMessage;
        }

        public void setHandleMessage(String handleMessage) {
            this.handleMessage = handleMessage;
        }

        public String getInnermsg() {
            return this.innermsg;
        }

        public void setInnermsg(String innermsg) {
            this.innermsg = innermsg;
        }

        public String getOperatorid() {
            return this.operatorid;
        }

        public void setOperatorid(String operatorid) {
            this.operatorid = operatorid;
        }

        public String getAllocatedpersonid() {
            return this.allocatedpersonid;
        }

        public void setAllocatedpersonid(String allocatedpersonid) {
            this.allocatedpersonid = allocatedpersonid;
        }
    }
}

