/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.common.CommonFilterUtil;

public class SynOrgLogListPlugin
extends AbstractListPlugin {
    private List<FilterColumn> commonFilterColumnList = new ArrayList<FilterColumn>();
    private static final String CACHE_KEY_SSC = "sscid";
    private static final String CACHE_KEY_OVER_CLICK = "overclick";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (!this.isOverClick()) {
            this.getPageCache().put(CACHE_KEY_OVER_CLICK, "true");
            String sscid = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_SSC);
            if (StringUtils.isEmpty((CharSequence)sscid)) {
                return;
            }
            this.getPageCache().put(CACHE_KEY_SSC, sscid);
            for (FilterColumn filterColumn : this.commonFilterColumnList) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("sscid.name".equals(fieldName)) {
                    CommonFilterUtil.filterContainerInitDefMainOrg((FilterContainer)this.getControl("filtercontainerap"), commonFilterColumn, "task_taskbill", sscid, this.getView().getFormShowParameter().getAppId());
                    continue;
                }
                if ("bizbill.name".equals(fieldName)) {
                    this.rebuildBizBillFilterColumn(commonFilterColumn);
                    continue;
                }
                if (!"synstatus".equals(fieldName)) continue;
                commonFilterColumn.setDefaultValue("1");
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map commonFilters = args.getCurrentCommonFilter();
        if (commonFilters != null) {
            List fieldName = (List)commonFilters.get("FieldName");
            List value = (List)commonFilters.get("Value");
            if (fieldName != null && fieldName.size() > 0 && value != null && value.size() > 0) {
                CommonFilterColumn sscColumn = this.getSscColumn(this.commonFilterColumnList);
                CommonFilterUtil.filterContainerInitDefMainOrg((FilterContainer)this.getControl("filtercontainerap"), sscColumn, "task_taskbill", this.getPageCache().get(CACHE_KEY_SSC), this.getView().getFormShowParameter().getAppId());
                String currentFieldName = (String)fieldName.get(0);
                if ("sscid.id".equals(currentFieldName)) {
                    Object sscidTmp = value.get(0);
                    if (sscidTmp != null) {
                        this.getPageCache().put(CACHE_KEY_SSC, sscidTmp + "");
                        CommonFilterColumn bizbillColumn = this.getBizBillColumn(this.commonFilterColumnList);
                        this.rebuildBizBillFilterColumn(bizbillColumn);
                        this.focusCommonFilter(args);
                    }
                } else {
                    CommonFilterColumn bizbillColumn = this.getBizBillColumn(this.commonFilterColumnList);
                    this.rebuildBizBillFilterColumn(bizbillColumn);
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        List qfilters = args.getQfilters();
        String sscIDStr = this.getPageCache().get(CACHE_KEY_SSC);
        if (kd.bos.util.StringUtils.isNotEmpty((String)sscIDStr) && "bizbill.id".equals(name)) {
            qfilters.add(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscIDStr)));
        }
    }

    private void rebuildBizBillFilterColumn(CommonFilterColumn commonFilterColumn) {
        String ssc = this.getPageCache().get(CACHE_KEY_SSC);
        if (StringUtils.isBlank((CharSequence)ssc) || commonFilterColumn == null) {
            return;
        }
        Long sscid = Long.valueOf(ssc);
        QFilter[] qfilters = new QFilter[]{new QFilter("ssccenter", "=", (Object)sscid)};
        String selectedField = "id,name";
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"task_taskbill", (String)selectedField, (QFilter[])qfilters);
        ArrayList<ComboItem> l5ComboItem = new ArrayList<ComboItem>();
        ArrayList<Long> bizBillIds = new ArrayList<Long>();
        for (DynamicObject dyo : collections) {
            Long bizBillId = dyo.getLong("id");
            if (!StringUtils.isNotBlank((Object)bizBillId) || bizBillIds.contains(bizBillId)) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(bizBillId));
            item.setCaption(new LocaleString(dyo.getString("name")));
            item.setValue(String.valueOf(bizBillId));
            l5ComboItem.add(item);
            bizBillIds.add(bizBillId);
        }
        commonFilterColumn.setComboItems(l5ComboItem);
    }

    private CommonFilterColumn getBizBillColumn(List<FilterColumn> columnList) {
        CommonFilterColumn bizcolumn = null;
        for (FilterColumn column : columnList) {
            CommonFilterColumn commonColumn = (CommonFilterColumn)column;
            if (!"bizbill.name".equals(commonColumn.getFieldName())) continue;
            bizcolumn = commonColumn;
        }
        return bizcolumn;
    }

    private CommonFilterColumn getSscColumn(List<FilterColumn> columnList) {
        CommonFilterColumn sscColumn = null;
        for (FilterColumn column : columnList) {
            CommonFilterColumn commonColumn = (CommonFilterColumn)column;
            if (!"sscid.name".equals(commonColumn.getFieldName())) continue;
            sscColumn = commonColumn;
        }
        return sscColumn;
    }

    private void focusCommonFilter(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        for (Map filter : customFiterList) {
            String fieldName;
            List fieldNames = (List)filter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)"bizbill.id", (CharSequence)(fieldName = fieldNames.get(0).toString()))) continue;
            filter.replace("Value", Collections.singletonList(""));
        }
    }

    private boolean isOverClick() {
        return "true".equals(this.getPageCache().get(CACHE_KEY_OVER_CLICK));
    }
}

