/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.Expirestate;
import kd.ssc.task.common.ImageOkEnum;

public class TaskAdministrateQingPlugin
extends AbstractFormPlugin
implements IQingDataProvider {
    private static Log log = LogFactory.getLog(TaskAdministrateQingPlugin.class);
    public static final String CACHE_ID = "cacheId";
    private String billFormId;
    private String pooltype;

    public void initialize() {
        super.initialize();
    }

    public QingData getData(String qingPageId, int start, int limit) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(10);
        IFormView view = SessionManager.getCurrent().getView(qingPageId);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String qFilterStr = pageCache.get("qFilter");
        this.billFormId = pageCache.get("billFormId");
        this.pooltype = pageCache.get("pooltype");
        Map<String, Integer> dataIndexMap = this.createDataIndexMap();
        if (StringUtils.isEmpty((String)qFilterStr)) {
            log.error("method:getData(),String qFilterStr = pageCache.get(\"qFilter\"); qFilterStr is null,");
            return null;
        }
        if (StringUtils.isEmpty((String)this.billFormId)) {
            log.error("method:getData(),String billFormId = pageCache.get(\"billFormId\"); billFormId is null,");
            return null;
        }
        String selectField = this.getSelectField();
        QFilter qFilter = QFilter.fromSerializedString((String)qFilterStr);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(qFilter);
        CachedDataSet cachedDataSet = null;
        if (this.isEmpty(pageCache.get(CACHE_ID))) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getTaskData()"), (String)this.billFormId, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), null);
            cachedDataSet = dataSet.cache(CacheHint.getDefault());
            pageCache.put(CACHE_ID, cachedDataSet.getCacheId());
        } else {
            cachedDataSet = this.getDataSet(pageCache.get(CACHE_ID));
        }
        if (start < 1) {
            start = 1;
        }
        List taskData = cachedDataSet.getList(start - 1, limit);
        QingMeta meta = this.createColumnItems();
        List columns = meta.getColumns();
        for (Row taskRow : taskData) {
            ArrayList<Long> rowObj = new ArrayList<Long>(columns.size());
            for (Field field : columns) {
                String value;
                Object colObj = null;
                if (QingFieldType.Date.toNumber() == field.getFieldType()) {
                    colObj = taskRow.getDate(field.getKey()) == null ? null : Long.valueOf(taskRow.getDate(field.getKey()).getTime());
                } else if ("state".equals(field.getKey())) {
                    value = taskRow.getString(field.getKey());
                    TaskStateEnum taskState = TaskStateEnum.getTaskState((String)value);
                    colObj = taskState == null ? "" : taskState.getName();
                } else if ("expirestate".equals(field.getKey())) {
                    value = taskRow.getString(field.getKey());
                    colObj = Expirestate.getName(value);
                } else if ("imageok".equals(field.getKey())) {
                    value = taskRow.getString(field.getKey());
                    colObj = ImageOkEnum.getName(value);
                } else {
                    colObj = taskRow.get(field.getKey());
                }
                rowObj.add((Long)colObj);
            }
            rows.add(rowObj.toArray(new Object[0]));
        }
        QingData qingData = new QingData();
        qingData.setDataindex(dataIndexMap);
        qingData.setRows(rows);
        return qingData;
    }

    private Map<String, Integer> createDataIndexMap() {
        QingMeta meta = this.createColumnItems();
        List columns = meta.getColumns();
        int size = columns.size();
        HashMap<String, Integer> dataIndexMap = new HashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            dataIndexMap.put(((Field)columns.get(i)).getKey(), i);
        }
        return dataIndexMap;
    }

    public QingMeta getMeta(String qingPageId) {
        IFormView view = SessionManager.getCurrent().getView(qingPageId);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        this.billFormId = pageCache.get("billFormId");
        this.pooltype = pageCache.get("pooltype");
        return this.createColumnItems();
    }

    private QingMeta createColumnItems() {
        QingMeta qingMeta = new QingMeta();
        qingMeta.addColumn(this.createFieldObj("creator.name", ResManager.loadKDString((String)"\u7533\u8bf7\u4eba", (String)"TaskAdministrateQingPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("creator.number", ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u5de5\u53f7", (String)"TaskAdministrateQingPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("subject", ResManager.loadKDString((String)"\u4e3b\u9898", (String)"TaskAdministrateQingPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("personid.name", ResManager.loadKDString((String)"\u5904\u7406\u4eba", (String)"TaskAdministrateQingPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("personid.number", ResManager.loadKDString((String)"\u5904\u7406\u4eba\u5de5\u53f7", (String)"TaskAdministrateQingPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("state", ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001", (String)"TaskAdministrateQingPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("apprevalmessage", ResManager.loadKDString((String)"\u5ba1\u6279\u610f\u89c1", (String)"TaskAdministrateQingPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("innermsg", ResManager.loadKDString((String)"\u5185\u90e8\u8bf4\u660e", (String)"TaskAdministrateQingPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("unpassreasondesc", ResManager.loadKDString((String)"\u6279\u9000\u539f\u56e0", (String)"TaskAdministrateQingPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        qingMeta.addColumn(this.createFieldObj("tasklevelid.name", ResManager.loadKDString((String)"\u4efb\u52a1\u4f18\u5148\u7ea7", (String)"TaskAdministrateQingPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        if ("task_task".equals(this.billFormId)) {
            if (TaskPoolTypeEnum.PROCESSING.getValue().equals(this.pooltype)) {
                qingMeta.addColumn(this.createFieldObj("receivetime", ResManager.loadKDString((String)"\u63a5\u6536\u65f6\u95f4", (String)"TaskAdministrateQingPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.Date.toNumber()));
            }
            qingMeta.addColumn(this.createFieldObj("resttime", ResManager.loadKDString((String)"\u5269\u4f59\u65f6\u95f4\uff08\u5c0f\u65f6\uff09", (String)"TaskAdministrateQingPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.Number.toNumber()));
            qingMeta.addColumn(this.createFieldObj("expirestate", ResManager.loadKDString((String)"\u8d85\u671f", (String)"TaskAdministrateQingPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
            qingMeta.addColumn(this.createFieldObj("taskcreatetime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"TaskAdministrateQingPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.Date.toNumber()));
        } else if ("task_taskhistory".equals(this.billFormId)) {
            qingMeta.addColumn(this.createFieldObj("expirestate", ResManager.loadKDString((String)"\u8d85\u671f", (String)"TaskAdministrateQingPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.String.toNumber()));
            qingMeta.addColumn(this.createFieldObj("receivetime", ResManager.loadKDString((String)"\u63a5\u6536\u65f6\u95f4", (String)"TaskAdministrateQingPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.Date.toNumber()));
            qingMeta.addColumn(this.createFieldObj("completetime", ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4", (String)"TaskAdministrateQingPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]), QingFieldType.Date.toNumber()));
        }
        return qingMeta;
    }

    private Field createFieldObj(String key, String name, int fieldType) {
        Field field = new Field();
        field.setKey(key);
        field.setName(new LocaleString(name));
        field.setFieldType(fieldType);
        return field;
    }

    private String getSelectField() {
        QingMeta meta = this.createColumnItems();
        List columns = meta.getColumns();
        return columns.stream().map(Field::getKey).collect(Collectors.joining(","));
    }

    private CachedDataSet getDataSet(String resultId) {
        return Algo.getCacheDataSet((String)resultId);
    }

    private boolean isEmpty(String str) {
        return null == str || str.trim().length() == 0;
    }

    public String getFilterParameter() {
        return this.getPageCache().get("qFilter");
    }

    public void setFilterParameter(String filterParameter) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("qFilter", filterParameter);
    }
}

