/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskApprovePageInvokerEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.bill.TaskBillChildUtil;
import kd.ssc.task.business.helper.WorkFlowInfoHelper;
import kd.ssc.task.formplugin.TaskAskFormPlugin;
import kd.ssc.task.formplugin.pojo.GetNextTaskResult;
import kd.ssc.task.formplugin.pojo.GetNextTaskResultEnum;
import kd.ssc.task.helper.TaskQueryServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskApprevalHelper {
    public static void getNextTask(DynamicObject curtask, IFormView view, String poolType, String poolTask, String sourcePageId) {
        String sampraryLibId;
        DynamicObject restask;
        String msg = "";
        String parentPageId = "";
        int code = 0;
        if (view.getParentView() != null && view.getParentView().getFormShowParameter().getFormId().equals("bos_list") && view.getParentView().getPageId() != null) {
            parentPageId = view.getParentView().getPageId();
        } else if (view.getFormShowParameter().getCustomParam("parentPageId") != null) {
            parentPageId = (String)view.getFormShowParameter().getCustomParam("parentPageId");
        }
        GetNextTaskResult res = TaskApprevalHelper.getNextTaskDetail(curtask, view);
        if (res.isSuccess()) {
            restask = res.getResTask();
        } else {
            msg = res.getMsg();
            restask = null;
            view.showTipNotification(msg);
            if (code == GetNextTaskResultEnum.NO_WAITDIS_TASK.getCode()) {
                view.showConfirm(msg, MessageBoxOptions.OK);
                view.close();
            }
            if (code == GetNextTaskResultEnum.NO_AUDIT_TASK.getCode()) {
                view.showConfirm(msg, MessageBoxOptions.OK);
                view.close();
            }
        }
        if (restask != null && (!StringUtils.isNotEmpty((CharSequence)(sampraryLibId = restask.getString("qualitysamplelibrary.id"))) || "0".equals(sampraryLibId))) {
            HashMap<String, String> map = new HashMap<String, String>();
            String pkId = restask.get("id").toString();
            map.put("formId", "task_approve");
            map.put("pkId", pkId);
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(map);
            formShowParameter.setCustomParam("billid", restask.get("billid"));
            long billtypeid = NumberUtils.toLong((String)restask.getString("billtype.id"));
            DynamicObjectCollection collection = TaskQueryServiceHelper.getDataOperationNumberAndtype(billtypeid);
            if (collection == null || collection.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\u6216\u914d\u7f6e\u7684\u64cd\u4f5c\u4e0d\u5b58\u5728\u3002", (String)"MytaskListPlugin_29", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int j = 0; j < collection.size(); ++j) {
                String billType = (String)((DynamicObject)collection.get(j)).get("bindbill.number");
                String bindform = (String)((DynamicObject)collection.get(j)).get("bindform.number");
                formShowParameter.setCustomParam("billnumber", (Object)billType);
                formShowParameter.setCustomParam("bindform", (Object)bindform);
                formShowParameter.setCustomParam("billtype", (Object)billType);
            }
            CloseCallBack closeCallBack = view.getFormShowParameter().getCloseCallBack();
            formShowParameter.setCustomParam("sscid", restask.get("sscid"));
            formShowParameter.setCustomParam("sourcebillnumber", (Object)restask.getString("billnumber"));
            formShowParameter.setCustomParam("taskid", restask.get("id"));
            formShowParameter.setCustomParam("sourcetaskid", restask.get("sourcetaskid"));
            formShowParameter.setCustomParam("bizdata", restask.get("bizdata"));
            formShowParameter.setCustomParam("billtypeid", restask.get("billtype"));
            formShowParameter.setCustomParam("operationnumber", (Object)restask.getString("oprt"));
            formShowParameter.setCustomParam("tasktypeid", restask.get("tasktypeid"));
            formShowParameter.setCustomParam("bizdata", restask.get("bizdata"));
            formShowParameter.setCustomParam("billtypeid", (Object)billtypeid);
            formShowParameter.setCustomParam("isembed", (Object)restask.getBoolean("billtype.isembed"));
            formShowParameter.setCustomParam("state", (Object)restask.getString("state"));
            formShowParameter.setCustomParam("pooltype", (Object)poolType);
            formShowParameter.setCustomParam("pooltype-mytask", (Object)poolTask);
            formShowParameter.setCustomParam("imageNumber", (Object)restask.getString("imagenumber"));
            formShowParameter.setCustomParam("decisionitem", (Object)restask.getString("decisionitem"));
            formShowParameter.setCustomParam("unpassreasondesc", (Object)restask.getString("unpassreasondesc"));
            formShowParameter.setCustomParam("unpassreasondata", (Object)restask.getString("unpassreasondata"));
            formShowParameter.setCustomParam("approveop", (Object)restask.getString("approveop"));
            formShowParameter.setCustomParam("pendingopinion", (Object)restask.getString("pendingopinion"));
            formShowParameter.setCustomParam("rescanopinion", (Object)restask.getString("rescanopinion"));
            formShowParameter.setCustomParam("apprevalmessage", (Object)restask.getString("apprevalmessage"));
            formShowParameter.setCustomParam("sourcePageId", (Object)sourcePageId);
            formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            formShowParameter.setParentPageId(parentPageId);
            formShowParameter.setCloseCallBack(closeCallBack);
            view.showForm(formShowParameter);
            TaskApprevalHelper.refreshSourcePage(view, sourcePageId);
        }
    }

    private static void refreshSourcePage(IFormView view, String sourcePageId) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)sourcePageId)) {
            IListView sourceView = (IListView)view.getView(sourcePageId);
            sourceView.refresh();
            BillList list = (BillList)sourceView.getControl("billlistap");
            list.clearSelection();
        }
    }

    public static GetNextTaskResult getNextTaskDetail(DynamicObject task, IFormView view) {
        String selectfields = "id,sscid,oprt,billtype,billid,tasktypeid,sourcetaskid,bizdata_tag,state,personid,reformperson,qualitystate,billnumber,innermsg,apprevalmessage,qualitysamplelibrary.id,billtype.isembed,bizdata,pooltype,receivetime,imagenumber,decisionitem,unpassreasondesc,unpassreasondata,approveop,pendingopinion,rescanopinion";
        QFilter typeFilter = new QFilter("qualitysamplelibrary", "=", (Object)0);
        long personid = task.getLong("personid.id");
        QFilter personFilter = new QFilter("personid", "=", (Object)personid);
        String sscid = task.get("sscid.id") + "";
        Date reveiveTime = task.getDate("receivetime");
        QFilter receiveTimeFilter = new QFilter("receivetime", ">=", (Object)reveiveTime);
        ArrayList<String> stateList = new ArrayList<String>(2);
        stateList.add(TaskStateEnum.TO_BE_AUDIT.getValue());
        stateList.add(TaskStateEnum.REUPLOAD_IMAGE.getValue());
        QFilter statusFilter = new QFilter("state", "in", stateList);
        QFilter sscFilter = new QFilter("sscid", "=", (Object)Long.parseLong(sscid));
        ORM orm = ORM.create();
        String orderby = "receivetime asc";
        QFilter idFilter = new QFilter("id", "=", (Object)task.getLong("id"));
        QFilter[] tFilters = new QFilter[]{idFilter};
        QFilter[] qFilters = new QFilter[]{receiveTimeFilter, statusFilter, sscFilter, personFilter, typeFilter};
        QFilter[] sFilters = new QFilter[]{statusFilter, sscFilter, personFilter, typeFilter};
        DynamicObjectCollection tasks = orm.query("task_task", selectfields, qFilters, orderby);
        String msg = "";
        boolean success = true;
        DynamicObjectCollection theTask = orm.query("task_task", selectfields, tFilters);
        DynamicObject restask = new DynamicObject();
        if (tasks != null && tasks.size() > 0) {
            restask = (DynamicObject)tasks.get(0);
            long id = task.getLong("id");
            Date curtime = task.getDate("receivetime");
            ArrayList<DynamicObject> sametimeTasks = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> sametimeTasks2 = new ArrayList<DynamicObject>();
            boolean state = false;
            String state0 = task.get("state").toString();
            if (tasks.size() == 1) {
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)state0, (CharSequence)TaskStateEnum.TO_BE_AUDIT.getValue()) || org.apache.commons.lang3.StringUtils.equals((CharSequence)state0, (CharSequence)TaskStateEnum.REUPLOAD_IMAGE.getValue())) {
                    GetNextTaskResult result = TaskApprevalHelper.getAllTasks(orm, selectfields, sFilters, sscid, id, view);
                    restask = result.getResTask();
                    msg = result.getMsg();
                    success = result.isSuccess();
                } else {
                    restask = (DynamicObject)tasks.get(0);
                }
            } else if (tasks.size() == 2) {
                boolean flag = true;
                boolean num = false;
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)state0, (CharSequence)TaskStateEnum.TO_BE_AUDIT.getValue()) && !org.apache.commons.lang3.StringUtils.equals((CharSequence)state0, (CharSequence)TaskStateEnum.REUPLOAD_IMAGE.getValue()) || theTask == null || theTask.size() == 0) {
                    DynamicObject task1 = (DynamicObject)tasks.get(0);
                    DynamicObject task2 = (DynamicObject)tasks.get(1);
                    restask = task1;
                    if (task1.getDate("receivetime").getTime() == task2.getDate("receivetime").getTime() && task1.getLong("id") > task2.getLong("id")) {
                        restask = task2;
                    }
                }
                if (id == ((DynamicObject)tasks.get(1)).getLong("id")) {
                    GetNextTaskResult result = TaskApprevalHelper.getAllTasks(orm, selectfields, sFilters, sscid, id, view);
                    restask = result.getResTask();
                    msg = result.getMsg();
                    success = result.isSuccess();
                } else {
                    for (DynamicObject dynamicObject : tasks) {
                        if (dynamicObject.getLong("id") == id) continue;
                        restask = dynamicObject;
                        break;
                    }
                }
            } else {
                DynamicObject task1;
                int i;
                DynamicObject task2 = !org.apache.commons.lang3.StringUtils.equals((CharSequence)state0, (CharSequence)TaskStateEnum.TO_BE_AUDIT.getValue()) && !org.apache.commons.lang3.StringUtils.equals((CharSequence)state0, (CharSequence)TaskStateEnum.REUPLOAD_IMAGE.getValue()) || theTask == null || theTask.size() == 0 ? (DynamicObject)tasks.get(0) : (DynamicObject)tasks.get(1);
                for (i = 0; i < tasks.size() && (task1 = (DynamicObject)tasks.get(i)).getDate("receivetime").compareTo(curtime) == 0; ++i) {
                    sametimeTasks.add(task1);
                }
                for (i = 0; i < tasks.size(); ++i) {
                    task1 = (DynamicObject)tasks.get(i);
                    if (task1.getDate("receivetime").compareTo(task2.getDate("receivetime")) != 0) continue;
                    sametimeTasks2.add(task1);
                }
                sametimeTasks.sort((s1, s2) -> Long.compare(s1.getLong("id"), s2.getLong("id")));
                sametimeTasks2.sort((s1, s2) -> Long.compare(s1.getLong("id"), s2.getLong("id")));
                if ((!org.apache.commons.lang3.StringUtils.equals((CharSequence)state0, (CharSequence)TaskStateEnum.TO_BE_AUDIT.getValue()) && !org.apache.commons.lang3.StringUtils.equals((CharSequence)state0, (CharSequence)TaskStateEnum.REUPLOAD_IMAGE.getValue()) || theTask == null || theTask.size() == 0) && sametimeTasks.size() < 1) {
                    restask = (DynamicObject)tasks.get(0);
                }
                if (task2.getDate("receivetime").compareTo(curtime) == 0) {
                    for (DynamicObject sametimeTask : sametimeTasks) {
                        if (state) {
                            state = false;
                            restask = sametimeTask;
                            break;
                        }
                        if (sametimeTask.getLong("id") != id) continue;
                        state = true;
                    }
                    if (state) {
                        if (tasks.size() > sametimeTasks.size()) {
                            restask = (DynamicObject)tasks.get(sametimeTasks.size());
                        } else {
                            GetNextTaskResult result = TaskApprevalHelper.getAllTasks(orm, selectfields, sFilters, sscid, id, view);
                            restask = result.getResTask();
                            msg = result.getMsg();
                            success = result.isSuccess();
                        }
                    }
                } else {
                    restask = (DynamicObject)sametimeTasks2.get(0);
                }
            }
        } else {
            Long curId = task.getLong("id");
            GetNextTaskResult result = TaskApprevalHelper.getAllTasks(orm, selectfields, sFilters, sscid, curId, view);
            restask = result.getResTask();
            msg = result.getMsg();
            success = result.isSuccess();
        }
        GetNextTaskResult getNextTaskResult = new GetNextTaskResult();
        getNextTaskResult.setMsg(msg);
        getNextTaskResult.setResTask(restask);
        getNextTaskResult.setSuccess(success);
        return getNextTaskResult;
    }

    public static GetNextTaskResult getAllTasks(ORM orm, String selectfields, QFilter[] sQFilter, String sscId, Long curId, IFormView view) {
        String orderby = "receivetime asc";
        String msg = "";
        int code = 0;
        boolean success = true;
        GetNextTaskResult result = new GetNextTaskResult();
        DynamicObjectCollection alltasks = orm.query("task_task", selectfields, sQFilter, orderby);
        TaskAskFormPlugin taskAskFormPlugin = new TaskAskFormPlugin();
        DynamicObject restask = new DynamicObject();
        if (alltasks != null && alltasks.size() > 0) {
            for (DynamicObject task0 : alltasks) {
                Long id = task0.getLong("id");
                if (!id.equals(curId)) {
                    restask = task0;
                    msg = "";
                    break;
                }
                success = false;
                restask = task0;
                code = GetNextTaskResultEnum.LATEST_TASK_CAN_NOT_SKIP.getCode();
                msg = GetNextTaskResultEnum.LATEST_TASK_CAN_NOT_SKIP.getMsg();
            }
        } else if (view.getFormShowParameter().getFormId().contains("task_approve")) {
            success = false;
            code = GetNextTaskResultEnum.NO_AUDIT_TASK.getCode();
            msg = GetNextTaskResultEnum.NO_AUDIT_TASK.getMsg();
        } else {
            view.getFormShowParameter().setCustomParam("sscid.id", (Object)sscId);
            taskAskFormPlugin.setView(view);
            Map<String, StringBuffer> askTaskRsMap = taskAskFormPlugin.askTask(1, sscId);
            if (askTaskRsMap.get("success") != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)askTaskRsMap.get("success").toString())) {
                result = TaskApprevalHelper.getAllTasks(orm, selectfields, sQFilter, sscId, curId, view);
                return result;
            }
            success = false;
            code = GetNextTaskResultEnum.NO_WAITDIS_TASK.getCode();
            msg = GetNextTaskResultEnum.NO_WAITDIS_TASK.getMsg();
        }
        result.setSuccess(success);
        result.setResTask(restask);
        result.setMsg(msg);
        result.setCode(code);
        return result;
    }

    public static DynamicObjectCollection getTasks(DynamicObjectCollection tasks, long personId, int num) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        if (tasks == null || tasks.size() == 0) {
            return result;
        }
        HashMap<Long, Set<Long>> personsExistedInWorkflow = TaskApprevalHelper.getPersonsExistedInWorkflow(tasks);
        for (DynamicObject task : tasks) {
            Set<Long> persons = personsExistedInWorkflow.get(task.getLong("assignid"));
            Set aheadHandlerOfSSCNode = WorkFlowInfoHelper.getAheadHandlerOfSSCNode((long)task.getLong("assignid"));
            if (persons != null && persons.contains(personId) || aheadHandlerOfSSCNode != null && aheadHandlerOfSSCNode.contains(personId)) continue;
            result.add((Object)task);
            if (result.size() != num) continue;
            break;
        }
        return result;
    }

    public static HashMap<Long, Set<Long>> getPersonsExistedInWorkflow(DynamicObjectCollection tasks) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"task_taskbill_child", (QFilter[])new QFilter("issame", "=", (Object)"1").toArray(), null, (int)-1);
        List isNotSameBillTaskIds = ids.stream().map(e -> (Long)e).collect(Collectors.toList());
        DynamicObjectCollection billTaskEntries = QueryServiceHelper.query((String)"task_taskbill", (String)"id,entryentity.childpkid as childPkId,entryentity.tasktype as taskTypeId", null);
        ArrayList<String> isNotSameBillTasks = new ArrayList<String>();
        for (Object entry : billTaskEntries) {
            if (!isNotSameBillTaskIds.contains(entry.getLong("childPkId"))) continue;
            isNotSameBillTasks.add(entry.getLong("id") + "_" + entry.getString("taskTypeId"));
        }
        HashSet<Long> needFindWorkflows = new HashSet<Long>();
        for (DynamicObject task : tasks) {
            if (!isNotSameBillTasks.contains(task.getLong("billtype.id") + "_" + task.getLong("tasktypeid.id"))) continue;
            needFindWorkflows.add(task.getLong("assignid"));
        }
        needFindWorkflows.remove(0L);
        DynamicObjectCollection nodes = QueryServiceHelper.query((String)"task_partaskinstnode", (String)"workflowid,personid", (QFilter[])new QFilter("workflowid", "in", needFindWorkflows).toArray());
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        for (DynamicObject node : nodes) {
            Set set = map.computeIfAbsent(node.getLong("workflowid"), k -> new HashSet());
            set.add(node.getLong("personid"));
        }
        return map;
    }

    public static void showFormToApprove(IFormView formView, Long taskId, boolean isHisTask, CloseCallBack callBack, String invoker) {
        TaskApprevalHelper.showFormToApprove(formView, taskId, isHisTask, callBack, invoker, null);
    }

    public static void showFormToApprove(IFormView formView, Long taskId, boolean isHisTask, CloseCallBack callBack, String invoker, BiConsumer<FormShowParameter, DynamicObject> formShowParameterConsumer) {
        DynamicObject task = TaskApprevalHelper.getTaskDynObj(taskId, isHisTask);
        if (!TaskApprevalHelper.validateTaskData(formView, task)) {
            return;
        }
        String formId = "task_approve";
        String poolType = task.getString("pooltype");
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId(formId);
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.getOpenStyle().setTargetKey("_submaintab_");
        showParam.setCloseCallBack(callBack);
        TaskApprevalHelper.setCommonParams(showParam, task);
        if (!isHisTask) {
            showParam.setCustomParam("approveop", (Object)task.getString("approveop"));
            showParam.setCustomParam("pendingopinion", (Object)task.getString("pendingopinion"));
            showParam.setCustomParam("pendingopinions", task.get("pendingopinions"));
            showParam.setCustomParam("rescanopinion", (Object)task.getString("rescanopinion"));
            showParam.setCustomParam("unpassreasondata", (Object)task.getString("unpassreasondata"));
        }
        if (TaskApprovePageInvokerEnum.MY_TASK_LIST.getValue().equals(invoker)) {
            showParam.setCustomParam("pooltype-mytask", (Object)poolType);
        } else if (TaskApprovePageInvokerEnum.TASK_ADMIN_LIST.getValue().equals(invoker)) {
            showParam.setCustomParam("from", (Object)"admin");
        }
        showParam.setCustomParam("sourcePageId", (Object)formView.getPageId());
        showParam.setPageId(formView.getPageId() + "_" + formId + "_" + taskId);
        if (formShowParameterConsumer != null) {
            formShowParameterConsumer.accept(showParam, task);
        }
        formView.showForm(showParam);
    }

    public static void showFormToQualityCheck(IFormView formView, Long taskId, boolean isHisTask, CloseCallBack callBack, String invoker, boolean isTracked) {
        DynamicObject task = TaskApprevalHelper.getTaskDynObj(taskId, isHisTask);
        if (!TaskApprevalHelper.validateTaskData(formView, task)) {
            return;
        }
        FormShowParameter showParam = new FormShowParameter();
        String state = task.getString("state");
        String formId = "";
        TaskStateEnum taskState = TaskStateEnum.getTaskState((String)state);
        if (taskState == null) {
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"MytaskListPlugin_60", (String)"ssc-task-formplugin", (Object[])new Object[0]), "taskState is null"));
            return;
        }
        switch (taskState) {
            case TO_BE_DIS: 
            case TO_BE_MANUAL_DIS: 
            case DIS_EXCEPTION: 
            case CHECKING: 
            case PAUSE_CHECKING: 
            case RECYCLE: {
                formId = "task_quality_docheck";
                break;
            }
            case RECTIFYING: 
            case PAUSE_RECTIFYING: {
                formId = "task_quality_dorectify";
                break;
            }
            case REVIEW: 
            case PAUSE_REVIEW: {
                formId = "task_quality_doreview";
                break;
            }
            case QUA_CHECK_COMPLETED: {
                formId = "task_quality_doreview";
                showParam.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u5904\u7406\u5df2\u5b8c\u6210", (String)"MytaskListPlugin_41", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                showParam.setStatus(OperationStatus.VIEW);
                break;
            }
            default: {
                formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"MytaskListPlugin_60", (String)"ssc-task-formplugin", (Object[])new Object[0]), "taskState = " + taskState.getName()));
                return;
            }
        }
        showParam.setFormId(formId);
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.getOpenStyle().setTargetKey("_submaintab_");
        showParam.setCloseCallBack(callBack);
        TaskApprevalHelper.setCommonParams(showParam, task);
        showParam.setCustomParam("reformperson", (Object)task.getString("reformperson.id"));
        showParam.setCustomParam("sampraryLibId", (Object)task.getString("qualitysamplelibrary.id"));
        if (TaskApprovePageInvokerEnum.MY_TASK_LIST.getValue().equals(invoker) || TaskApprovePageInvokerEnum.SMART_APPROVAL_SIMILAR_BILL.getValue().equals(invoker)) {
            showParam.setCustomParam("pooltype-mytask", (Object)task.getString("pooltype"));
            showParam.setCustomParam("ismytask", (Object)"mytask");
            if (isTracked) {
                showParam.setStatus(OperationStatus.VIEW);
            }
        } else if (TaskApprovePageInvokerEnum.QUALITY_CHECK_MANAGE_LIST.getValue().equals(invoker) || TaskApprovePageInvokerEnum.QUALITY_CHECK_PROGRESS_DETAIL_RPT.getValue().equals(invoker)) {
            showParam.setCustomParam("ismanagepage", (Object)"ismanagepage");
            showParam.setStatus(OperationStatus.VIEW);
        }
        formView.showForm(showParam);
    }

    private static DynamicObject getTaskDynObj(Long taskId, boolean isHisTask) {
        String entityName = "task_taskhistory";
        String selectFields = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, personid.id, imagenumber,billtype.id, billtype.isembed, billtype.bindbill.number, billtype.bindform.number, billtype.isstoredindb,bizdata_tag, innermsg, apprevalmessage, decisionitem, qualitysamplelibrary.id, reformperson.id,unpassreasondesc, pendingopinion,pendingopinions.fbasedataid as pendingopinions, rescanopinion";
        if (!isHisTask) {
            entityName = "task_task";
            selectFields = selectFields + ", approveop, unpassreasondata";
        }
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
    }

    private static boolean validateTaskData(IFormView formView, DynamicObject task) {
        if (task == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"TaskApprevalHelper_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (task.getLong("billtype.id") == 0L || task.getLong("tasktypeid.id") == 0L) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u6216\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"TaskApprevalHelper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        String billBill = task.getString("billtype.bindbill.number");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billBill)) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u5c5e\u6027\uff1a\u201c\u6765\u6e90\u5355\u636e\u201d\u5f02\u5e38\u3002", (String)"TaskApprevalHelper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static void setCommonParams(FormShowParameter showParam, DynamicObject task) {
        String bizdata_tag = task.getString("bizdata_tag");
        String bizdata = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bizdata_tag) ? null : bizdata_tag;
        showParam.setCustomParam("taskid", (Object)task.getLong("id"));
        showParam.setCustomParam("tasktypeid", (Object)task.getLong("tasktypeid.id"));
        showParam.setCustomParam("billtypeid", (Object)task.getLong("billtype.id"));
        showParam.setCustomParam("billtype", (Object)task.getString("billtype.bindbill.number"));
        showParam.setCustomParam("billid", (Object)task.getString("billid"));
        showParam.setCustomParam("billno", (Object)task.getString("billnumber"));
        showParam.setCustomParam("personid", (Object)task.getString("personid.id"));
        showParam.setCustomParam("bizdata", (Object)bizdata);
        showParam.setCustomParam("apprevalmessage", (Object)task.getString("apprevalmessage"));
        showParam.setCustomParam("innermsg", (Object)task.getString("innermsg"));
        showParam.setCustomParam("state", (Object)task.getString("state"));
        showParam.setCustomParam("pooltype", (Object)task.getString("pooltype"));
        showParam.setCustomParam("billnumber", (Object)task.getString("billtype.bindbill.number"));
        DynamicObject bindForm = new TaskBillChildUtil().queryOne(task, "bindform.number");
        String bindFormNumber = bindForm == null ? null : bindForm.getString("bindform.number");
        showParam.setCustomParam("bindform", (Object)bindFormNumber);
        showParam.setCustomParam("sourcetaskid", (Object)task.getLong("sourcetaskid"));
        showParam.setCustomParam("isembed", (Object)task.getBoolean("billtype.isembed"));
        showParam.setCustomParam("imageNumber", (Object)task.getString("imagenumber"));
        showParam.setCustomParam("decisionitem", (Object)task.getString("decisionitem"));
        showParam.setCustomParam("unpassreasondesc", (Object)task.getString("unpassreasondesc"));
        showParam.setCustomParam("sscid", (Object)String.valueOf(task.getLong("sscid.id")));
    }
}

