/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.common.Expirestate;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.common.TaskIndexDataUtil;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.formplugin.IndexDataAutoCalculateTask;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskBusinessManageIndexPlugin
extends AbstractFormPlugin
implements ProgresssListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(TaskBusinessManageIndexPlugin.class);
    private final String isAvgEfficiency = "isAvgEfficiency";
    private final String isTodayTask = "isTodayTask";
    private static String RECEIVECOMPLETE_TASK_FILTER_TAG = "receivecomplete_task_filter_tag";
    private static String COMPLETE_TASK_FILTER_TAG = "complete_task_filter_tag";
    private static String PROCESSING_TASK_FILTER_TAG = "processing_task_filter_tag";
    private static String EXPIRED_TASK_FILTER_TAG = "expired_task_filter_tag";
    private static String TOBEASSIGNED_TASK_FILTER_TAG = "tobeassigned_task_filter_tag";
    private static String TOUPLOADIMAGE_TASK_FILTER_TAG = "touploadimage_task_filter_tag";
    private static String AFTERCREATENEWDATA_TAG = "aftercreatenewdata_tag";
    private static String DYNAMIC_TASK_ADMIN = "task_administrate";
    private static String entityName = "task_task";
    private static String completentityName = "task_taskhistory";
    private static String USERGROUP = "usergroup";
    private static String SHARECENTER = "sharecenter";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"todaybtn", "thismonthbtn", "avgbtn", "handletotalbtn", "timenode", "processing", "expire", "tobeassigned", "touploadimage", "sharecenter", "receivecomplete", "complete"});
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Tab tab1 = (Tab)this.getControl("tabap1");
        tab1.addTabSelectListener((TabSelectListener)this);
        Button refreshBtn = (Button)this.getView().getControl("refreshbtn");
        refreshBtn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        long userId = RequestContext.get().getCurrUserId();
        if (userId < 1L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskBusinessManageIndexPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        super.afterCreateNewData(e);
        this.setShareCenter();
        long orgId = NumberUtils.toLong((String)this.getCurrentOrgId(), (long)-1L);
        if (orgId == -1L) {
            IFormView view = this.getView();
            view.close();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("caption", ResManager.loadKDString((String)"\u4e1a\u52a1\u7ba1\u7406\u5458\u9996\u9875", (String)"TaskBusinessManageIndexPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            TeamLeaderApi.showForm(view, paramMap);
            return;
        }
        if (!this.setGroup(orgId, userId)) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"pauselabel_m", "expirelabel_m", "rescanlabel_m", "handleentity"});
        this.getPageCache().put("isAvgEfficiency", "true");
        this.getPageCache().put("isTodayTask", "true");
        this.setInitialViewDate();
        this.setInitialViewNew(String.valueOf(orgId));
        this.getPageCache().put(AFTERCREATENEWDATA_TAG, "true");
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
    }

    private void setInitialViewDate() {
        Date nowDate = new Date();
        IDataModel dataModel = this.getModel();
        Date startDate = DateUtil.addDay((Date)nowDate, (long)-6L);
        try {
            nowDate = DateUtil.getCurDateForm((Date)nowDate, (boolean)false);
            startDate = DateUtil.getCurDateForm((Date)startDate, (boolean)true);
        }
        catch (ParseException e) {
            nowDate = new Date();
            log.error("", (Throwable)e);
        }
        dataModel.setValue("timenode", (Object)nowDate);
        dataModel.setValue("daterangenum_startdate", (Object)startDate);
        dataModel.setValue("daterangenum_enddate", (Object)nowDate);
    }

    private void setInitialViewNew(String scidStr) {
        if (StringUtils.isEmpty((CharSequence)scidStr)) {
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        String userId = RequestContext.get().getUserId();
        String cacheKey = String.format("%s|%s|%s", userId, appId, "SSC_BORARD_SSCID");
        String oldValue = SscDistributeCache.get((String)cacheKey);
        if (StringUtils.isEmpty((CharSequence)oldValue) || !scidStr.equals(oldValue)) {
            SscDistributeCache.put((String)cacheKey, (Object)scidStr);
        }
        Long scid = Long.valueOf(scidStr);
        IDataModel dataModel = this.getModel();
        String groupId = this.getCurrentGroup();
        try {
            this.getPageCache().put("onProgress", "true");
            Map<String, Date> dateMap = this.getTodayandThismonthDate();
            this.setTodayOrMonthTaskNew(dateMap.get("startDate"), dateMap.get("endDate"), scid);
            this.setToDoTaskNew(scid, groupId);
            Date timenode = (Date)this.getModel().getValue("timenode");
            if (timenode != null) {
                timenode = DateUtil.getCurDateForm((Date)timenode, (boolean)false);
                this.updateHandleChart(timenode);
            }
            this.getPageCache().remove("onProgress");
            Date startDate = (Date)dataModel.getValue("daterangenum_startdate");
            Date endDate = (Date)dataModel.getValue("daterangenum_enddate");
            if (startDate != null && endDate != null && startDate.compareTo(endDate) <= 0) {
                startDate = DateUtil.getCurDateForm((Date)startDate, (boolean)true);
                endDate = DateUtil.getCurDateForm((Date)endDate, (boolean)false);
                boolean isAvgEfficient = Boolean.parseBoolean(this.getPageCache().get("isAvgEfficiency"));
                if (isAvgEfficient) {
                    this.setTaskEntryEfficiency(startDate, endDate, scid, groupId);
                } else {
                    this.setTaskEntryCount(startDate, endDate, scid, groupId);
                }
            }
        }
        catch (Exception e) {
            ErrorCode code = new ErrorCode("-1", e.getMessage());
            throw new KDException((Throwable)e, code, new Object[0]);
        }
    }

    private void setShareCenter() {
        long userid = Long.parseLong(RequestContext.get().getUserId());
        Long orgid = RequestContext.get().getOrgId();
        String entityName = this.getModel().getDataEntityType().getName();
        List<ComboItem> list = TeamLeaderApi.getSscenters(userid, entityName);
        if (list != null && list.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl("sharecenter");
            combo.setComboItems(list);
            boolean isIni = false;
            for (ComboItem item : list) {
                Long sscId = Long.valueOf(item.getValue());
                if (!sscId.equals(orgid)) continue;
                this.getModel().setValue("sharecenter", (Object)orgid);
                isIni = true;
            }
            if (!isIni) {
                this.getModel().setValue("sharecenter", (Object)list.get(0).getValue());
            }
        }
    }

    boolean setGroup(Long orgId, Long userId) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)orgId);
        boolean isSysAdminAndAllRight = TeamLeaderApi.isAdminRole(String.valueOf(orgId), userId, "HXLFBW8ZGNH", "HXLT47Z1L8S");
        this.getPageCache().put("isSysAdminAndAllRight", String.valueOf(isSysAdminAndAllRight));
        if (!isSysAdminAndAllRight) {
            qFilter.and("entryentity.userfield", "=", (Object)userId);
            if (TeamLeaderApi.isOpenTeamleader(String.valueOf(orgId))) {
                qFilter.and("entryentity.teamleader", "=", (Object)Boolean.TRUE);
            }
        }
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        IFormView view = this.getView();
        if (!(isSysAdminAndAllRight || groups != null && groups.length != 0)) {
            view.close();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("caption", ResManager.loadKDString((String)"\u4e1a\u52a1\u7ba1\u7406\u5458\u9996\u9875", (String)"TaskBusinessManageIndexPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            TeamLeaderApi.showForm(view, paramMap);
            return false;
        }
        List<ComboItem> comboItems = TaskBusinessManageIndexPlugin.getComboItems(groups);
        ComboEdit combo = (ComboEdit)this.getControl(USERGROUP);
        if (comboItems.size() > 0) {
            combo.setComboItems(comboItems);
            this.getModel().setValue(USERGROUP, (Object)comboItems.get(0).getValue());
            this.getView().updateView(USERGROUP);
        } else {
            this.getModel().setValue(USERGROUP, (Object)"");
            combo.setComboItems(null);
        }
        return true;
    }

    @Deprecated
    public static boolean isAdminRole(String sid, Long uid, String sscAdminRoleId, String AdminRoleId) {
        boolean result = false;
        Map<Long, Set<String>> map = TeamLeaderApi.getOrgRoleAssignMap(uid);
        block0: for (Map.Entry<Long, Set<String>> entry : map.entrySet()) {
            Long key = entry.getKey();
            if (!sid.equals(String.valueOf(key))) continue;
            Set<String> roleSet = entry.getValue();
            for (String roleId : roleSet) {
                if (!sscAdminRoleId.equals(roleId) && !AdminRoleId.equals(roleId)) continue;
                result = true;
                break block0;
            }
        }
        return result || PermissionServiceHelper.isSuperUser((long)uid);
    }

    private static List<ComboItem> getComboItems(DynamicObject[] items) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        ComboItem unLimitedItem = new ComboItem();
        unLimitedItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TaskBusinessManageIndexPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0])));
        unLimitedItem.setValue("-1");
        list.add(unLimitedItem);
        for (DynamicObject item : items) {
            ComboItem citem = new ComboItem();
            citem.setCaption(new LocaleString(item.getLocaleString("name") + ""));
            citem.setValue(item.get("id") + "");
            list.add(citem);
        }
        return list;
    }

    private void setTaskEntryEfficiency(Date startDate, Date endDate, Long scid, String groupId) {
        DataSet ds = this.getTaskCountSet(startDate, endDate, scid, groupId).orderBy(new String[]{"taskefficiency desc"});
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("taskentity");
        int rank = 1;
        for (Row row : ds) {
            Long personid = row.getLong("personid");
            Integer taskcount = row.getInteger("taskcount");
            Object taskefficiency = row.get("taskefficiency");
            taskefficiency = new BigDecimal(taskefficiency.toString()).setScale(2, 4);
            int rowKey = model.createNewEntryRow("taskentity");
            model.setValue("avguser", (Object)personid, rowKey);
            model.setValue("taskefficiency", taskefficiency, rowKey);
            model.setValue("finishcount", (Object)taskcount, rowKey);
            model.setValue("rank", (Object)rank++, rowKey);
        }
        model.endInit();
        this.getView().updateView("taskentity");
        EntryGrid entry = (EntryGrid)this.getControl("taskentity");
        int entrySize = model.getEntryRowCount("taskentity");
        if (entrySize > 0) {
            entry.selectRows(0);
        }
    }

    private void setTaskEntryCount(Date startDate, Date endDate, Long scid, String groupId) {
        DataSet ds = this.getTaskCountSet(startDate, endDate, scid, groupId).orderBy(new String[]{"taskcount desc"});
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("handleentity");
        int rank = 1;
        for (Row row : ds) {
            Long personid = row.getLong("personid");
            Integer taskcount = row.getInteger("taskcount");
            Object coefficient = row.get("taskamount");
            coefficient = new BigDecimal(coefficient.toString()).setScale(2, 4);
            int rowKey = model.createNewEntryRow("handleentity");
            model.setValue("handlerank", (Object)rank++, rowKey);
            model.setValue("taskuser", (Object)personid, rowKey);
            model.setValue("finishtotal", (Object)taskcount, rowKey);
            model.setValue("handlecount", coefficient, rowKey);
        }
        model.endInit();
        this.getView().updateView("handleentity");
        EntryGrid entry = (EntryGrid)this.getControl("handleentity");
        int entrySize = model.getEntryRowCount("handleentity");
        if (entrySize > 0) {
            entry.selectRows(0);
        }
    }

    private DataSet getTaskCountSet(Date startDate, Date endDate, Long scid, String usergroupId) {
        Date nowDate = new Date();
        Date todayStart = null;
        Date todayEnd = null;
        try {
            todayStart = DateUtil.getCurDateForm((Date)nowDate, (boolean)true);
            todayEnd = DateUtil.getCurDateForm((Date)nowDate, (boolean)false);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        int start = startDate.compareTo(DateUtil.addDay((Date)todayStart, (long)-6L));
        int end = endDate.compareTo(todayEnd);
        boolean isSysAdminAndAllRight = Boolean.parseBoolean(this.getPageCache().get("isSysAdminAndAllRight"));
        if (start == 0 && end == 0) {
            return TaskIndexDataUtil.getTaskCountSet(scid, usergroupId, isSysAdminAndAllRight);
        }
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)scid);
        QFilter receivetimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        QFilter pooltypeFilter = new QFilter("pooltype", "=", (Object)Character.valueOf('2'));
        QFilter ishandledFilter = new QFilter("ishandled", "=", (Object)Character.valueOf('0'));
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        QFilter notAutoProcess = new QFilter("autoprocess", "=", (Object)"0");
        qfList.add(shareCenterFilter);
        qfList.add(receivetimeFilter);
        qfList.add(pooltypeFilter);
        qfList.add(ishandledFilter);
        qfList.add(notQuaCheckTask);
        qfList.add(notAutoProcess);
        if (usergroupId != null && !"-1".equals(usergroupId)) {
            QFilter groupFilter = new QFilter("usergroup.id", "=", (Object)Long.parseLong(usergroupId));
            qfList.add(groupFilter);
        } else if (!isSysAdminAndAllRight) {
            QFilter leaderGroupFilter = new QFilter("usergroup.id", "!=", (Object)0L);
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            HashSet<Long> manageGroupSet = UserGroupUtil.getManageGroup(String.valueOf(scid), currUserId);
            QFilter leaderGroupFilter2 = new QFilter("usergroup", "in", manageGroupSet);
            qfList.add(leaderGroupFilter);
            qfList.add(leaderGroupFilter2);
        }
        String selectFields = "personid.id as personid, pooltype, coefficient, costwaittime";
        DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "setTaskEntryCount"), (String)completentityName, (String)selectFields, (QFilter[])qfList.toArray(new QFilter[0]), null);
        ds = ds.select(new String[]{"personid", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "pooltype", "(case when costwaittime is null or costwaittime = 0 then 0.02 else costwaittime end) as costwaittime"}).groupBy(new String[]{"personid"}).count("taskcount").sum("coefficient", "taskamount").sum("costwaittime").finish();
        ds = ds.select(new String[]{"personid", "taskcount", "taskamount", "costwaittime", "cast(case when taskcount=0 then 0 else taskamount/costwaittime end as decimal) as taskefficiency"});
        return ds;
    }

    private Map<String, Date> getTodayandThismonthDate() {
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        String isTodayTaskStr = this.getPageCache().get("isTodayTask");
        try {
            Date nowDate = new Date();
            if ("true".equals(isTodayTaskStr)) {
                dateMap.put("startDate", DateUtil.getCurDateForm((Date)nowDate, (boolean)true));
                dateMap.put("endDate", DateUtil.getCurDateForm((Date)nowDate, (boolean)false));
            } else if ("false".equals(isTodayTaskStr)) {
                Date firstDay = DateUtil.getFirstDayOfMonth((Date)nowDate);
                dateMap.put("startDate", DateUtil.getCurDateForm((Date)firstDay, (boolean)true));
                dateMap.put("endDate", nowDate);
            }
        }
        catch (ParseException e1) {
            throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
        }
        return dateMap;
    }

    private void setTodayOrMonthTaskNew(Date startDate, Date endDate, Long sscid) {
        boolean isSysAdminAndAllRight;
        String isTodayTaskStr = this.getPageCache().get("isTodayTask");
        String usergroupId = this.getCurrentGroup();
        Map<String, Long> dataMap = TaskIndexDataUtil.getIndexData(sscid, usergroupId, isSysAdminAndAllRight = Boolean.parseBoolean(this.getPageCache().get("isSysAdminAndAllRight")));
        if (dataMap == null) {
            return;
        }
        Long distributed = 0L;
        Long receivecomplete = 0L;
        Long complete = 0L;
        if ("true".equals(isTodayTaskStr)) {
            distributed = dataMap.get("today_distributed");
            distributed = distributed == null ? Long.valueOf(0L) : distributed;
            receivecomplete = dataMap.get("today_receivecomplete");
            receivecomplete = receivecomplete == null ? Long.valueOf(0L) : receivecomplete;
            complete = dataMap.get("today_complete");
            complete = complete == null ? Long.valueOf(0L) : complete;
        } else if ("false".equals(isTodayTaskStr)) {
            distributed = dataMap.get("curmonth_distributed");
            distributed = distributed == null ? Long.valueOf(0L) : distributed;
            receivecomplete = dataMap.get("curmonth_receivecomplete");
            receivecomplete = receivecomplete == null ? Long.valueOf(0L) : receivecomplete;
            complete = dataMap.get("curmonth_complete");
            complete = complete == null ? Long.valueOf(0L) : complete;
        }
        Label distributedLabel = (Label)this.getControl("distributed");
        distributedLabel.setText(distributed + "");
        Label receivecompleteLabel = (Label)this.getControl("receivecomplete");
        receivecompleteLabel.setText(receivecomplete + "");
        Label completeLabel = (Label)this.getControl("complete");
        completeLabel.setText(complete + "");
        HashMap<String, String> lightGrey = new HashMap<String, String>(2);
        lightGrey.put("fc", "#bbbbbb");
        HashMap<String, String> darkGrey = new HashMap<String, String>(2);
        darkGrey.put("fc", "#666666");
        if (Long.compare(distributed, 0L) == 0) {
            this.getView().updateControlMetadata("distributed", lightGrey);
        } else {
            this.getView().updateControlMetadata("distributed", darkGrey);
        }
        if (Long.compare(complete, 0L) == 0) {
            this.getView().updateControlMetadata("complete", lightGrey);
        } else {
            this.getView().updateControlMetadata("complete", darkGrey);
        }
        this.setTodayOrMonthFilterCache(startDate, endDate, sscid, usergroupId);
    }

    private void setToDoTaskNew(Long sscid, String usergroupId) {
        boolean isSysAdminAndAllRight = Boolean.parseBoolean(this.getPageCache().get("isSysAdminAndAllRight"));
        Map<String, Long> dataMap = TaskIndexDataUtil.getIndexData(sscid, usergroupId, isSysAdminAndAllRight);
        if (dataMap == null) {
            return;
        }
        long processing = NumberUtils.toLong((String)(dataMap.get("processing") + ""), (long)0L);
        long expire = NumberUtils.toLong((String)(dataMap.get("expire") + ""), (long)0L);
        long tobeassigned = NumberUtils.toLong((String)(dataMap.get("tobeassigned") + ""), (long)0L);
        long touploadimage = NumberUtils.toLong((String)(dataMap.get("touploadimage") + ""), (long)0L);
        Label processingLabel = (Label)this.getControl("processing");
        processingLabel.setText(processing + "");
        Label expireLabel = (Label)this.getControl("expire");
        expireLabel.setText(expire + "");
        Label tobeassignedLabel = (Label)this.getControl("tobeassigned");
        tobeassignedLabel.setText(tobeassigned + "");
        Label touploadimageLabel = (Label)this.getControl("touploadimage");
        touploadimageLabel.setText(touploadimage + "");
        this.setToDOTaskFilterCache(sscid);
    }

    private void updateHandleChart(Date timenode) {
        Chart customchart = (Chart)this.getControl("handlechart");
        customchart.clearData();
        customchart.setMargin(Position.bottom, "45px");
        customchart.setMargin(Position.left, "26px");
        customchart.setLegendAlign(XAlign.center, YAlign.bottom);
        customchart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
        customchart.setShowTooltip(true);
        this.setHandlechartXaxisTick(customchart);
        this.setHandleChartData(customchart, timenode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer[]> getHandleChartData(Date date) {
        Serializable manageGroupSet;
        if (date == null) {
            date = new Date();
        }
        String scidStr = (String)this.getModel().getValue("sharecenter");
        Long scid = Long.valueOf(scidStr);
        String groupId = this.getCurrentGroup();
        boolean isSysAdminAndAllRight = Boolean.parseBoolean(this.getPageCache().get("isSysAdminAndAllRight"));
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)scid);
        QFilter processingFilter = new QFilter("pooltype", "=", (Object)"1");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        ArrayList<Long> outOfDateList = new ArrayList<Long>(16);
        QFilter outDateFilter = new QFilter("expirestate", "=", (Object)Expirestate.Yes.getValue());
        QFilter groupFilter = null;
        QFilter[] filters = null;
        if (groupId != null && !"-1".equals(groupId)) {
            groupFilter = new QFilter("usergroup.id", "=", (Object)Long.parseLong(groupId));
        } else if (!isSysAdminAndAllRight) {
            groupFilter = new QFilter("usergroup.id", "!=", (Object)0L);
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            manageGroupSet = UserGroupUtil.getManageGroup(String.valueOf(scid), currUserId);
            QFilter leaderGroupFilter2 = new QFilter("usergroup", "in", manageGroupSet);
            groupFilter.and(leaderGroupFilter2);
        }
        filters = new QFilter[]{shareCenterFilter, processingFilter, notQuaCheckTask, outDateFilter, groupFilter};
        try {
            DataSet outDateDataSet = QueryServiceHelper.queryDataSet((String)"queryOutOfDateObject", (String)"task_task", (String)"id", (QFilter[])filters, null);
            manageGroupSet = null;
            try {
                if (outDateDataSet != null) {
                    for (Row row : outDateDataSet) {
                        outOfDateList.add(row.getLong("id"));
                    }
                }
            }
            catch (Throwable it) {
                manageGroupSet = it;
                throw it;
            }
            finally {
                if (outDateDataSet != null) {
                    if (manageGroupSet != null) {
                        try {
                            outDateDataSet.close();
                        }
                        catch (Throwable it) {
                            ((Throwable)manageGroupSet).addSuppressed(it);
                        }
                    } else {
                        outDateDataSet.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8d85\u671f\u4efb\u52a1ID\u51fa\u9519:" + e.getMessage(), (Throwable)e);
        }
        QFilter outOfDateFilter = new QFilter("id", "in", outOfDateList);
        Date threeDate = DateUtil.addDay((Date)date, (long)-3L);
        Date seventhDate = DateUtil.addDay((Date)date, (long)-7L);
        Date tenthDate = DateUtil.addDay((Date)date, (long)-10L);
        Date fifthDate = DateUtil.addDay((Date)date, (long)-15L);
        Date twentyDate = DateUtil.addDay((Date)date, (long)-20L);
        Date monthDate = DateUtil.addDay((Date)date, (long)-30L);
        QFilter threedayFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{threeDate, date});
        QFilter seventhdayFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{seventhDate, threeDate});
        QFilter tenthFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{tenthDate, seventhDate});
        QFilter fifthFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{fifthDate, tenthDate});
        QFilter twentFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{twentyDate, fifthDate});
        QFilter monthFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{monthDate, twentyDate});
        QFilter gtmonthFilter = QFilter.of((String)"receivetime <= ? ", (Object[])new Object[]{monthDate});
        DataSet dataSet0_3 = null;
        DataSet oodDataSet0_3 = null;
        DataSet dataSet3_7 = null;
        DataSet oodDataSet3_7 = null;
        DataSet dataSet7_10 = null;
        DataSet oodDataSet7_10 = null;
        DataSet dataSet10_15 = null;
        DataSet oodDataSet10_15 = null;
        DataSet dataSet15_20 = null;
        DataSet oodDataSet15_20 = null;
        DataSet dataSet20_30 = null;
        DataSet oodDataSet20_30 = null;
        DataSet dataSet30_xx = null;
        DataSet oodDataSet30_xx = null;
        ArrayList<Integer[]> chartDataList = new ArrayList<Integer[]>();
        try {
            QFilter[] filters0_3 = new QFilter[]{threedayFilter, processingFilter, shareCenterFilter, notQuaCheckTask, groupFilter};
            QFilter[] oodFilters0_3 = new QFilter[]{threedayFilter, processingFilter, shareCenterFilter, outOfDateFilter, notQuaCheckTask, groupFilter};
            dataSet0_3 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])filters0_3, null);
            oodDataSet0_3 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])oodFilters0_3, null);
            int count0_3 = dataSet0_3.count("id", false);
            int oodCount0_3 = oodDataSet0_3.count("id", false);
            int iodCount0_3 = count0_3 - oodCount0_3;
            QFilter[] filters3_7 = new QFilter[]{seventhdayFilter, processingFilter, shareCenterFilter, notQuaCheckTask, groupFilter};
            QFilter[] oodFilters3_7 = new QFilter[]{seventhdayFilter, processingFilter, shareCenterFilter, outOfDateFilter, notQuaCheckTask, groupFilter};
            dataSet3_7 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])filters3_7, null);
            oodDataSet3_7 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])oodFilters3_7, null);
            int count3_7 = dataSet3_7.count("id", false);
            int oodCount3_7 = oodDataSet3_7.count("id", false);
            int iodCount3_7 = count3_7 - oodCount3_7;
            QFilter[] filters7_10 = new QFilter[]{tenthFilter, processingFilter, shareCenterFilter, notQuaCheckTask, groupFilter};
            QFilter[] oodFilters7_10 = new QFilter[]{tenthFilter, processingFilter, shareCenterFilter, outOfDateFilter, notQuaCheckTask, groupFilter};
            dataSet7_10 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])filters7_10, null);
            oodDataSet7_10 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])oodFilters7_10, null);
            int count7_10 = dataSet7_10.count("id", false);
            int oodCount7_10 = oodDataSet7_10.count("id", false);
            int iodCount7_10 = count7_10 - oodCount7_10;
            QFilter[] filters10_15 = new QFilter[]{fifthFilter, processingFilter, shareCenterFilter, notQuaCheckTask, groupFilter};
            QFilter[] oodFilters10_15 = new QFilter[]{fifthFilter, processingFilter, shareCenterFilter, outOfDateFilter, notQuaCheckTask, groupFilter};
            dataSet10_15 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])filters10_15, null);
            oodDataSet10_15 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])oodFilters10_15, null);
            int count10_15 = dataSet10_15.count("id", false);
            int oodCount10_15 = oodDataSet10_15.count("id", false);
            int iodCount10_15 = count10_15 - oodCount10_15;
            QFilter[] filters15_20 = new QFilter[]{twentFilter, processingFilter, shareCenterFilter, notQuaCheckTask, groupFilter};
            QFilter[] oodFilters15_20 = new QFilter[]{twentFilter, processingFilter, shareCenterFilter, outOfDateFilter, notQuaCheckTask, groupFilter};
            dataSet15_20 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])filters15_20, null);
            oodDataSet15_20 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])oodFilters15_20, null);
            int count15_20 = dataSet15_20.count("id", false);
            int oodCount15_20 = oodDataSet15_20.count("id", false);
            int iodCount15_20 = count15_20 - oodCount15_20;
            QFilter[] filters20_30 = new QFilter[]{monthFilter, processingFilter, shareCenterFilter, notQuaCheckTask, groupFilter};
            QFilter[] oodFilters20_30 = new QFilter[]{monthFilter, processingFilter, shareCenterFilter, outOfDateFilter, notQuaCheckTask, groupFilter};
            dataSet20_30 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])filters20_30, null);
            oodDataSet20_30 = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])oodFilters20_30, null);
            int count20_30 = dataSet20_30.count("id", false);
            int oodCount20_30 = oodDataSet20_30.count("id", false);
            int iodCount20_30 = count20_30 - oodCount20_30;
            QFilter[] filters30_xx = new QFilter[]{gtmonthFilter, processingFilter, shareCenterFilter, notQuaCheckTask, groupFilter};
            QFilter[] oodFilters30_xx = new QFilter[]{gtmonthFilter, processingFilter, shareCenterFilter, outOfDateFilter, notQuaCheckTask, groupFilter};
            dataSet30_xx = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])filters30_xx, null);
            oodDataSet30_xx = QueryServiceHelper.queryDataSet((String)"ssc.task.businessManageIndex.getHandleChartData", (String)entityName, (String)"id", (QFilter[])oodFilters30_xx, null);
            int count30_xx = dataSet30_xx.count("id", false);
            int oodCount30_xx = oodDataSet30_xx.count("id", false);
            int iodCount30_xx = count30_xx - oodCount30_xx;
            Integer[] dataSum = new Integer[]{count0_3, count3_7, count7_10, count10_15, count15_20, count20_30, count30_xx};
            Integer[] oodData = new Integer[]{oodCount0_3, oodCount3_7, oodCount7_10, oodCount10_15, oodCount15_20, oodCount20_30, oodCount30_xx};
            Integer[] iodData = new Integer[]{iodCount0_3, iodCount3_7, iodCount7_10, iodCount10_15, iodCount15_20, iodCount20_30, iodCount30_xx};
            chartDataList.add(dataSum);
            chartDataList.add(oodData);
            chartDataList.add(iodData);
            ArrayList<Integer[]> arrayList = chartDataList;
            return arrayList;
        }
        catch (Exception e1) {
            log.error("TaskBusinessManageIndexPlugin_updateHandleChart", (Throwable)e1);
        }
        finally {
            if (dataSet0_3 != null) {
                dataSet0_3.close();
            }
            if (dataSet3_7 != null) {
                dataSet3_7.close();
            }
            if (dataSet7_10 != null) {
                dataSet7_10.close();
            }
            if (dataSet10_15 != null) {
                dataSet10_15.close();
            }
            if (dataSet15_20 != null) {
                dataSet15_20.close();
            }
            if (dataSet20_30 != null) {
                dataSet20_30.close();
            }
            if (dataSet30_xx != null) {
                dataSet30_xx.close();
            }
        }
        chartDataList.add(new Integer[]{0, 0, 0, 0, 0, 0, 0});
        chartDataList.add(new Integer[]{0, 0, 0, 0, 0, 0, 0});
        chartDataList.add(new Integer[]{0, 0, 0, 0, 0, 0, 0});
        return chartDataList;
    }

    private List<Integer[]> getHandleChartDataNew() {
        String scidStr = (String)this.getModel().getValue("sharecenter");
        Long scid = Long.valueOf(scidStr);
        ArrayList<Integer[]> chartDataList = new ArrayList();
        String usergroupId = this.getCurrentGroup();
        boolean isSysAdminAndAllRight = Boolean.parseBoolean(this.getPageCache().get("isSysAdminAndAllRight"));
        chartDataList = TaskIndexDataUtil.getIndexChartData(scid, usergroupId, isSysAdminAndAllRight);
        return chartDataList;
    }

    private void setHandleChartData(Chart customchart, Date timenode) {
        Axis taskNumberAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570", (String)"TaskBusinessManageIndexPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), AxisType.value);
        String stack = ResManager.loadKDString((String)"\u603b\u91cf", (String)"TaskBusinessManageIndexPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        BarSeries seriesNormal = customchart.createBarSeries(ResManager.loadKDString((String)"\u672a\u8d85\u671f", (String)"TaskBusinessManageIndexPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        seriesNormal.setBarWidth("20%");
        seriesNormal.setStack(stack);
        seriesNormal.setColor("#2EC6C8");
        seriesNormal.getLabel().setShow(false);
        List<Object> charDataList = new ArrayList();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date curDate = null;
        Date chooseDate = null;
        try {
            curDate = format.parse(format.format(new Date()));
            chooseDate = format.parse(format.format(timenode));
        }
        catch (ParseException e) {
            log.error("TaskBusinessManageIndexPlugin.setHandleChartData error:" + e.getMessage(), (Throwable)e);
        }
        int result = 0;
        if (curDate != null && chooseDate != null) {
            result = curDate.compareTo(chooseDate);
        }
        charDataList = result == 0 ? this.getHandleChartDataNew() : this.getHandleChartData(timenode);
        Object[] dataSum = (Integer[])charDataList.get(0);
        Number[] oodData = (Integer[])charDataList.get(1);
        Number[] iodData = (Integer[])charDataList.get(2);
        seriesNormal.setData(iodData);
        BarSeries seriesOverdue = customchart.createBarSeries(ResManager.loadKDString((String)"\u5df2\u8d85\u671f", (String)"TaskBusinessManageIndexPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        seriesOverdue.setBarWidth("20%");
        seriesOverdue.setStack(stack);
        seriesOverdue.setColor("#FD6C6A");
        seriesOverdue.setData(oodData);
        ArrayList<String> path = new ArrayList<String>();
        path.add("label");
        path.add("normal");
        path.add("formatter");
        seriesOverdue.addFuncPath(path);
        String formatter = "(function(params){var retVal = '';var dataSum =" + Arrays.toString(dataSum) + ";retVal += dataSum[params.dataIndex]; return retVal;})";
        seriesOverdue.getLabel().setFormatter(formatter);
        int maxTask = (Integer)Collections.max(Arrays.asList(dataSum));
        int baseParam = maxTask <= 100 ? 25 : (maxTask > 100 && maxTask <= 500 ? 50 : (maxTask > 500 && maxTask <= 1000 ? 100 : (maxTask > 1000 && maxTask <= 5000 ? 500 : (maxTask > 5000 && maxTask <= 10000 ? 1000 : (maxTask > 10000 && maxTask <= 50000 ? 5000 : (maxTask > 50000 && maxTask <= 100000 ? 10000 : 50000))))));
        int yMaxValue = maxTask != 0 && maxTask % baseParam == 0 ? maxTask : (Math.floorDiv(maxTask, baseParam) + 1) * baseParam;
        int interval = yMaxValue / 5;
        taskNumberAxis.setMax((Number)yMaxValue);
        taskNumberAxis.setInterval((Number)interval);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        taskNumberAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(taskNumberAxis, "#666666");
        taskNumberAxis.setPropValue("axisLine", axisTick);
        customchart.bindData(null);
    }

    private Axis setHandlechartXaxisTick(Chart customchart) {
        Axis xaxis = customchart.createXAxis(null, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        ArrayList<String> xDimensions = new ArrayList<String>();
        xDimensions.add(ResManager.loadKDString((String)"3\u5929\u4ee5\u5185", (String)"TaskScheduleFormRpt_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"4-7\u5929", (String)"TaskScheduleFormRpt_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"8-10\u5929", (String)"TaskScheduleFormRpt_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"11-15\u5929", (String)"TaskScheduleFormRpt_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"16-20\u5929", (String)"TaskScheduleFormRpt_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"21-30\u5929", (String)"TaskScheduleFormRpt_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"1\u4e2a\u6708\u4ee5\u4e0a", (String)"TaskScheduleFormRpt_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xaxis.setCategorys(xDimensions);
        this.setLineColor(xaxis, "#666666");
        return xaxis;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if ("distributed".equals(key)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("type", "1");
            paramMap.put("date", "isToday");
            paramMap.put("usergroupid", this.getCurrentGroup());
            this.openNewForm(paramMap);
        } else if ("receivecomplete".equals(key)) {
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("sources", "TaskBusinessManageIndexPlugin");
            paramMap.put("sscid", scidStr);
            paramMap.put("pooltype", "2");
            paramMap.put("isToday", this.getPageCache().get("isTodayTask"));
            paramMap.put("opr", "receivecomplete");
            paramMap.put("qfilter", this.getPageCache().get(RECEIVECOMPLETE_TASK_FILTER_TAG));
            paramMap.put("usergroupid", this.getCurrentGroup());
            this.openNewForm(paramMap);
        } else if ("complete".equals(key)) {
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("sources", "TaskBusinessManageIndexPlugin");
            paramMap.put("sscid", scidStr);
            paramMap.put("pooltype", "2");
            paramMap.put("isToday", this.getPageCache().get("isTodayTask"));
            paramMap.put("opr", "complete");
            paramMap.put("qfilter", this.getPageCache().get(COMPLETE_TASK_FILTER_TAG));
            paramMap.put("usergroupid", this.getCurrentGroup());
            this.openNewForm(paramMap);
        } else if ("processing".equals(key)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            paramMap.put("sources", "TaskBusinessManageIndexPlugin");
            paramMap.put("pooltype", "1");
            paramMap.put("sscid", scidStr);
            paramMap.put("qfilter", this.getPageCache().get(PROCESSING_TASK_FILTER_TAG));
            paramMap.put("usergroupid", this.getCurrentGroup());
            this.openNewForm(paramMap);
        } else if ("tobeassigned".equals(key)) {
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("sources", "TaskBusinessManageIndexPlugin");
            paramMap.put("sscid", scidStr);
            paramMap.put("pooltype", "0");
            paramMap.put("qfilter", this.getPageCache().get(TOBEASSIGNED_TASK_FILTER_TAG));
            paramMap.put("usergroupid", this.getCurrentGroup());
            this.openNewForm(paramMap);
        } else if ("touploadimage".equals(key)) {
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("sources", "TaskBusinessManageIndexPlugin");
            paramMap.put("sscid", scidStr);
            paramMap.put("qfilter", this.getPageCache().get(TOUPLOADIMAGE_TASK_FILTER_TAG));
            paramMap.put("pooltype", "3");
            paramMap.put("usergroupid", this.getCurrentGroup());
            this.openNewForm(paramMap);
        } else if ("expire".equals(key)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("sources", "TaskBusinessManageIndexPlugin");
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            paramMap.put("sscid", scidStr);
            paramMap.put("expire", "2");
            paramMap.put("pooltype", "1");
            paramMap.put("qfilter", this.getPageCache().get(EXPIRED_TASK_FILTER_TAG));
            paramMap.put("usergroupid", this.getCurrentGroup());
            this.openNewForm(paramMap);
        } else if (!"sharecenter".equals(key) && "refreshbtn".equalsIgnoreCase(key)) {
            IndexDataAutoCalculateTask task = new IndexDataAutoCalculateTask();
            task.execute(null, null);
            String sscId = (String)this.getModel().getValue(SHARECENTER);
            String groupId = this.getCurrentGroup();
            Tab dateTab = (Tab)this.getControl("tabap");
            String dateCurTab = dateTab.getCurrentTab();
            if ("todaybtn".equals(dateCurTab)) {
                dateTab.selectTab("todaybtn");
            } else {
                dateTab.activeTab("todaybtn");
            }
            Tab taskDealTab = (Tab)this.getControl("tabap1");
            String taskCurTab = taskDealTab.getCurrentTab();
            if ("avgbtn".equals(taskCurTab)) {
                taskDealTab.selectTab("avgbtn");
            } else {
                taskDealTab.activeTab("avgbtn");
            }
            this.setToDoTaskNew(Long.valueOf(sscId), groupId);
            this.setInitialViewDate();
            Date timeNode = (Date)this.getModel().getValue("timenode");
            try {
                timeNode = DateUtil.getCurDateForm((Date)timeNode, (boolean)false);
            }
            catch (ParseException e) {
                throw new KDException(BosErrorCode.fulltextException, new Object[]{e});
            }
            this.updateHandleChart(timeNode);
        }
    }

    private void openNewForm(Map<String, Object> paramMap) {
        String appId = this.getView().getFormShowParameter().getAppId();
        String bizAppId = StringUtils.isNotEmpty((CharSequence)appId) ? BizAppServiceHelp.getAppIdByAppNumber((String)appId) : BizAppServiceHelp.getAppIdByFormNum((String)DYNAMIC_TASK_ADMIN);
        String permItem = this.getView().getFormShowParameter().getPermissionItemId();
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)bizAppId, (String)DYNAMIC_TASK_ADMIN, (String)permItem);
        if (!hasPerm) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u65e0\u201c\u4efb\u52a1\u7ba1\u7406\u5217\u8868\u201d\u67e5\u770b\u6743\u9650\u3002", (String)"TaskBusinessManageIndexPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        ListShowParameter parameEdit = new ListShowParameter();
        parameEdit.setFormId(DYNAMIC_TASK_ADMIN);
        parameEdit.setBillFormId("task_task");
        parameEdit.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameEdit.getOpenStyle().setTargetKey("_submaintab_");
        parameEdit.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u7ba1\u7406", (String)"TaskBusinessManageIndexPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        parameEdit.setCustomParams(paramMap);
        parameEdit.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameEdit);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        if ("sharecenter".equals(propertyName)) {
            long orgId = NumberUtils.toLong((String)this.getCurrentOrgId(), (long)-1L);
            Long userId = this.getCurrentUserId();
            this.setGroup(orgId, userId);
            this.setInitialViewNew((String)newValue);
        } else if ("timenode".equals(propertyName)) {
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            Date timenode = (Date)this.getModel().getValue("timenode");
            if (timenode == null) {
                return;
            }
            try {
                timenode = DateUtil.getCurDateForm((Date)timenode, (boolean)false);
            }
            catch (ParseException e1) {
                timenode = new Date();
                log.error("", (Throwable)e1);
            }
            this.updateHandleChart(timenode);
            this.getView().updateView("handlechart");
        } else if ("daterangenum_startdate".equals(propertyName)) {
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            Date startDate = (Date)newValue;
            Date endDate = (Date)this.getModel().getValue("daterangenum_enddate");
            if (endDate == null || startDate.compareTo(endDate) > 0) {
                return;
            }
            try {
                startDate = DateUtil.getCurDateForm((Date)startDate, (boolean)true);
                endDate = DateUtil.getCurDateForm((Date)endDate, (boolean)false);
            }
            catch (Exception e2) {
                throw new KDException((Throwable)e2, BosErrorCode.systemError, new Object[0]);
            }
            this.setTaskHandlepropertyChanged(startDate, endDate);
        } else if ("daterangenum_enddate".equals(propertyName)) {
            Date endDate;
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            Date startDate = (Date)this.getModel().getValue("daterangenum_startdate");
            if (startDate.compareTo(endDate = (Date)newValue) > 0) {
                return;
            }
            try {
                startDate = DateUtil.getCurDateForm((Date)startDate, (boolean)true);
                endDate = DateUtil.getCurDateForm((Date)endDate, (boolean)false);
            }
            catch (Exception e2) {
                throw new KDException((Throwable)e2, BosErrorCode.systemError, new Object[0]);
            }
            this.setTaskHandlepropertyChanged(startDate, endDate);
        } else if ("usergroup".equals(propertyName)) {
            String scid = this.getCurrentOrgId();
            this.setInitialViewNew(scid);
        }
    }

    private void setTaskHandlepropertyChanged(Date startDate, Date endDate) {
        boolean isAvgEfficient = Boolean.parseBoolean(this.getPageCache().get("isAvgEfficiency"));
        String scidStr = (String)this.getModel().getValue("sharecenter");
        if (StringUtils.isEmpty((CharSequence)scidStr)) {
            return;
        }
        Long scid = Long.valueOf(scidStr);
        String groupId = this.getCurrentGroup();
        if (isAvgEfficient) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"handleentity"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"taskentity"});
            this.setTaskEntryEfficiency(startDate, endDate, scid, groupId);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"handleentity"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"taskentity"});
            this.setTaskEntryCount(startDate, endDate, scid, groupId);
        }
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    public void onProgress(ProgressEvent arg0) {
        if (!"true".equals(this.getPageCache().get(AFTERCREATENEWDATA_TAG))) {
            return;
        }
        int value = 12;
        long userid = RequestContext.get().getCurrUserId();
        String scidStr = (String)this.getModel().getValue("sharecenter");
        if (userid > 0L && !StringUtils.isEmpty((CharSequence)scidStr)) {
            this.setInitialViewNew(scidStr);
        }
        arg0.setProgress(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tabSelected(TabSelectEvent paramTabSelectEvent) {
        if ("todaybtn".equals(paramTabSelectEvent.getTabKey())) {
            this.getPageCache().put("isTodayTask", "true");
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) return;
            Long scid = Long.valueOf(String.valueOf(scidStr));
            Map<String, Date> dateMap = this.getTodayandThismonthDate();
            this.setTodayOrMonthTaskNew(dateMap.get("startDate"), dateMap.get("endDate"), scid);
            this.getView().setVisible(Boolean.TRUE, new String[]{"pauselabel_d", "expirelabel_d", "rescanlabel_d"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"pauselabel_m", "expirelabel_m", "rescanlabel_m"});
            Label expirelabel = (Label)this.getControl("expirelabel_d");
            expirelabel.setText(ResManager.loadKDString((String)"\u4eca\u65e5\u5b8c\u6210", (String)"TaskBusinessManageIndexPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            Label rescanlabel = (Label)this.getControl("rescanlabel_d");
            rescanlabel.setText(ResManager.loadKDString((String)"\u4eca\u65e5\u7d2f\u8ba1\u5b8c\u6210", (String)"TaskBusinessManageIndexPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("thismonthbtn".equals(paramTabSelectEvent.getTabKey())) {
            this.getPageCache().put("isTodayTask", "false");
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) return;
            Long scid = Long.valueOf(scidStr);
            Map<String, Date> dateMap = this.getTodayandThismonthDate();
            this.setTodayOrMonthTaskNew(dateMap.get("startDate"), dateMap.get("endDate"), scid);
            this.getView().setVisible(Boolean.FALSE, new String[]{"pauselabel_d", "expirelabel_d", "rescanlabel_d"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"pauselabel_m", "expirelabel_m", "rescanlabel_m"});
            Label expirelabel = (Label)this.getControl("expirelabel_m");
            expirelabel.setText(ResManager.loadKDString((String)"\u672c\u6708\u5b8c\u6210", (String)"TaskBusinessManageIndexPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            Label rescanlabel = (Label)this.getControl("rescanlabel_m");
            rescanlabel.setText(ResManager.loadKDString((String)"\u672c\u6708\u7d2f\u8ba1\u5b8c\u6210", (String)"TaskBusinessManageIndexPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("avgbtn".equals(paramTabSelectEvent.getTabKey())) {
            String scidStr = (String)this.getModel().getValue("sharecenter");
            if (StringUtils.isEmpty((CharSequence)scidStr)) {
                return;
            }
            this.getPageCache().put("isAvgEfficiency", "true");
            this.getView().setVisible(Boolean.FALSE, new String[]{"handleentity"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"taskentity"});
            Long scid = Long.valueOf(scidStr);
            Date startDate = (Date)this.getModel().getValue("daterangenum_startdate");
            Date endDate = (Date)this.getModel().getValue("daterangenum_enddate");
            if (startDate == null || endDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"TaskBusinessManageIndexPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                startDate = DateUtil.getCurDateForm((Date)startDate, (boolean)true);
                endDate = DateUtil.getCurDateForm((Date)endDate, (boolean)false);
            }
            catch (ParseException e) {
                log.error("DataParse error:" + e.getMessage(), (Throwable)e);
            }
            String groupId = this.getCurrentGroup();
            this.setTaskEntryEfficiency(startDate, endDate, scid, groupId);
            return;
        }
        if (!"handletotalbtn".equals(paramTabSelectEvent.getTabKey())) return;
        String scidStr = (String)this.getModel().getValue("sharecenter");
        if (StringUtils.isEmpty((CharSequence)scidStr)) {
            return;
        }
        this.getPageCache().put("isAvgEfficiency", "false");
        ContainerAp conap = new ContainerAp();
        conap.setKey("handleentity");
        conap.setVisible("new");
        this.getView().updateControlMetadata("handleentity", conap.createControl());
        this.getView().setVisible(Boolean.TRUE, new String[]{"handleentity"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"taskentity"});
        Long scid = Long.valueOf(scidStr);
        Date startDate = (Date)this.getModel().getValue("daterangenum_startdate");
        Date endDate = (Date)this.getModel().getValue("daterangenum_enddate");
        if (startDate == null || endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"TaskBusinessManageIndexPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            startDate = DateUtil.getCurDateForm((Date)startDate, (boolean)true);
            endDate = DateUtil.getCurDateForm((Date)endDate, (boolean)false);
        }
        catch (ParseException e) {
            log.error("DataParse error:" + e.getMessage(), (Throwable)e);
        }
        String groupId = this.getCurrentGroup();
        this.setTaskEntryCount(startDate, endDate, scid, groupId);
    }

    private void setToDOTaskFilterCache(Long sscid) {
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        QFilter processingFilter = new QFilter("pooltype", "=", (Object)"1");
        QFilter todoFilter = new QFilter("pooltype", "=", (Object)"0");
        QFilter touploadimageFilter = new QFilter("pooltype", "=", (Object)"3");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        this.getPageCache().put(EXPIRED_TASK_FILTER_TAG, processingFilter.copy().and(shareCenterFilter).and(notQuaCheckTask).toSerializedString());
        this.getPageCache().put(PROCESSING_TASK_FILTER_TAG, processingFilter.and(shareCenterFilter).and(notQuaCheckTask).toSerializedString());
        this.getPageCache().put(TOBEASSIGNED_TASK_FILTER_TAG, todoFilter.and(shareCenterFilter).and(notQuaCheckTask).toSerializedString());
        this.getPageCache().put(TOUPLOADIMAGE_TASK_FILTER_TAG, touploadimageFilter.and(shareCenterFilter).and(notQuaCheckTask).toSerializedString());
    }

    private void setTodayOrMonthFilterCache(Date startDate, Date endDate, Long sscid, String groupId) {
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        QFilter receivetimeFilter = QFilter.of((String)"receivetime >= ? and receivetime <= ?", (Object[])new Object[]{startDate, endDate});
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        QFilter completetimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        if (groupId != null && !"-1".equals(groupId)) {
            QFilter groupFilter = new QFilter("usergroup.id", "=", (Object)Long.parseLong(groupId));
            this.getPageCache().put(RECEIVECOMPLETE_TASK_FILTER_TAG, receivetimeFilter.and(completetimeFilter).and(shareCenterFilter).and(notQuaCheckTask).and(groupFilter).toSerializedString());
            this.getPageCache().put(COMPLETE_TASK_FILTER_TAG, completetimeFilter.and(shareCenterFilter).and(notQuaCheckTask).and(groupFilter).toSerializedString());
        } else {
            this.getPageCache().put(RECEIVECOMPLETE_TASK_FILTER_TAG, receivetimeFilter.and(completetimeFilter).and(shareCenterFilter).and(notQuaCheckTask).toSerializedString());
            this.getPageCache().put(COMPLETE_TASK_FILTER_TAG, completetimeFilter.and(shareCenterFilter).and(notQuaCheckTask).toSerializedString());
        }
    }

    String getCurrentOrgId() {
        return this.getModel().getValue(SHARECENTER) + "";
    }

    String getCurrentGroup() {
        return this.getModel().getValue(USERGROUP) + "";
    }

    Long getCurrentUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    void putIsAdminCache(String key, boolean result) {
        this.getPageCache().put(key, String.valueOf(result));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_businessmanageindex", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"TaskBusinessManageIndexPlugin_23", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

