/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.common.OrgpatternEnum;

public class TaskCreateOrgListcomitemHelper {
    private static Log log = LogFactory.getLog(TaskCreateOrgListcomitemHelper.class);

    public List<ComboItem> getOrgidListcomitemBySSCID(Long sscid) {
        ArrayList<ComboItem> listcomitem = new ArrayList<ComboItem>();
        DynamicObjectCollection col = this.getOrgBySscId(sscid);
        if (col != null) {
            for (DynamicObject taskRow : col) {
                String caption = taskRow.getString("name");
                String value = taskRow.getString("id");
                listcomitem.add(new ComboItem(new LocaleString(caption), value));
            }
        }
        return listcomitem;
    }

    public List<Long> getEntrustOrgBySSCID(Long sscid) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        DynamicObjectCollection dynObjs = this.getOrgBySscId(sscid);
        if (dynObjs != null) {
            for (DynamicObject dynObj : dynObjs) {
                orgIds.add(dynObj.getLong("id"));
            }
        }
        return orgIds;
    }

    private DynamicObjectCollection getOrgBySscId(Long sscid) {
        List deputeOrgIDList = OrgRelationQueryHelper.getFromOrgList((long)sscid);
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName() + ".getOrgBySscId", "bos_org", "id,number,name", new QFilter("id", "in", (Object)deputeOrgIDList).toArray());){
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"bos_org");
            return dynamicObjectCollection;
        }
    }

    @Deprecated
    private DynamicObjectCollection getOrgCompanyBySscId(Long sscid) {
        List<Long> deputeOrgIDList = this.getSscDeputeOrgList(sscid);
        return this.getBosOrgCompanyByID(deputeOrgIDList);
    }

    private List<Long> getSscDeputeOrgList(Long sscid) {
        ArrayList<Long> deputeOrgIDList = new ArrayList();
        try {
            deputeOrgIDList = OrgRelationQueryHelper.getFromOrgList((long)sscid);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5171\u4eab\u4e2d\u5fc3\u59d4\u6258\u7ec4\u7ec7\u5931\u8d25", (Throwable)e);
        }
        return deputeOrgIDList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection getBosOrgCompanyByID(List<Long> deputeOrgIDList) {
        ORM orm = ORM.create();
        ArrayList<Integer> orgpattern = new ArrayList<Integer>();
        orgpattern.add(OrgpatternEnum.Company.getValue());
        orgpattern.add(OrgpatternEnum.BranchCompany.getValue());
        orgpattern.add(OrgpatternEnum.Group.getValue());
        String selectField = "id,number,name";
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("id", "in", deputeOrgIDList));
        filterList.add(new QFilter("orgpattern", "in", orgpattern));
        try (DataSet ds = null;){
            DynamicObjectCollection collection;
            ds = orm.queryDataSet(this.getClass().getName() + ".getBosOrgCompanyByNum", "bos_org", selectField, filterList.toArray(new QFilter[0]));
            DynamicObjectCollection dynamicObjectCollection = collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"bos_org");
            return dynamicObjectCollection;
        }
    }
}

