/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.common.TaskIndexDataUtil;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.formplugin.IndexDataAutoCalculateTask;
import kd.ssc.task.formplugin.WidgetPCIndexPlugin;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskSalesIndexPlugin
extends AbstractFormPlugin
implements ProgresssListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(TaskSalesIndexPlugin.class);
    private static final QFilter processingFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
    private static final QFilter completFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
    private static final QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
    private static final QFilter expirestateQFilter = new QFilter("expirestate", "=", (Object)"2");
    private static final QFilter overduequalityFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.CHECKING.getValue(), TaskStateEnum.RECTIFYING.getValue(), TaskStateEnum.REVIEW.getValue()});
    private static final QFilter pendinghandleFilter = new QFilter("state", "=", (Object)TaskStateEnum.CHECKING.getValue());
    private static final QFilter pendingFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.PAUSE_CHECKING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue()});
    private static final QFilter pendingreformFilter = new QFilter("state", "=", (Object)TaskStateEnum.RECTIFYING.getValue());
    private static final QFilter pendingrecheckFilter = new QFilter("state", "=", (Object)TaskStateEnum.REVIEW.getValue());
    private static final QFilter completedqualityFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.QUA_CHECK_COMPLETED.getValue(), TaskStateEnum.TO_BE_TRACKED.getValue()});
    private static final QFilter quaCheckTask = new QFilter("qualitysamplelibrary", ">", (Object)TaskFilterEnum.NOTQUACHECKTASK);
    private static String dailyPatternRegex = "[\\.\\/\\-]?yyyy[\\.\\/\\-]?";
    private static String monthlyPatternRegex = "[\\.\\/\\-]d+|d+[\\.\\/\\-]";
    private static String defaultDailyPattern = "MM-dd";
    private static String defaultMonthlyPattern = "yyyy-MM";
    private static String COMMON_URL = "/images/pc/emotion/default_person_82_82.png";
    private static String entityName = "task_task";
    private static String completentityName = "task_taskhistory";
    private static String expireNum = "expireNum";
    private static String normalNum = "normalNum";
    private static String AFTERCREATENEWDATA_TAG = "aftercreatenewdata_tag";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"sharecenter", "avgday", "avgmonth", "normal", "normallabel", "pause", "pauselabel", "expirestate", "expirelabel", "rescan", "rescanlabel", "complet", "completlabel", "ranktopfabulous1", "ranktopfabulous2", "ranktopfabulous3", "ranktopfabulous4", "ranktopfabulous5", "pendinghandle", "pending", "pendingreform", "pendingrecheck", "overduequality", "completedquality", "qualityavgday", "qualityavgmonth", "tasktab", "qualitytab", "tasktab1", "qualitytab1", "quaranktopfabulous1", "quaranktopfabulous2", "quaranktopfabulous3", "quaranktopfabulous4", "quaranktopfabulous5"});
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Tab tab1 = (Tab)this.getControl("tabap2");
        tab1.addTabSelectListener((TabSelectListener)this);
        Tab tab21 = (Tab)this.getControl("tabap21");
        tab21.addTabSelectListener((TabSelectListener)this);
        Tab tab22 = (Tab)this.getControl("tabap1");
        tab22.addTabSelectListener((TabSelectListener)this);
        Button refreshBtn = (Button)this.getView().getControl("refreshbtn");
        refreshBtn.addClickListener((ClickListener)this);
    }

    public void tabSelected(TabSelectEvent paramTabSelectEvent) {
        String dailyPattern;
        long userId = NumberUtils.toLong((String)RequestContext.get().getUserId());
        String dateFormat = InteServiceHelper.getDateFormat((Long)userId);
        String monthlyPattern = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(monthlyPatternRegex, "") : defaultMonthlyPattern;
        String string = dailyPattern = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(dailyPatternRegex, "") : defaultDailyPattern;
        if ("avgday".equals(paramTabSelectEvent.getTabKey())) {
            try {
                Date startDate = (Date)this.getModel().getValue("daterangenum_startdate");
                Date endDate = (Date)this.getModel().getValue("daterangenum_enddate");
                Map<String, Object> dateMap = this.processDate(startDate, endDate, dailyPattern);
                this.updateChartTasks(dateMap, true, false);
                this.getView().setVisible(Boolean.TRUE, new String[]{"daterangenum"});
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        } else if ("avgmonth".equals(paramTabSelectEvent.getTabKey())) {
            Map<String, Object> dateMap = this.getMonthDate(monthlyPattern);
            this.updateChartTasks(dateMap, false, false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"daterangenum"});
        } else if ("qualityavgday".equals(paramTabSelectEvent.getTabKey())) {
            try {
                Date startDate = (Date)this.getModel().getValue("quadaterangenum_startdate");
                Date endDate = (Date)this.getModel().getValue("quadaterangenum_enddate");
                Map<String, Object> dateMap = this.processDate(startDate, endDate, dailyPattern);
                this.updateChartTasks(dateMap, true, true);
                this.getView().setVisible(Boolean.TRUE, new String[]{"quadaterangenum"});
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        } else if ("qualityavgmonth".equals(paramTabSelectEvent.getTabKey())) {
            Map<String, Object> dateMap = this.getMonthDate(monthlyPattern);
            this.updateChartTasks(dateMap, false, true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"quadaterangenum"});
        } else if ("tasktab1".equals(paramTabSelectEvent.getTabKey())) {
            ((Tab)this.getControl("tabap1")).activeTab("tasktab");
        } else if ("qualitytab1".equals(paramTabSelectEvent.getTabKey())) {
            ((Tab)this.getControl("tabap1")).activeTab("qualitytab");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setShareCenter();
        long userid = Long.parseLong(RequestContext.get().getUserId());
        if (userid < 1L) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskSalesIndexPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"TaskSalesIndexPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        log.info("\u4e1a\u52a1\u5458\u9996\u9875\uff0c\u5f53\u524d\u767b\u5f55\u4eba\u5458id:" + userid);
        Long sscid = this.getSSCId(true, userid);
        if (sscid == null || sscid < 1L) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u201c\u6211\u7684\u4efb\u52a1\u201d\u83dc\u5355\u6743\u9650\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskSalesIndexPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        log.info("\u4e1a\u52a1\u5458\u9996\u9875\uff0c\u5f53\u524d\u767b\u5f55\u5171\u4eab\u4e2d\u5fc3:" + sscid);
        this.refreshData(userid);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
    }

    private void setShareCenter() {
        Object currentOrgId = this.getView().getFormShowParameter().getCustomParam("currentOrgId");
        long userId = RequestContext.get().getCurrUserId();
        long orgId = RequestContext.get().getOrgId();
        String entityName = this.getModel().getDataEntityType().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        List<ComboItem> list = WidgetPCIndexPlugin.getSscenters(appId, userId, entityName);
        if (list != null && list.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl("sharecenter");
            combo.setComboItems(list);
            boolean isIni = false;
            for (ComboItem item : list) {
                Long sscId = Long.valueOf(item.getValue());
                if (!sscId.equals(orgId)) continue;
                this.getModel().setValue("sharecenter", (Object)orgId);
                isIni = true;
            }
            if (!isIni) {
                this.getModel().setValue("sharecenter", (Object)list.get(0).getValue());
            }
        }
    }

    String getCurrentOrgId() {
        return this.getModel().getValue("sharecenter") + "";
    }

    Long getCurrentUserId() {
        return RequestContext.get().getCurrUserId();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String dailyPattern;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Map<String, Object> dateMap = null;
        boolean isAvgDay = ((Tab)this.getControl("tabap")).getCurrentTab().equals("avgday");
        String dateFormat = InteServiceHelper.getDateFormat((Long)NumberUtils.toLong((String)RequestContext.get().getUserId()));
        String string = dailyPattern = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(dailyPatternRegex, "") : defaultDailyPattern;
        if ("sharecenter".equals(propertyName)) {
            Long userId = this.getCurrentUserId();
            this.refreshData(userId);
        } else if ("daterangedaily_startdate".equals(propertyName)) {
            Date startDate = (Date)newValue;
            Date endDate = (Date)this.getModel().getValue("daterangedaily_enddate");
            try {
                dateMap = this.processDate(startDate, endDate, dailyPattern);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            this.updateChartDaily(dateMap, false, dailyPattern);
        } else if ("daterangedaily_enddate".equals(propertyName)) {
            Date startDate = (Date)this.getModel().getValue("daterangedaily_startdate");
            Date endDate = (Date)newValue;
            try {
                dateMap = this.processDate(startDate, endDate, dailyPattern);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            this.updateChartDaily(dateMap, false, dailyPattern);
        } else if ("quadaterangedaily_startdate".equals(propertyName)) {
            Date startDate = (Date)newValue;
            Date endDate = (Date)this.getModel().getValue("quadaterangedaily_enddate");
            try {
                dateMap = this.processDate(startDate, endDate, dailyPattern);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            this.updateChartDaily(dateMap, true, dailyPattern);
        } else if ("quadaterangedaily_enddate".equals(propertyName)) {
            Date startDate = (Date)this.getModel().getValue("quadaterangedaily_startdate");
            Date endDate = (Date)newValue;
            try {
                dateMap = this.processDate(startDate, endDate, dailyPattern);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            this.updateChartDaily(dateMap, true, dailyPattern);
        } else if ("daterangenum_startdate".equals(propertyName)) {
            if (!isAvgDay) {
                return;
            }
            Date startDate = (Date)newValue;
            Date endDate = (Date)this.getModel().getValue("daterangenum_enddate");
            try {
                dateMap = this.processDate(startDate, endDate, dailyPattern);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            this.updateChartTasks(dateMap, isAvgDay, false);
        } else if ("daterangenum_enddate".equals(propertyName)) {
            if (!isAvgDay) {
                return;
            }
            Date startDate = (Date)this.getModel().getValue("daterangenum_startdate");
            Date endDate = (Date)newValue;
            try {
                dateMap = this.processDate(startDate, endDate, dailyPattern);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            this.updateChartTasks(dateMap, isAvgDay, false);
        } else if ("quadaterangenum_startdate".equals(propertyName)) {
            if (!isAvgDay) {
                return;
            }
            Date startDate = (Date)newValue;
            Date endDate = (Date)this.getModel().getValue("quadaterangenum_enddate");
            try {
                dateMap = this.processDate(startDate, endDate, dailyPattern);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            this.updateChartTasks(dateMap, isAvgDay, true);
        } else if ("quadaterangenum_enddate".equals(propertyName)) {
            if (!isAvgDay) {
                return;
            }
            Date startDate = (Date)this.getModel().getValue("quadaterangenum_startdate");
            Date endDate = (Date)newValue;
            try {
                dateMap = this.processDate(startDate, endDate, dailyPattern);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            this.updateChartTasks(dateMap, isAvgDay, true);
        }
    }

    private void refreshData(Long userId) {
        this.updateMyNeedDealtNew(userId);
        this.updateRanking(userId);
        try {
            String dateformat = InteServiceHelper.getDateFormat((Long)userId);
            String dailypattern = "MM-dd";
            if (StringUtils.isNotEmpty((String)dateformat)) {
                dailypattern = dateformat.replaceAll(dailyPatternRegex, "");
            }
            Map<String, Object> datemap = this.getDefaultDate(dailypattern);
            this.getModel().setValue("daterangedaily_startdate", datemap.get("startDate"));
            this.getModel().setValue("daterangedaily_enddate", datemap.get("endDate"));
            this.getModel().setValue("daterangenum_startdate", datemap.get("startDate"));
            this.getModel().setValue("daterangenum_enddate", datemap.get("endDate"));
            this.getModel().setValue("quadaterangedaily_startdate", datemap.get("startDate"));
            this.getModel().setValue("quadaterangedaily_enddate", datemap.get("endDate"));
            this.getModel().setValue("quadaterangenum_startdate", datemap.get("startDate"));
            this.getModel().setValue("quadaterangenum_enddate", datemap.get("endDate"));
            this.updateChartDaily(datemap, false, dailypattern);
            this.updateChartDaily(datemap, true, dailypattern);
            this.updateChartTasks(datemap, true, false);
            this.updateChartTasks(datemap, true, true);
        }
        catch (Exception e1) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{e1});
        }
        this.getPageCache().put(AFTERCREATENEWDATA_TAG, "true");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        QFilter sscFilter = this.getSSCFilter();
        if (key.equals("normal")) {
            List<QFilter> filters = this.getCommonFilter(false);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
            filters.add(new QFilter("state", "in", (Object)new String[]{TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.REUPLOAD_IMAGE.getValue()}));
            this.goMyTaskListPage(this.getExpirestateFilter(filters, false), TaskPoolTypeEnum.PROCESSING.getValue(), "1", false);
        } else if (key.equals("pause")) {
            List<QFilter> filters = this.getCommonFilter(false);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
            filters.add(new QFilter("state", "=", (Object)TaskStateEnum.PAUSE.getValue()));
            this.goMyTaskListPage(this.getExpirestateFilter(filters, false), TaskPoolTypeEnum.PROCESSING.getValue(), "0", false);
        } else if (key.equals("expirestate")) {
            List<QFilter> filters = this.getCommonFilter(false);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
            this.goMyTaskListPage(this.getExpirestateFilter(filters, true), TaskPoolTypeEnum.PROCESSING.getValue(), "4", false);
        } else if (key.equals("rescan")) {
            List<QFilter> filters = this.getCommonFilter(false);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
            filters.add(new QFilter("state", "=", (Object)TaskStateEnum.RESCAN.getValue()));
            this.goMyTaskListPage(this.getExpirestateFilter(filters, false), TaskPoolTypeEnum.PROCESSING.getValue(), "2", false);
        } else if (key.equals("complet")) {
            List<QFilter> filters = this.getCommonFilter(false);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue()));
            Date nowDate = new Date();
            Date startDate = null;
            Date endDate = null;
            try {
                startDate = this.getDateForm(nowDate, true);
                endDate = this.getDateForm(nowDate, false);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
            filters.add(QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate}));
            this.goMyTaskListPage(filters, TaskPoolTypeEnum.COMPLETE.getValue(), "3", false);
        } else if (key.equals("pendinghandle")) {
            List<QFilter> filters = this.getCommonFilter(true);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(pendinghandleFilter);
            this.goMyTaskListPage(filters, TaskPoolTypeEnum.PROCESSING.getValue(), "5", true);
        } else if (key.equals("pending")) {
            List<QFilter> filters = this.getCommonFilter(true);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(pendingFilter);
            this.goMyTaskListPage(filters, TaskPoolTypeEnum.PROCESSING.getValue(), "10", true);
        } else if (key.equals("pendingreform")) {
            List<QFilter> filters = this.getCommonFilter(true);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(pendingreformFilter);
            this.goMyTaskListPage(filters, TaskPoolTypeEnum.PROCESSING.getValue(), "6", true);
        } else if (key.equals("pendingrecheck")) {
            List<QFilter> filters = this.getCommonFilter(true);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(pendingrecheckFilter);
            this.goMyTaskListPage(filters, TaskPoolTypeEnum.PROCESSING.getValue(), "7", true);
        } else if (key.equals("overduequality")) {
            List<QFilter> filters = this.getCommonFilter(true);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            filters.add(overduequalityFilter);
            filters.add(expirestateQFilter);
            this.goMyTaskListPage(filters, TaskPoolTypeEnum.PROCESSING.getValue(), "8", true);
        } else if (key.equals("completedquality")) {
            QFilter monthFilter;
            List<QFilter> filters = this.getCommonFilter(true);
            if (sscFilter != null) {
                filters.add(sscFilter);
            }
            Date nowDate = new Date();
            try {
                Date firstMonth = this.getMonthFirstDate(nowDate);
                Date endDate = this.getDateForm(nowDate, false);
                monthFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{firstMonth, endDate});
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
            filters.add(completedqualityFilter);
            filters.add(monthFilter);
            this.goMyTaskListPage(filters, TaskPoolTypeEnum.COMPLETE.getValue(), "9", true);
        } else if (key.startsWith("ranktopfabulous")) {
            if (!this.isCanThumbUp(key, false)) {
                return;
            }
            this.createFabulous(key, false);
            String targetUserId = this.getPageCache().get(key);
            int count = this.getFabulousOne(targetUserId, false, true, false);
            String labelKey = key.replace("ranktopfabulous", "ranktopfabulousnum");
            ((Label)this.getControl(labelKey)).setText(String.valueOf(count));
            String url = UrlService.getImageFullUrl((String)"/icons/pc/state/praised.png");
            ((Image)this.getControl(key)).setUrl(url);
        } else if (key.startsWith("quaranktopfabulous")) {
            if (!this.isCanThumbUp(key, true)) {
                return;
            }
            this.createFabulous(key, true);
            String targetUserId = this.getPageCache().get(key);
            int count = this.getFabulousOne(targetUserId, false, true, true);
            String labelKey = key.replace("quaranktopfabulous", "qualitranktopfabulousnum");
            ((Label)this.getControl(labelKey)).setText(String.valueOf(count));
            String url = UrlService.getImageFullUrl((String)"/icons/pc/state/praised.png");
            ((Image)this.getControl(key)).setUrl(url);
        } else if ("refreshbtn".equalsIgnoreCase(key)) {
            IndexDataAutoCalculateTask task = new IndexDataAutoCalculateTask();
            task.execute(null, null);
            Long userId = this.getCurrentUserId();
            this.refreshData(userId);
            Tab taskNumTab = (Tab)this.getControl("tabap");
            taskNumTab.activeTab("avgday");
            Tab topTab = (Tab)this.getControl("tabap21");
            topTab.activeTab("tasktab1");
        }
    }

    private QFilter getSSCFilter() {
        long userid = Long.parseLong(RequestContext.get().getUserId());
        if (userid <= 0L) {
            return null;
        }
        Long sscid = this.getSSCId(false, userid);
        if (sscid == null || sscid <= 0L) {
            return null;
        }
        return new QFilter("sscid", "=", (Object)sscid);
    }

    private List<QFilter> getCommonFilter(boolean isQuality) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        long userid = Long.parseLong(RequestContext.get().getUserId());
        filters.add(new QFilter("personid", "=", (Object)userid));
        if (isQuality) {
            filters.add(quaCheckTask);
        } else {
            filters.add(notQuaCheckTask);
        }
        return filters;
    }

    private List<QFilter> getExpirestateFilter(List<QFilter> filters, boolean isOut) {
        ArrayList<QFilter> goToMyTaskfilters = new ArrayList<QFilter>();
        if (isOut) {
            QFilter expirestateQFilter = new QFilter("expirestate", "=", (Object)"2");
            goToMyTaskfilters.add(expirestateQFilter);
        } else {
            goToMyTaskfilters.add(new QFilter("id", "in", this.getTaskNumber("ssc.task.tasksalesindex.tasknumbergotomytask", filters.toArray(new QFilter[0]), true, false)));
        }
        goToMyTaskfilters.add(notQuaCheckTask);
        return goToMyTaskfilters;
    }

    private void goMyTaskListPage(List<QFilter> filters, String poolType, String item, boolean isQuality) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        QFilter ultimately = filters.get(0);
        for (int i = 1; i < filters.size(); ++i) {
            ultimately = ultimately.and(filters.get(i));
        }
        String taskproperty = isQuality ? "1" : "0";
        ArrayList<String> taskPropertyList = new ArrayList<String>();
        if (isQuality) {
            taskPropertyList.add(TaskPropertyEnum.QUACHECKTASK.getValue());
        } else {
            taskPropertyList.add(TaskPropertyEnum.APPROVETASK.getValue());
            taskPropertyList.add(TaskPropertyEnum.INQUIRY_TASK.getValue());
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("task_task");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setCustomParam("tasksaleindex_pooltype", (Object)poolType);
        parameter.setCustomParam("tasksaleindex_item", (Object)item);
        parameter.setCustomParam("sources", (Object)"TaskSalesIndexPlugin");
        parameter.setCustomParam("qfilter", (Object)ultimately.toSerializedString());
        parameter.setCustomParam("taskproperty", (Object)taskproperty);
        parameter.setCustomParam("taskPropertyList", taskPropertyList);
        long userid = Long.parseLong(RequestContext.get().getUserId());
        Long sscid = this.getSSCId(false, userid);
        parameter.setCustomParam("sscid", (Object)sscid);
        parameter.setCaption(ResManager.loadKDString((String)"\u6211\u7684\u4efb\u52a1", (String)"TaskSalesIndexPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        FormShowParameter parent = this.getView().getFormShowParameter();
        parameter.setParentPageId(parent.getParentPageId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void updateChartTasks(Map<String, Object> dateMap, boolean isDaily, boolean isQuality) {
        if (dateMap == null || dateMap.isEmpty()) {
            return;
        }
        Chart customchart = (Chart)this.getControl(isQuality ? "qualitycharttasks" : "charttasks");
        customchart.clearData();
        Number[] personAvgSeriesData = this.getPersonAvgSeriesData(dateMap, isDaily, isQuality);
        Number[] departAvgData = this.getDepartAvgData(dateMap, isDaily, isQuality);
        int max = this.getDataMax((Integer[])personAvgSeriesData, (Integer[])departAvgData);
        Map<String, Integer> scaleMap = this.calculationYMax(max);
        this.setXaxisTick(customchart, dateMap);
        Axis yAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u5f20\u6570", (String)"TaskSalesIndexPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), AxisType.value);
        yAxis.setInterval((Number)scaleMap.get("interval"));
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisTick);
        yAxis.setMax((Number)scaleMap.get("max"));
        this.setLineColor(yAxis, "#666666");
        yAxis.setPropValue("axisLine", axisTick);
        String stack = ResManager.loadKDString((String)"\u4e2a\u4eba\u603b\u91cf", (String)"TaskSalesIndexPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        LineSeries personAvgSeries = customchart.createLineSeries(ResManager.loadKDString((String)"\u4e2a\u4eba\u5b9e\u9645\u503c", (String)"TaskSalesIndexPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        personAvgSeries.setStack(stack);
        personAvgSeries.setSmooth(true);
        personAvgSeries.setColor("#799AFF");
        personAvgSeries.setData(personAvgSeriesData);
        LineSeries departAvgSeries = customchart.createLineSeries(ResManager.loadKDString((String)"\u90e8\u95e8\u5e73\u5747\u503c", (String)"TaskSalesIndexPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        departAvgSeries.setStack(ResManager.loadKDString((String)"\u90e8\u95e8\u5e73\u5747\u503c", (String)"TaskSalesIndexPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        departAvgSeries.setSmooth(true);
        departAvgSeries.setColor("#73DDDE");
        departAvgSeries.setData(departAvgData);
        customchart.setShowTooltip(true);
        customchart.bindData(null);
    }

    private Axis setXaxisTick(Chart customchart, Map<String, Object> dateMap) {
        Axis xaxis = customchart.createXAxis(null, AxisType.category);
        List xDimensions = (List)dateMap.get("xtitle");
        xaxis.setCategorys(xDimensions);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xaxis, "#666666");
        return xaxis;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private Integer[] getPersonAvgSeriesData(Map<String, Object> dateMap, boolean isDaily, boolean isQuality) {
        Long userid = Long.valueOf(RequestContext.get().getUserId());
        String dateFormat = InteServiceHelper.getDateFormat((Long)userid);
        String dailyDateFormat = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(dailyPatternRegex, "") : defaultDailyPattern;
        String monthlyDateFormat = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(monthlyPatternRegex, "") : defaultMonthlyPattern;
        Long sscId = this.getSSCId(false, userid);
        DataSet taskNumDaily = TaskIndexDataUtil.getTaskNumDaily(dateMap, userid, sscId, isQuality);
        taskNumDaily = isDaily ? taskNumDaily.select(new String[]{"id", "user", "(normalnum + expirenum) as num", "date"}) : taskNumDaily.select(new String[]{"id", "user", "(normalnum + expirenum) as num", "(cast(year(date) as integer)*100+cast(month(date) as integer)) as date"}).groupBy(new String[]{"date"}).sum("num").finish();
        Object[] personAvg = new Integer[]{0};
        if (taskNumDaily != null) {
            Iterator it = taskNumDaily.iterator();
            List xDimensions = (List)dateMap.get("xtitle");
            personAvg = new Integer[xDimensions.size()];
            String key = null;
            while (it.hasNext()) {
                int index;
                Row row = (Row)it.next();
                if (isDaily) {
                    key = DateUtil.format((Object)row.get("date"), (String)dailyDateFormat);
                } else {
                    int year = row.getInteger("date") / 100;
                    int month = row.getInteger("date") % 100;
                    Calendar.getInstance().set(1, year);
                    Calendar.getInstance().set(2, month - 1);
                    Calendar.getInstance().set(5, 1);
                    key = DateUtil.format((Object)Calendar.getInstance().getTime(), (String)monthlyDateFormat);
                }
                if ((index = xDimensions.indexOf(key)) <= -1) continue;
                personAvg[index] = row.getInteger("num");
            }
            taskNumDaily.close();
        }
        this.castnulltoZero(personAvg, true);
        return personAvg;
    }

    private Integer[] getDepartAvgData(Map<String, Object> dateMap, boolean isDaily, boolean isQuality) {
        List list = (List)dateMap.get("xtitle");
        Integer[] departAvgData = new Integer[list.size()];
        Long userid = Long.valueOf(RequestContext.get().getUserId());
        String dateFormat = InteServiceHelper.getDateFormat((Long)userid);
        String dailyDateFormat = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(dailyPatternRegex, "") : defaultDailyPattern;
        String monthlyDateFormat = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(monthlyPatternRegex, "") : defaultMonthlyPattern;
        Long sscId = this.getSSCId(false, userid);
        DataSet taskNumDaily = TaskIndexDataUtil.getTaskNumDaily(dateMap, null, sscId, isQuality);
        if (isDaily) {
            taskNumDaily = taskNumDaily.select(new String[]{"id", "user", "(normalnum + expirenum) as num", "date"}).groupBy(new String[]{"date"}).count("peoples").sum("num", "totalunit").finish();
        } else {
            taskNumDaily = taskNumDaily.select(new String[]{"id", "user", "(normalnum + expirenum) as num", "(cast(year(date) as integer)*100+cast(month(date) as integer)) as date"}).groupBy(new String[]{"date", "user"}).sum("num").finish();
            taskNumDaily = taskNumDaily.groupBy(new String[]{"date"}).count("peoples").sum("num", "totalunit").finish();
        }
        if (taskNumDaily != null) {
            for (Row row : taskNumDaily) {
                int index;
                String key = null;
                if (isDaily) {
                    key = DateUtil.format((Object)row.get("date"), (String)dailyDateFormat);
                } else {
                    int year = row.getInteger("date") / 100;
                    int month = row.getInteger("date") % 100;
                    Calendar.getInstance().set(1, year);
                    Calendar.getInstance().set(2, month - 1);
                    Calendar.getInstance().set(5, 1);
                    key = DateUtil.format((Object)Calendar.getInstance().getTime(), (String)monthlyDateFormat);
                }
                if ((index = list.indexOf(key)) <= -1) continue;
                BigDecimal totalunit = row.getBigDecimal("totalunit");
                BigDecimal peoples = row.getBigDecimal("peoples");
                departAvgData[index] = totalunit.divide(peoples, 0, 4).intValue();
            }
            taskNumDaily.close();
        }
        for (int i = 0; i < departAvgData.length; ++i) {
            if (departAvgData[i] != null) continue;
            departAvgData[i] = 0;
        }
        return departAvgData;
    }

    private void updateChartDaily(Map<String, Object> dateMap, boolean isQuality, String monthlyPattern) {
        if (dateMap == null || dateMap.isEmpty()) {
            return;
        }
        Chart customchart = (Chart)this.getControl(isQuality ? "qualitychartdaily" : "chartdaily");
        customchart.clearData();
        Map<String, Object> result = this.getChartDailyData(dateMap, isQuality, monthlyPattern);
        Number[] expireData = (Integer[])result.get(expireNum);
        Number[] normalData = (Integer[])result.get(normalNum);
        int max = this.getDataMax((Integer[])expireData, (Integer[])normalData);
        Map<String, Integer> scaleMap = this.calculationYMax(max);
        this.setXaxisTick(customchart, dateMap);
        Axis taskNumberAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u5f20\u6570", (String)"TaskSalesIndexPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), AxisType.value);
        taskNumberAxis.setInterval((Number)scaleMap.get("interval"));
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        taskNumberAxis.setPropValue("axisTick", axisTick);
        taskNumberAxis.setMax((Number)scaleMap.get("max"));
        this.setLineColor(taskNumberAxis, "#666666");
        taskNumberAxis.setPropValue("axisLine", axisTick);
        Axis proportionAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u6bd4\u4f8b(%)", (String)"TaskSalesIndexPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]), AxisType.value);
        proportionAxis.setInterval((Number)20);
        proportionAxis.setMax((Number)100);
        proportionAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(proportionAxis, "#666666");
        proportionAxis.setPropValue("axisLine", axisTick);
        String stack = ResManager.loadKDString((String)"\u603b\u91cf", (String)"TaskSalesIndexPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        BarSeries expireSeries = customchart.createBarSeries(ResManager.loadKDString((String)"\u8d85\u671f", (String)"TaskSalesIndexPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        expireSeries.setBarWidth("20%");
        expireSeries.setStack(stack);
        expireSeries.setColor("#E1453E");
        expireSeries.setData(expireData);
        BarSeries normalSeries = customchart.createBarSeries(ResManager.loadKDString((String)"\u672a\u8d85\u671f", (String)"TaskSalesIndexPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        normalSeries.setBarWidth("20%");
        normalSeries.setStack(stack);
        normalSeries.setColor("#6282F2");
        normalSeries.setData(normalData);
        LineSeries expireProportion = customchart.createLineSeries(ResManager.loadKDString((String)"\u8d85\u671f\u5360\u6bd4", (String)"TaskSalesIndexPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        expireProportion.setYAxisIndex(1);
        expireProportion.setColor("#FC8055");
        expireProportion.setAreaColor(null);
        Number[] expireProportionData = (Float[])result.get("proportion");
        expireProportion.setData(expireProportionData);
        customchart.setShowTooltip(true);
        customchart.setMargin(Position.right, "20px");
        customchart.bindData(null);
    }

    private Map<String, Object> getChartDailyData(Map<String, Object> dateMap, boolean isQuality, String dailyPattern) {
        Long userid = Long.valueOf(RequestContext.get().getUserId());
        HashMap<String, Object> dailyData = new HashMap<String, Object>();
        Long sscId = this.getSSCId(false, userid);
        DataSet taskNumDaily = TaskIndexDataUtil.getTaskNumDaily(dateMap, userid, sscId, isQuality);
        if (taskNumDaily == null) {
            return dailyData;
        }
        Iterator it = taskNumDaily.iterator();
        HashMap calssfyMap = new HashMap();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            HashMap<String, Integer> temp = new HashMap<String, Integer>();
            temp.put(expireNum, row.getInteger("expirenum"));
            temp.put(normalNum, row.getInteger("normalnum"));
            calssfyMap.put(row.getDate("date"), temp);
        }
        taskNumDaily.close();
        List dateCategory = (List)dateMap.get("xtitle");
        Object[] expireNumbers = new Integer[dateCategory.size()];
        Object[] normalNumbers = new Integer[dateCategory.size()];
        Object[] expireProportion = new Float[dateCategory.size()];
        if (!calssfyMap.isEmpty()) {
            Map temp = null;
            Set calssfySet = calssfyMap.entrySet();
            for (Map.Entry calssfy : calssfySet) {
                temp = (Map)calssfy.getValue();
                String element = DateUtil.format(calssfy.getKey(), (String)dailyPattern);
                int index = dateCategory.indexOf(element);
                if (index <= -1) continue;
                expireNumbers[index] = temp.get(expireNum) == null ? Integer.valueOf(0) : (Integer)temp.get(expireNum);
                normalNumbers[index] = temp.get(normalNum) == null ? Integer.valueOf(0) : (Integer)temp.get(normalNum);
                BigDecimal expire = new BigDecimal((Integer)expireNumbers[index]);
                BigDecimal sum = expire.add(new BigDecimal((Integer)normalNumbers[index]));
                expireProportion[index] = Float.valueOf(sum.compareTo(BigDecimal.ZERO) == 0 ? 0.0f : expire.divide(sum, 4, 4).multiply(BigDecimal.valueOf(100L)).floatValue());
            }
        }
        dailyData.put(expireNum, this.castnulltoZero(expireNumbers, true));
        dailyData.put(normalNum, this.castnulltoZero(normalNumbers, true));
        dailyData.put("proportion", this.castnulltoZero(expireProportion, false));
        return dailyData;
    }

    private Map<String, Object> getDefaultDate(String dailyPattern) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> xAisTitle = new ArrayList<String>();
        Date nowDate = new Date();
        Date intervalDate = null;
        for (int i = -6; i < 0; ++i) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.add(6, i);
            intervalDate = calendar.getTime();
            xAisTitle.add(DateUtil.format((Object)intervalDate, (String)dailyPattern));
            if (i != -6) continue;
            map.put("startDate", intervalDate);
        }
        xAisTitle.add(DateUtil.format((Object)nowDate, (String)dailyPattern));
        map.put("xtitle", xAisTitle);
        map.put("endDate", nowDate);
        return map;
    }

    private Map<String, Object> getMonthDate(String monthlyPattern) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Date startDate = this.getYearStartTime();
            Date endDate = this.getTodayEndTime();
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            int month = Calendar.getInstance().get(2);
            ArrayList<String> xAisTitle = new ArrayList<String>(10);
            for (int i = 1; i <= month + 1; ++i) {
                xAisTitle.add(LocalDate.of(Calendar.getInstance().get(1), i, 1).format(DateTimeFormatter.ofPattern(monthlyPattern)));
            }
            map.put("xtitle", xAisTitle);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return map;
    }

    private Date getYearStartTime() {
        Calendar today = Calendar.getInstance();
        today.set(2, 0);
        today.set(5, 1);
        today.set(10, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        return today.getTime();
    }

    private Date getTodayEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(10, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    private Map<String, Object> processDate(Date startDate, Date endDate, String dailyPattern) throws Exception {
        if (startDate == null || endDate == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date nowDate = this.getDateForm(new Date(), true);
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(nowDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        ArrayList<String> xaissList = new ArrayList<String>();
        if (startCalendar.after(nowCalendar)) {
            return null;
        }
        if (nowCalendar.before(endCalendar)) {
            map.put("startDate", this.getDateForm(startCalendar.getTime(), true));
            this.processXAiss(xaissList, startCalendar, nowCalendar, dailyPattern);
            map.put("endDate", this.getDateForm(nowCalendar.getTime(), false));
        } else {
            map.put("startDate", this.getDateForm(startCalendar.getTime(), true));
            this.processXAiss(xaissList, startCalendar, endCalendar, dailyPattern);
            map.put("endDate", this.getDateForm(endCalendar.getTime(), false));
        }
        map.put("xtitle", xaissList);
        return map;
    }

    private void processXAiss(List<String> titles, Calendar startCalendar, Calendar endCalendar, String dailyPattern) {
        while (startCalendar.before(endCalendar)) {
            String xtitle = DateUtil.format((Object)startCalendar.getTime(), (String)dailyPattern);
            titles.add(xtitle);
            startCalendar.add(6, 1);
        }
        String endtitle = DateUtil.format((Object)endCalendar.getTime(), (String)dailyPattern);
        titles.add(endtitle);
    }

    private void updateMyNeedDealtNew(long userid) {
        Long sscId = this.getSSCId(false, userid);
        Map<String, Long> dataMap = TaskIndexDataUtil.getSaleIndexData(userid, sscId);
        HashMap<String, Integer> stayDealt = new HashMap<String, Integer>();
        Long myprocess = 0L;
        Long normal = 0L;
        Long pause = 0L;
        Long rescan = 0L;
        Long expirestate = 0L;
        Long complet = 0L;
        myprocess = dataMap.get("sale_myprocess");
        if (myprocess == null) {
            myprocess = 0L;
        }
        if ((normal = dataMap.get("sale_normal")) == null) {
            normal = 0L;
        }
        if ((pause = dataMap.get("sale_pause")) == null) {
            pause = 0L;
        }
        if ((rescan = dataMap.get("sale_rescan")) == null) {
            rescan = 0L;
        }
        if ((expirestate = dataMap.get("sale_expirestate")) == null) {
            expirestate = 0L;
        }
        if ((complet = dataMap.get("sale_complet")) == null) {
            complet = 0L;
        }
        Long pendinghandle = 0L;
        Long pendingreform = 0L;
        Long pendingrecheck = 0L;
        Long overduequality = 0L;
        Long completedquality = 0L;
        Long pending = 0L;
        Long quamyprocess = 0L;
        quamyprocess = dataMap.get("sale_quamyprocess");
        if (quamyprocess == null) {
            quamyprocess = 0L;
        }
        if ((pendinghandle = dataMap.get("sale_pendinghandle")) == null) {
            pendinghandle = 0L;
        }
        if ((pending = dataMap.get("sale_pending")) == null) {
            pending = 0L;
        }
        if ((pendingreform = dataMap.get("sale_pendingreform")) == null) {
            pendingreform = 0L;
        }
        if ((pendingrecheck = dataMap.get("sale_pendingrecheck")) == null) {
            pendingrecheck = 0L;
        }
        if ((overduequality = dataMap.get("sale_overduequality")) == null) {
            overduequality = 0L;
        }
        if ((completedquality = dataMap.get("sale_completedquality")) == null) {
            completedquality = 0L;
        }
        stayDealt.put("quamyprocess", quamyprocess.intValue());
        stayDealt.put("myprocess", myprocess.intValue());
        stayDealt.put("normal", normal.intValue());
        stayDealt.put("pause", pause.intValue());
        stayDealt.put("rescan", rescan.intValue());
        stayDealt.put("expirestate", expirestate.intValue());
        stayDealt.put("complet", complet.intValue());
        stayDealt.put("pendinghandle", pendinghandle.intValue());
        stayDealt.put("pendingreform", pendingreform.intValue());
        stayDealt.put("pendingrecheck", pendingrecheck.intValue());
        stayDealt.put("overduequality", overduequality.intValue());
        stayDealt.put("completedquality", completedquality.intValue());
        stayDealt.put("pending", pending.intValue());
        this.createCardState(stayDealt);
    }

    private void createCardState(Map<String, Integer> stayDealt) {
        ((Label)this.getControl("normal")).setText(stayDealt.get("normal").toString());
        ((Label)this.getControl("pause")).setText(stayDealt.get("pause").toString());
        ((Label)this.getControl("expirestate")).setText(stayDealt.get("expirestate").toString());
        ((Label)this.getControl("rescan")).setText(stayDealt.get("rescan").toString());
        ((Label)this.getControl("complet")).setText(stayDealt.get("complet").toString());
        ((Label)this.getControl("myprocess")).setText(stayDealt.get("myprocess").toString());
        ((Label)this.getControl("pendinghandle")).setText(stayDealt.get("pendinghandle").toString());
        ((Label)this.getControl("pendingreform")).setText(stayDealt.get("pendingreform").toString());
        ((Label)this.getControl("pendingrecheck")).setText(stayDealt.get("pendingrecheck").toString());
        ((Label)this.getControl("overduequality")).setText(stayDealt.get("overduequality").toString());
        ((Label)this.getControl("completedquality")).setText(stayDealt.get("completedquality").toString());
        ((Label)this.getControl("pending")).setText(stayDealt.get("pending").toString());
        ((Label)this.getControl("quamyprocess")).setText(stayDealt.get("quamyprocess").toString());
    }

    private void updateRanking(long userid) {
        ((Label)this.getControl("curusercount")).setText("0");
        ((Label)this.getControl("curusertop")).setText("");
        ((Label)this.getControl("curfabulousnum")).setText("0");
        for (int i = 1; i <= 5; ++i) {
            ((Image)this.getControl("ranktopimg" + i)).setUrl(COMMON_URL);
            ((Label)this.getControl("ranktopcount" + i)).setText("0");
            ((Label)this.getControl("ranktopname" + i)).setText(ResManager.loadKDString((String)"\u7528\u6237", (String)"TaskSalesIndexPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            ((Label)this.getControl("ranktopfabulousnum" + i)).setText("0");
        }
        ORM orm = ORM.create();
        Long sscId = this.getSSCId(false, userid);
        QFilter sscFilter = new QFilter("sscid", "=", (Object)sscId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(sscFilter);
        DataSet ranking = null;
        DataSet rankingOfQuality = null;
        ranking = TaskIndexDataUtil.getSaleIndexRankData(filters, false);
        rankingOfQuality = TaskIndexDataUtil.getSaleIndexRankData(filters, true);
        this.renderRankingInfo(ranking, userid, false, orm);
        this.renderRankingInfo(rankingOfQuality, userid, true, orm);
    }

    private void renderRankingInfo(DataSet ranking, long userid, boolean isQuality, ORM orm) {
        Iterator it = ranking.iterator();
        HashMap<Long, Map<String, Object>> rankMap = new HashMap<Long, Map<String, Object>>();
        HashSet<Long> userIdSet = new HashSet<Long>();
        HashMap<String, Object> currentUser = null;
        int len = 1;
        Row row2 = null;
        while (it.hasNext()) {
            row2 = (Row)it.next();
            long scpuserid = row2.getLong("personid");
            if (scpuserid == userid) {
                currentUser = new HashMap<String, Object>();
                currentUser.put("userid", scpuserid);
                currentUser.put("taskcount", row2.getLong("count"));
                currentUser.put("topn", len);
                userIdSet.add(userid);
            }
            if (len < 6) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("userid", scpuserid);
                temp.put("taskcount", row2.get("count"));
                temp.put("topn", len);
                userIdSet.add(row2.getLong("personid"));
                rankMap.put(scpuserid, temp);
            }
            if (currentUser != null && len > 5) break;
            ++len;
        }
        ranking.close();
        if (!userIdSet.isEmpty()) {
            DataSet userDataSet = orm.queryDataSet("ssc.task.tasksalesindex.rankuser", "bos_user", "id,name,picturefield", new QFilter[]{new QFilter("id", "in", userIdSet)});
            for (Row row2 : userDataSet) {
                long scpuserid = row2.getLong("id");
                Map temp = (Map)rankMap.get(scpuserid);
                if (temp != null) {
                    temp.put("name", row2.get("name"));
                    temp.put("picturefield", row2.get("picturefield"));
                }
                if (currentUser == null || scpuserid != (Long)currentUser.get("userid")) continue;
                if (row2.get("picturefield") == null) {
                    log.info("picturefield is null-----------");
                } else {
                    log.info("picturefield is not null correct ----------");
                }
                currentUser.put("name", row2.get("name"));
                currentUser.put("picturefield", row2.get("picturefield"));
            }
            userDataSet.close();
        }
        this.setranking(rankMap, isQuality);
        this.setCurrentUser(currentUser, isQuality);
        this.setRankingAndCurFabulous(rankMap, isQuality);
    }

    private void setCurrentUser(Map<String, Object> currentUser, boolean isQuality) {
        String img;
        String name = isQuality ? "quacurusername" : "curusername";
        String top = isQuality ? "quacurusertop" : "curusertop";
        String count = isQuality ? "quacurusercount" : "curusercount";
        String string = img = isQuality ? "quacuruserimg" : "curuserimg";
        if (currentUser == null || currentUser.isEmpty()) {
            long userid = Long.parseLong(RequestContext.get().getUserId());
            DynamicObject user = ORM.create().getById("bos_user", (Object)userid);
            Map userAvatarPath = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userid), (boolean)true);
            if (StringUtils.isNotEmpty((String)((String)userAvatarPath.get(userid)))) {
                ((Image)this.getControl(img)).setUrl((String)userAvatarPath.get(userid));
            } else {
                ((Image)this.getControl(img)).setUrl(COMMON_URL);
            }
            if (user.get("name").toString() != null) {
                ((Label)this.getControl(name)).setText(user.get("name").toString());
            }
            return;
        }
        if (currentUser.get("userid") != null) {
            Map userAvatarPath = UserServiceHelper.getUserAvatarPath(Collections.singletonList(Long.parseLong(currentUser.get("userid").toString())), (boolean)true);
            if (StringUtils.isNotEmpty((String)((String)userAvatarPath.get(currentUser.get("userid"))))) {
                ((Image)this.getControl(img)).setUrl((String)userAvatarPath.get(currentUser.get("userid")));
            } else {
                ((Image)this.getControl(img)).setUrl(COMMON_URL);
            }
        }
        if (currentUser.get("topn") != null) {
            ((Label)this.getControl(top)).setText(String.format(ResManager.loadKDString((String)"\u7b2c%s\u540d", (String)"TaskSalesIndexPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]), currentUser.get("topn").toString()));
        }
        if (currentUser.get("taskcount") != null) {
            ((Label)this.getControl(count)).setText(currentUser.get("taskcount").toString());
        }
        if (currentUser.get("name") != null) {
            ((Label)this.getControl(name)).setText(currentUser.get("name").toString());
        }
    }

    private void setranking(Map<Long, Map<String, Object>> rankMap, boolean isQuality) {
        Set<Map.Entry<Long, Map<String, Object>>> rankSet = rankMap.entrySet();
        for (Map.Entry<Long, Map<String, Object>> rank : rankSet) {
            Map userAvatarPath;
            Map<String, Object> rankUser = rank.getValue();
            int topn = (Integer)rankUser.get("topn");
            if (isQuality) {
                userAvatarPath = UserServiceHelper.getUserAvatarPath(Collections.singletonList(rank.getKey()), (boolean)true);
                if (StringUtils.isNotEmpty((String)((String)userAvatarPath.get(rank.getKey())))) {
                    ((Image)this.getControl("qualityranktopimg" + topn)).setUrl((String)userAvatarPath.get(rank.getKey()));
                } else {
                    ((Image)this.getControl("qualityranktopimg" + topn)).setUrl(COMMON_URL);
                }
                ((Label)this.getControl("qualityranktopcount" + topn)).setText(String.valueOf(rankUser.get("taskcount")));
                ((Label)this.getControl("qualityranktopname" + topn)).setText((String)rankUser.get("name"));
                continue;
            }
            userAvatarPath = UserServiceHelper.getUserAvatarPath(Collections.singletonList(rank.getKey()), (boolean)true);
            if (StringUtils.isNotEmpty((String)((String)userAvatarPath.get(rank.getKey())))) {
                ((Image)this.getControl("ranktopimg" + topn)).setUrl((String)userAvatarPath.get(rank.getKey()));
            } else {
                ((Image)this.getControl("ranktopimg" + topn)).setUrl(COMMON_URL);
            }
            ((Label)this.getControl("ranktopcount" + topn)).setText(String.valueOf(rankUser.get("taskcount")));
            ((Label)this.getControl("ranktopname" + topn)).setText((String)rankUser.get("name"));
        }
        this.cacheRankingUserId(rankMap, isQuality);
    }

    private Date getDateForm(Date date, boolean isStart) throws Exception {
        String dateStr = DateUtil.format((Object)date, (String)"yyyy-MM-dd");
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        String result = dateStr + suffix;
        Pattern p = Pattern.compile("\\d{4}(-\\d{2}){2}\\s\\d{2}(:\\d{2}){2}");
        Matcher m = p.matcher(result);
        boolean b = m.matches();
        if (b) {
            log.info("getDateForm date is " + date);
            log.info("getDateForm dateStr is " + dateStr);
            log.info("getDateForm result is " + result);
            return DateUtil.parse((String)result, (String)"yyyy-MM-dd HH:mm:ss");
        }
        throw new Exception("getDateForm is error TaskSalesIndexPlugin ----------" + result);
    }

    private Date getMonthFirstDate(Date nowDate) throws Exception {
        SimpleDateFormat monthformat = new SimpleDateFormat("yyyy-MM");
        String dateStr = monthformat.format(nowDate);
        return DateUtil.parse((String)(dateStr + "-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
    }

    private Object[] castnulltoZero(Object[] arrays, boolean isInt) {
        for (int i = 0; i < arrays.length; ++i) {
            if (arrays[i] != null) continue;
            arrays[i] = isInt ? (Number)0 : (Number)Float.valueOf(0.0f);
        }
        return arrays;
    }

    private Set<Long> getTaskNumber(String queryKey, QFilter[] qfilters, boolean pooltype, boolean isQuality) {
        String entityType = pooltype ? entityName : completentityName;
        DataSet expirestatenotrescan = ORM.create().queryDataSet(queryKey, entityType, "id", qfilters);
        Iterator it = expirestatenotrescan.iterator();
        HashSet<Long> set = new HashSet<Long>();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            set.add(row.getLong("id"));
        }
        expirestatenotrescan.close();
        return set;
    }

    private Map<String, Integer> calculationYMax(int max) {
        int model = 5;
        float factor = 0.7f;
        max = BigDecimal.valueOf(max).divide(BigDecimal.valueOf(factor), 5, 1).intValue();
        int cd = 1;
        if (max > 5) {
            int interval = max / model;
            int Surplus = interval % model;
            int lack = model - Surplus;
            cd = interval + lack;
            max = cd * model;
        } else {
            int Surplus = max % model;
            int lack = model - Surplus;
            cd = (max += lack) / model;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("interval", cd);
        map.put("max", max);
        return map;
    }

    private int getDataMax(Integer[] data1, Integer[] data2) {
        if (data1.length == data2.length) {
            int sum = 0;
            for (int i = 0; i < data1.length; ++i) {
                int temp = Integer.sum(data1[i], data2[i]);
                if (temp <= sum) continue;
                sum = temp;
            }
            return sum;
        }
        return 0;
    }

    public void onProgress(ProgressEvent arg0) {
        if (!"true".equals(this.getPageCache().get(AFTERCREATENEWDATA_TAG))) {
            return;
        }
        int value = 12;
        long userid = Long.parseLong(RequestContext.get().getUserId());
        String dateFormat = InteServiceHelper.getDateFormat((Long)userid);
        String monthlyPattern = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(monthlyPatternRegex, "") : defaultMonthlyPattern;
        String dailyPattern = StringUtils.isNotEmpty((String)dateFormat) ? dateFormat.replaceAll(dailyPatternRegex, "") : defaultDailyPattern;
        Control control = this.getControl("ranktopimg5");
        Control quacontrol = this.getControl("qualityranktopimg5");
        if (userid > 0L && null != control && quacontrol != null) {
            this.updateMyNeedDealtNew(userid);
            this.updateRanking(userid);
            try {
                Date startDate = (Date)this.getModel().getValue("daterangedaily_startdate");
                Date endDate = (Date)this.getModel().getValue("daterangedaily_enddate");
                Date quaStartDate = (Date)this.getModel().getValue("quadaterangedaily_startdate");
                Date quaEndDate = (Date)this.getModel().getValue("quadaterangedaily_enddate");
                Map<String, Object> dateMap = this.processDate(startDate, endDate, dailyPattern);
                Map<String, Object> quaDateMap = this.processDate(quaStartDate, quaEndDate, dailyPattern);
                this.updateChartDaily(dateMap, false, dailyPattern);
                this.updateChartDaily(quaDateMap, true, dailyPattern);
                boolean isAvgDay = ((Tab)this.getControl("tabap")).getCurrentTab().equals("avgday");
                boolean isQualityAvgDay = ((Tab)this.getControl("tabap2")).getCurrentTab().equals("qualityavgday");
                if (isAvgDay) {
                    startDate = (Date)this.getModel().getValue("daterangenum_startdate");
                    endDate = (Date)this.getModel().getValue("daterangenum_enddate");
                    dateMap = this.processDate(startDate, endDate, dailyPattern);
                } else {
                    dateMap = this.getMonthDate(monthlyPattern);
                }
                this.updateChartTasks(dateMap, isAvgDay, false);
                if (isQualityAvgDay) {
                    quaStartDate = (Date)this.getModel().getValue("quadaterangenum_startdate");
                    quaEndDate = (Date)this.getModel().getValue("quadaterangenum_enddate");
                    quaDateMap = this.processDate(quaStartDate, quaEndDate, dailyPattern);
                } else {
                    quaDateMap = this.getMonthDate(monthlyPattern);
                }
                this.updateChartTasks(quaDateMap, isQualityAvgDay, true);
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.fulltextException, new Object[]{e});
            }
        }
        arg0.setProgress(value);
    }

    private void cacheRankingUserId(Map<Long, Map<String, Object>> rankMap, boolean isQuality) {
        IPageCache pageCache = this.getPageCache();
        for (Map.Entry<Long, Map<String, Object>> entry : rankMap.entrySet()) {
            Long mapKey = entry.getKey();
            Map<String, Object> rankUser = entry.getValue();
            int topn = (Integer)rankUser.get("topn");
            String key = isQuality ? "quaranktopfabulous" + topn : "ranktopfabulous" + topn;
            pageCache.put(key, mapKey == null ? null : mapKey.toString());
        }
    }

    private Map<Long, Integer> getFabulous(List<Long> tagetUserID, boolean isTodyDay, boolean isAll, boolean isQuality) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        QFilter tagetUserFilter = new QFilter("bythumbupuser", "in", tagetUserID);
        QFilter typepropFilter = new QFilter("taskproperty", "=", (Object)(isQuality ? TaskPropertyEnum.QUACHECKTASK.getValue() : TaskPropertyEnum.APPROVETASK.getValue()));
        qfilters.add(tagetUserFilter);
        qfilters.add(typepropFilter);
        if (isTodyDay) {
            try {
                qfilters.add(new QFilter("date", "=", (Object)this.getDateForm(new Date(), true)));
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
            }
        }
        if (!isAll) {
            Long userid = Long.valueOf(RequestContext.get().getUserId());
            qfilters.add(new QFilter("thumbupuser", "=", (Object)userid));
        }
        DataSet dataSet = ORM.create().queryDataSet("ssc.TaskSalesIndexPlugin.getFabulous", "task_fabulous", "id,bythumbupuser", qfilters.toArray(new QFilter[0]));
        GroupbyDataSet groupByDataSet = dataSet.groupBy(new String[]{"bythumbupuser"});
        groupByDataSet.count();
        DataSet result = groupByDataSet.finish();
        Iterator iterator = result.iterator();
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            map.put(row.getLong("bythumbupuser"), row.getInteger("count"));
        }
        return map;
    }

    private int getFabulousOne(String targetUserId, boolean isTodyDay, boolean isAll, boolean isQuality) {
        ArrayList<Long> idList = new ArrayList<Long>();
        Long id = Long.valueOf(targetUserId);
        idList.add(id);
        Map<Long, Integer> map = this.getFabulous(idList, isTodyDay, isAll, isQuality);
        return map.get(id) == null ? 0 : map.get(id);
    }

    private boolean isThumbUp(String targetUserId, boolean isQuality) {
        return this.getFabulousOne(targetUserId, true, false, isQuality) < 1;
    }

    private boolean isCanThumbUp(String key, boolean isQuality) {
        String targetUserId = this.getPageCache().get(key);
        String currUserid = RequestContext.get().getUserId();
        return StringUtils.isEmpty((String)targetUserId) || targetUserId.equals(currUserid) ? false : this.isThumbUp(targetUserId, isQuality);
    }

    private void setRankingAndCurFabulous(Map<Long, Map<String, Object>> rankMap, boolean isQuality) {
        Long userid = Long.valueOf(RequestContext.get().getUserId());
        ArrayList<Long> idList = new ArrayList<Long>(rankMap.keySet());
        Map<Long, Integer> thumbUpMap = this.getFabulous(idList, true, false, isQuality);
        idList.add(userid);
        Map<Long, Integer> allFabulousMap = this.getFabulous(idList, false, true, isQuality);
        String url = UrlService.getImageFullUrl((String)"/icons/pc/state/praised.png");
        for (Map.Entry<Long, Integer> entry : allFabulousMap.entrySet()) {
            Map<String, Object> rank;
            Long key = entry.getKey();
            if (userid.equals(key)) {
                ((Label)this.getControl(isQuality ? "qualitycurfabulousnum" : "curfabulousnum")).setText(allFabulousMap.get(key) + "");
            }
            if ((rank = rankMap.get(key)) == null) continue;
            int topn = (Integer)rank.get("topn");
            ((Label)this.getControl(isQuality ? "qualitranktopfabulousnum" + topn : "ranktopfabulousnum" + topn)).setText(allFabulousMap.get(key) + "");
            Integer thumbUpMapKey = thumbUpMap.get(key);
            if ((thumbUpMapKey == null || thumbUpMapKey <= 0) && !userid.equals(key)) continue;
            ((Image)this.getControl(isQuality ? "quaranktopfabulous" + topn : "ranktopfabulous" + topn)).setUrl(url);
        }
    }

    private void createFabulous(String key, boolean isQuality) {
        ORM orm = ORM.create();
        DynamicObject fabulous = orm.newDynamicObject("task_fabulous");
        Long userid = Long.valueOf(RequestContext.get().getUserId());
        String targetUserId = this.getPageCache().get(key);
        fabulous.set("bythumbupuser", (Object)Long.valueOf(targetUserId));
        fabulous.set("thumbupuser", (Object)userid);
        fabulous.set("taskproperty", (Object)(isQuality ? TaskPropertyEnum.QUACHECKTASK.getValue() : TaskPropertyEnum.APPROVETASK.getValue()));
        try {
            fabulous.set("date", (Object)this.getDateForm(new Date(), true));
        }
        catch (Exception e1) {
            throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
        }
        BusinessDataWriter.save((IDataEntityType)orm.getDataEntityType("task_fabulous"), (Object[])new Object[]{fabulous});
    }

    private Long getSSCId(boolean userFirst, Long userId) {
        if (userFirst) {
            return this.getUserFirstSSCId(userId);
        }
        return Long.parseLong(this.getCurrentOrgId());
    }

    private Long getUserFirstSSCId(Long userId) {
        boolean isScc;
        String user = String.valueOf(userId);
        String cacheSSCId = this.getPageCache().get(user);
        if (StringUtils.isNotEmpty((String)cacheSSCId)) {
            return Long.valueOf(cacheSSCId);
        }
        Long sscid = 0L;
        String appId = "ssc";
        String entityName = "task_task";
        sscid = RequestContext.get().getOrgId();
        int checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscid, (String)"12", (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (checkPermission == 1 && (isScc = OrgUnitServiceHelper.checkOrgFunction((Long)sscid, (String)"12"))) {
            this.getPageCache().put(user, String.valueOf(sscid));
            return sscid;
        }
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"12", (String)appId, (String)entityName, (String)"47150e89000000ac");
        boolean isHasAllOrgPerm = allPermOrgs.hasAllOrgPerm();
        if (isHasAllOrgPerm) {
            QFilter f1 = new QFilter("view.number", "=", (Object)"12");
            QFilter f3 = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
            DynamicObject bosorgItem = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f1, f3});
            if (bosorgItem != null) {
                sscid = bosorgItem.getLong("org");
            }
        } else {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            List sscOrgList = OrgUnitServiceHelper.filterOrgDuty((List)hasPermOrgs, (String)"12");
            if (sscOrgList != null && sscOrgList.size() > 0) {
                sscOrgList.sort(Long::compareTo);
                sscid = (Long)sscOrgList.get(0);
            }
        }
        if (sscid != null) {
            this.getPageCache().put(user, String.valueOf(sscid));
        }
        return sscid;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_salesindex", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"TaskSalesIndexPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

