/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.task.common.DisRuleDataSyncHelper;
import kd.ssc.task.formplugin.imports.TaskImportHelper;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;

public class UserGroupFormPlugin
extends AbstractBillPlugIn
implements ClickListener {
    private static final Log log = LogFactory.getLog(UserGroupFormPlugin.class);
    private static final String ISROBOTS = "isrobots";
    private static final String REDISTRIBUTION = "redistributionnew";
    private static final String CURTASKNUM = "curtasknum";
    private static final String TASKALLNUM = "taskallnum";
    private static final String CURTASKNUM_E = "curtasknum_e";
    private static final String TASKALLNUM_E = "taskallnum_e";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        int rowCount = model.getEntryRowCount("entryentity");
        if (rowCount > 0) {
            model.setValue("teamleader", (Object)Boolean.TRUE, 0);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
        IDataModel model = this.getModel();
        boolean isRobot = (Boolean)model.getValue(ISROBOTS);
        view.setVisible(Boolean.valueOf(isRobot), new String[]{REDISTRIBUTION});
        OperationStatus opStatus = view.getFormShowParameter().getStatus();
        DynamicObject ssccenter = (DynamicObject)model.getValue("orgfield");
        if (ssccenter == null) {
            return;
        }
        if (OperationStatus.EDIT.equals((Object)opStatus)) {
            view.setEnable(Boolean.FALSE, new String[]{"orgfield", ISROBOTS, "number"});
            if (isRobot) {
                view.setVisible(Boolean.FALSE, new String[]{"workloadpanel", "ability", CURTASKNUM_E, TASKALLNUM_E});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        IDataModel model = this.getModel();
        if (source instanceof Save) {
            Object createOrg = model.getValue("createorg");
            model.setValue("orgfield", createOrg);
            this.invalid(args);
        }
    }

    private void invalid(BeforeDoOperationEventArgs evt) {
        IDataModel model = this.getModel();
        DynamicObject createOrg = (DynamicObject)model.getValue("createorg");
        int abortCount = 0;
        int rowCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            if (model.getValue("userfield", i) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7528\u6237\u3002", (String)"UserGroupFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            if (((Boolean)model.getValue("usestatus", i)).booleanValue()) continue;
            ++abortCount;
        }
        if (rowCount == 0 || rowCount > 0 && abortCount == rowCount) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u542f\u7528\u4e00\u540d\u7528\u6237\u7ec4\u6210\u5458\u3002", (String)"UserGroupFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess;
        super.afterDoOperation(e);
        IDataModel model = this.getModel();
        if (e.getSource() instanceof Save && (isSuccess = e.getOperationResult().isSuccess())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ISROBOTS, "number"});
            List IDs = e.getOperationResult().getSuccessPkIds();
            this.checkAndKeepDataDync(IDs);
            this.synchroData((DynamicObject)model.getValue("createorg"), IDs);
            List pkids = e.getOperationResult().getSuccessPkIds();
            if (pkids != null && !pkids.isEmpty()) {
                Long pkid = (Long)pkids.get(0);
                this.updateGroupEntry(pkid);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIdx = changeData[0].getRowIndex();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (ISROBOTS.equals(propName)) {
            this.isRobotsChanged(view, model, newValue);
        } else if ("ability".equals(propName)) {
            this.abilityChanged(view, model, newValue, rowIdx);
        } else if (CURTASKNUM.equals(propName) || TASKALLNUM.equals(propName)) {
            this.taskNumChanged(view, model, newValue, propName);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String name = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if ("entryentity".equals(name)) {
            RowDataEntity[] rowEntities = e.getRowDataEntities();
            int curTaskNum = (Integer)model.getValue(CURTASKNUM);
            int taskAllNum = (Integer)model.getValue(TASKALLNUM);
            int len = rowEntities.length;
            for (int i = 0; i < len; ++i) {
                int rowIdx = rowEntities[i].getRowIndex();
                BigDecimal ability = (BigDecimal)model.getValue("ability", rowIdx);
                model.setValue(CURTASKNUM_E, (Object)ability.multiply(BigDecimal.valueOf(curTaskNum)).intValue(), rowIdx);
                model.setValue(TASKALLNUM_E, (Object)ability.multiply(BigDecimal.valueOf(taskAllNum)).intValue(), rowIdx);
                if (rowIdx != 0) continue;
                model.setValue("teamleader", (Object)Boolean.TRUE, 0);
            }
        }
    }

    private void checkAndKeepDataDync(List<Object> userGroupIDs) {
        if (CollectionUtils.isEmpty(userGroupIDs)) {
            return;
        }
        Long userGroupId = (Long)userGroupIDs.get(0);
        String entityName = "task_disrule";
        String selectProperties = "id,number,name,ssccenter,priority,tasktype,entryentity.billtype,entryentity.filterrule,entryentity.filterrulejson_tag,entryentity.applycreditleveljoson_tag,entryentity1.usergroup,entryentity1.orgrange";
        QFilter userGroupFilter = new QFilter("entryentity1.usergroup", "=", (Object)userGroupId);
        DynamicObject[] disRuleDos = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{userGroupFilter});
        DisRuleDataSyncHelper disRuleDataSyncHelper = new DisRuleDataSyncHelper();
        if (disRuleDos != null) {
            for (DynamicObject disRuleDo : disRuleDos) {
                disRuleDataSyncHelper.keepDataSyncByGroup(disRuleDo, userGroupId);
            }
        }
    }

    private void isRobotsChanged(IFormView view, IDataModel model, Object newValue) {
        Boolean isRobots = (Boolean)newValue;
        view.setVisible(isRobots, new String[]{REDISTRIBUTION});
        view.setVisible(Boolean.valueOf(isRobots == false), new String[]{"workloadpanel", "ability", CURTASKNUM_E, TASKALLNUM_E});
    }

    private void abilityChanged(IFormView view, IDataModel model, Object newValue, int rowIdx) {
        if (newValue != null) {
            BigDecimal ability = (BigDecimal)newValue;
            int curTaskNum = (Integer)model.getValue(CURTASKNUM);
            int taskAllNum = (Integer)model.getValue(TASKALLNUM);
            model.setValue(CURTASKNUM_E, (Object)ability.multiply(BigDecimal.valueOf(curTaskNum)).intValue());
            model.setValue(TASKALLNUM_E, (Object)ability.multiply(BigDecimal.valueOf(taskAllNum)).intValue());
        }
    }

    private void taskNumChanged(IFormView view, IDataModel model, Object newValue, String propName) {
        int newVal = (Integer)newValue;
        int rowCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal ability = (BigDecimal)model.getValue("ability", i);
            String propName_ = null;
            if (CURTASKNUM.equals(propName)) {
                propName_ = CURTASKNUM_E;
            } else if (TASKALLNUM.equals(propName)) {
                propName_ = TASKALLNUM_E;
            }
            if (!StringUtils.isNotEmpty((String)propName_)) continue;
            model.setValue(propName_, (Object)ability.multiply(BigDecimal.valueOf(newVal)), i);
        }
    }

    private void synchroData(DynamicObject ssc, List<Object> IDs) {
        List<Long> userIds = SscWorkCalendarLoadService.getUserIdList(IDs.get(0) + "");
        if (!userIds.isEmpty()) {
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
                pub.publish((Object)new WorkCalendarTaskMessage(ssc.getPkValue() + "", IDs.get(0) + "", userIds, null, null, "ssc"));
            }
        }
    }

    private void updateGroupEntry(Long pkid) {
        try {
            DynamicObject groupInfo = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"task_usergroup");
            DynamicObjectCollection entrys = groupInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyo : entrys) {
                dyo.set("groupid", (Object)pkid);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{groupInfo});
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u66f4\u65b0\u5206\u5f55groupid\u5931\u8d25", (Throwable)e);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        JSONObject row = (JSONObject)e.getSourceData();
        TaskImportHelper.checkUniqueForFieldInFile((AbstractFormPlugin)this, "number", row.getString("number"), e);
        TaskImportHelper.checkUniqueForFieldInFile((AbstractFormPlugin)this, "name", row.getJSONObject("name").getString(RequestContext.get().getLang().toString()), e);
        try {
            Map sourceDataMap = e.getSourceData();
            JSONObject sourceData = new JSONObject(sourceDataMap);
            sourceData.put("orgfield", sourceData.get((Object)"createorg"));
            JSONArray userEntry = sourceData.getJSONArray("entryentity");
            Object groupId = ((BillModel)e.getSource()).getPKValue();
            Boolean isRobot = sourceData.getBoolean(ISROBOTS);
            if (isRobot.booleanValue()) {
                sourceData.remove((Object)"workperiod");
                sourceData.remove((Object)TASKALLNUM);
                sourceData.remove((Object)CURTASKNUM);
                for (Object o : userEntry) {
                    JSONObject curEntry = (JSONObject)o;
                    curEntry.put("groupid", groupId);
                    curEntry.remove((Object)"ability");
                }
            } else {
                BigDecimal curTaskNum = sourceData.getBigDecimal(CURTASKNUM) != null ? sourceData.getBigDecimal(CURTASKNUM) : new BigDecimal(10000);
                BigDecimal taskAllNum = sourceData.getBigDecimal(TASKALLNUM) != null ? sourceData.getBigDecimal(TASKALLNUM) : new BigDecimal(10000);
                for (Object o : userEntry) {
                    JSONObject curEntry = (JSONObject)o;
                    curEntry.put("groupid", groupId);
                    BigDecimal ability = curEntry.getBigDecimal("ability") != null ? curEntry.getBigDecimal("ability") : BigDecimal.ONE;
                    curEntry.put(CURTASKNUM_E, (Object)ability.multiply(curTaskNum).setScale(0, RoundingMode.FLOOR));
                    curEntry.put(TASKALLNUM_E, (Object)ability.multiply(taskAllNum).setScale(0, RoundingMode.FLOOR));
                }
            }
        }
        catch (Exception ex) {
            log.error("Fail to fill data for import row", (Throwable)ex);
        }
    }
}

