/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterScriptBuilder;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.OutSystemWorkLoadNodeChangeUtil;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.dis.BillCusFilter;
import kd.ssc.task.dis.WorkLoad;
import kd.ssc.task.dis.WorkLoadUtil;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.helper.MessageHelper;
import kd.ssc.task.helper.MutexCacheHelper;
import kd.ssc.task.util.DateUtil;
import kd.ssc.task.util.ObjectCloneUtil;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;
import kd.ssc.task.util.TaskDisUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class UserWorkLoadFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(UserWorkLoadFormPlugin.class);
    private static final String INCLUDENOPERM = "includenoperm";
    private static final String DISRULEMETA = "task_disrule";
    private static final int BATCH_COUNT = 20;
    private List<String> taskSscGlList;
    private List<String> tIDTTypeBTypeGlList;
    private List<String> taskOrgGLList;
    private boolean isExceptRebots = false;
    private Set<String> qualityPages = new HashSet<String>(Arrays.asList("task_doqualitymanagement", "task_quality_docheck"));
    private List<Long> taskIds;
    private Long curUserId = 0L;
    private Long applierOfCurTask = 0L;
    private boolean isRectification = false;
    private static final Log logger = LogFactory.getLog(UserWorkLoadFormPlugin.class);
    private static final String MINE_GROUP_LEADER = "minegroupleader";

    public void initialize() {
        this.addClickListeners(new String[]{INCLUDENOPERM, "btok"});
        this.addItemClickListeners(new String[]{INCLUDENOPERM});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
        this.curUserId = RequestContext.get().getCurrUserId();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String entryfieldchange = e.getProperty().getName();
        ChangeData[] data = e.getChangeSet();
        Object newValue = data[0].getNewValue();
        if (entryfieldchange.equals(INCLUDENOPERM)) {
            Boolean isOpen = (Boolean)newValue;
            if (isOpen.booleanValue()) {
                this.getModel().setValue(MINE_GROUP_LEADER, (Object)Boolean.FALSE);
            }
            this.queryData(Boolean.parseBoolean(this.getView().getModel().getValue(INCLUDENOPERM).toString()), false, true);
        } else if (entryfieldchange.equals(MINE_GROUP_LEADER)) {
            Boolean isOpen = (Boolean)newValue;
            if (isOpen.booleanValue()) {
                this.getModel().setValue(INCLUDENOPERM, (Object)Boolean.FALSE);
                this.queryMineGroupLeaderData(isOpen);
            } else {
                boolean isSysAdmin = true;
                String identity = (String)this.getView().getFormShowParameter().getCustomParam("identity");
                if (!"sysadmin".equals(identity)) {
                    isSysAdmin = false;
                }
                this.queryData(false, true, isSysAdmin);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btok")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u5206\u914d\u4eba\u5458\u3002", (String)"UserWorkLoadFormPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.disToUser(selectRows);
        }
    }

    private void disToUser(int[] selectRows) {
        boolean success;
        Long userID = ((DynamicObject)this.getModel().getValue("usernum", selectRows[0])).getLong("id");
        Long userGroup = ((DynamicObject)this.getModel().getValue("usergroup", selectRows[0])).getLong("id");
        if (userID <= 0L || userGroup <= 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237ID\u4e0d\u5408\u6cd5\u3002", (String)"UserWorkLoadFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (this.qualityPages.contains(parentFormId)) {
            if ("task_quality_docheck".equals(parentFormId)) {
                this.getView().returnDataToParent((Object)userID);
            } else {
                this.getView().returnDataToParent((Object)(userID + "_" + userGroup));
            }
            this.getView().close();
            return;
        }
        List taskIDs = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        if (taskIDs.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u4f20\u9012\u4efb\u52a1\u3002", (String)"UserWorkLoadFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        int taskSize = taskIDs.size();
        Boolean includeNoPermOpen = (Boolean)this.getModel().getValue(INCLUDENOPERM);
        Boolean mineGroupLeaderOpen = (Boolean)this.getModel().getValue(MINE_GROUP_LEADER);
        if (!(taskSize != 1 || includeNoPermOpen.booleanValue() || mineGroupLeaderOpen.booleanValue() || (success = this.checkApplier((Long)taskIDs.get(0), userID)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u81ea\u63d0\u81ea\u5ba1\u3002", (String)"UserWorkLoadFormPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (taskSize < 20) {
            this.disTaskWithUserId(userID, taskIDs, this.getView(), false, userGroup);
        } else {
            this.batchProcessing(userID, taskIDs, userGroup);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals("taskdis")) {
            this.queryData(false, false, true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Boolean isRectification;
        boolean isSysAdmin = true;
        String identity = (String)this.getView().getFormShowParameter().getCustomParam("identity");
        if (!"sysadmin".equals(identity)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{INCLUDENOPERM});
            isSysAdmin = false;
        }
        if (Boolean.TRUE.equals(isRectification = (Boolean)this.getView().getFormShowParameter().getCustomParam("isRectification"))) {
            this.setRectification(true);
        }
        this.showMineGroupLeader();
        this.queryData(false, true, isSysAdmin);
    }

    private void showMineGroupLeader() {
        HashSet<Long> manageGroupSet;
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        String sscId = (String)taskSscList.get(0);
        Long currUserId = RequestContext.get().getCurrUserId();
        this.getModel().setValue(MINE_GROUP_LEADER, (Object)Boolean.FALSE);
        if (TeamLeaderApi.isOpenTeamleader(String.valueOf(sscId)) && CollectionUtils.isNotEmpty(manageGroupSet = UserGroupUtil.getManageGroup(sscId, String.valueOf(currUserId)))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MINE_GROUP_LEADER});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{MINE_GROUP_LEADER});
    }

    private void queryData(boolean includenoperm, boolean isFromButton, boolean isSysAdmin) {
        List taskSscList;
        IDataModel dataModel = this.getModel();
        ArrayList<Long> errRuleDyns = new ArrayList<Long>(4);
        List<WorkerStatusPojo> gridList = this.queryGridDataByAssign(includenoperm, errRuleDyns);
        if (isFromButton && !isSysAdmin && (taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs")) != null && taskSscList.size() > 0 && gridList != null && gridList.size() > 0) {
            HashSet<Long> manageGroup = UserGroupUtil.getManageGroup((String)taskSscList.get(0), RequestContext.get().getUserId());
            Iterator<WorkerStatusPojo> iterator = gridList.iterator();
            while (iterator.hasNext()) {
                if (manageGroup.contains(iterator.next().getUserGroupId())) continue;
                iterator.remove();
            }
        }
        dataModel.deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("usernum", new Object[0]);
        vs.addField("workload", new Object[0]);
        vs.addField("usergroup", new Object[0]);
        vs.addField("workstatus", new Object[0]);
        vs.addField("ability", new Object[0]);
        if (gridList != null) {
            for (int i = gridList.size() - 1; i >= 0; --i) {
                WorkerStatusPojo girdData = gridList.get(i);
                vs.addRow(new Object[]{girdData.getUserId(), girdData.getTaskTotal(), girdData.getUserGroupId(), girdData.isPresent(), girdData.getAbilityValue()});
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        if (!errRuleDyns.isEmpty()) {
            this.showWarningMsg(errRuleDyns);
        }
    }

    private void showWarningMsg(List<Long> errRuleDyns) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", errRuleDyns)};
        String selectFields = "number";
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)DISRULEMETA, (String)selectFields, (QFilter[])qFilters);
        StringBuilder warningMsg = new StringBuilder();
        warningMsg.append(ResManager.loadKDString((String)"\u83b7\u53d6\u53ef\u5206\u914d\u4eba\u5458\u65f6\uff0c\u90e8\u5206\u4efb\u52a1\u5206\u914d\u89c4\u5219\u6267\u884c\u51fa\u9519\uff0c\u89c4\u5219\u7f16\u7801\u4e3a\uff1a", (String)"UserWorkLoadFormPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        for (DynamicObject dyo : dyns) {
            warningMsg.append(dyo.get("number"));
            warningMsg.append("\uff0c");
        }
        warningMsg.append(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"UserWorkLoadFormPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.getView().showTipNotification(warningMsg.toString());
    }

    private List<WorkerStatusPojo> queryGridData(boolean includenoperm) {
        List<Object> userIDList = new ArrayList();
        userIDList = !includenoperm ? this.getDisUserAndUserGroupIDS() : this.getAllUserInGroup();
        this.addUserWorklingJobLoad(userIDList);
        return userIDList;
    }

    private List<WorkerStatusPojo> queryGridDataByAssign(boolean includenoperm, List<Long> errRuleDyns) {
        List<Object> userIDList = new ArrayList(8);
        List taskidList = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        if (!includenoperm && taskidList.size() == 1) {
            this.getPageCache().put("singleTask", taskidList.get(0) + "");
            userIDList = this.getDisUserAndUserGroupIDSByAssign(errRuleDyns);
        } else if (includenoperm) {
            userIDList = this.getAllUserInGroup();
        } else {
            return null;
        }
        this.addUserWorklingJobLoad(userIDList);
        return userIDList;
    }

    private List<WorkerStatusPojo> getAllUserInGroup() {
        ArrayList<WorkerStatusPojo> userIDList = new ArrayList<WorkerStatusPojo>(8);
        QFilter sscQFilter = this.buildSscQfilterBySscidList("orgfield");
        QFilter enableUserQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter enableUserGroupQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("");
        DynamicObject[] userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name,createorg,entryentity.userfield,entryentity.ability,entryentity.usestatus", (QFilter[])new QFilter[]{sscQFilter, enableUserQF, enableUserGroupQF});
        UserWorkLoadFormPlugin.initEnableAndWorkUserList(userIDList, userGroups);
        return userIDList;
    }

    private void addUserWorklingJobLoad(List<WorkerStatusPojo> workerStatusPojos) {
        if (CollectionUtils.isEmpty(workerStatusPojos)) {
            return;
        }
        ORM orm = ORM.create();
        HashSet<Long> userIDList = new HashSet<Long>(16);
        HashMap<String, Integer> taskTotalMap = new HashMap<String, Integer>(16);
        for (WorkerStatusPojo workerStatusPojo : workerStatusPojos) {
            userIDList.add(workerStatusPojo.getUserId());
        }
        QFilter PersonIDS = new QFilter("personid", "in", userIDList);
        QFilter disedTKFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter stateExFilter = WorkLoadUtil.getWorkloadStateExFilter();
        if (stateExFilter != null) {
            disedTKFilter.and(stateExFilter);
        }
        try (DataSet taskDS = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query task", "task_task", "personid,usergroup", new QFilter[]{PersonIDS, disedTKFilter});
             DataSet taskAfterGroupDS = taskDS.groupBy(new String[]{"personid", "usergroup"}).count("workload").finish().orderBy(new String[]{"workload desc"});){
            for (Row taskAfterOrderRow : taskAfterGroupDS) {
                Long persionID = taskAfterOrderRow.getLong("personid");
                Long usergroup = taskAfterOrderRow.getLong("usergroup");
                Integer workload = taskAfterOrderRow.getInteger("workload");
                taskTotalMap.put(usergroup + "_" + persionID, workload);
            }
        }
        if (taskTotalMap.size() == 0) {
            return;
        }
        for (WorkerStatusPojo workerStatusPojo : workerStatusPojos) {
            Integer integer = (Integer)taskTotalMap.get(workerStatusPojo.getUserGroupId() + "_" + workerStatusPojo.getUserId());
            if (integer == null) continue;
            workerStatusPojo.setTaskTotal(integer);
        }
        if (workerStatusPojos.size() > 0) {
            Collections.sort(workerStatusPojos, new UserWorkLoadCompare());
        }
    }

    public List<WorkerStatusPojo> getDisUserAndUserGroupIDS() {
        List<Long> userGroupIDList = this.getMatchedUserGroup();
        List<WorkerStatusPojo> userIDList = this.addUserGoupMembers(userGroupIDList);
        return userIDList;
    }

    public List<WorkerStatusPojo> getDisUserAndUserGroupIDSByAssign(List<Long> errRuleDyns) {
        Map<Object, Object> groupId2Priority = new HashMap();
        groupId2Priority = "true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild")) ? this.buildHandleGroupMapByAssignNew(errRuleDyns) : this.buildHandleGroupMapByAssign(errRuleDyns);
        return this.addUserGoupMembers(new ArrayList<Object>(groupId2Priority.keySet()));
    }

    private Map<Long, Integer> buildHandleGroupMapByAssignNew(List<Long> errRuleDyns) {
        boolean isRectification;
        DynamicObject[] rules;
        long taskId = Long.parseLong(this.getPageCache().get("singleTask"));
        Map<Long, Set<Long>> matchRuleAndGroups = Distribution.manualDistribution(taskId, rules = this.buildLongNumGatherRuleMap(), isRectification = this.isRectification(), errRuleDyns);
        if (matchRuleAndGroups.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, Integer> rulePriorities = this.buildRulePriorities(matchRuleAndGroups.keySet());
        return this.buildGroupMap(matchRuleAndGroups, rulePriorities);
    }

    private Map<Long, Integer> buildGroupMap(Map<Long, Set<Long>> matchRuleAndGroups, Map<Long, Integer> rulePriorities) {
        HashMap<Long, Integer> groupMap = new HashMap<Long, Integer>();
        for (Map.Entry<Long, Set<Long>> entry : matchRuleAndGroups.entrySet()) {
            Long rule = entry.getKey();
            Set<Long> groups = entry.getValue();
            Integer priority = rulePriorities.get(rule);
            for (Long groupId : groups) {
                Integer oldValue = groupMap.computeIfAbsent(groupId, g -> priority);
                if (oldValue <= priority) continue;
                groupMap.put(groupId, priority);
            }
        }
        return groupMap;
    }

    private Map<Long, Integer> buildRulePriorities(Set<Long> rules) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", rules)};
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)DISRULEMETA, (String)"id,priority", (QFilter[])qFilters);
        HashMap<Long, Integer> rtnMap = new HashMap<Long, Integer>(rules.size());
        for (DynamicObject dyn : dyns) {
            rtnMap.put(dyn.getLong("id"), dyn.getInt("priority"));
        }
        return rtnMap;
    }

    public WorkerStatusPojo getMatchAndLeastPerson() {
        WorkLoad workLoad = new WorkLoad();
        HashMap<Long, Integer> groupId2Priority = this.buildHandleGroupMapByAssign(new ArrayList<Long>(4));
        if (groupId2Priority.isEmpty()) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", groupId2Priority.keySet());
        QFilter userGroupEnable = new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        QFilter exceptRebotsFilter = new QFilter("isrobots", "!=", (Object)"1");
        ArrayList<QFilter> usergroupFilterList = new ArrayList<QFilter>(3);
        usergroupFilterList.add(filter);
        usergroupFilterList.add(userGroupEnable);
        usergroupFilterList.add(exceptRebotsFilter);
        workLoad.setUsergroupFilterList(usergroupFilterList);
        workLoad.setGroupId2Priority(groupId2Priority);
        workLoad.setApplierOfCurTask(this.applierOfCurTask);
        workLoad.prepareData();
        return workLoad.getMatchAndLeastPerson();
    }

    public List<Long> getMatchedUserGroup() {
        ArrayList<Long> userGroupIDList = new ArrayList<Long>();
        HashSet<Long> groupHandlerHashSet = this.buildHandleGroupMap();
        userGroupIDList.addAll(groupHandlerHashSet);
        return userGroupIDList;
    }

    private HashSet<Long> buildHandleGroupMap() {
        List<Long> taskIds = this.getTaskIds();
        if (taskIds == null || taskIds.isEmpty()) {
            return new HashSet<Long>();
        }
        Long taskId = taskIds.get(0);
        DynamicObject[] disrules = this.buildLongNumGatherRuleMap();
        if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
            ArrayList<Long> errRuleDyns = new ArrayList<Long>(4);
            Map<Long, Set<Long>> matchRuleAndGroups = Distribution.manualDistribution(taskId, disrules, this.isRectification, errRuleDyns);
            if (matchRuleAndGroups.isEmpty()) {
                return new HashSet<Long>();
            }
            return (HashSet)matchRuleAndGroups.values().stream().reduce((v1, v2) -> {
                v1.addAll(v2);
                return v1;
            }).get();
        }
        return this.getMatchGroupOld(disrules);
    }

    private HashSet<Long> getMatchGroupOld(DynamicObject[] disrules) {
        HashSet<Long> groupHandlerHsSet = new HashSet<Long>();
        List taskOrgList = null;
        taskOrgList = this.taskOrgGLList != null ? this.taskOrgGLList : (List)this.getView().getFormShowParameter().getCustomParam("orgIDList");
        for (String taskOrgIdStr : taskOrgList) {
            for (DynamicObject rule : disrules) {
                DynamicObjectCollection entryCols = rule.getDynamicObjectCollection("entryentity1");
                for (DynamicObject entryObj : entryCols) {
                    DynamicObjectCollection ruleOrgCols = entryObj.getDynamicObjectCollection("orgrange");
                    for (DynamicObject ruleOrg : ruleOrgCols) {
                        if (!TaskDisUtil.orgMatch((Long)ruleOrg.getLong("FBasedataId_id"), (Long)Long.valueOf(taskOrgIdStr))) continue;
                        groupHandlerHsSet.add(entryObj.getDynamicObject("usergroup").getLong("id"));
                    }
                }
            }
        }
        return groupHandlerHsSet;
    }

    private HashMap<Long, Integer> buildHandleGroupMapByAssign(List<Long> errDyns) {
        HashMap<Long, Integer> groupId2Priority = new HashMap<Long, Integer>();
        DynamicObject[] disrules = this.buildLongNumGatherRuleMap();
        List taskOrgList = this.taskOrgGLList != null ? this.taskOrgGLList : (List)this.getView().getFormShowParameter().getCustomParam("orgIDList");
        Map<Long, String> billTypeMap = this.buildTypeMap();
        for (String taskOrgIdStr : taskOrgList) {
            for (DynamicObject rule : disrules) {
                try {
                    this.ruleMatching(groupId2Priority, billTypeMap, taskOrgIdStr, rule);
                }
                catch (Exception e) {
                    Long id = rule.getLong("id");
                    errDyns.add(id);
                    log.error("\u4efb\u52a1\u5206\u914d\u6761\u4ef6\u5339\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u5206\u914d\u89c4\u5219id\uff1a" + id, (Throwable)e);
                }
            }
        }
        return groupId2Priority;
    }

    private void ruleMatching(HashMap<Long, Integer> groupId2Priority, Map<Long, String> billTypeMap, String taskOrgIdStr, DynamicObject rule) {
        DynamicObjectCollection entryCols = rule.getDynamicObjectCollection("entryentity1");
        DynamicObjectCollection entryRules = rule.getDynamicObjectCollection("entryentity");
        List taskIdList = this.taskIds != null ? this.taskIds : (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id,tasktypeid,billtype,state,orgid,sscid,billid,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskIdList)});
        String billId = task.getString("billid");
        Long creator = task.getLong("creator.id");
        Long billTypeId = task.getLong("billtype.id");
        String ssc = task.getString("sscid.id");
        boolean isMatched = false;
        for (DynamicObject entryRule : entryRules) {
            Long billType = entryRule.getLong("billtype.id");
            if (billTypeId.compareTo(billType) != 0) continue;
            String filterRuleJson = entryRule.getString("filterrulejson_tag");
            String applyCreditLevelJson = entryRule.getString("applycreditleveljoson_tag");
            String metaNum = billTypeMap.get(billType);
            if (!this.billCusFilterMatch(metaNum, billId, filterRuleJson) || !this.creditMatch(applyCreditLevelJson, creator, ssc)) continue;
            isMatched = true;
            break;
        }
        if (!isMatched) {
            return;
        }
        Long targetOrgId = Long.valueOf(taskOrgIdStr);
        block1: for (DynamicObject entryObj : entryCols) {
            DynamicObjectCollection ruleOrgCols = entryObj.getDynamicObjectCollection("orgrange");
            for (DynamicObject ruleOrg : ruleOrgCols) {
                Long groupId;
                Integer priority;
                if (targetOrgId.compareTo(ruleOrg.getLong("FBasedataId_id")) != 0 || (priority = groupId2Priority.get(groupId = Long.valueOf(entryObj.getDynamicObject("usergroup").getLong("id")))) != null && priority <= rule.getInt("priority")) continue;
                groupId2Priority.put(groupId, rule.getInt("priority"));
                continue block1;
            }
        }
    }

    private Map<Long, String> buildTypeMap() {
        DynamicObject[] billTypeDyObjs = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"bindbill.number", null);
        HashMap<Long, String> billTypeMap = new HashMap<Long, String>(16);
        for (DynamicObject billType : billTypeDyObjs) {
            long billTypeID = billType.getLong("id");
            String billTypeNum = billType.getString("bindbill.number");
            if (kd.bos.util.StringUtils.isEmpty((String)billTypeNum)) continue;
            billTypeMap.put(billTypeID, billTypeNum);
        }
        return billTypeMap;
    }

    private boolean billCusFilterMatch(String entityName, String billIdStr, String billCusFilterJson) {
        QFilter billFilter = BillCusFilter.getBillFilter(entityName, billCusFilterJson);
        if (billFilter == null) {
            return true;
        }
        QFilter idFilters = null;
        boolean res = false;
        try {
            idFilters = new QFilter("id", "=", (Object)Long.parseLong(billIdStr));
            res = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{idFilters, billFilter});
        }
        catch (Throwable e) {
            log.warn("\u81ea\u5b9a\u4e49\u6761\u4ef6\u5339\u914d\u62a5\u9519\uff0cbillIdStr = " + billIdStr, e);
            idFilters = new QFilter("id", "=", (Object)billIdStr);
            res = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{idFilters, billFilter});
        }
        return res;
    }

    private boolean creditMatch(String applyCreditFilter, Long userId, String sscid) {
        boolean matchresult = false;
        if (kd.bos.util.StringUtils.isEmpty((String)applyCreditFilter)) {
            log.info("\u91cd\u5206\u914d\uff1a\u672a\u8bbe\u7f6e\u4fe1\u7528\u7b49\u7ea7\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6;\u4fe1\u7528\u7b49\u7ea7\u5339\u914d\u6210\u529f");
            matchresult = true;
        } else {
            Map filters = (Map)SerializationUtils.fromJsonString((String)applyCreditFilter, HashMap.class);
            Object filterRow = filters.get("filterRow");
            if (filterRow == null || ((List)filterRow).size() == 0) {
                log.info("\u91cd\u5206\u914d\uff1a\u672a\u8bbe\u7f6e\u4fe1\u7528\u7b49\u7ea7\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6;\u4fe1\u7528\u7b49\u7ea7\u5339\u914d\u6210\u529f");
                matchresult = true;
            } else {
                QFilter[] qFilters = new QFilter[]{new QFilter("user", "in", (Object)userId), new QFilter("status", "!=", (Object)Character.valueOf('D'))};
                DynamicObject[] creditFiles = BusinessDataServiceHelper.load((String)"task_creditfiles", (String)"user.id,creditlevel.name", (QFilter[])qFilters);
                if (creditFiles.length <= 0) {
                    log.info("\u91cd\u5206\u914d\uff1a\u672a\u627e\u5230\u7528\u6237\u4fe1\u7528\u7b49\u7ea7\uff0c\u4fe1\u7528\u5339\u914d\u5931\u8d25");
                    return matchresult;
                }
                String creLevelName = creditFiles[0].getString("creditlevel.name");
                log.info("\u91cd\u5206\u914d\uff1a\u4fe1\u7528\u7b49\u7ea7\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a" + applyCreditFilter + ";");
                log.info("\u91cd\u5206\u914d\uff1a\u7528\u6237\u4fe1\u7528\u7b49\u7ea7\u4e3a\uff1a" + creLevelName + ";");
                if (kd.bos.util.StringUtils.isEmpty((String)creLevelName)) {
                    log.info("\u91cd\u5206\u914d\uff1a\u672a\u627e\u5230\u7528\u6237\u4fe1\u7528\u7b49\u7ea7\uff0c\u4fe1\u7528\u5339\u914d\u5931\u8d25");
                    return matchresult;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("applycreditlevel.name", creLevelName);
                String creFormula = UserWorkLoadFormPlugin.getCreExpFormular(applyCreditFilter);
                Object result = "false";
                try {
                    result = FormulaEngine.execExcelFormula((String)creFormula, map);
                }
                catch (FormulaException e) {
                    log.error("\u91cd\u5206\u914d\uff1a\u4efb\u52a1\u5206\u914d\u89c4\u5219\u89e3\u6790\u5931\u8d25:" + creFormula, (Throwable)e);
                }
                if ("true".equals(result.toString())) {
                    log.info("\u91cd\u5206\u914d\uff1a\u4fe1\u7528\u7b49\u7ea7\u5339\u914d\u6210\u529f");
                    matchresult = true;
                } else {
                    log.info("\u91cd\u5206\u914d\uff1a\u4fe1\u7528\u7b49\u7ea7\u5339\u914d\u5931\u8d25");
                }
            }
        }
        return matchresult;
    }

    private static String getCreExpFormular(String applyCreditFilter) {
        String creditFilterJson = applyCreditFilter;
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)creditFilterJson, FilterCondition.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_disrulef7creditlevel");
        FilterBuilder filterBuilder = new FilterBuilder(entityType, fc);
        filterBuilder.buildFilter(false);
        FilterObject filterObject = filterBuilder.getFilterObject();
        if (filterObject == null) {
            return "1 = 2";
        }
        FilterScriptBuilder scriptBuilder = new FilterScriptBuilder();
        String[] filterScript = scriptBuilder.buildFilterScript(filterObject);
        return filterScript[0];
    }

    private DynamicObject[] buildLongNumGatherRuleMap() {
        QFilter[] qfilters = this.buildFilterByTaskParam();
        DynamicObject[] disrules = BusinessDataServiceHelper.load((String)DISRULEMETA, (String)"id,number,name,priority,ssccenter,tasktype,entryentity1.id,entryentity1.orgrange,entryentity1.usergroup,entryentity.billtype,entryentity.filterrulejson_tag,entryentity.applycreditleveljoson_tag", (QFilter[])qfilters);
        return disrules;
    }

    private QFilter[] buildFilterByTaskParam() {
        QFilter sscQFilter = this.buildSscQfilterBySscidList("ssccenter");
        QFilter billTypeAndTaskTypeQFilter = this.buildCurTaskDisRuleQfilterByTypeAndSsc();
        QFilter disruleEnbaleQFilter = CommonFilterUtil.getEnableDisRuleQFilter();
        billTypeAndTaskTypeQFilter = billTypeAndTaskTypeQFilter.and(sscQFilter).and(disruleEnbaleQFilter);
        QFilter[] qfilters = new QFilter[]{billTypeAndTaskTypeQFilter};
        return qfilters;
    }

    private QFilter buildCurTaskDisRuleQfilterByTypeAndSsc() {
        QFilter billTypeAndTaskTypeQFilter = new QFilter("id", "!=", (Object)-10);
        List tIDTTypeBTypeList = null;
        tIDTTypeBTypeList = this.tIDTTypeBTypeGlList != null ? this.tIDTTypeBTypeGlList : (List)this.getView().getFormShowParameter().getCustomParam("taskdisParameters");
        for (String taskTypeBillType : tIDTTypeBTypeList) {
            if (taskTypeBillType == null) continue;
            String[] taskTypeBillTypes = taskTypeBillType.split(",");
            QFilter taskTypeQFilter = new QFilter("tasktype", "=", (Object)Long.valueOf(taskTypeBillTypes[0]));
            QFilter billTypeQFilter = new QFilter("entryentity.billtype", "=", (Object)Long.valueOf(taskTypeBillTypes[1]));
            taskTypeQFilter = taskTypeQFilter.and(billTypeQFilter);
            billTypeAndTaskTypeQFilter = billTypeAndTaskTypeQFilter.and(taskTypeQFilter);
        }
        return billTypeAndTaskTypeQFilter;
    }

    private List<WorkerStatusPojo> addUserGoupMembers(List<Long> userGroupIDList) {
        ArrayList<WorkerStatusPojo> userIDList = new ArrayList<WorkerStatusPojo>(8);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter userGroupFilter = new QFilter("id", "in", userGroupIDList);
        QFilter userGroupEnable = new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        filters.add(userGroupFilter);
        filters.add(userGroupEnable);
        QFilter enableQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter userEnabled = new QFilter("entryentity.usestatus", "=", (Object)Character.valueOf('1'));
        filters.add(enableQF);
        filters.add(userEnabled);
        IFormView view = this.getView();
        if (view != null) {
            Object isexceptrebots = view.getFormShowParameter().getCustomParam("isexceptrebots");
            boolean bl = this.isExceptRebots = isexceptrebots == null ? false : (Boolean)isexceptrebots;
        }
        if (this.isExceptRebots) {
            QFilter exceptRebotsFilter = new QFilter("isrobots", "!=", (Object)"1");
            filters.add(exceptRebotsFilter);
        }
        QFilter[] filterArr = new QFilter[filters.size()];
        DynamicObject[] userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name,createorg,entryentity.userfield,entryentity.ability,entryentity.usestatus", (QFilter[])filters.toArray(filterArr));
        UserWorkLoadFormPlugin.initEnableAndWorkUserList(userIDList, userGroups);
        return userIDList;
    }

    private QFilter buildSscQfilterBySscidList(String field) {
        List taskSscList = null;
        taskSscList = this.taskSscGlList != null ? this.taskSscGlList : (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        String sscid = taskSscList.get(0);
        if (taskSscList.size() <= 0) {
            return new QFilter(field, "=", (Object)"-1");
        }
        return new QFilter(field, "=", (Object)Long.valueOf(sscid));
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        this.disToUser(selectRows);
    }

    private void batchProcessing(Long userId, List<Long> taskIds, Long userGroup) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("task_allocation_progress");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customPara = parameter.getCustomParams();
        customPara.put("userid", userId);
        customPara.put("taskids", SerializationUtils.toJsonString(taskIds));
        customPara.put("batchcount", 20);
        customPara.put("usergroup", userGroup);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batchAllocation");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("batchAllocation".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void disTaskWithUserId(Long userId, List<Long> taskIds, IFormView view, boolean isBatchProcessing, Long userGroup) {
        StringBuilder errorMsg = new StringBuilder();
        List<Long> successIds = this.disTaskNew(userId, taskIds, view, errorMsg, userGroup);
        if (!isBatchProcessing) {
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>(8);
            int totalTaskCount = taskIds.size();
            int totalSuccessCount = successIds.size();
            returnDataMap.put("totalTaskCount", totalTaskCount);
            returnDataMap.put("totalSuccessCount", totalSuccessCount);
            String digest = this.createTipDigest(totalTaskCount, totalSuccessCount);
            returnDataMap.put("digest", digest);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                errorMsg.deleteCharAt(errorMsg.length() - 1);
                returnDataMap.put("errorMsg", errorMsg.toString());
            }
            String jsonString = JSON.toJSONString(returnDataMap);
            log.info(jsonString);
            this.getView().returnDataToParent((Object)jsonString);
            this.getView().close();
        }
    }

    public List<Long> disTaskNew(Long userId, List<Long> taskIds, IFormView view, StringBuilder errorMsg, Long userGroup) {
        ArrayList<DynamicObject> disTaskDynaList = new ArrayList<DynamicObject>();
        boolean isRedistribute = "admin_redistribution".equals(view.getFormShowParameter().getCustomParam("operation"));
        Map task2Index = (Map)view.getFormShowParameter().getCustomParam("task2Index");
        for (Long taskId : taskIds) {
            if (QueryServiceHelper.exists((String)"task_task", (Object)taskId)) {
                DynamicObject disTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
                long personId = disTask.getLong("personid.id");
                long userGroupId = disTask.getLong("usergroup.id");
                String billNumber = disTask.getString("billnumber");
                if (isRedistribute && MutexCacheHelper.containsMutexCache(String.valueOf(taskId))) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6b63\u5728\u5ba1\u6279\u4e2d\uff0c\u65e0\u6cd5\u91cd\u5206\u914d\u3002", (String)"TaskAdministrateListPlugin_104", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNumber));
                    errorMsg.append("\n");
                    continue;
                }
                if (userId.equals(personId) && userGroup.equals(userGroupId)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5206\u914d\u5931\u8d25\uff0c\u91cd\u5206\u914d\u4eba\u5458\u4e0e\u73b0\u5904\u7406\u4eba\u76f8\u540c\u3002", (String)"UserWorkLoadFormPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNumber));
                    errorMsg.append("\n");
                    continue;
                }
                disTaskDynaList.add(disTask);
                continue;
            }
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u53ef\u80fd\u5df2\u88ab\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u4efb\u52a1\u5217\u8868\u3002", (String)"UserWorkLoadFormPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]), (Integer)task2Index.get(taskId) + 1));
            errorMsg.append("\n");
        }
        List<Long> successIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(disTaskDynaList)) {
            if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
                successIds = Distribution.manualDisTaskDeal4Batch(userGroup, userId, disTaskDynaList);
            } else {
                DynamicObject[] disTasks = disTaskDynaList.toArray(new DynamicObject[disTaskDynaList.size()]);
                successIds = this.disTaskOld(userId, disTasks, userGroup);
            }
            log.info("\u624b\u5de5\u5206\u914d\uff0c\u6210\u529f\u5206\u914d\u7684\u4efb\u52a1id\uff1a" + Arrays.toString((Object[])successIds.toArray(new Long[0])));
        }
        return successIds;
    }

    public String createTipDigest(Integer totalTaskCount, Integer totalSuccessCount) {
        String digest = ResManager.loadKDString((String)"\u5171%1$s\u6761\u4efb\u52a1\uff0c\u5206\u914d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"UserWorkLoadFormPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        digest = String.format(digest, totalTaskCount, totalSuccessCount, totalTaskCount - totalSuccessCount);
        return digest;
    }

    private List<Long> disTaskOld(Long userId, DynamicObject[] disTaskDynaList, Long userGroup) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        boolean robotGroup = UserGroupUtil.isRobotGroup(userGroup);
        HashSet<Long> successSampleLibIds = new HashSet<Long>(8);
        ArrayList<DynamicObject> stateChangeDynObjs = new ArrayList<DynamicObject>(16);
        Date now = new Date();
        for (DynamicObject disTask : disTaskDynaList) {
            boolean isQuality;
            String curPoolType = disTask.getString("pooltype");
            Long sampleLib = disTask.getLong("qualitysamplelibrary.id");
            Date firstreceivetime = disTask.getDate("firstreceivetime");
            disTask.set("personid", (Object)userId);
            if (sampleLib > 0L) {
                disTask.set("orignalperson", (Object)userId);
            }
            disTask.set("usergroup", (Object)userGroup);
            if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(curPoolType)) {
                this.setState4DisTask(disTask, now, stateChangeDynObjs, successSampleLibIds, userId);
            } else if (TaskPoolTypeEnum.PROCESSING.getValue().equals(curPoolType)) {
                this.setState4RedisTask(disTask, now, stateChangeDynObjs, userId);
            } else {
                log.error("pooltype error, taskid = " + disTask.getLong("id") + ", pooltype = " + curPoolType);
                continue;
            }
            disTask.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
            disTask.set("receivetime", (Object)now);
            boolean bl = isQuality = sampleLib > 0L;
            if (!isQuality && firstreceivetime == null) {
                disTask.set("firstreceivetime", (Object)now);
            }
            disTask.set("autoprocess", (Object)robotGroup);
            taskIds.add(disTask.getLong("id"));
        }
        try {
            SaveServiceHelper.save((DynamicObject[])disTaskDynaList);
            SaveServiceHelper.save((DynamicObject[])stateChangeDynObjs.toArray(new DynamicObject[stateChangeDynObjs.size()]));
            this.deletePriorityLog(taskIds);
            if (!successSampleLibIds.isEmpty()) {
                QualityCheckSchemeUtil.changeQualitySampleLib4DisTask(successSampleLibIds);
            }
            OutSystemWorkLoadNodeChangeUtil.changeWorkLoadNode(disTaskDynaList, this.getView());
            this.addTaskCommon(disTaskDynaList);
            try {
                ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterDist((DynamicObject[])disTaskDynaList);
            }
            catch (Exception e) {
                logger.error("UserWorkLoadFormPlugin.disTaskWithUserId: \u624b\u52a8\u5206\u914d -> \u66f4\u6539\u8282\u70b9\u5ba1\u6279\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
            MessageHelper.sendMessage((DynamicObject[])disTaskDynaList);
        }
        catch (Exception e) {
            logger.error("\u91cd\u5206\u914d\u5931\u8d25:", (Throwable)e);
            return new ArrayList<Long>();
        }
        return taskIds;
    }

    private void setState4DisTask(DynamicObject disTask, Date now, List<DynamicObject> stateChangeDynObjs, Set<Long> successSampleLibIds, Long userId) {
        Long sampleLib = disTask.getLong("qualitysamplelibrary.id");
        String curState = disTask.getString("state");
        if (sampleLib > 0L) {
            disTask.set("state", (Object)TaskStateEnum.CHECKING.getValue());
            successSampleLibIds.add(sampleLib);
        } else {
            disTask.set("state", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        }
        DynamicObject stateChangeObj = this.createTaskStateChangeDynObj(disTask.getLong("id"), disTask.getString("state"), curState, now, "6", disTask.getLong("tasktypeid.id"), disTask.getLong("billtype.id"), userId);
        stateChangeDynObjs.add(stateChangeObj);
    }

    private void setState4RedisTask(DynamicObject disTask, Date now, List<DynamicObject> stateChangeDynObjs, Long userId) {
        String curState = disTask.getString("state");
        DynamicObject stateChangeObj = this.createTaskStateChangeDynObj(disTask.getLong("id"), curState, curState, now, "7", disTask.getLong("tasktypeid.id"), disTask.getLong("billtype.id"), userId);
        stateChangeDynObjs.add(stateChangeObj);
    }

    private DynamicObject createTaskStateChangeDynObj(Long taskId, String newJobState, String oldJobState, Date changeTime, String operation, Long tasktype_id, Long billtype_id, Long userId) {
        DynamicObject stateChangeDynObj = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
        stateChangeDynObj.set("jobid", (Object)taskId);
        stateChangeDynObj.set("newjobstate", (Object)newJobState);
        stateChangeDynObj.set("oldjobstate", (Object)oldJobState);
        stateChangeDynObj.set("changetime", (Object)changeTime);
        if (this.curUserId == 0L) {
            this.curUserId = RequestContext.get().getCurrUserId();
        }
        stateChangeDynObj.set("operatorid_id", (Object)this.curUserId);
        stateChangeDynObj.set("allocatedpersonid_id", (Object)userId);
        stateChangeDynObj.set("operation", (Object)operation);
        stateChangeDynObj.set("tasktype_id", (Object)tasktype_id);
        stateChangeDynObj.set("billtype_id", (Object)billtype_id);
        return stateChangeDynObj;
    }

    private void addTaskCommon(DynamicObject[] disTaskDynaList) {
        TaskWorkFlowUtil.updatePersonAndMsgDisTask((DynamicObject[])disTaskDynaList, (String)ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"UserWorkLoadFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    public void deletePriorityLog(List<Long> jobId) {
        QFilter fjobId = new QFilter("job", "in", jobId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"ssc.deletePriorityLog", (String)"task_prioritychangerecord", (String)"id,job", (QFilter[])fjobId.toArray(), null);
        if (col != null && col.size() > 0) {
            Object[] pks = new Object[col.size()];
            int i = 0;
            for (DynamicObject obj : col) {
                pks[i++] = obj.getLong("id");
            }
            BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"task_prioritychangerecord"), (Object[])pks);
        }
    }

    public void setTaskSscGlList(List<String> taskSscGlList) {
        this.taskSscGlList = (List)ObjectCloneUtil.cloneObject(taskSscGlList);
    }

    public void settIDTTypeBTypeGlList(List<String> tIDTTypeBTypeGlList) {
        this.tIDTTypeBTypeGlList = (List)ObjectCloneUtil.cloneObject(tIDTTypeBTypeGlList);
    }

    public void setTaskOrgList(List<String> taskOrgList) {
        this.taskOrgGLList = (List)ObjectCloneUtil.cloneObject(taskOrgList);
    }

    public void setExceptRebots(boolean isExceptRebots) {
        this.isExceptRebots = isExceptRebots;
    }

    public List<Long> getTaskIds() {
        return this.taskIds;
    }

    public void setTaskIds(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    public WorkerStatusPojo queryReformerMinWorkload() {
        List<WorkerStatusPojo> resultList = this.queryGridData(false);
        if (resultList != null && resultList.size() > 0) {
            return resultList.get(0);
        }
        return null;
    }

    private boolean checkApplier(Long taskId, Long userId) {
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"creator.id,billtype.id,qualitysamplelibrary.id", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        if (task == null || task.getLong("qualitysamplelibrary.id") > 0L) {
            return true;
        }
        DynamicObject billType = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"allowanyapplier", (QFilter[])new QFilter("id", "=", (Object)task.getLong("billtype.id")).toArray());
        return billType.getBoolean("allowanyapplier") || !userId.equals(task.getLong("creator.id"));
    }

    public void setApplierOfCurTask(Long applierOfCurTask) {
        this.applierOfCurTask = applierOfCurTask;
    }

    private void queryMineGroupLeaderData(boolean mineGroupLeader) {
        IDataModel dataModel = this.getModel();
        List<WorkerStatusPojo> gridList = this.queryGridDataByGroupLeader(mineGroupLeader);
        dataModel.deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        if (gridList != null && gridList.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("usernum", new Object[0]);
            vs.addField("workload", new Object[0]);
            vs.addField("usergroup", new Object[0]);
            vs.addField("workstatus", new Object[0]);
            vs.addField("ability", new Object[0]);
            for (int i = gridList.size() - 1; i >= 0; --i) {
                WorkerStatusPojo girdData = gridList.get(i);
                vs.addRow(new Object[]{girdData.getUserId(), girdData.getTaskTotal(), girdData.getUserGroupId(), girdData.isPresent(), girdData.getAbilityValue()});
            }
            model.batchCreateNewEntryRow("entryentity", vs);
        }
        this.getView().updateView("entryentity");
    }

    private List<WorkerStatusPojo> queryGridDataByGroupLeader(boolean mineGroupLeader) {
        if (mineGroupLeader) {
            List<WorkerStatusPojo> userIDList = this.getAllUserByGroupLeader();
            this.addUserWorklingJobLoad(userIDList);
            return userIDList;
        }
        return null;
    }

    private List<WorkerStatusPojo> getAllUserByGroupLeader() {
        ArrayList<WorkerStatusPojo> userIDList = new ArrayList<WorkerStatusPojo>(8);
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        String sscId = (String)taskSscList.get(0);
        Long currUserId = RequestContext.get().getCurrUserId();
        QFilter sscQFilter = new QFilter("createorg", "=", (Object)Long.valueOf(sscId));
        QFilter enableUserQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter enableUserGroupQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("");
        HashSet<Long> manageGroupSet = UserGroupUtil.getManageGroup(sscId, String.valueOf(currUserId));
        QFilter manageGroupQF = new QFilter("id", "in", manageGroupSet);
        DynamicObject[] userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name,createorg,entryentity.userfield,entryentity.ability,entryentity.usestatus", (QFilter[])new QFilter[]{sscQFilter, enableUserQF, enableUserGroupQF, manageGroupQF});
        UserWorkLoadFormPlugin.initEnableAndWorkUserList(userIDList, userGroups);
        return userIDList;
    }

    private static void initEnableAndWorkUserList(List<WorkerStatusPojo> userIDList, DynamicObject[] userGroups) {
        if (userGroups == null || userGroups.length == 0) {
            return;
        }
        ArrayList<Long> groupList = new ArrayList<Long>(10);
        Long sscId = userGroups[0].getLong("createorg.id");
        DynamicObject createorg = userGroups[0].getDynamicObject("createorg");
        DynamicObject timezone = createorg.getDynamicObject("timezone");
        String timezonenumber = "";
        if (timezone != null) {
            timezonenumber = timezone.getString("number");
        }
        for (DynamicObject usergroup : userGroups) {
            DynamicObjectCollection usergroupColl = usergroup.getDynamicObjectCollection("entryentity");
            Long userGroupID = usergroup.getLong("id");
            groupList.add(userGroupID);
            for (DynamicObject user : usergroupColl) {
                if (!user.getBoolean("userfield.enable") || !user.getBoolean("usestatus")) continue;
                BigDecimal ability = user.getBigDecimal("ability").setScale(1, RoundingMode.HALF_UP);
                Long userID = user.getLong("userfield.id");
                WorkerStatusPojo workerStatusPojo = new WorkerStatusPojo();
                workerStatusPojo.setSscId(sscId);
                workerStatusPojo.setUserId(userID);
                workerStatusPojo.setUserGroupId(userGroupID);
                workerStatusPojo.setTimezoneNumber(timezonenumber);
                workerStatusPojo.setAbilityValue(ability);
                userIDList.add(workerStatusPojo);
            }
        }
        Map<Long, Set<Long>> userMapOnWork = SscWorkCalendarApi.queryUserOnWork(new HashSet<Long>(groupList), DateUtil.changeTimeZone((Date)new Date(), (String)timezonenumber));
        for (int i = 0; i < userIDList.size(); ++i) {
            WorkerStatusPojo workerStatusPojo = userIDList.get(i);
            Set<Long> userIds = userMapOnWork.get(workerStatusPojo.getUserGroupId());
            if (CollectionUtils.isNotEmpty(userIds) && userIds.contains(workerStatusPojo.getUserId())) {
                workerStatusPojo.setPresent(true);
                continue;
            }
            workerStatusPojo.setPresent(false);
        }
    }

    public boolean isRectification() {
        return this.isRectification;
    }

    public void setRectification(boolean rectification) {
        this.isRectification = rectification;
    }

    private static class UserWorkLoadCompare
    implements Comparator<WorkerStatusPojo> {
        private UserWorkLoadCompare() {
        }

        @Override
        public int compare(WorkerStatusPojo o1, WorkerStatusPojo o2) {
            if (Long.compare(o1.getUserGroupId(), o2.getUserGroupId()) == 0) {
                return Integer.compare(o1.getTaskTotal(), o2.getTaskTotal());
            }
            return Long.compare(o1.getUserGroupId(), o2.getUserGroupId());
        }
    }
}

