/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ViewPhotoAutoRefreshPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String CACHED_KEY_URL = "url";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ssc-task");

    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.start();
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        IFrame frame = (IFrame)this.getControl("iframeap");
        String userId = RequestContext.get().getUserId();
        String pageId = (String)cache.get("ViewPhotoAutoRefreshPluginPageId" + userId);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            int time = 4;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)"viewPhotoCacheRefreshTime")});
            if (dynamicObject != null && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("paramvalue"))) {
                time = Integer.parseInt(dynamicObject.getString("paramvalue"));
            }
            cache.put("ViewPhotoAutoRefreshPluginPageId" + userId, (Object)pageId, time);
            String url = this.getUrl();
            if (StringUtils.isNotBlank((CharSequence)url)) {
                String cachedUrl = this.getPageCache().get(CACHED_KEY_URL);
                if (StringUtils.isBlank((CharSequence)cachedUrl)) {
                    this.getPageCache().put(CACHED_KEY_URL, url);
                    frame.setSrc(url);
                } else if (!url.equals(cachedUrl)) {
                    this.getPageCache().put(CACHED_KEY_URL, url);
                    frame.setSrc(url);
                }
            }
        }
    }

    private String getUrl() {
        String userId = RequestContext.get().getUserId();
        return (String)cache.get("ViewPhotoAutoRefreshPluginUrl" + userId);
    }
}

