/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.helper.MutexCacheHelper;

public class WidgetPCIndexPlugin
extends AbstractFormPlugin {
    private static final String VIEW_PERMID = "47150e89000000ac";
    private static final String SALE_INDEX = "task_salesindex";
    private static final String MANAGER_INDEX = "task_businessmanageindex";
    public static final String ADMINROLEID = "HXLT47Z1L8S";

    public void initialize() {
        super.initialize();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        List<Long> allPermSSC;
        super.preOpenForm(e);
        String formId = e.getFormShowParameter().getFormId();
        if ("som_apphome".equals(formId) && (allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), formId, e.getFormShowParameter().getAppId())).size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"WidgetPCIndexPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String formId;
        super.afterCreateNewData(e);
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        String string = formId = isSuperUser ? MANAGER_INDEX : this.getFormIdByNotSuper(currUserId);
        if (!"false".equals(this.getPageCache().get("isFirst"))) {
            this.getPageCache().put("isFirst", "false");
            FormShowParameter parameEdit = new FormShowParameter();
            parameEdit.setFormId(formId);
            parameEdit.getOpenStyle().setTargetKey("indexap");
            parameEdit.getOpenStyle().setShowType(ShowType.InContainer);
            this.getPageCache().get("controlstates");
            this.getView().showForm(parameEdit);
        }
        MutexCacheHelper.removeMutexCache4User(String.valueOf(RequestContext.get().getCurrUserId()));
    }

    public String getFormIdByNotSuper(long currUserId) {
        List<Long> taskSalesindex;
        String formId = SALE_INDEX;
        List<Long> taskBusinessmanageindex = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), MANAGER_INDEX, this.getView().getFormShowParameter().getAppId());
        formId = taskBusinessmanageindex.size() > 0 ? this.getFormIdIsAdmin(taskBusinessmanageindex, currUserId) : ((taskSalesindex = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), SALE_INDEX, this.getView().getFormShowParameter().getAppId())).size() > 0 ? SALE_INDEX : "task_nossc_errorpage");
        return formId;
    }

    public String getFormIdIsAdmin(List<Long> list, long currUserId) {
        boolean adminRole = TeamLeaderApi.isAdminRole(list, (Long)currUserId, "HXLFBW8ZGNH", ADMINROLEID);
        if (adminRole) {
            return MANAGER_INDEX;
        }
        String formId = SALE_INDEX;
        for (Long sid : list) {
            if (!TeamLeaderApi.isOpenTeamleader(String.valueOf(sid))) {
                formId = MANAGER_INDEX;
                break;
            }
            boolean isTeamleader = false;
            for (Long sid2 : list) {
                if (!TeamLeaderApi.isTeamleader(String.valueOf(sid2), currUserId)) continue;
                isTeamleader = true;
                break;
            }
            formId = isTeamleader ? MANAGER_INDEX : this.getFormIdByIsLeader();
        }
        if (formId.equals(SALE_INDEX)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u957f\u6743\u9650\uff0c\u5df2\u4e3a\u60a8\u8df3\u8f6c\u81f3\u4e1a\u52a1\u5458\u9996\u9875\u3002", (String)"WidgetPCIndexPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return formId;
    }

    public String getFormIdByIsLeader() {
        String formId = this.checkFunctionPermission(SALE_INDEX) ? SALE_INDEX : "task_errorpage";
        return formId;
    }

    @Deprecated
    public static List<ComboItem> getSscenters(Long userid, String formId) {
        return WidgetPCIndexPlugin.getSscenters("ssc", userid, formId);
    }

    public static List<ComboItem> getSscenters(String appId, Long userid, String formId) {
        QFilter qFilter;
        HasPermOrgResult hasPermOrgs;
        if (StringUtils.isBlank((String)appId)) {
            appId = "ssc";
        }
        if ((hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userid, (String)"12", (String)appId, (String)formId, (String)VIEW_PERMID)).hasAllOrgPerm() || PermissionServiceHelper.isSuperUser((long)userid)) {
            qFilter = null;
        } else {
            List orgIDs = hasPermOrgs.getHasPermOrgs();
            if (orgIDs == null || orgIDs.size() == 0) {
                return Collections.emptyList();
            }
            qFilter = new QFilter("id", "in", (Object)orgIDs);
        }
        QFilter cFilter = new QFilter("fisscc", "=", (Object)Character.valueOf('1'));
        ORM orm = ORM.create();
        DataSet set = orm.queryDataSet("bos_org_index", "bos_org", "id,name", new QFilter[]{qFilter, cFilter});
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        Iterator rows = set.iterator();
        while (rows.hasNext()) {
            ComboItem citem = new ComboItem();
            Row groupRow = (Row)rows.next();
            String value = groupRow.getString(0);
            Object name = groupRow.get(1);
            LocaleString nameStr = (LocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)name), LocaleString.class);
            citem.setCaption(nameStr);
            citem.setValue(value);
            list.add(citem);
        }
        return list;
    }

    @Deprecated
    public static boolean isAdminRole(String sid, Long uid, String sscAdminRoleId, String AdminRoleId) {
        boolean result = false;
        if (!TeamLeaderApi.isOpenTeamleader(sid)) {
            return true;
        }
        Map<Long, Set<String>> map = TeamLeaderApi.getOrgRoleAssignMap(uid);
        block0: for (Map.Entry<Long, Set<String>> entry : map.entrySet()) {
            Long key = entry.getKey();
            if (!sid.equals(String.valueOf(key))) continue;
            Set<String> roleSet = entry.getValue();
            for (String roleId : roleSet) {
                if (!sscAdminRoleId.equals(roleId) && !AdminRoleId.equals(roleId)) continue;
                result = true;
                break block0;
            }
        }
        return result || PermissionServiceHelper.isSuperUser((long)uid);
    }

    private boolean checkFunctionPermission(String entityName) {
        RequestContext context = RequestContext.get();
        long userid = Long.parseLong(context.getUserId());
        return PermissionServiceHelper.hasSpecificPerm((long)userid, null, (String)entityName, (String)VIEW_PERMID);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        MutexCacheHelper.removeMutexCache4User(String.valueOf(RequestContext.get().getCurrUserId()));
    }
}

