/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.achieve.AchieveDateUtil;
import kd.ssc.task.formplugin.pojo.achieve.AchieveExpEnum;
import kd.ssc.task.formplugin.util.AchieveUtil;
import kd.ssc.task.formplugin.util.WorkLoadOnlineRecountUtil;

public class AchieveExceptionListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(AchieveExceptionListPlugin.class);
    private static final String systemType = "ssc-task-formplugin";

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        OperationResult operationResult = evt.getOperationResult();
        String operateKey = evt.getOperateKey();
        IFormView view = this.getView();
        if (("recalculate".equals(operateKey) || "viewlog".equals(operateKey)) && operationResult.isSuccess()) {
            DynamicObjectCollection query = null;
            List<Long> selectedRowIds = AchieveUtil.getSelectedRowIds((IListView)view);
            if (selectedRowIds == null || selectedRowIds.isEmpty()) {
                return;
            }
            String selectFields = "id,sscid,achievebasedata,logdetail,logdetail_tag,recalculation,createdate,recalstatus";
            QFilter filter = new QFilter("id", "in", selectedRowIds);
            query = QueryServiceHelper.query((String)"ssc_achieveexception", (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (query == null || query.isEmpty()) {
                return;
            }
            if ("recalculate".equals(operateKey)) {
                boolean flag = false;
                boolean status = false;
                for (DynamicObject obj : query) {
                    if (this.validate(obj.getDate("createdate"))) {
                        flag = true;
                        break;
                    }
                    if (!"0".equals(obj.getString("recalstatus"))) continue;
                    status = true;
                    break;
                }
                if (flag) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u7684\u65f6\u95f4\u8d85\u8fc7\u56db\u4e2a\u6708\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"AchieveExceptionListPlugin_4", (String)systemType, (Object[])new Object[0]));
                    return;
                }
                if (status) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5931\u8d25\u72b6\u6001\u7684\u6570\u636e\u8fdb\u884c\u91cd\u8bd5\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"AchieveExceptionListPlugin_5", (String)systemType, (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener recalculate = new ConfirmCallBackListener("recalculate", (IFormPlugin)this);
                view.showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8986\u76d6\u4e4b\u524d\u751f\u6210\u7684\u6570\u636e\u4e48\uff1f", (String)"AchieveExceptionListPlugin_0", (String)systemType, (Object[])new Object[0]), MessageBoxOptions.OKCancel, recalculate);
            } else if ("viewlog".equals(operateKey)) {
                if (selectedRowIds.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u65e5\u5fd7\u67e5\u770b\u3002", (String)"AchieveExceptionListPlugin_3", (String)systemType, (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> param = new HashMap<String, Object>(4);
                param.put("sscid", ((DynamicObject)query.get(0)).getLong("sscid"));
                param.put("type", ((DynamicObject)query.get(0)).getString("achievebasedata"));
                param.put("logdetail", ((DynamicObject)query.get(0)).getString("logdetail"));
                param.put("count", ((DynamicObject)query.get(0)).getInt("recalculation"));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ssc_achieveexception");
                this.showForm("ssc_achievelogdetail", closeCallBack, ShowType.Modal, param);
            }
        }
    }

    private void showForm(String formId, CloseCallBack closeCallBack, ShowType showType, Map params) {
        params.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)params);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setCustomParams(params);
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        DynamicObjectCollection query = null;
        IFormView view = this.getView();
        if ("recalculate".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            List<Long> selectedRowIds = AchieveUtil.getSelectedRowIds((IListView)view);
            if (selectedRowIds == null || selectedRowIds.isEmpty()) {
                return;
            }
            try {
                QFilter filter = new QFilter("id", "in", selectedRowIds);
                String selectFields = "id,sscid,achievebasedata,logdetail,logdetail_tag,recalculation,createdate,recalstatus";
                query = QueryServiceHelper.query((String)"ssc_achieveexception", (String)selectFields, (QFilter[])new QFilter[]{filter});
                if (query == null || query.isEmpty()) {
                    return;
                }
                boolean result = false;
                for (DynamicObject obj : query) {
                    long eid = obj.getLong("id");
                    Date createdate = obj.getDate("createdate");
                    String logDeatil = obj.getString("logdetail_tag");
                    List<Long> sscids = Collections.singletonList(obj.getLong("sscid"));
                    if (AchieveExpEnum.SSC_USERONDUTYTIME.getValue().equals(obj.getString("achievebasedata"))) {
                        AchieveUtil.deleteDate(Collections.singletonList(createdate), sscids);
                        String info = AchieveUtil.saveUserTime(createdate, sscids);
                        if ("".equals(info)) {
                            AchieveUtil.saveAchieveException(sscids, AchieveExpEnum.SSC_USERONDUTYTIME.getValue(), createdate, logDeatil, "0", eid);
                            continue;
                        }
                        log.error("\u6267\u884c\u5728\u5c97\u65f6\u957f\u91cd\u7b97\u5931\u8d25\uff1a" + info);
                        result = true;
                        AchieveUtil.saveAchieveException(sscids, AchieveExpEnum.SSC_USERONDUTYTIME.getValue(), createdate, info, "1", eid);
                        continue;
                    }
                    if (!AchieveExpEnum.SSC_WORKLOADONLINE.getValue().equals(obj.getString("achievebasedata"))) continue;
                    try {
                        WorkLoadOnlineRecountUtil.deleteWorkLoadByDay(createdate, sscids);
                        WorkLoadOnlineRecountUtil.saveWorkLoadBybeforeDay(createdate, sscids);
                        AchieveUtil.saveAchieveException(sscids, AchieveExpEnum.SSC_WORKLOADONLINE.getValue(), createdate, logDeatil, "0", eid);
                    }
                    catch (Exception e) {
                        log.error("\u6267\u884c\u7ebf\u4e0a\u5de5\u4f5c\u91cf\u91cd\u7b97\u5931\u8d25\uff1a" + e);
                        result = true;
                        AchieveUtil.saveAchieveException(sscids, AchieveExpEnum.SSC_WORKLOADONLINE.getValue(), createdate, e.getMessage(), "1", eid);
                    }
                }
                if (result) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"AchieveExceptionListPlugin_2", (String)systemType, (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"AchieveExceptionListPlugin_1", (String)systemType, (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                log.error("\u91cd\u590d\u6267\u884c\u5931\u8d25:" + e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"AchieveExceptionListPlugin_2", (String)systemType, (Object[])new Object[0]));
            }
            view.updateView("billlistap");
        }
    }

    public boolean validate(Date startDate) {
        boolean result = false;
        long between = AchieveDateUtil.between((Date)startDate, (Date)new Date());
        if (between > 125L) {
            result = true;
        }
        return result;
    }
}

