/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.achieve.CalFactorFieldConfigEnum;
import kd.ssc.enums.achieve.TargetRule;

public class CalFactorEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"dimensions", "conditiontext", "aggobject"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("entityObject");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initFieldMapping();
    }

    public void afterCopyData(EventObject e) {
        this.initFieldMapping();
        this.initLocalStringData();
    }

    public void afterLoadData(EventObject e) {
        this.initFieldMapping();
        this.initLocalStringData();
    }

    public void afterBindData(EventObject e) {
        this.setCalModeStyle();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT == status) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name"});
            boolean hasReferenced = this.calFactorHasReferenced();
            Boolean ispreset = (Boolean)this.getModel().getValue("ispreset");
            if (ispreset.booleanValue() || hasReferenced) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"description", "datasource", "javaplugin", "entityobject", "conditiontext", "aggmode", "aggobject"});
                int entryCount = this.getModel().getEntryRowCount("fieldmappingentry");
                for (int i = 0; i < entryCount; ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"dimensions"});
                }
            }
            if (hasReferenced) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"description"});
            }
        } else if (OperationStatus.ADDNEW == status) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number", "name", "description", "datasource", "javaplugin", "entityobject", "conditiontext", "aggmode", "aggobject"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("datasource".equals(key)) {
            this.setCalModeStyle();
        } else if ("entityobject".equals(key)) {
            this.clearValues("conditiontext", "aggmode", "aggobject", "aggfieldnumber", "conditiontext", "fieldmapping");
            int entryCount = this.getModel().getEntryRowCount("fieldmappingentry");
            for (int i = 0; i < entryCount; ++i) {
                this.getModel().setValue("dimensions", null, i);
                this.getModel().setValue("dimensionnumber", null, i);
            }
        } else if ("aggmode".equals(key)) {
            this.clearValues("aggobject", "aggfieldnumber");
        } else if ("conditiontext".equals(key)) {
            this.clearValues("conditionjson");
        } else if ("dimensions".equals(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String dimensions = (String)this.getModel().getValue("dimensions", rowIndex);
            if (StringUtils.isEmpty((String)dimensions)) {
                this.getModel().setValue("dimensionnumber", null, rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobject");
        if (entityObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"CalFactorEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("dimensions".equals(key) || "aggobject".equals(key)) {
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("entityNumber", entityObject.getString("number"));
            param.put("entityName", entityObject.getString("name"));
            String actionId = null;
            if ("dimensions".equals(key)) {
                int selectedrow = this.getModel().getEntryCurrentRowIndex("fieldmappingentry");
                param.put("fieldConfiguration", String.valueOf(selectedrow));
                actionId = String.valueOf(selectedrow);
            } else {
                String aggMode = (String)this.getModel().getValue("aggmode");
                if (StringUtils.isEmpty((String)aggMode)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u805a\u5408\u65b9\u5f0f\u3002", (String)"CalFactorEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                param.put("fieldConfiguration", aggMode);
                actionId = aggMode;
            }
            this.showEntityPropSelectForm(param, actionId);
        } else if ("conditiontext".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("ssc_achievecondition");
            formShowParameter.setCustomParam("entityNumber", (Object)entityObject.getString("number"));
            formShowParameter.setCustomParam("conditionJson", this.getModel().getValue("conditionjson"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "condition");
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        if (actionId.equals("condition")) {
            String conditionText = (String)map.get("desc");
            String conditionJson = (String)map.get("conditionJson");
            this.getModel().setValue("conditiontext", (Object)conditionText);
            this.getModel().setValue("conditionjson", (Object)conditionJson);
        } else {
            boolean isEntry = true;
            int entryRow = 0;
            try {
                entryRow = Integer.parseInt(actionId);
            }
            catch (Exception ex) {
                isEntry = false;
            }
            String number = (String)map.get("number");
            String name = (String)map.get("name");
            if (isEntry) {
                this.getModel().setValue("dimensions", (Object)name, entryRow);
                this.getModel().setValue("dimensionnumber", (Object)number, entryRow);
            } else {
                this.getModel().setValue("aggobject", (Object)name);
                this.getModel().setValue("aggfieldnumber", (Object)number);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object operate = args.getSource();
        if (operate instanceof Save && "1".equals((String)this.getModel().getValue("datasource"))) {
            HashMap param = new HashMap(4);
            for (int i = 0; i < 3; ++i) {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("fieldName", (String)this.getModel().getValue("dimensions", i));
                map.put("fieldNumber", (String)this.getModel().getValue("dimensionnumber", i));
                param.put(String.valueOf(i), map);
            }
            this.getModel().setValue("fieldmapping", (Object)SerializationUtils.toJsonString(param));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operationKey = e.getOperateKey();
        if ("save".equals(operationKey) && "1".equals((String)this.getModel().getValue("datasource"))) {
            this.initFieldMapping();
            this.getModel().setDataChanged(false);
        }
    }

    private void showEntityPropSelectForm(Map<String, Object> formParams, String actionId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("som_achieveproptree");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams(formParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(formShowParameter);
    }

    private void initLocalStringData() {
        String conditionJson;
        IDataModel model = this.getModel();
        String aggFieldNumber = (String)model.getValue("aggfieldnumber");
        if (StringUtils.isNotEmpty((String)aggFieldNumber)) {
            model.setValue("aggobject", (Object)this.getEntityProLocalString(aggFieldNumber));
        }
        if (StringUtils.isNotEmpty((String)(conditionJson = (String)model.getValue("conditionjson")))) {
            DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobject");
            if (entityObject == null) {
                return;
            }
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityObject.getString("number"));
            FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition, false);
            filterBuilder.buildFilter(false);
            String conditionText = filterBuilder.getFilterObject().getFilter();
            model.setValue("conditiontext", (Object)conditionText);
        }
    }

    private void initFieldMapping() {
        this.getModel().deleteEntryData("fieldmappingentry");
        this.getModel().batchCreateNewEntryRow("fieldmappingentry", 3);
        this.getModel().setValue("indicatorparam", (Object)CalFactorFieldConfigEnum.ACHIEVE_ACCESS_TIME.getFieldKey(), 0);
        this.getModel().setValue("indicatorparam", (Object)CalFactorFieldConfigEnum.ACHIEVE_USER.getFieldKey(), 1);
        this.getModel().setValue("indicatorparam", (Object)CalFactorFieldConfigEnum.ACHIEVE_SSC.getFieldKey(), 2);
        String fieldMapping = (String)this.getModel().getValue("fieldmapping");
        if (StringUtils.isNotEmpty((String)fieldMapping) && "1".equals((String)this.getModel().getValue("datasource"))) {
            Map map = (Map)SerializationUtils.fromJsonString((String)fieldMapping, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                int index = Integer.parseInt((String)entry.getKey());
                String dimensionNumber = (String)((Map)entry.getValue()).get("fieldNumber");
                this.getModel().setValue("dimensions", (Object)this.getEntityProLocalString(dimensionNumber), index);
                this.getModel().setValue("dimensionnumber", (Object)dimensionNumber, index);
            }
        }
    }

    private void setCalModeStyle() {
        String datasource = (String)this.getModel().getValue("datasource");
        if ("1".equals(datasource)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"javaplugin"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"entityobject", "conditiontext", "aggmode", "aggobject", "flexpanelap1"});
            this.setMustInput(Boolean.FALSE, "javaplugin");
            this.setMustInput(Boolean.TRUE, "entityobject", "aggmode", "aggobject");
            this.clearValues("javaplugin");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"javaplugin"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entityobject", "conditiontext", "aggmode", "aggobject", "flexpanelap1"});
            this.setMustInput(Boolean.TRUE, "javaplugin");
            this.setMustInput(Boolean.FALSE, "entityobject", "aggmode", "aggobject");
            this.clearValues("entityobject");
        }
    }

    private void setMustInput(boolean mustInput, String ... fields) {
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl(field);
            fieldEdit.setMustInput(mustInput);
        }
    }

    private void clearValues(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null);
        }
    }

    private boolean calFactorHasReferenced() {
        String currNumber = (String)this.getModel().getValue("number");
        QFilter calIndicator = new QFilter("targettype", "=", (Object)"0");
        DynamicObjectCollection sscAchieveTargets = QueryServiceHelper.query((String)"ssc_achievetarget", (String)"id,number,name,ruleexpjson_tag", (QFilter[])new QFilter[]{calIndicator});
        for (DynamicObject sscAchieveTarget : sscAchieveTargets) {
            String ruleexpjson = sscAchieveTarget.getString("ruleexpjson_tag");
            TargetRule targetRule = (TargetRule)SerializationUtils.fromJsonString((String)ruleexpjson, TargetRule.class);
            BOSExpression bosExpression = new BOSExpression(targetRule.getExpression());
            Set vars = bosExpression.getVars();
            if (!vars.contains(currNumber)) continue;
            return true;
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        if ("entityobject".equals(key)) {
            QFilter qFilter = new QFilter("modeltype", "in", Arrays.asList("MobileFormModel", "BillFormModel", "LogBillFormModel", "BaseFormModel"));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private String getEntityProLocalString(String propNumber) {
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobject");
        if (entityObject == null) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityObject.getString("number"));
        DynamicProperty property = entityType.getProperty(propNumber);
        if (property == null) {
            return null;
        }
        return property.getDisplayName().getLocaleValue();
    }
}

