/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.board;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.message.CreditBoardMessage;
import kd.ssc.task.formplugin.util.MetadataUtil;
import kd.ssc.task.util.TaskParamControlUtil;

public class CreditBoardConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final long bizSys = 427215148743160832L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit billType = (BasedataEdit)this.getControl("billtype");
        billType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit bizTypeParam = (TextEdit)this.getView().getControl("fieldname");
        bizTypeParam.addButtonClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit source = (BasedataEdit)e.getSource();
        String key = source.getKey();
        if ("billtype".equalsIgnoreCase(key)) {
            Object org = this.getModel().getValue("createorg");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"CreditBoardConfigPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
            QFilter filter = new QFilter("createorg", "=", ((DynamicObject)org).getPkValue());
            DynamicObjectCollection configs = QueryServiceHelper.query((String)"task_creditboardconfig_", (String)"id,billtype", (QFilter[])new QFilter[]{filter});
            if (!configs.isEmpty()) {
                List billTypes = configs.stream().map(config -> config.get("billtype")).collect(Collectors.toList());
                qFilters.add(new QFilter("id", "not in", billTypes));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeProperty = e.getProperty().getName();
        if ("billtype".equalsIgnoreCase(changeProperty)) {
            this.getModel().setValue("fieldname", (Object)"");
            this.getModel().setValue("fieldnumber", (Object)"");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        Object billTypeO = this.getModel().getValue("billtype");
        if ("fieldname".equals(key)) {
            if (billTypeO == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"CreditBoardConfigPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
            String entityNumber = billType.getString("number");
            String entityName = billType.getString("name") + "";
            try {
                EntityMetadataCache.getDataEntityType((String)entityNumber);
            }
            catch (Exception e) {
                String errorInfo = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a\u201c%s\u201d\u3002", (String)"CreditBoardConfigPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage());
                this.getView().showMessage(errorInfo);
                return;
            }
            MetadataUtil.getBillRule(entityNumber, entityName, key, (IFormPlugin)this, this.getView(), "80");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null && e.getActionId() != null) {
            Map ret = (Map)returnData;
            if ("propertyTree".equalsIgnoreCase(e.getActionId()) && !ret.isEmpty()) {
                String fieldNumber = (String)ret.get("key");
                boolean isEntry = fieldNumber.contains(".");
                if (isEntry && fieldNumber.split("\\.").length > 2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e8c\u7ea7\u4ee5\u5185\u7684\u5c5e\u6027\u3002", (String)"CreditBoardConfigPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject billType = (DynamicObject)((DynamicObject)this.getModel().getValue("billtype")).get("basedatafield");
                MainEntityType billTypeEntityType = MetadataServiceHelper.getDataEntityType((String)billType.getString("number"));
                DynamicProperty property = isEntry ? ((EntryProp)billTypeEntityType.getProperty(fieldNumber.split("\\.")[0])).getDynamicCollectionItemPropertyType().getProperty(fieldNumber.split("\\.")[1]) : billTypeEntityType.getProperty(fieldNumber);
                boolean flag = false;
                if (property != null) {
                    BasedataProp prop = (BasedataProp)property;
                    DataEntityPropertyCollection entityProperties = prop.getComplexType().getProperties();
                    for (IDataEntityProperty entityProperty : entityProperties) {
                        if (!"name".equals(entityProperty.getName())) continue;
                        flag = true;
                    }
                    if (flag) {
                        String propertyEntityNumber = prop.getBaseEntityId();
                        this.getModel().setValue("fieldentitynumber", (Object)propertyEntityNumber);
                        this.getModel().setValue("fieldname", ret.get("alias"));
                        this.getModel().setValue("fieldnumber", (Object)fieldNumber);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e3a\u5355\u636e\u914d\u7f6e\u5f15\u7528\u57fa\u7840\u8d44\u6599\u5c5e\u6027name\u5b57\u6bb5", (String)"CreditBoardConfigPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.updateCreditBoardBaseData();
        }
    }

    void updateCreditBoardBaseData() {
        Object sscId = ((DynamicObject)this.getModel().getValue("createorg")).getPkValue();
        String billTypeNumber = ((DynamicObject)this.getModel().getValue("billtype")).get("number") + "";
        String fieldName = this.getModel().getValue("fieldname") + "";
        String fieldNumber = this.getModel().getValue("fieldnumber") + "";
        Object fieldEntityNumber = this.getModel().getValue("fieldentitynumber");
        QFilter qFilter = new QFilter("sscid", "=", sscId);
        qFilter.and(new QFilter("entry.bizbill", "=", (Object)billTypeNumber));
        qFilter.and(new QFilter("entry.bizsys", "=", (Object)427215148743160832L));
        int count = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ssc_creditboarddata", (String)"id,entry.id", (QFilter[])new QFilter[]{qFilter}, (String)"").count("entry.id", false);
        int pageIndex = 0;
        CreditBoardMessage message = new CreditBoardMessage(sscId, billTypeNumber, fieldNumber, fieldName, fieldEntityNumber);
        int maxDataSize = 1000;
        String configPageSize = TaskParamControlUtil.querySscParam((String)"creditBoardConfigPageSize");
        if (configPageSize != null) {
            maxDataSize = Integer.parseInt(configPageSize);
        }
        while (count > 0 && pageIndex <= count / maxDataSize) {
            int pageSize = maxDataSize;
            int sub = count - pageIndex * maxDataSize;
            if (sub < maxDataSize) {
                pageSize = sub;
            }
            message.setPageIndex(pageIndex);
            message.setPageSize(pageSize);
            CreditBoardConfigPlugin.updateCreditBoardBaseDataMQ(message);
            ++pageIndex;
        }
    }

    private static void updateCreditBoardBaseDataMQ(CreditBoardMessage message) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_creditboard_queue");){
            pub.publish((Object)message);
        }
    }
}

