/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ComboItemEditFormPlugin
extends AbstractFormPlugin {
    private static final String ENTRYKEY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        this.fullEntryEntity();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("savecheck".equals(operateKey) && e.getOperationResult().isSuccess()) {
            this.returnData();
        }
    }

    private void fullEntryEntity() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pubParams = (String)formShowParameter.getCustomParam("value");
        if (StringUtils.isBlank((CharSequence)pubParams)) {
            return;
        }
        JSONObject extraInfo = JSON.parseObject((String)pubParams);
        JSONArray items = extraInfo.getJSONArray("items");
        if (items != null && items.size() > 0) {
            IDataModel model = this.getModel();
            int[] rowIndex = model.batchCreateNewEntryRow(ENTRYKEY, items.size());
            int i = 0;
            for (JSONObject item_ : items) {
                model.setValue("caption", item_.get((Object)"Caption"), rowIndex[i]);
                model.setValue("value", item_.get((Object)"Value"), rowIndex[i]);
                ++i;
            }
        }
    }

    private void returnData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entity = model.getEntryEntity(ENTRYKEY);
        if (null == entity || entity.size() <= 0) {
            view.returnDataToParent(null);
            view.close();
            return;
        }
        ArrayList results = new ArrayList(8);
        for (DynamicObject dy : entity) {
            String caption = dy.getString("caption");
            String value = dy.getString("value");
            if (StringUtils.isBlank((CharSequence)caption) || StringUtils.isBlank((CharSequence)value)) continue;
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("Caption", caption);
            result.put("Value", value);
            results.add(result);
        }
        if (results.isEmpty()) {
            view.returnDataToParent(null);
        } else {
            HashMap para = new HashMap(1);
            para.put("value", results);
            view.returnDataToParent(para);
        }
        view.close();
    }
}

