/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.ssc.task.business.condition.ConFieldTypeEnum;

public class ConField2BillFieldEditPlugin
extends AbstractFormPlugin {
    private static final String OP_CHECK_SAVE = "checksave";
    private static final String CK_DELETE_ROW_ID = "deleteRowId";
    private static final String CK_OLD_VALUE = "conFieldOldValue";
    private static final String CB_CONFIRM_CHANGE = "callback_confirmChange";
    private static final String CB_SELECT_PROP = "callback_selectProp";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"billfield", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        Object defConField = fsp.getCustomParam("defConField");
        if (defConField != null) {
            this.getModel().setValue("dimconfield", defConField);
            view.setEnable(Boolean.FALSE, new String[]{"dimconfield"});
            this.buildEntryData(Long.parseLong(defConField.toString()));
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        IDataModel model = this.getModel();
        String deletedCache = this.getPageCache().get(CK_DELETE_ROW_ID);
        ArrayList<Long> deleteList = null;
        if (StringUtils.isNotBlank((CharSequence)deletedCache)) {
            deleteList = (ArrayList<Long>)SerializationUtils.fromJsonString((String)deletedCache, List.class);
        }
        if (deleteList == null) {
            deleteList = new ArrayList<Long>(1);
        }
        for (int rowIndex : e.getRowIndexs()) {
            Long id = (Long)model.getValue("id", rowIndex);
            if (id <= 0L) continue;
            deleteList.add(id);
        }
        this.getPageCache().put(CK_DELETE_ROW_ID, SerializationUtils.toJsonString(deleteList));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        if ("dimconfield".equals(propName)) {
            DynamicObjectCollection entry = dataModel.getEntryEntity("entryentity");
            String deleteRows = this.getPageCache().get(CK_DELETE_ROW_ID);
            if (dataModel.getDataChanged() && oldValue != null && (deleteRows != null || entry.stream().anyMatch(c -> c.getDataEntityState().isBizChanged()))) {
                view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u5207\u6362\u6761\u4ef6\u5b57\u6bb5\u5c06\u6e05\u9664\u6240\u6709\u6620\u5c04\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"ConField2BillFieldEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CB_CONFIRM_CHANGE, (IFormPlugin)this));
                String oldDataId = ((DynamicObject)oldValue).getString("id");
                this.getPageCache().put(CK_OLD_VALUE, oldDataId);
            } else {
                this.switchEntry((DynamicObject)newValue);
            }
        } else if ("sourcebill".equals(propName)) {
            dataModel.setValue("billfield", null, rowIndex);
        } else if ("billfield".equals(propName) && StringUtils.isEmpty((CharSequence)((String)newValue))) {
            dataModel.setValue("billfieldnumber", null, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        IDataModel model = this.getModel();
        String callBackId = event.getCallBackId();
        if (CB_CONFIRM_CHANGE.equals(callBackId)) {
            MessageBoxResult result = event.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.switchEntry((DynamicObject)model.getValue("dimconfield"));
            } else {
                String oldValue = this.getPageCache().get(CK_OLD_VALUE);
                model.beginInit();
                model.setValue("dimconfield", (Object)oldValue);
                model.endInit();
                this.getView().updateView("dimconfield");
            }
        } else if ("continue_close".equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(key) && this.getModel().getDataChanged()) {
            evt.setCancel(true);
            this.showClose();
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("billfield".equals(key)) {
            this.showPropSelectForm();
        }
    }

    private void showPropSelectForm() {
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        String entityNumber = ((DynamicObject)model.getValue("sourcebill", currentRowIndex)).getString("number");
        DynamicObject conField = (DynamicObject)model.getValue("dimconfield");
        String fieldType = conField.getString("fieldtype");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ssc_entitytree");
        showParameter.setCustomParam("entityNumber", (Object)entityNumber);
        showParameter.setCustomParam("conFieldType", (Object)fieldType);
        if (ConFieldTypeEnum.BASE_DATA.getValue().equals(fieldType)) {
            showParameter.setCustomParam("baseDataType", (Object)conField.getString("basedatatype.number"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CB_SELECT_PROP));
        this.getView().showForm(showParameter);
    }

    private void showClose() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillField2ConFieldEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillField2ConFieldEditPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"BillField2ConFieldEditPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillField2ConFieldEditPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        if (CB_SELECT_PROP.equals(actionId)) {
            String number = (String)map.get("number");
            String name = (String)map.get("name");
            int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("billfield", (Object)name, currentRowIndex);
            model.setValue("billfieldnumber", (Object)number, currentRowIndex);
        }
    }

    private void switchEntry(DynamicObject newConField) {
        IDataModel model = this.getModel();
        if (newConField != null) {
            Long conFieldId = newConField.getLong("id");
            this.buildEntryData(conFieldId);
        } else {
            model.deleteEntryData("entryentity");
        }
        model.setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String operateKey = eventArgs.getOperateKey();
        if (OP_CHECK_SAVE.equals(operateKey) && eventArgs.getOperationResult().isSuccess()) {
            if (model.getDataChanged()) {
                String deleteRows = this.getPageCache().get(CK_DELETE_ROW_ID);
                DynamicObjectCollection mappingCol = model.getEntryEntity("entryentity");
                List changedRows = mappingCol.stream().filter(c -> c.getDataEntityState().isBizChanged()).collect(Collectors.toList());
                if (deleteRows != null || changedRows.size() > 0) {
                    long conFieldId = ((DynamicObject)model.getValue("dimconfield")).getLong("id");
                    HashMap<Long, DynamicObject[]> updateData = new HashMap<Long, DynamicObject[]>(changedRows.size());
                    ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(changedRows.size());
                    for (DynamicObject[] changedRow : changedRows) {
                        long id = changedRow.getLong("id");
                        if (id > 0L) {
                            updateData.put(id, changedRow);
                            continue;
                        }
                        DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"ssc_confield_mapping");
                        newData.set("confield", (Object)conFieldId);
                        newData.set("sourcebill", changedRow.get("sourcebill"));
                        newData.set("billfield", changedRow.get("billfield"));
                        newData.set("billfieldnumber", changedRow.get("billfieldnumber"));
                        saveData.add(newData);
                    }
                    if (!updateData.isEmpty()) {
                        DynamicObject[] load;
                        for (DynamicObject row : load = BusinessDataServiceHelper.load((Object[])updateData.keySet().toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_confield_mapping"))) {
                            Long id = row.getLong("id");
                            DynamicObject temp = (DynamicObject)updateData.get(id);
                            if (temp == null) continue;
                            row.set("sourcebill", temp.get("sourcebill"));
                            row.set("billfield", temp.get("billfield"));
                            row.set("billfieldnumber", temp.get("billfieldnumber"));
                            saveData.add(row);
                        }
                    }
                    String deletedCache = this.getPageCache().get(CK_DELETE_ROW_ID);
                    List deleteList = null;
                    if (StringUtils.isNotBlank((CharSequence)deletedCache)) {
                        deleteList = (List)SerializationUtils.fromJsonString((String)deletedCache, List.class);
                    }
                    if (deleteList != null && deleteList.size() > 0) {
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ssc_confield_mapping"), (Object[])deleteList.toArray());
                        this.getPageCache().remove(CK_DELETE_ROW_ID);
                    }
                    if (saveData.size() > 0) {
                        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ssc_confield_mapping", (DynamicObject[])saveData.toArray(new DynamicObject[0]), null);
                        if (!operationResult.isSuccess()) {
                            this.getView().showTipNotification(operationResult.getMessage());
                            return;
                        }
                        model.setDataChanged(false);
                    }
                }
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ConField2BillFieldEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            Object defConField = view.getFormShowParameter().getCustomParam("defConField");
            if (defConField != null) {
                view.returnDataToParent((Object)"success");
                view.close();
            }
        }
    }

    private void buildEntryData(Long conFieldId) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.deleteEntryData("entryentity");
        QFilter fieldFilter = new QFilter("confield", "=", (Object)conFieldId);
        DynamicObjectCollection mappingCol = QueryServiceHelper.query((String)"ssc_confield_mapping", (String)"id,sourcebill,billfield,billfieldnumber", (QFilter[])new QFilter[]{fieldFilter});
        if (mappingCol != null && mappingCol.size() > 0) {
            for (int index : model.batchCreateNewEntryRow("entryentity", mappingCol.size())) {
                DynamicObject mapping = (DynamicObject)mappingCol.get(index);
                model.setValue("id", (Object)mapping.getLong("id"), index);
                model.setValue("sourcebill", (Object)mapping.getString("sourcebill"), index);
                model.setValue("billfield", (Object)mapping.getString("billfield"), index);
                model.setValue("billfieldnumber", (Object)mapping.getString("billfieldnumber"), index);
            }
        }
        view.updateView("entryentity");
    }
}

