/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.util.JSONUtils;
import kd.ssc.task.business.condition.ConFieldTypeEnum;

public class ConditionFieldFormPlugin
extends AbstractBillPlugIn {
    private static final String KEY_COMBO_ITEM = "comboitem";
    private static final String CB_EDIT_CONDITION = "editCondition";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_COMBO_ITEM});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_COMBO_ITEM.equals(key)) {
            this.showConditionEditForm();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object oldValue = valueSet[0].getOldValue();
        Object newValue = valueSet[0].getNewValue();
        if (KEY_COMBO_ITEM.equals(propName)) {
            if (ObjectUtils.isEmpty((Object)newValue)) {
                model.setValue("comboitemjson", null);
                model.setValue("comboitemjson_tag", null);
            }
        } else if ("fieldtype".equals(propName)) {
            if (ConFieldTypeEnum.BASE_DATA.getValue().equals(oldValue)) {
                model.setValue("basedatatype", null);
            } else if (ConFieldTypeEnum.COMBO.getValue().equals(oldValue)) {
                model.setValue(KEY_COMBO_ITEM, null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        IDataModel model = this.getModel();
        Object returnData = event.getReturnData();
        String actionId = event.getActionId();
        if (CB_EDIT_CONDITION.equals(actionId)) {
            if (ObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            String comboJsonStr = this.convertCombo2Json(returnData);
            String comboItemDes = this.getCaptionFromComboJson(comboJsonStr);
            model.setValue(KEY_COMBO_ITEM, (Object)comboItemDes);
            model.setValue("comboitemjson", (Object)comboItemDes);
            model.setValue("comboitemjson_tag", (Object)comboJsonStr);
        }
    }

    public void afterCopyData(EventObject e) {
        this.initData();
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        String type = (String)model.getValue("fieldtype");
        DynamicObject baseDataType = (DynamicObject)model.getValue("basedatatype");
        if (!ConFieldTypeEnum.BASE_DATA.getValue().equals(type) && baseDataType != null) {
            model.setValue("basedatatype", null);
        }
    }

    public void afterLoadData(EventObject e) {
        String enable;
        boolean referenced = BaseDataRefrenceHelper.isRefrenced((String)"ssc_condition_field", (Object)this.getModel().getDataEntity().getPkValue());
        if (referenced) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fieldtype"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"basedatatype"});
        }
        if ("0".equals(enable = (String)this.getModel().getValue("enable"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
        }
        this.initData();
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        JSONObject row = (JSONObject)e.getSourceData();
        String fieldType = row.getString("fieldtype");
        if (ConFieldTypeEnum.BASE_DATA.getValue().equals(fieldType)) {
            JSONObject baseDataType = row.getJSONObject("basedatatype");
            if (ObjectUtils.isEmpty((Object)baseDataType)) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u5f53\u5b57\u6bb5\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\u65f6\uff0c\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5fc5\u5f55\u3002", (String)"ConditionFieldFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if (ConFieldTypeEnum.COMBO.getValue().equals(fieldType)) {
            String comboItem = row.getString(KEY_COMBO_ITEM);
            if (StringUtils.isBlank((CharSequence)comboItem)) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u5f53\u5b57\u6bb5\u7c7b\u578b\u4e3a\u4e0b\u62c9\u5217\u8868\u65f6\uff0c\u4e0b\u62c9\u9879\u5fc5\u5f55\u3002", (String)"ConditionFieldFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                String[] arr = comboItem.split(",");
                ArrayList items = new ArrayList(4);
                HashSet<String> keySet = new HashSet<String>();
                HashSet<String> valueSet = new HashSet<String>();
                for (String s : arr) {
                    String[] pair = s.split(":");
                    if (pair.length != 2) {
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u4e0b\u62c9\u9879\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42\uff0c\u8bf7\u6309\u7167\uff1akey1:value1,key2:value2\u7684\u683c\u5f0f\u7f16\u8f91\u5185\u5bb9\u3002", (String)"ConditionFieldFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        if (items.isEmpty()) break;
                        items = null;
                        break;
                    }
                    String key = pair[0];
                    String value = pair[1];
                    if (key.length() > 50 || value.length() > 50) {
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u4e0b\u62c9\u9879\u7684key\u548cvalue\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"ConditionFieldFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (!keySet.add(key)) {
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u4e0b\u62c9\u9879\u7684key\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ConditionFieldFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (!valueSet.add(value)) {
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u4e0b\u62c9\u9879\u7684value\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ConditionFieldFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    HashMap<String, String> item = new HashMap<String, String>(2);
                    item.put("Value", key);
                    item.put("Caption", value);
                    items.add(item);
                }
                if (e.isCancel()) {
                    return;
                }
                if (items != null && items.size() > 0) {
                    Set captions = items.stream().map(i -> (String)i.get("Caption")).collect(Collectors.toSet());
                    String itemDes = StringUtils.substring((String)String.join((CharSequence)",", captions), (int)0, (int)255);
                    row.put(KEY_COMBO_ITEM, (Object)itemDes);
                    this.getModel().setValue("comboitemjson", (Object)itemDes);
                    HashMap itemMap = new HashMap(1);
                    itemMap.put("items", items);
                    this.getModel().setValue("comboitemjson_tag", (Object)SerializationUtils.toJsonString(itemMap));
                }
            }
        }
    }

    private void initData() {
        IDataModel model = this.getModel();
        model.setValue(KEY_COMBO_ITEM, model.getValue("comboitemjson"));
    }

    private void showConditionEditForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ssc_comboitem");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String comboJson = (String)this.getModel().getValue("comboitemjson_tag");
        showParameter.setCustomParam("value", (Object)comboJson);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CB_EDIT_CONDITION);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public String convertCombo2Json(Object returnData) {
        Map ret = (Map)returnData;
        if (ret == null) {
            return null;
        }
        Object valueJson = ret.get("value");
        if (valueJson == null) {
            return null;
        }
        List map = (List)valueJson;
        HashMap<String, List> reMap = new HashMap<String, List>(1);
        reMap.put("items", map);
        return JSONObject.toJSONString(reMap);
    }

    public String getCaptionFromComboJson(Object fieldPropJSON) {
        if (fieldPropJSON == null || StringUtils.isBlank((CharSequence)fieldPropJSON.toString())) {
            return null;
        }
        List<Map<String, Object>> maps = this.coverJson2List((String)fieldPropJSON);
        if (maps == null) {
            return null;
        }
        String caption = maps.stream().map(item -> item.get("Caption").toString()).collect(Collectors.joining(","));
        return StringUtils.substring((String)caption, (int)0, (int)255);
    }

    private List<Map<String, Object>> coverJson2List(String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        if (jsonObject == null) {
            return null;
        }
        Object value = jsonObject.get((Object)"items");
        List remap = null;
        if (value != null) {
            try {
                remap = (List)JSONUtils.cast((String)value.toString(), List.class);
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("IOException", e.getMessage()), new Object[0]);
            }
        }
        return remap;
    }
}

