/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.formula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;

public class FormulaConfigF7Formplugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("save".equals(key)) {
            FormShowParameter paramter = this.getView().getFormShowParameter();
            String taskBill = (String)paramter.getCustomParam("taskBill");
            FilterCondition filterCondition = this.getFilterCondition("filtergridap");
            FilterBuilder filterBuilder = this.getFilterBuilder(taskBill, filterCondition);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("filter", filterBuilder.getFilterObject().getFilter());
            map.put("filterCondition", SerializationUtils.toJsonString((Object)filterCondition));
            map.put("billentity", taskBill);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private FilterCondition getFilterCondition(String controlKey) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(controlKey);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        return filterCondition;
    }

    private FilterBuilder getFilterBuilder(String entityNumber, FilterCondition filterCondition) {
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, false);
        filterBuilder.buildFilter(true);
        return filterBuilder;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.createFilterGrid(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String json = (String)paramter.getCustomParam("json");
        this.setFilterCondition("filtergridap", json);
    }

    private void setFilterCondition(String controlKey, String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(controlKey);
        FilterCondition fc2 = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
        filterGrid.SetValue(fc2);
    }

    public void createFilterGrid(EventObject e) {
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String taskBill = (String)paramter.getCustomParam("taskBill");
        if (taskBill != null) {
            this.filterGridSetFieldColumns("filtergridap", taskBill, null, true);
        }
    }

    private void filterGridSetFieldColumns(String controlKey, String entityNumber, List<String> fieldNames, boolean isAddedBtn) {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        FilterGrid filterGrid = (FilterGrid)this.getControl(controlKey);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        filterGrid.setEntityNumber(entityType.getName());
        if (fieldNames == null || fieldNames.size() == 0) {
            List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setFilterColumns(filterColumns);
        } else {
            ArrayList<Map> filterColumns = new ArrayList<Map>(10);
            for (String fieldName : fieldNames) {
                FilterField filterField = FilterField.create((MainEntityType)entityType, (String)fieldName);
                Map filterColumn = filterField.createFilterColumn();
                filterColumns.add(filterColumn);
            }
            filterGrid.setFilterColumns(filterColumns);
        }
        if (!isAddedBtn) {
            filterGrid.setBtnStatus();
        }
    }
}

