/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.formula;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.formula.TaskFormulaEngine;

public class FormulaEngineFormplugin
extends AbstractFormPlugin {
    private static final String RULE = "rule";
    private static final String BIZ_BILL = "taskbizbill";
    private static final String Q_FILTER = "qfilter";
    private static final String FILTER_S = "filters";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        TextEdit source = (TextEdit)this.getControl(RULE);
        source.addButtonClickListener((ClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String billId;
        String filterjson;
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        DynamicObject billType = (DynamicObject)model.getValue(BIZ_BILL);
        if (billType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u3002", (String)"DisRuleFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String bill = this.getTaskBill(billType);
        if ("rule_sql_btn".equals(key)) {
            filterjson = (String)model.getValue("filterjson_tag");
            QFilter qFilter = this.getBillFilter(bill, filterjson);
            filterjson = filterjson.substring(0, Integer.min(2000, filterjson.length()));
            model.setValue(FILTER_S, (Object)filterjson);
            model.setValue(Q_FILTER, (Object)qFilter);
        }
        if ("rule_match_btn".equals(key)) {
            filterjson = (String)model.getValue("filterjson_tag");
            billId = (String)model.getValue("billid");
            QFilter qFilter = this.getBillFilter(bill, filterjson);
            if (qFilter != null) {
                QFilter idFilters;
                long billId_l = 0L;
                try {
                    billId_l = Long.parseLong(billId);
                    idFilters = new QFilter("id", "=", (Object)billId_l);
                }
                catch (NumberFormatException e) {
                    idFilters = new QFilter("id", "=", (Object)billId);
                }
                qFilter.and(idFilters);
                DynamicObject[] exist = BusinessDataServiceHelper.load((String)bill, (String)"id", (QFilter[])qFilter.toArray());
                if (exist != null && exist.length > 0) {
                    this.getView().showSuccessNotification("This bill exist");
                } else {
                    this.getView().showErrorNotification("This bill does not exist");
                }
            }
        }
        if ("rule_engin_match_btn".equals(key)) {
            filterjson = (String)model.getValue("filterjson_tag");
            billId = (String)model.getValue("billid");
            Boolean result = TaskFormulaEngine.fastMatchByEngine((String)billId, (String)filterjson, (String)bill);
            if ("true".equals(result + "")) {
                this.getView().showSuccessNotification("This bill exist");
            } else {
                this.getView().showErrorNotification("This bill does not exist");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (RULE.equals(key)) {
            IDataModel model = this.getModel();
            DynamicObject billType = (DynamicObject)model.getValue(BIZ_BILL);
            if (billType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u3002", (String)"DisRuleFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String bill = this.getTaskBill(billType);
            this.showBillFilter(bill);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event == null || event.getReturnData() == null) {
            return;
        }
        String eKey = event.getActionId();
        if ("filterrule".equals(eKey)) {
            Map ret = (Map)event.getReturnData();
            this.setRule(ret);
        }
    }

    private boolean setRule(Map<String, Object> map) {
        String filter = (String)map.get("filter");
        String filterCondition = (String)map.get("filterCondition");
        String bill = (String)map.get("billentity");
        IDataModel model = this.getModel();
        model.setValue(RULE, (Object)filter);
        model.setValue("filterjson_tag", (Object)filterCondition);
        QFilter qFilter = this.getBillFilter(bill, filterCondition);
        filterCondition = filterCondition.substring(0, Integer.min(2000, filterCondition.length()));
        model.setValue(FILTER_S, (Object)filterCondition);
        model.setValue(Q_FILTER, (Object)qFilter);
        return true;
    }

    private QFilter getBillFilter(String metaNum, String filterrulejson) {
        QFilter billruleFilter = null;
        FilterObject filterObject = this.getBillFilterObject(metaNum, filterrulejson);
        if (filterObject != null) {
            billruleFilter = filterObject.getQFilter();
        }
        return billruleFilter;
    }

    private FilterObject getBillFilterObject(String metaNum, String filterrulejson) {
        FilterObject obj = null;
        if (!StringUtils.isBlank((String)filterrulejson)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)filterrulejson, FilterCondition.class);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)metaNum);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, fc);
            filterBuilder.buildFilter(false);
            obj = filterBuilder.getFilterObject();
        }
        return obj;
    }

    private void showBillFilter(String taskBill) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_rule_config");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCustomParam("taskBill", (Object)taskBill);
        showParameter.setCustomParam("json", this.getModel().getValue("filterjson_tag"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "filterrule");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private String getTaskBill(DynamicObject billType) {
        Object id = billType.getPkValue();
        QFilter qf = new QFilter("id", "=", id);
        DynamicObject dycBindBill = BusinessDataServiceHelper.loadSingle((String)"task_taskbill", (String)"bindbill", (QFilter[])new QFilter[]{qf});
        if (dycBindBill == null) {
            return "";
        }
        return dycBindBill.getString("bindbill.number");
    }
}

