/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class TaskAbstractListPlugin
extends AbstractListPlugin {
    public static final String PRO_CREATEORG = "createOrg";
    public static final String VERIFYORG = "verifyOrg";
    public static final String NOT_FIRST_TIME_OPEN = "key";
    private static final String IMICDIMENSION_BOS_ORG = "imicdimension_bos_org";

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void initialize() {
        super.initialize();
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam(IMICDIMENSION_BOS_ORG);
        if (StringUtils.isEmpty((String)orgId)) {
            return;
        }
        this.getPageCache().put(PRO_CREATEORG, orgId);
        this.getPageCache().put(VERIFYORG, orgId);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        boolean isFirstTimeOpenFromInitPage = this.isFirstTimeOpenFromInitPage();
        if (isFirstTimeOpenFromInitPage) {
            String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscId");
            List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                String name = filterColumn.getFieldName();
                if (!name.equals("orgfield.name") && !name.equals("useorg.id") && !name.contains("ssccenter")) continue;
                filterColumn.setDefaultValue(sscId);
                this.changeFilterCache(sscId);
                break;
            }
            this.getPageCache().put("sscid", sscId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isFirstTimeOpenFromInitPage()) {
            if ("1".equals(this.getView().getFormShowParameter().getCustomParams().get("invokeExport"))) {
                if ("task_taskbill".equals(this.getView().getFormShowParameter().getCustomParam("billFormId"))) {
                    this.getView().invokeOperation("taskexporttaskbill");
                } else {
                    this.getView().invokeOperation("exportlist");
                }
            }
            this.getPageCache().put(NOT_FIRST_TIME_OPEN, "1");
        }
    }

    private boolean isFirstTimeOpenFromInitPage() {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam(IMICDIMENSION_BOS_ORG);
        if (StringUtils.isNotEmpty((String)orgId)) {
            this.getView().getFormShowParameter().setCustomParam("sscId", (Object)orgId);
        }
        return this.getView().getFormShowParameter().getCustomParam("sscId") != null && !this.getPageCache().getAll().containsKey(NOT_FIRST_TIME_OPEN);
    }

    private void changeFilterCache(String sscId) {
        String filterStr = this.getPageCache().get("customfilter");
        if (StringUtils.isNotEmpty((String)filterStr)) {
            List customFilterArray = (List)SerializationUtils.fromJsonString((String)filterStr, ArrayList.class);
            for (Map customFilter : customFilterArray) {
                List fieldNames = (List)customFilter.get("FieldName");
                if (CollectionUtils.isEmpty((Collection)fieldNames) || !"useorg.id".equals(fieldNames.get(0))) continue;
                customFilter.put("Value", Collections.singletonList(sscId));
            }
            this.getPageCache().put("customfilter", SerializationUtils.toJsonString((Object)customFilterArray));
        }
    }
}

