/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.imports;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.common.DisRuleDataSyncHelper;
import kd.ssc.task.formplugin.TaskRule4ImptEditPlugin;
import kd.ssc.task.formplugin.imports.TaskImportHelper;
import kd.ssc.task.partask.analyzation.ParTaskFlowAnaFromBill;

public class TaskBatchImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(TaskRule4ImptEditPlugin.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        String sscNumber = SscDistributeCache.get((String)"sscNumber");
        TaskImportHelper.invalidSsc4PerBill(billdatas, logger, sscNumber);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult = super.save(rowdatas, logger);
        if ("task_disrule".equals(this.ctx.getBillFormId()) && apiResult.getData() != null) {
            List ids = ((ArrayList)apiResult.getData()).stream().map(e -> (Long)e.get("id")).collect(Collectors.toList());
            DisRuleDataSyncHelper disRuleDataSyncHelper = new DisRuleDataSyncHelper();
            disRuleDataSyncHelper.keepDataSync(new QFilter("id", "in", ids));
        }
        if ("task_taskbill4impt".equals(this.ctx.getBillFormId()) && apiResult.getData() != null) {
            HashSet<String> sucNumbers = new HashSet<String>();
            ArrayList data = (ArrayList)apiResult.getData();
            ArrayList bill4ImportIds = new ArrayList();
            for (HashMap map : data) {
                if (!((Boolean)map.get("success")).booleanValue() && !map.containsKey("id")) continue;
                bill4ImportIds.add(map.get("id"));
                sucNumbers.add(map.get("number").toString());
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.saveTaskBill(rowdatas, sucNumbers);
                    DeleteServiceHelper.delete((String)"task_taskbill4impt", (QFilter[])new QFilter("id", "in", bill4ImportIds).toArray());
                }
                catch (Exception e2) {
                    h.markRollback();
                    log.error("Error on saving real taskbill data", (Throwable)e2);
                    throw e2;
                }
            }
        }
        return apiResult;
    }

    private void saveTaskBill(List<ImportBillData> rowDataList, HashSet<String> sucNumbers) {
        if (sucNumbers.isEmpty()) {
            return;
        }
        Long sscId = 0L;
        HashSet<Long> parTaskBillIds = new HashSet<Long>();
        HashMap<Long, Long[]> billId2ChildIds = new HashMap<Long, Long[]>();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_taskbill");
        Long[] sequences = this.generateSequence(sucNumbers.size());
        int seqIndex = 0;
        ArrayList<DynamicObject> taskBillList = new ArrayList<DynamicObject>(sucNumbers.size());
        ArrayList<DynamicObject> taskBillChildList = new ArrayList<DynamicObject>();
        Map<String, JSONObject> number2Row = rowDataList.stream().collect(Collectors.toMap(k -> k.getData().getString("number"), ImportBillData::getData));
        for (String number : sucNumbers) {
            DynamicObject curEntry;
            JSONObject entry;
            JSONObject curRow = number2Row.get(number);
            Long curId = sequences[seqIndex++];
            DynamicObject taskBill = new DynamicObject((DynamicObjectType)type, (Object)curId);
            taskBill.set("masterid", (Object)taskBill.getLong("id"));
            taskBill.set("number", (Object)curRow.getString("number"));
            taskBill.set("name", curRow.get((Object)"name"));
            taskBill.set("status", (Object)"C");
            taskBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            taskBill.set("enable", (Object)"1");
            sscId = curRow.getJSONObject("ssccenter").getLong("id");
            taskBill.set("ssccenter", (Object)sscId);
            taskBill.set("externalerp", (Object)curRow.getJSONObject("externalerp").getLong("id"));
            taskBill.set("description", (Object)curRow.getString("description"));
            taskBill.set("bindbill", (Object)curRow.getJSONObject("bindbill").getString("id"));
            taskBill.set("isembed", (Object)curRow.getBoolean("isembed"));
            taskBill.set("isneedimage", (Object)curRow.getBoolean("isneedimage"));
            taskBill.set("uselang", (Object)ResManager.getLanguage());
            taskBill.set("effective", (Object)"1");
            taskBill.set("autosynorg", (Object)"0");
            taskBill.set("createtaskmodel", (Object)curRow.getString("createtaskmodel"));
            taskBill.set("group", (Object)curRow.getJSONObject("group").getLong("id"));
            JSONObject taskPoolJson = curRow.getJSONObject("taskpool");
            taskBill.set("taskpool", taskPoolJson != null ? taskPoolJson.getLong("id") : null);
            JSONObject applyCondJson = curRow.getJSONObject("applycond");
            taskBill.set("applycond", applyCondJson != null ? applyCondJson.getLong("id") : null);
            taskBill.set("isuseimage", (Object)curRow.getString("isuseimage"));
            DynamicObjectCollection orgCol = taskBill.getDynamicObjectCollection("sscbillorgpar");
            ArrayList orgIds = (ArrayList)curRow.get((Object)"orgCollection");
            for (Long id : orgIds) {
                DynamicObject dynamicObject = orgCol.addNew();
                dynamicObject.set("fbasedataid", (Object)id);
            }
            DynamicObjectCollection collection = taskBill.getDynamicObjectCollection("entryentityfield");
            JSONArray fieldEntity = curRow.getJSONArray("entryentityfield");
            for (int i = 0; i < fieldEntity.size(); ++i) {
                entry = fieldEntity.getJSONObject(i);
                curEntry = collection.addNew();
                curEntry.set("seq", (Object)(i + 1));
                curEntry.set("fieldconfiguration", (Object)entry.getString("fieldconfiguration"));
                curEntry.set("sourcefieldname", (Object)entry.getString("sourcefieldname"));
                curEntry.set("sourcefieldnumber", (Object)entry.getString("sourcefieldnumber"));
            }
            MainEntityType childType = EntityMetadataCache.getDataEntityType((String)"task_taskbill_child");
            collection = taskBill.getDynamicObjectCollection("entryentity");
            JSONArray taskChildEntity = curRow.getJSONArray("childbillentryentity");
            Long[] sequence = this.generateSequence(taskChildEntity.size());
            billId2ChildIds.put(curId, sequence);
            for (int i = 0; i < taskChildEntity.size(); ++i) {
                Long curChildId = sequence[i];
                entry = taskChildEntity.getJSONObject(i);
                DynamicObject childEntry = new DynamicObject((DynamicObjectType)childType, (Object)curChildId);
                childEntry.set("tasktype", (Object)entry.getJSONObject("tasktype").getLong("id"));
                childEntry.set("taskoriginal", (Object)entry.getString("taskoriginal"));
                childEntry.set("nexttasks", (Object)entry.getString("nexttasks"));
                childEntry.set("issame", (Object)entry.getBoolean("issame"));
                childEntry.set("childssc", (Object)taskBill.getLong("ssccenter"));
                childEntry.set("taskcount", (Object)1000);
                childEntry.set("taskhour", (Object)4);
                DynamicObjectCollection levelEntity = childEntry.getDynamicObjectCollection("entryentitylevel");
                DynamicObject obj = levelEntity.addNew();
                obj.set("priority", (Object)1);
                obj.set("timeliness", (Object)4);
                obj = levelEntity.addNew();
                obj.set("priority", (Object)2);
                obj.set("timeliness", (Object)48);
                this.fillMulF7Data(entry, childEntry);
                taskBillChildList.add(childEntry);
                curEntry = collection.addNew();
                curEntry.set("seq", (Object)(i + 1));
                curEntry.set("childpkid", (Object)curChildId);
                curEntry.set("tasktype", (Object)childEntry.getLong("tasktype"));
            }
            if (curRow.get((Object)"isParTaskBill") != null) {
                parTaskBillIds.add(taskBill.getLong("id"));
            }
            taskBillList.add(taskBill);
        }
        Object[] taskBills = SaveServiceHelper.save((DynamicObject[])taskBillList.toArray(new DynamicObject[0]));
        Object[] childTaskBills = SaveServiceHelper.save((DynamicObject[])taskBillChildList.toArray(new DynamicObject[0]));
        Set<Long> sucBillIds = Arrays.stream((DynamicObject[])taskBills).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
        if (!sucBillIds.isEmpty() && !parTaskBillIds.isEmpty()) {
            this.saveParTaskFlowDef(sscId, parTaskBillIds, sucBillIds, billId2ChildIds);
        }
    }

    private void saveParTaskFlowDef(Long sscId, HashSet<Long> parTaskBillIds, Set<Long> sucBillIds, HashMap<Long, Long[]> billId2ChildIds) {
        parTaskBillIds.removeIf(id -> !sucBillIds.contains(id));
        for (Long parTaskBillId : parTaskBillIds) {
            List childPkIds = Arrays.stream((Object[])billId2ChildIds.get(parTaskBillId)).collect(Collectors.toList());
            ParTaskFlowAnaFromBill.saveParTaskFlowDef((Object)sscId, (Object)parTaskBillId, childPkIds);
        }
    }

    private Long[] generateSequence(int count) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_taskbill");
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        return (Long[])seqReader.getSequences((Object[])new Long[0], type.getAlias(), count);
    }

    private void fillMulF7Data(JSONObject entry, DynamicObject childEntry) {
        DynamicObject dynamicObject;
        if (entry.containsKey((Object)"preTaskCollection")) {
            DynamicObjectCollection col = childEntry.getDynamicObjectCollection("pretasks");
            ArrayList ids = (ArrayList)entry.get((Object)"preTaskCollection");
            for (Long id : ids) {
                dynamicObject = col.addNew();
                dynamicObject.set("fbasedataid", (Object)id);
            }
        }
        if (entry.containsKey((Object)"insightSchemaCollection")) {
            DynamicObjectCollection col1 = childEntry.getDynamicObjectCollection("datainsightschema");
            ArrayList ids1 = (ArrayList)entry.get((Object)"insightSchemaCollection");
            for (Long id : ids1) {
                dynamicObject = col1.addNew();
                dynamicObject.set("fbasedataid", (Object)id);
            }
        }
        if (entry.containsKey((Object)"checkPointCollection")) {
            ArrayList ids2 = (ArrayList)entry.get((Object)"checkPointCollection");
            DynamicObjectCollection checkEntity = childEntry.getDynamicObjectCollection("entryentityarticheck");
            for (Long id : ids2) {
                DynamicObject obj = checkEntity.addNew();
                obj.set("articheck", (Object)id);
            }
        }
    }
}

