/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.imports;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.form.plugin.ImportStartPlugin;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.cache.SscDistributeCache;

public class TaskImportStartPlugin
extends ImportStartPlugin {
    private static final String IMPORTTYPE = "importtype";
    private static final String FILEPATH = "filepath";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ImportStartData.getInstance((AbstractFormPlugin)this, importStartData -> {
            String billFormId = importStartData.getCustomParamData().getBillFormId();
            if ("task_checkpoint".equalsIgnoreCase(billFormId) || "task_withdrawal".equalsIgnoreCase(billFormId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"radiofield1", "radiofield2", "keyfields"});
                this.init((ImportStartData)importStartData);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield1", "radiofield2", "keyfields"});
            }
        });
    }

    private void init(ImportStartData importStartData) {
        List keyfieldItems = importStartData.getKeyfieldItems();
        if (!keyfieldItems.isEmpty()) {
            ArrayList<ComboItem> fieldItems = new ArrayList<ComboItem>(2);
            for (ComboItem com : keyfieldItems) {
                if (!com.getValue().equals("number") && !com.getValue().equals("name")) continue;
                fieldItems.add(com);
            }
            ComboEdit combo = (ComboEdit)this.getControl("keyfields");
            combo.setComboItems(fieldItems);
        }
    }

    private void importData(String url) {
        ImportStartData.getInstance((AbstractFormPlugin)this, importStartData -> {
            IFormView view = this.getView();
            FormShowParameter showParam = view.getFormShowParameter();
            Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)importStartData.getCustomParamData().getBillFormId()).getEntityTypeId());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_importing");
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String importType = (String)this.getModel().getValue(IMPORTTYPE);
            params.put("Type", importType);
            if (!"new".equals(importType)) {
                params.put("KeyFields", (String)this.getModel().getValue("keyfields"));
                if ("override".equals(importType)) {
                    params.put("ForUpdateMultiLangFields", view.getPageCache().get("ForUpdateMultiLangFields"));
                }
                params.put("OverrideEntry", view.getPageCache().get("OverrideEntry"));
            }
            SscDistributeCache.put((String)"sscNumber", (Object)showParam.getCustomParam("sscNumber"));
            params.put("SetNULL", view.getPageCache().get("SetNULL"));
            params.put("ServiceAppId", importStartData.getCustomParamData().getServiceAppId());
            params.put("CheckRightAppId", importStartData.getCustomParamData().getCheckrightappid());
            params.put("BillFormId", importStartData.getCustomParamData().getBillFormId());
            params.put("ListName", importStartData.getCustomParamData().getListName());
            params.put("OpSave", ops.getSave());
            params.put("Url", url);
            params.put("ImportPlugin", this.getImportPlugin(showParam));
            params.put("OperateKey", showParam.getCustomParam("OperateKey"));
            params.put("OperateName", showParam.getCustomParam("OperateName"));
            params.put("RealPermissionEntityId", showParam.getCustomParam("RealPermissionEntityId"));
            params.put("PermissionItemId", showParam.getCustomParam("PermissionItemId"));
            params.put("MainOrgIds", showParam.getCustomParam("MainOrgIds"));
            showParameter.setCustomParams(params);
            showParameter.setParentPageId(showParam.getParentPageId());
            showParameter.setCloseCallBack(showParam.getCloseCallBack());
            view.showForm(showParameter);
        });
    }

    public void click(EventObject evt) {
        FormShowParameter currShowParameter;
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            FormShowParameter currShowParameter2 = this.getView().getFormShowParameter();
            OperationResult result = new OperationResult();
            String orgIdsStr = (String)currShowParameter2.getCustomParam("MainOrgIds");
            ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter2.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter2.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter2.getCustomParam("BillFormId")).setOperateName((String)currShowParameter2.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter2.getCustomParam("PermissionItemId")).setResult(result);
            try {
                if (!this.validatePermission(importPermissionParamBuidler.build())) {
                    this.doFailCheckRight(result);
                    this.createNoPermissionOperationLog(result);
                    return;
                }
                String url = this.checkAndReturnUrl();
                if (this.checkToImportNow()) {
                    this.importData(url);
                }
                this.createOperationLogByStart(true);
            }
            catch (KDBizException e) {
                this.createOperationLogByStart(false);
                this.getView().showErrorNotification(e.getMessage());
            }
            return;
        }
        if ("btndownload".equals(key) && "task_taskbill4impt".equals((currShowParameter = this.getView().getFormShowParameter()).getCustomParam("BillFormId"))) {
            this.downloadTemplate4TaskBill();
            return;
        }
        super.click(evt);
    }

    private void downloadTemplate4TaskBill() {
        String billFormId = "task_taskbill4impt";
        long templateId = 1465052565409675264L;
        LocalDate now = LocalDate.now();
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((String)"bos_importtemplate", (String)"name", (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
        if (templateData == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9884\u7f6e\u7684\u4e1a\u52a1\u5355\u636e\u5bfc\u5165\u6a21\u677f\u3002", (String)"TaskImportStartPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String fileName = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_%s", (String)"TaskImportStartPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), templateData.get("name"));
        fileName = fileName.replaceAll(" ", "_");
        fileName = fileName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth());
        List<ExportWriterFormat> formats = this.loadExportFormat(billFormId, templateId);
        ListDataExporter exporter = new ListDataExporter("sheet1", formats, false);
        String url = exporter.flush(fileName, 60);
        this.getView().download(url);
    }

    private List<ExportWriterFormat> loadExportFormat(String entityNumber, long templateId) {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(entityNumber, templateId, null, null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        return formats;
    }

    private void createNoPermissionOperationLog(OperationResult result) {
        List errList = result.getValidateResult().getValidateErrors();
        StringBuilder sb = new StringBuilder();
        for (ValidateResult errResult : errList) {
            for (IOperateInfo errInfo : errResult.getAllErrorInfo()) {
                sb.append(errInfo.getMessage());
            }
        }
        String errorTips = sb.toString();
        ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.IMPORT_NOPERMISSION_FAIL.getOpName(), errorTips);
    }

    private String checkAndReturnUrl() {
        String url = (String)this.getModel().getValue(FILEPATH);
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"TaskImportStartPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        if (!"new".equals(this.getModel().getValue(IMPORTTYPE)) && StringUtils.isBlank((Object)this.getModel().getValue("keyfields"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u89c4\u5219\u3002", (String)"TaskImportStartPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return url;
    }

    private boolean checkToImportNow() {
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        IPageCache cache = this.getView().getPageCache();
        String importtype = (String)this.getModel().getValue(IMPORTTYPE);
        String entryHasNoId = cache.get("EntryHasNoId");
        boolean overrideEntry = Boolean.parseBoolean(cache.get("OverrideEntry"));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)currShowParameter.getCustomParam("BillFormId")));
        if (!StringUtils.equals((CharSequence)"new", (CharSequence)importtype) && (overrideEntry || StringUtils.isNotBlank((CharSequence)entryHasNoId)) && !(entityType instanceof QueryEntityType)) {
            String msg = overrideEntry ? ResManager.loadKDString((String)"\u5df2\u5f00\u542f #OverrideEntry \u5173\u952e\u5b57\uff0c\u66f4\u65b0\u6a21\u5f0f\u4e0b\uff0c\u5339\u914d\u5230\u7684\u5355\u636e\u5c06\u8986\u76d6\u6240\u6709\u5206\u5f55\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"TaskImportStartPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6a21\u5f0f\u4e0b\uff0c\u7531\u4e8e\u5bfc\u5165\u6a21\u677f\u7684%s\u5b9e\u4f53\u4e0d\u5305\u542b\u5206\u5f55id\uff0c\u5c06\u6267\u884c\u5206\u5f55\u65b0\u589e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"TaskImportStartPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), entryHasNoId);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("ImportConfirmCallBack", (IConfirmCallBack)this));
            return false;
        }
        return true;
    }

    private void createOperationLogByStart(boolean status) {
        if (status) {
            ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.IMPORT_START_SUCCESS.getOpName(), ImportOperationLog.OperationEnum.IMPORT_START_SUCCESS.getOpDescFormat());
            return;
        }
        ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.IMPORT_START_FAIL.getOpName(), ImportOperationLog.OperationEnum.IMPORT_START_FAIL.getOpDescFormat());
    }

    private String getImportPlugin(FormShowParameter showParam) {
        List plugins;
        String pluginName = (String)showParam.getCustomParam("ImportPlugin");
        if (StringUtils.isBlank((CharSequence)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                return (String)p.get("ClassName");
            }
        }
        return pluginName;
    }
}

