/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.util.StringUtils;
import kd.ssc.enums.indicators.DateRangeEnum;
import kd.ssc.enums.indicators.DimensionStatisticalEnum;
import kd.ssc.enums.indicators.IndicatorsTypeEnum;

public class IndicatorsFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CAL_FORMULA = "calformula";
    private static final String BIZ_OBJECT = "bizobject";
    private static final String INDICATORS_TYPE = "indicatorstype";
    private static final String DIMENSION_MAPPING = "dimensionmapping";
    private static final String DATE_MAPPING = "datemapping";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String bizNumber = ((DynamicObject)this.getModel().getValue(BIZ_OBJECT)).getString("number");
        this.buildDateTimeCombo(bizNumber);
    }

    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        String indicatorsType = (String)this.getModel().getValue(INDICATORS_TYPE);
        if (StringUtils.isNotEmpty((String)indicatorsType)) {
            if (IndicatorsTypeEnum.COMPOSITE.getType().equals(indicatorsType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"condition", "dimensionsetting", BIZ_OBJECT});
            } else if (IndicatorsTypeEnum.MANUAL.getType().equals(indicatorsType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"condition", "dimensionsetting", "formula", BIZ_OBJECT});
            } else if (IndicatorsTypeEnum.BASE.getType().equals(indicatorsType)) {
                String dateType = (String)this.getModel().getValue("datetype");
                if (dateType.equals(DateRangeEnum.CUSTOM.getType())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"daterange"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"daterange"});
                }
                String bizNumber = ((DynamicObject)this.getModel().getValue(BIZ_OBJECT)).getString("number");
                this.initBizObjectAndMapping(bizNumber);
            }
        }
        if (OperationStatus.EDIT == (status = this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"monitortype", INDICATORS_TYPE, "unit", BIZ_OBJECT, DATE_MAPPING, "datetype", "datebegin", "dateend", DIMENSION_MAPPING, "dimensionstatistical", "number"});
        } else if (OperationStatus.ADDNEW == status) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"monitortype", INDICATORS_TYPE, "unit", BIZ_OBJECT, DATE_MAPPING, "datetype", "datebegin", "dateend", DIMENSION_MAPPING, "dimensionstatistical", "number"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save || source instanceof SaveAndNew) {
            String number = (String)this.getModel().getValue("number");
            this.getModel().setValue("number", (Object)number.toLowerCase());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CAL_FORMULA, DATE_MAPPING, DIMENSION_MAPPING});
        BasedataEdit bizObject = (BasedataEdit)this.getControl(BIZ_OBJECT);
        bizObject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (CAL_FORMULA.equals(key)) {
            String indicatorsType = (String)this.getModel().getValue(INDICATORS_TYPE);
            if (indicatorsType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u7c7b\u578b\u3002", (String)"IndicatorsFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            if (IndicatorsTypeEnum.BASE.getType().equals(indicatorsType)) {
                DynamicObject bizObject = (DynamicObject)this.getModel().getValue(BIZ_OBJECT);
                if (bizObject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"IndicatorsFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                String bizNumber = bizObject.getString("number");
                this.showCalFormula(bizNumber);
            } else if (IndicatorsTypeEnum.COMPOSITE.getType().equals(indicatorsType)) {
                this.showCompositeFormula();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        Object newValue = changeSet[0].getNewValue();
        if (INDICATORS_TYPE.equals(propertyName)) {
            String indicatorsType = (String)newValue;
            this.adjustViewByIndicatorsType(indicatorsType);
        } else if (BIZ_OBJECT.equals(propertyName)) {
            DynamicObject bizObject = (DynamicObject)newValue;
            String number = bizObject.getString("number");
            this.buildDateTimeCombo(number);
            String dimensionStatistical = (String)this.getModel().getValue("dimensionstatistical");
            this.buildDimensionCombo(number, dimensionStatistical);
            this.clearSelectedData();
        } else if ("dimensionstatistical".equals(propertyName)) {
            String dimensionStatistical = (String)newValue;
            DynamicObject bizObject = (DynamicObject)this.getModel().getValue(BIZ_OBJECT);
            if (bizObject != null) {
                String number = bizObject.getString("number");
                this.buildDimensionCombo(number, dimensionStatistical);
                this.getModel().setValue(DIMENSION_MAPPING, null);
            }
        } else if ("datetype".equals(propertyName)) {
            String dateType = (String)newValue;
            if (DateRangeEnum.CUSTOM.getType().equals(dateType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"daterange"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"daterange"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("save".equals(operationKey) && operationResult.isSuccess()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    private void adjustViewByIndicatorsType(String indicatorsTypeId) {
        if (IndicatorsTypeEnum.BASE.getType().equals(indicatorsTypeId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"condition", "dimensionsetting", "formula", BIZ_OBJECT});
            this.getModel().setValue(CAL_FORMULA, null);
            this.getModel().setValue("calformulajson", null);
        } else if (IndicatorsTypeEnum.COMPOSITE.getType().equals(indicatorsTypeId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"condition", "dimensionsetting", BIZ_OBJECT});
            this.getView().setVisible(Boolean.TRUE, new String[]{"formula"});
            this.clearConditionAndFormula();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"condition", "dimensionsetting", "formula", BIZ_OBJECT});
            this.clearConditionAndFormula();
        }
    }

    private void clearConditionAndFormula() {
        this.getModel().setValue(DATE_MAPPING, null);
        this.getModel().setValue("datetype", null);
        this.getModel().setValue("datebegin", null);
        this.getModel().setValue("dateend", null);
        this.getModel().setValue("dimensionstatistical", null);
        this.getModel().setValue(DIMENSION_MAPPING, null);
        this.getModel().setValue(CAL_FORMULA, null);
        this.getModel().setValue("calformulajson", null);
    }

    private void showCalFormula(String bizNumber) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u57fa\u7840\u6307\u6807\u8868\u8fbe\u5f0f", (String)"IndicatorsFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        formShowParameter.setFormId("base_formula");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("formula", this.getModel().getValue("calformulajson"));
        params.put("bizNumber", bizNumber);
        params.put("treenodes", SerializationUtils.toJsonString((Object)this.createTreeNodeByEntityNumber(bizNumber)));
        params.put("openstatus", this.getView().getFormShowParameter().getStatus());
        formShowParameter.setCustomParams(params);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "indicatorsFormula"));
        this.getView().showForm(formShowParameter);
    }

    private void showCompositeFormula() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u590d\u5408\u6307\u6807\u8868\u8fbe\u5f0f", (String)"IndicatorsFormPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW) {
            String number = (String)this.getModel().getValue("number");
            formShowParameter.setCustomParam("number", (Object)number);
        }
        formShowParameter.setFormId("composite_formula");
        formShowParameter.setCustomParam("formula", this.getModel().getValue("calformulajson"));
        formShowParameter.setCustomParam("openstatus", (Object)this.getView().getFormShowParameter().getStatus());
        String sscId = String.valueOf(((DynamicObject)this.getModel().getValue("createorg")).getString("id"));
        formShowParameter.setCustomParam("sscId", (Object)sscId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "compositeFormula"));
        this.getView().showForm(formShowParameter);
    }

    private TreeNode createTreeNodeByEntityNumber(String number) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)number);
        PropTreeBuildOption propTreeBuildOption = new PropTreeBuildOption();
        propTreeBuildOption.setOnlyPhysicsField(true);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)propTreeBuildOption);
        treeNode.setIsOpened(true);
        return treeNode;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String formulaJson = null;
        if ("indicatorsFormula".equals(actionId)) {
            formulaJson = (String)closedCallBackEvent.getReturnData();
        } else if ("compositeFormula".equals(actionId)) {
            JSONObject jsonObject = (JSONObject)closedCallBackEvent.getReturnData();
            if (jsonObject == null) {
                return;
            }
            formulaJson = (String)jsonObject.get((Object)"formula");
        }
        if (StringUtils.isNotEmpty((String)formulaJson)) {
            CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            this.getModel().setValue("calformulajson", (Object)formulaJson);
            String localeExprDesc = crFormula.getExprDesc();
            if (StringUtils.isEmpty((String)localeExprDesc)) {
                localeExprDesc = crFormula.getLocaleExprTran().getLocaleValue();
            }
            localeExprDesc = localeExprDesc.length() > 50 ? localeExprDesc.substring(0, 50) : localeExprDesc;
            this.getModel().setValue(CAL_FORMULA, (Object)localeExprDesc);
        }
    }

    private void buildDimensionCombo(String number, String type) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)number);
        DataEntityPropertyCollection properties = entityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(properties.size());
        List propertyList = properties.stream().collect(Collectors.toList());
        propertyList = DimensionStatisticalEnum.USER.getValue().equals(type) ? propertyList.stream().filter(p -> {
            if (p instanceof UserProp) {
                return true;
            }
            if (p instanceof BasedataProp) {
                BasedataProp baseDataProp = (BasedataProp)p;
                return "bos_user".equals(baseDataProp.getBaseEntityId());
            }
            return false;
        }).collect(Collectors.toList()) : (DimensionStatisticalEnum.SSC.getValue().equals(type) ? propertyList.stream().filter(p -> {
            if (p instanceof OrgProp) {
                return true;
            }
            if (p instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)p;
                return "bos_org".equals(basedataProp.getBaseEntityId());
            }
            return false;
        }).collect(Collectors.toList()) : propertyList.stream().filter(p -> p instanceof BasedataProp).collect(Collectors.toList()));
        for (IDataEntityProperty dataEntityProperty : propertyList) {
            LocaleString displayName = dataEntityProperty.getDisplayName();
            if (displayName == null) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(displayName);
            comboItem.setValue(dataEntityProperty.getName());
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(DIMENSION_MAPPING);
        comboEdit.setComboItems(comboItems);
    }

    private void buildDateTimeCombo(String number) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)number);
        DataEntityPropertyCollection properties = entityType.getProperties();
        List dateTimePropertyList = properties.stream().filter(prop -> prop instanceof DateTimeProp).collect(Collectors.toList());
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dateTimePropertyList.size());
        for (IDataEntityProperty dataEntityProperty : dateTimePropertyList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(dataEntityProperty.getDisplayName());
            comboItem.setValue(dataEntityProperty.getName());
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(DATE_MAPPING);
        comboEdit.setComboItems(comboItems);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object value;
        BasedataEdit baseData;
        String fieldKey;
        Object source = beforeF7SelectEvent.getSource();
        if (source instanceof BasedataEdit && BIZ_OBJECT.equals(fieldKey = (baseData = (BasedataEdit)source).getFieldKey()) && (value = this.getModel().getValue(INDICATORS_TYPE)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u7c7b\u578b\u3002", (String)"IndicatorsFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        }
    }

    private void initBizObjectAndMapping(String bizNumber) {
        String type = (String)this.getModel().getValue("dimensionstatistical");
        this.buildDimensionCombo(bizNumber, type);
        this.buildDateTimeCombo(bizNumber);
    }

    private void clearSelectedData() {
        this.getModel().setValue(DATE_MAPPING, null);
        this.getModel().setValue("datetype", null);
        this.getModel().setValue("datebegin", null);
        this.getModel().setValue("dateend", null);
        this.getModel().setValue("dimensionstatistical", null);
        this.getModel().setValue(DIMENSION_MAPPING, null);
        this.getModel().setValue("calformulajson", null);
        this.getModel().setValue(CAL_FORMULA, null);
    }
}

