/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.ssc.task.formplugin.util.ViewFlowchartUtil;

public class ReportListPlugin
extends AbstractListPlugin {
    private static final String NEXT_AUDITOR = "nextauditor";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscId");
        if (StringUtils.isNotEmpty((CharSequence)sscId)) {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!commonFilterColumn.getFilterField().getFieldName().equals("org.id")) continue;
                commonFilterColumn.setDefaultValue(sscId);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                ArrayList ids = new ArrayList();
                rows.forEach(v -> ids.add(String.valueOf(v.getPkValue())));
                if (ids.size() > 0) {
                    ReportListPlugin.this.setNextAuditor(rows, ids);
                }
                return rows;
            }
        });
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> ids) {
        if (!((DynamicObject)collection.get(0)).getDataEntityType().getProperties().containsKey((Object)NEXT_AUDITOR)) {
            collection.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(NEXT_AUDITOR, String.class, null));
        }
        Map<String, String> nextAuditorMap = ViewFlowchartUtil.getNextAuditor(ids);
        collection.forEach(v -> {
            String id = String.valueOf(v.getPkValue());
            v.set(NEXT_AUDITOR, (Object)(nextAuditorMap.get(id) == null ? "" : nextAuditorMap.get(id)));
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (NEXT_AUDITOR.equals(fieldName)) {
            args.setCancel(true);
            ListSelectedRow selectedRowInfo = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo();
            Long billId = Long.parseLong(String.valueOf(selectedRowInfo.getPrimaryKeyValue()));
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = listShowParameter.getPageId();
            WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)billId);
        }
    }
}

