/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;

public class ReportSchemeFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ReportSchemeFormPlugin.class);
    private static final String FIELD_MONITORTYPESELECT = "monitortypeselect";
    private static final String FIELD_ENTRY_INDICATOR = "indicator";
    private static final String FIELD_ENTRY_INDICATORGROUP = "indicatorgroup";
    private static final String FIELD_ENTRY_INDICATORTYPE = "indicatortype";
    private static final String FIELD_ENTRY_INDICATORREMARK = "indicatorremark";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit indicator = (BasedataEdit)this.getControl(FIELD_ENTRY_INDICATOR);
        indicator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit userGroup = (BasedataEdit)this.getControl("usergroupmonitor");
        BasedataEdit ssc = (BasedataEdit)this.getControl("orgmonitor");
        userGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ssc.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"taskusertext"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    private void init() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter parameter = view.getFormShowParameter();
        Object org = parameter.getCustomParam("createorg");
        if (!ObjectUtils.isEmpty((Object)org)) {
            model.setValue("createorg", org);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"usergroupmonitor", "taskusertext"});
    }

    public void afterBindData(EventObject e) {
        String taskUserMonitor;
        this.processMonitorInteraction();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT == status) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_saveandnew"});
        }
        if (StringUtils.isNotEmpty((CharSequence)(taskUserMonitor = (String)this.getModel().getValue("taskusermonitor_tag")))) {
            List valueTextItems = JSONArray.parseArray((String)taskUserMonitor).toJavaList(ValueTextItem.class);
            String text = valueTextItems.stream().map(ValueTextItem::getText).collect(Collectors.joining(","));
            String showMessage = valueTextItems.stream().map(ValueTextItem::getText).collect(Collectors.joining(","));
            this.getModel().setValue("taskusertext", (Object)(showMessage.length() > 255 ? text.substring(0, 255) : showMessage));
        }
    }

    private void processMonitorInteraction() {
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl("orgmonitor");
        MulBasedataEdit userGroup = (MulBasedataEdit)this.getView().getControl("usergroupmonitor");
        TextEdit user = (TextEdit)this.getView().getControl("taskusertext");
        String monitorType = (String)this.getModel().getValue(FIELD_MONITORTYPESELECT);
        if (StringUtils.isBlank((CharSequence)monitorType)) {
            return;
        }
        int flag = 1;
        this.getView().setVisible(Boolean.FALSE, new String[]{"orgmonitor", "usergroupmonitor", "taskusertext"});
        switch (monitorType) {
            case "orgmonitor": {
                break;
            }
            case "usergroupmonitor": {
                flag <<= 1;
                break;
            }
            case "taskusermonitor": {
                flag <<= 2;
                monitorType = "taskusertext";
                break;
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{monitorType});
        org.setMustInput((flag & 1) == 1);
        userGroup.setMustInput((flag & 2) == 2);
        user.setMustInput((flag & 4) == 4);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "monitortypeselect": {
                this.getModel().setValue("orgmonitor", (Object)"");
                this.getModel().setValue("usergroupmonitor", (Object)"");
                this.getModel().setValue("taskusermonitor", (Object)"");
                this.getModel().setValue("taskusermonitor_tag", (Object)"");
                this.getModel().setValue("taskusertext", (Object)"");
                this.processMonitorInteraction();
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "indicator": {
                int i = e.getChangeSet()[0].getRowIndex();
                Object group = null;
                String indicatorType = null;
                String remark = null;
                if (!ObjectUtils.isEmpty((Object)newValue)) {
                    DynamicObject dynamicObject = (DynamicObject)newValue;
                    group = dynamicObject.get("group");
                    indicatorType = dynamicObject.getString("indicatorstype");
                    remark = dynamicObject.getString("remark");
                }
                model.setValue(FIELD_ENTRY_INDICATORGROUP, group, i);
                model.setValue(FIELD_ENTRY_INDICATORTYPE, indicatorType, i);
                model.setValue(FIELD_ENTRY_INDICATORREMARK, (Object)remark, i);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String monitorType;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (("save".equals(operateKey) || "saveandnew".equals(operateKey)) && !"taskusermonitor".equals(monitorType = this.getModel().getValue(FIELD_MONITORTYPESELECT).toString())) {
            DynamicObjectCollection monitors = this.getModel().getDataEntity().getDynamicObjectCollection(monitorType);
            String name = monitors.stream().map(monitor -> ((OrmLocaleValue)((DynamicObject)monitor.get("fbasedataid")).get("name")).getLocaleValue()).collect(Collectors.joining(","));
            this.getModel().setValue("monitortext", (Object)(name.length() > 2000 ? name.substring(0, 2000) : name));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (FIELD_ENTRY_INDICATOR.equals(key)) {
            String monitorType = (String)this.getModel().getValue(FIELD_MONITORTYPESELECT);
            if (monitorType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76d1\u63a7\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"ReportSchemeFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            String targetIndicatorType = "1";
            if ("orgmonitor".equals(monitorType)) {
                targetIndicatorType = "3";
            } else if ("usergroupmonitor".equals(monitorType)) {
                targetIndicatorType = "2";
            }
            QFilter indicatorTypeFilter = new QFilter("monitortype", "=", (Object)targetIndicatorType);
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            Set indicatorIds = dynamicObjects.stream().filter(dynamicObject -> dynamicObject.getDynamicObject(FIELD_ENTRY_INDICATOR) != null).map(dynamicObject -> dynamicObject.getDynamicObject(FIELD_ENTRY_INDICATOR).getPkValue()).collect(Collectors.toSet());
            QFilter selectedFilter = new QFilter("id", "not in", indicatorIds);
            ArrayList<Long> sscIds = new ArrayList<Long>();
            sscIds.add((Long)((DynamicObject)this.getModel().getValue("createorg")).getPkValue());
            IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
            QFilter strategyFilter = baseDataService.getBaseDataFilter("som_indicators_lib", sscIds, true);
            strategyFilter.or(new QFilter("ctrlstrategy", "=", (Object)"7"));
            List filterList = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            filterList.add(selectedFilter);
            filterList.add(indicatorTypeFilter);
            filterList.add(strategyFilter);
        } else {
            String monitorType = (String)this.getModel().getValue(FIELD_MONITORTYPESELECT);
            if (monitorType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76d1\u63a7\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"ReportSchemeFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if ("orgmonitor".equals(monitorType)) {
                return;
            }
            QFilter sscFilter = null;
            Long sscId = (Long)((DynamicObject)this.getModel().getValue("createorg")).getPkValue();
            if ("usergroupmonitor".equals(monitorType)) {
                sscFilter = new QFilter("createorg", "=", (Object)sscId);
                sscFilter.and(new QFilter("enable", "=", (Object)"1"));
            }
            List filterList = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            filterList.add(sscFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("taskusertext".equals(key)) {
            String monitorText = (String)this.getModel().getValue("taskusermonitor_tag");
            List valueTextItems = new ArrayList(16);
            if (StringUtils.isNotEmpty((CharSequence)monitorText)) {
                valueTextItems = (List)SerializationUtils.fromJsonString((String)monitorText, List.class);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("selectedData", valueTextItems);
            Long sscId = (Long)((DynamicObject)this.getModel().getValue("createorg")).getPkValue();
            formShowParameter.setCustomParam("sscId", (Object)String.valueOf(sscId));
            formShowParameter.setFormId("multiselect_taskuser");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5171\u4eab\u7528\u6237", (String)"ReportSchemeFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "multiSelectTaskUser"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("multiSelectTaskUser".equals(actionId) && StringUtils.isNotEmpty((CharSequence)(returnData = (String)closedCallBackEvent.getReturnData()))) {
            List valueTextItems = JSONArray.parseArray((String)returnData).toJavaList(ValueTextItem.class);
            String text = valueTextItems.stream().map(ValueTextItem::getText).collect(Collectors.joining(","));
            this.getModel().setValue("monitortext", (Object)(text.length() > 2000 ? text.substring(0, 2000) : text));
            this.getModel().setValue("taskusermonitor_tag", (Object)returnData);
            String showMessage = valueTextItems.stream().map(ValueTextItem::getText).collect(Collectors.joining(","));
            this.getModel().setValue("taskusertext", (Object)(showMessage.length() > 255 ? text.substring(0, 255) : showMessage));
        }
    }
}

