/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.nsynprocess;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.OpBatchExecuter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.task.formplugin.UserWorkLoadFormPlugin;

public class NsynTaskAllocationProcess
implements Runnable {
    private static final Log log = LogFactory.getLog(OpBatchExecuter.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private String taskId;
    private Long userId;
    private Long userGroup;
    private List<Long> taskIds;
    private int batchCount;
    private IFormView formView;

    public NsynTaskAllocationProcess(String taskId, Long userId, List<Long> taskIds, int batchCount, IFormView view, Long userGroup) {
        this.taskId = taskId;
        this.userId = userId;
        this.taskIds = new ArrayList<Long>();
        this.taskIds.addAll(taskIds);
        this.batchCount = batchCount <= 0 ? 100 : batchCount;
        this.formView = view;
        this.userGroup = userGroup;
    }

    @Override
    public void run() {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            NsynTaskAllocationProcess.setInterruption(this.taskId, true);
            log.error("BatchAllocateTaskException:" + e.getMessage(), (Throwable)e);
        }
        finally {
            NsynTaskAllocationProcess.setFinished(this.taskId, true);
        }
    }

    private void doExecute() {
        List<Long> ids;
        int seq;
        int totalCount = this.taskIds.size();
        int times = totalCount / this.batchCount + 1;
        int finishCount = seq * this.batchCount;
        log.warn("\u6279\u91cf\u4efb\u52a1\u5206\u914d\u6279\u6b21[\u6279\u6b21,\u603b\u6570,\u5df2\u5206\u914d\u6570]:[seq:" + seq + ",totalCount:" + totalCount + ",finishCount:" + finishCount + "]");
        for (seq = NsynTaskAllocationProcess.getBatchSeq(this.taskId); seq < times && !(ids = this.getCurrIds(seq)).isEmpty(); ++seq) {
            this.executeOperate(this.userId, ids, this.userGroup);
            int percent = (finishCount += ids.size()) * 100 / totalCount;
            String tip = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6279\u91cf\u64cd\u4f5c\uff0c\u6bcf\u6279\u5904\u7406%1$s\u5f20\uff0c\u5df2\u5b8c\u6210%2$s/%3$s\u5f20\u3002", (String)"NsynTaskAllocationProcess_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), this.batchCount, finishCount, totalCount);
            NsynTaskAllocationProcess.setProgress(this.taskId, percent);
            NsynTaskAllocationProcess.setProgressTip(this.taskId, tip);
        }
        if (finishCount >= totalCount) {
            NsynTaskAllocationProcess.setCompleted(this.taskId, true);
        } else {
            NsynTaskAllocationProcess.setInterruption(this.taskId, true);
        }
    }

    private void executeOperate(Long userId, List<Long> ids, Long userGroup) {
        try {
            UserWorkLoadFormPlugin plugin = new UserWorkLoadFormPlugin();
            String errorMsgStr = NsynTaskAllocationProcess.getErrorMsg(this.taskId);
            StringBuilder errorMsg = new StringBuilder(errorMsgStr);
            List<Long> successIds = plugin.disTaskNew(userId, ids, this.formView, errorMsg, userGroup);
            int successCount = NsynTaskAllocationProcess.getSuccessCount(this.taskId);
            NsynTaskAllocationProcess.setSuccessCount(this.taskId, successCount += successIds.size());
            NsynTaskAllocationProcess.setErrorMsg(this.taskId, errorMsg);
        }
        catch (Throwable e) {
            log.error("\u4efb\u52a1\u6279\u91cf\u5206\u914d\u51fa\u9519:" + e.getMessage(), e);
            throw e;
        }
    }

    private List<Long> getCurrIds(int seq) {
        ArrayList<Long> ids = new ArrayList<Long>();
        int begin = seq * this.batchCount;
        int end = begin + this.batchCount;
        for (int i = begin; i < end && i < this.taskIds.size(); ++i) {
            ids.add(this.taskIds.get(i));
        }
        return ids;
    }

    public static boolean isFinished(String taskId) {
        String finish = (String)CACHE.get(NsynTaskAllocationProcess.buildCacheType(taskId), "finish");
        return StringUtils.isBlank((CharSequence)finish) ? false : Boolean.parseBoolean(finish);
    }

    public static void setFinished(String taskId, boolean finisih) {
        CACHE.put(NsynTaskAllocationProcess.buildCacheType(taskId), "finish", (Object)String.valueOf(finisih));
    }

    public static boolean isCompleted(String taskId) {
        String finish = (String)CACHE.get(NsynTaskAllocationProcess.buildCacheType(taskId), "complete");
        return StringUtils.isBlank((CharSequence)finish) ? false : Boolean.parseBoolean(finish);
    }

    public static void setCompleted(String taskId, boolean complete) {
        CACHE.put(NsynTaskAllocationProcess.buildCacheType(taskId), "complete", (Object)String.valueOf(complete));
    }

    public static void setSuccessCount(String taskId, int successCount) {
        CACHE.put(NsynTaskAllocationProcess.buildCacheType(taskId), "successCount", (Object)String.valueOf(successCount));
    }

    public static int getSuccessCount(String taskId) {
        String successCount = (String)CACHE.get(NsynTaskAllocationProcess.buildCacheType(taskId), "successCount");
        return StringUtils.isBlank((CharSequence)successCount) ? 0 : Integer.parseInt(successCount);
    }

    public static void setErrorMsg(String taskId, StringBuilder errorMsg) {
        CACHE.put(NsynTaskAllocationProcess.buildCacheType(taskId), "errorMsg", (Object)errorMsg.toString());
    }

    public static String getErrorMsg(String taskId) {
        String errorMsg = (String)CACHE.get(NsynTaskAllocationProcess.buildCacheType(taskId), "errorMsg");
        return StringUtils.isBlank((CharSequence)errorMsg) ? "" : errorMsg;
    }

    public static boolean isInteruption(String taskId) {
        String finish = (String)CACHE.get(NsynTaskAllocationProcess.buildCacheType(taskId), "interruption");
        return StringUtils.isBlank((CharSequence)finish) ? false : Boolean.parseBoolean(finish);
    }

    public static void setInterruption(String taskId, boolean interruption) {
        CACHE.put(NsynTaskAllocationProcess.buildCacheType(taskId), "interruption", (Object)String.valueOf(interruption));
    }

    public static int getProgress(String taskId) {
        String progress = (String)CACHE.get(NsynTaskAllocationProcess.buildCacheType(taskId), "progress");
        return StringUtils.isBlank((CharSequence)progress) ? 0 : Integer.parseInt(progress);
    }

    public static void setProgress(String taskId, int progress) {
        CACHE.put(NsynTaskAllocationProcess.buildCacheType(taskId), "progress", (Object)String.valueOf(progress));
    }

    public static String getProgressTip(String taskId) {
        return (String)CACHE.get(NsynTaskAllocationProcess.buildCacheType(taskId), "tip");
    }

    public static void setProgressTip(String taskId, String tip) {
        CACHE.put(NsynTaskAllocationProcess.buildCacheType(taskId), "tip", (Object)tip);
    }

    public static int getBatchSeq(String taskId) {
        String seq = (String)CACHE.get(NsynTaskAllocationProcess.buildCacheType(taskId), "batchseq");
        return StringUtils.isBlank((CharSequence)seq) ? 0 : Integer.parseInt(seq);
    }

    public static void setBatchSeq(String taskId, int seq) {
        CACHE.put(NsynTaskAllocationProcess.buildCacheType(taskId), "batchseq", (Object)String.valueOf(seq));
    }

    public static void clearCache(String taskId) {
        CACHE.removeType(NsynTaskAllocationProcess.buildCacheType(taskId));
    }

    private static String buildCacheType(String taskId) {
        return "NsynTaskAllocationProcess_" + taskId;
    }
}

