/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.quality;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.business.task.TaskQcPendingRecordHelper;

public class QualityApprovalPendingHelper {
    public static void qualityPauseAction(IFormView formView, Map<String, Object> dataMap) {
        Integer totalTaskCount = (Integer)dataMap.get("totalTaskCount");
        Integer totalSuccessCount = (Integer)dataMap.get("totalSuccessCount");
        String digest = (String)dataMap.get("digest");
        String errorMsg = (String)dataMap.get("errorMsg");
        if (totalTaskCount == 1) {
            if (totalSuccessCount == 0) {
                if (StringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = ResManager.loadKDString((String)"\u6682\u6302\u5931\u8d25\u3002", (String)"QualityApprovalPendingHelper_0", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                }
                formView.showTipNotification(errorMsg);
            } else {
                formView.showSuccessNotification(ResManager.loadKDString((String)"\u6682\u6302\u6210\u529f\u3002", (String)"QualityApprovalPendingHelper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
            btnNameMaps.put(MessageBoxResult.OK.getValue(), ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"QualityApprovalPendingHelper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            formView.showConfirm(digest, errorMsg, MessageBoxOptions.OK, ConfirmTypes.Save, null, btnNameMaps);
        }
    }

    public static boolean isPause(String state) {
        return TaskStateEnum.CHECKING.getValue().equals(state) || TaskStateEnum.RECTIFYING.getValue().equals(state) || TaskStateEnum.REVIEW.getValue().equals(state);
    }

    public static boolean isCancelPause(String state) {
        return TaskStateEnum.PAUSE_CHECKING.getValue().equals(state) || TaskStateEnum.PAUSE_RECTIFYING.getValue().equals(state) || TaskStateEnum.PAUSE_REVIEW.getValue().equals(state);
    }

    public static Map<String, Object> qualityCancelPending(List<Long> taskIds) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(15);
        Integer totalTaskCount = taskIds.size();
        Integer totalSuccessCount = 0;
        StringBuilder errorMsg = new StringBuilder();
        QFilter idFilter = new QFilter("id", "in", taskIds);
        DynamicObject[] taskDos = BusinessDataServiceHelper.load((String)"task_task", (String)"id,billnumber,state,pendingopinion", (QFilter[])new QFilter[]{idFilter});
        if (taskDos != null && taskDos.length > 0) {
            for (DynamicObject task : taskDos) {
                long taskId = task.getLong("id");
                String state = task.getString("state");
                String billNumber = task.getString("billnumber");
                if (!QualityApprovalPendingHelper.isCancelPause(state)) {
                    String result = String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u9009\u62e9\u8d28\u68c0\u6682\u6302\u3001\u6574\u6539\u6682\u6302\u3001\u590d\u6838\u6682\u6302\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"QualityApprovalPendingHelper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNumber);
                    errorMsg.append(result).append("\n");
                    continue;
                }
                if (TaskStateEnum.PAUSE_CHECKING.getValue().equals(state)) {
                    task.set("state", (Object)TaskStateEnum.CHECKING.getValue());
                } else if (TaskStateEnum.PAUSE_RECTIFYING.getValue().equals(state)) {
                    task.set("state", (Object)TaskStateEnum.RECTIFYING.getValue());
                } else if (TaskStateEnum.PAUSE_REVIEW.getValue().equals(state)) {
                    task.set("state", (Object)TaskStateEnum.REVIEW.getValue());
                }
                long currUserId = RequestContext.get().getCurrUserId();
                TaskQcPendingRecordHelper.savePendingCancelRecord((Long)taskId, (Long)currUserId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                Integer n = totalSuccessCount;
                Integer n2 = totalSuccessCount = Integer.valueOf(totalSuccessCount + 1);
            }
        }
        returnData.put("totalTaskCount", totalTaskCount);
        returnData.put("totalSuccessCount", totalSuccessCount);
        returnData.put("digest", QualityApprovalPendingHelper.createTipDigest(totalTaskCount, totalSuccessCount));
        returnData.put("errorMsg", errorMsg.toString());
        return returnData;
    }

    private static String createTipDigest(Integer totalTaskCount, Integer totalSuccessCount) {
        String digest = ResManager.loadKDString((String)"\u5171%1$s\u6761\u4efb\u52a1\uff0c\u53d6\u6d88\u6682\u6302\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"QualityApprovalPendingHelper_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        digest = String.format(digest, totalTaskCount, totalSuccessCount, totalTaskCount - totalSuccessCount);
        return digest;
    }

    public static void qualityCancelPauseAction(IFormView formView, Map<String, Object> dataMap) {
        Integer totalTaskCount = (Integer)dataMap.get("totalTaskCount");
        Integer totalSuccessCount = (Integer)dataMap.get("totalSuccessCount");
        String digest = (String)dataMap.get("digest");
        String errorMsg = (String)dataMap.get("errorMsg");
        if (totalTaskCount == 1) {
            if (totalSuccessCount == 0) {
                if (StringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u5931\u8d25\u3002", (String)"QualityApprovalPendingHelper_5", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                }
                formView.showTipNotification(errorMsg);
            } else {
                formView.showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"QualityApprovalPendingHelper_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
            btnNameMaps.put(MessageBoxResult.OK.getValue(), ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"QualityApprovalPendingHelper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            formView.showConfirm(digest, errorMsg, MessageBoxOptions.OK, ConfirmTypes.Save, null, btnNameMaps);
        }
    }
}

