/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.ExportExcel;
import kd.bos.list.ControlContext;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.util.SscUtil;

public class RptTaskQualityStatisticsFormPlugin
extends AbstractReportFormPlugin {
    private static final String KEY_RPTTASKQUALITY_FIRST_ROAD = "rptTaskQualityFirstRoad";
    private static final String DIMENSION = "dimension";
    private static final String ALLDIM = "alldim";
    private static final String ORGDIM = "orgdim";
    private static final String TASKTYPEDIM = "tasktypedim";
    private static final String BUSSINESSBILLDIM = "bussinessbilldim";
    private static final String HANDLEPERSONDIM = "handlepersondim";
    private List<FilterColumn> commonFilters = null;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long sscId;
        Long userId;
        int isPermission;
        super.beforeDoOperation(args);
        Object operation = args.getSource();
        if (operation instanceof ExportExcel && (isPermission = PermissionServiceHelper.checkPermission((Long)(userId = Long.valueOf(RequestContext.get().getCurrUserId())), (Long)(sscId = Long.valueOf(Long.parseLong(this.getPageCache().get(CacheKey.getSSCKey((Object)"rptTaskQualityOldSSC"))))), (String)"12", (String)"ssc", (String)"task_qualitystatisticsrpt", (String)"4730fc9f000004ae")) != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4efb\u52a1\u8d28\u91cf\u7edf\u8ba1\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u7684\u6743\u9650\u3002", (String)"RptTaskQualityStatisticsFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject dyn : rowData) {
            int taskcount = (Integer)dyn.get("taskcount");
            int unpasscount = (Integer)dyn.get("unpasscount");
            int returncount = (Integer)dyn.get("returncount");
            int pendingcount = (Integer)dyn.get("pendingcount");
            int exceptioncount = (Integer)dyn.get("exceptioncount");
            if (taskcount <= 0) continue;
            dyn.set("unpassrate", (Object)(100.0 * (double)unpasscount / (double)taskcount));
            dyn.set("returnrate", (Object)(100.0 * (double)returncount / (double)taskcount));
            dyn.set("pendingrate", (Object)(100.0 * (double)pendingcount / (double)taskcount));
            dyn.set("exceptionrate", (Object)(100.0 * (double)exceptioncount / (double)taskcount));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        String curFieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
        String curValue = (String)((List)currentCommonFilter.get("Value")).get(0);
        String oldSsc = this.getPageCache().get(CacheKey.getSSCKey((Object)"rptTaskQualityOldSSC"));
        if ("sharecenter.id".equals(curFieldName) && !curValue.equals(oldSsc)) {
            this.getPageCache().put(CacheKey.getSSCKey((Object)"rptTaskQualityOldSSC"), curValue);
            Map filterValues = args.getFilterValues();
            List customfilter = (List)filterValues.get("customfilter");
            customfilter.forEach(filter -> {
                String fieldName = (String)((List)filter.get("FieldName")).get(0);
                if ("tasktype.id".equals(fieldName)) {
                    ((List)filter.get("Value")).set(0, "");
                }
                if ("org.id".equals(fieldName)) {
                    ((List)filter.get("Value")).set(0, "");
                }
            });
            List filterItems = this.getQueryParam().getFilter().getFilterItems();
            Iterator iterator = filterItems.iterator();
            while (iterator.hasNext()) {
                FilterItemInfo next = (FilterItemInfo)iterator.next();
                String propName = next.getPropName();
                if ("sharecenter.id".equals(propName) || "receivetime".equals(propName)) continue;
                iterator.remove();
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfo = filterInfo.getFilterItem(DIMENSION);
        String valueStr = (String)this.getModel().getValue(DIMENSION);
        if (valueStr != null && !ALLDIM.equals(valueStr.trim())) {
            ArrayList<String> dimensionList = new ArrayList<String>();
            dimensionList.add(valueStr);
            if (itemInfo != null) {
                itemInfo.setValue(dimensionList);
            } else {
                filterInfo.addFilterItem(DIMENSION, dimensionList, "in");
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TASKTYPEDIM);
            list.add(ORGDIM);
            list.add(HANDLEPERSONDIM);
            list.add(BUSSINESSBILLDIM);
            if (itemInfo != null) {
                itemInfo.setValue(list);
            } else {
                filterInfo.addFilterItem(DIMENSION, list, "in");
            }
        }
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        for (FilterColumn filterColumn : this.commonFilters) {
            QFilter filter;
            FilterItemInfo oItemInfo;
            FilterInfo oFilterInfo;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if ("tasktype".equalsIgnoreCase(fieldName)) {
                oFilterInfo = queryParam.getFilter();
                oItemInfo = oFilterInfo.getFilterItem("sharecenter.id");
                if (oItemInfo == null) continue;
                String comType = oItemInfo.getCompareType();
                Object sscFilterValue = oItemInfo.getValue();
                QFilter idFilter = new QFilter("orgfield.id", comType, sscFilterValue);
                QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscFilterValue, false);
                continue;
            }
            if (!"org".equalsIgnoreCase(fieldName) || (oItemInfo = (oFilterInfo = queryParam.getFilter()).getFilterItem("sharecenter.id")) == null) continue;
            Object sscFilterValue = oItemInfo.getValue();
            if (sscFilterValue instanceof List) {
                List sscValues = (List)sscFilterValue;
                filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityOrgFilter", sscValues.get(0));
                for (int i = 1; i < sscValues.size(); ++i) {
                    filter.or(CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityOrgFilter", sscValues.get(i)));
                }
            } else {
                filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityOrgFilter", sscFilterValue);
            }
            CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityOrg", commonFilterColumn, "bos_org", filter, sscFilterValue, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (DIMENSION.equals(e.getProperty().getName())) {
            this.getView().refresh();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfoComm = filterInfo.getFilterItem("sharecenter.id");
        FilterItemInfo itemInfoSche = filterInfo.getFilterItem("sharecenter.name");
        if (itemInfoComm == null && itemInfoSche == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"RptTaskQualityStatisticsFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String sscid = "-1";
        this.commonFilters = contInitEvent.getCommonFilterColumns();
        if (this.getPageCache().get(CacheKey.getSSCKey((Object)KEY_RPTTASKQUALITY_FIRST_ROAD)) == null) {
            for (FilterColumn filterColumn : this.commonFilters) {
                String fieldName;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                switch (fieldName = commonFilterColumn.getFieldName()) {
                    case "sharecenter.name": {
                        ControlContext context = commonFilterColumn.getContext();
                        ControlFilters controlFilters = context.getControlFilters();
                        if (controlFilters == null) {
                            List sscItems = commonFilterColumn.getComboItems();
                            Long orgId = RequestContext.get().getOrgId();
                            sscid = TaskRptHelper.getDefSscId(sscItems, orgId);
                        } else {
                            List filter = controlFilters.getFilter("sharecenter.id");
                            sscid = String.valueOf(filter.get(0));
                        }
                        this.getPageCache().put(CacheKey.getSSCKey((Object)"rptTaskQualityOldSSC"), sscid);
                        this.getPageCache().put(CacheKey.getSSCKey((Object)KEY_RPTTASKQUALITY_FIRST_ROAD), "true");
                        commonFilterColumn.setDefaultValue(sscid);
                        commonFilterColumn.setDefValue(sscid);
                        commonFilterColumn.setMustInput(true);
                        break;
                    }
                    case "org": {
                        QFilter filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityOrgFilter", sscid);
                        CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityOrg", commonFilterColumn, "bos_org", filter, sscid, false);
                        break;
                    }
                    case "receivetime": {
                        filterColumn.setDefaultValue("92");
                        break;
                    }
                    case "tasktype": {
                        if (!StringUtils.isNotBlank((CharSequence)sscid)) break;
                        QFilter idFilter = new QFilter("orgfield.id", "=", (Object)Long.valueOf(sscid));
                        QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                        CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscid, false);
                    }
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        List qfilters = args.getQfilters();
        String sscIDStr = this.getPageCache().get(CacheKey.getSSCKey((Object)"rptTaskQualityOldSSC"));
        if (kd.bos.util.StringUtils.isNotEmpty((String)sscIDStr)) {
            if ("tasktype.id".equals(name)) {
                qfilters.add(new QFilter("orgfield", "=", (Object)Long.valueOf(sscIDStr)));
                qfilters.add(new QFilter("qualityjudge", "=", (Object)"0"));
            } else if ("org.id".equals(name)) {
                OrgF7ViewShowHelper.beforeFilterContainerF7((BeforeFilterF7SelectEvent)args, (Long)Long.parseLong(sscIDStr));
            }
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            if (!"personid".equals(event.getColumnName())) continue;
            event.setSort(false);
            event.setFilter(true);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_qualitystatisticsrpt", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"RptTaskQualityStatisticsFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

