/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.ExportExcel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.util.SscUtil;

public class RptTaskUnpassReasonFormPlugin
extends AbstractReportFormPlugin {
    private List<FilterColumn> commonFilters = null;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operation = args.getSource();
        if (operation instanceof ExportExcel) {
            int isPermission;
            Long userId = RequestContext.get().getCurrUserId();
            Long sscId = Long.parseLong(this.getPageCache().get("rptTaskUnpass_sscid.id"));
            String appId = this.getView().getFormShowParameter().getAppId();
            if (StringUtils.isBlank((CharSequence)appId)) {
                appId = "ssc";
            }
            if ((isPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)"12", (String)appId, (String)"task_unpassreasonrpt", (String)"4730fc9f000004ae")) != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4efb\u52a1\u6279\u9000\u539f\u56e0\u62a5\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u7684\u6743\u9650\u3002", (String)"RptTaskUnpassReasonFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject row : rowData) {
            int total = row.getInt("tasktotalcount");
            int unpass = row.getInt("taskunpasscount");
            int reason = row.getInt("unpasscount");
            if (total != 0) {
                row.set("unpassrate", (Object)(100.0 * (double)unpass / (double)total));
            } else {
                row.set("unpassrate", (Object)0);
            }
            if (unpass != 0) {
                row.set("reasonrate", (Object)(100.0 * (double)reason / (double)unpass));
                continue;
            }
            row.set("reasonrate", (Object)0);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.setValue("dimension", (Object)"orgdim");
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("dimension");
        String valueStr = (String)this.getModel().getValue("dimension");
        if (valueStr != null && !valueStr.trim().equals("")) {
            ArrayList<String> dimensionlist = new ArrayList<String>();
            dimensionlist.add(valueStr);
            if (itemInfo != null) {
                itemInfo.setValue(dimensionlist);
            } else {
                filterInfo.addFilterItem("dimension", dimensionlist, "in");
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add("tasktypedim");
            list.add("orgdim");
            list.add("handlepersondim");
            list.add("billtypedim");
            if (itemInfo != null) {
                itemInfo.setValue(list);
            } else {
                filterInfo.addFilterItem("dimension", list, "in");
            }
        }
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        for (FilterColumn filterColumn : this.commonFilters) {
            QFilter idFilter;
            Object sscFilterValue;
            FilterItemInfo oItemInfo;
            FilterInfo oFilterInfo;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if ("tasktype".equalsIgnoreCase(fieldName)) {
                oFilterInfo = queryParam.getFilter();
                oItemInfo = oFilterInfo.getFilterItem("sharecenter.id");
                if (oItemInfo == null) continue;
                sscFilterValue = oItemInfo.getValue();
                idFilter = new QFilter("orgfield.id", "in", sscFilterValue);
                QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskUnpassTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscFilterValue, false);
                continue;
            }
            if (!"taskbill".equalsIgnoreCase(fieldName) || (oItemInfo = (oFilterInfo = queryParam.getFilter()).getFilterItem("sharecenter.id")) == null) continue;
            sscFilterValue = oItemInfo.getValue();
            idFilter = new QFilter("ssccenter.id", "in", sscFilterValue);
            CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskUnpassBillType", commonFilterColumn, "task_taskbill", idFilter, sscFilterValue, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("dimension")) {
            this.getView().refresh();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfoComm = filterInfo.getFilterItem("sharecenter.id");
        FilterItemInfo itemInfoSche = filterInfo.getFilterItem("sharecenter.name");
        if (itemInfoComm == null && itemInfoSche == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3", (String)"RptTaskUnpassReasonFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String sscid = "";
        this.commonFilters = contInitEvent.getCommonFilterColumns();
        if (this.getPageCache().get(CacheKey.getSSCKey((Object)"rptTaskUnpassFirstRoad")) == null) {
            for (FilterColumn filterColumn : contInitEvent.getCommonFilterColumns()) {
                QFilter idFilter;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("sharecenter.name".equalsIgnoreCase(fieldName)) {
                    List sscItems = commonFilterColumn.getComboItems();
                    Long orgId = RequestContext.get().getOrgId();
                    sscid = TaskRptHelper.getDefSscId(sscItems, orgId);
                    commonFilterColumn.setDefaultValue(sscid);
                    commonFilterColumn.setDefValue(sscid);
                    commonFilterColumn.setMustInput(true);
                    this.getPageCache().put(CacheKey.getSSCKey((Object)"rptTaskUnpassFirstRoad"), "true");
                    if (this.getPageCache().getAll().containsKey("rptTaskUnpass_sscid.id")) continue;
                    this.getPageCache().put("rptTaskUnpass_sscid.id", sscid);
                    continue;
                }
                if ("completetime".equalsIgnoreCase(fieldName)) {
                    filterColumn.setDefaultValue("92");
                    continue;
                }
                if ("tasktype".equalsIgnoreCase(fieldName)) {
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)sscid)) continue;
                    idFilter = new QFilter("orgfield.id", "=", (Object)Long.valueOf(sscid));
                    QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskUnpassTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscid, false);
                    continue;
                }
                if (!"taskbill".equalsIgnoreCase(fieldName) || !kd.bos.util.StringUtils.isNotEmpty((String)sscid)) continue;
                idFilter = new QFilter("ssccenter.id", "=", (Object)Long.valueOf(sscid));
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskUnpassBillType", commonFilterColumn, "task_taskbill", idFilter, sscid, false);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        List qfilters = args.getQfilters();
        String sscIDStr = this.getPageCache().get("rptTaskUnpass_sscid.id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)sscIDStr)) {
            if ("taskbill.id".equals(name)) {
                qfilters.add(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscIDStr)));
            } else if ("tasktype.id".equals(name)) {
                qfilters.add(new QFilter("orgfield", "=", (Object)Long.valueOf(sscIDStr)));
                qfilters.add(new QFilter("qualityjudge", "=", (Object)"0"));
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String currentFieldName;
        Map currentFilter = args.getCurrentCommonFilter();
        List currentFieldNames = (List)currentFilter.get("FieldName");
        if (currentFieldNames != null && !currentFieldNames.isEmpty() && "sharecenter.id".equalsIgnoreCase(currentFieldName = currentFieldNames.get(0).toString())) {
            List sscidValues = (List)currentFilter.get("Value");
            String sscid = "";
            if (sscidValues != null && !sscidValues.isEmpty()) {
                sscid = (String)sscidValues.get(0);
            }
            if (!sscid.equals(this.getPageCache().get("rptTaskUnpass_sscid.id"))) {
                this.getPageCache().put("rptTaskUnpass_sscid.id", sscid);
                Map filterValues = args.getSearchClickEvent().getFilterValues();
                List customFiterList = (List)filterValues.get("customfilter");
                for (Map filter : customFiterList) {
                    List fieldNames = (List)filter.get("FieldName");
                    if (fieldNames == null || fieldNames.isEmpty()) continue;
                    String fieldName = fieldNames.get(0).toString();
                    if ("tasktype.id".equalsIgnoreCase(fieldName)) {
                        filter.replace("Value", Collections.singletonList(""));
                    }
                    if (!"taskbill.id".equalsIgnoreCase(fieldName)) continue;
                    filter.replace("Value", Collections.singletonList(""));
                }
            }
            List filterItems = this.getQueryParam().getFilter().getFilterItems();
            Iterator iterator = filterItems.iterator();
            while (iterator.hasNext()) {
                FilterItemInfo next = (FilterItemInfo)iterator.next();
                String propName = next.getPropName();
                if (!"tasktype.id".equals(propName) && !"taskbill.id".equals(propName)) continue;
                iterator.remove();
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_unpassreasonrpt", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"RptTaskUnpassReasonFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

