/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.ExportExcel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.common.DateRangeUtil;
import kd.ssc.task.common.TaskPoolTypeEnum;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.rpt.TaskScheduleParamHelper;
import kd.ssc.task.formplugin.util.SscUtil;

public class TaskScheduleFormRpt
extends AbstractReportFormPlugin {
    private static String[] barcolors = new String[]{"#B775FF", "#B775FF", "#FF703E", "#FF703E", "#FF703E", "#FD5454", "#FD5454"};
    private boolean flag = true;
    private List<FilterColumn> commonFilters = null;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operation = args.getSource();
        if (operation instanceof ExportExcel) {
            int isPermission;
            Long userId = RequestContext.get().getCurrUserId();
            Long sscId = Long.parseLong(this.getPageCache().get("rptTaskSchedule_sscid.id"));
            String appId = this.getView().getFormShowParameter().getAppId();
            if (StringUtils.isBlank((CharSequence)appId)) {
                appId = "ssc";
            }
            if ((isPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)"12", (String)appId, (String)"task_taskschedule", (String)"4730fc9f000004ae")) != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4efb\u52a1\u8fdb\u5ea6\u7edf\u8ba1\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u7684\u6743\u9650\u3002", (String)"TaskScheduleFormRpt_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"barchartap", "piechartap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.setValue("selectcolumn", (Object)"handler");
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("piechartap")) {
            ReportQueryParam queryParam;
            Date[] dates;
            DateRangeEnum dateType;
            ChartClickEvent e = (ChartClickEvent)evt;
            String name = e.getName();
            if (name == null && e.getValue() == null && e.getSeriesName() == null) {
                return;
            }
            if (name == null) {
                name = TaskPoolTypeEnum.Processing.getName();
            }
            if ((dateType = DateRangeUtil.getDateRangeEnum((dates = TaskScheduleParamHelper.getQueryDateRange(queryParam = this.getQueryParam()))[0], dates[1])) == null || dateType.getValue() < 0) {
                Integer[] bardata = TaskScheduleParamHelper.getBarChartData(queryParam, name);
                this.setBarData(bardata, name);
            } else {
                Integer[] bardata = TaskScheduleParamHelper.getBarChartDataFromTempTable(queryParam, name, dateType);
                if (!this.isNotAllZero(bardata)) {
                    bardata = TaskScheduleParamHelper.getBarChartData(queryParam, name);
                }
                this.setBarData(bardata, name);
            }
        }
    }

    public void setBarData(Integer[] bardata, String name) {
        String leftBorder = "80px";
        String rightBorder = "80px";
        Chart customchartap = (Chart)this.getControl("barchartap");
        customchartap.clearData();
        BarSeries barseries = customchartap.createBarSeries(name);
        barseries.setData(this.getItemValue(bardata));
        barseries.setType(ChartType.bar);
        barseries.setBarWidth("30%");
        Axis xaxis = customchartap.createXAxis(ResManager.loadKDString((String)"\u65f6\u95f4", (String)"TaskScheduleFormRpt_10", (String)"ssc-task-formplugin", (Object[])new Object[0]), AxisType.category);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        ArrayList<String> xAsix = new ArrayList<String>(16);
        xAsix.add(ResManager.loadKDString((String)"3\u5929\u4ee5\u5185", (String)"TaskScheduleFormRpt_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xAsix.add(ResManager.loadKDString((String)"4-7\u5929", (String)"TaskScheduleFormRpt_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xAsix.add(ResManager.loadKDString((String)"8-10\u5929", (String)"TaskScheduleFormRpt_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xAsix.add(ResManager.loadKDString((String)"11-15\u5929", (String)"TaskScheduleFormRpt_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xAsix.add(ResManager.loadKDString((String)"16-20\u5929", (String)"TaskScheduleFormRpt_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xAsix.add(ResManager.loadKDString((String)"21-30\u5929", (String)"TaskScheduleFormRpt_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xAsix.add(ResManager.loadKDString((String)"1\u4e2a\u6708\u4ee5\u4e0a", (String)"TaskScheduleFormRpt_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        xaxis.setCategorys(xAsix);
        this.setLineColor(xaxis, "#666666");
        customchartap.setMargin(Position.left, leftBorder);
        customchartap.setMargin(Position.right, rightBorder);
        Axis yaxis = customchartap.createYAxis(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6570/%s", (String)"TaskScheduleFormRpt_11", (String)"ssc-task-formplugin", (Object[])new Object[0]), name), AxisType.value);
        yaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(yaxis, "#666666");
        this.setSplitLineColor(yaxis, "#cccccc");
        customchartap.setShowTooltip(true);
        yaxis.setPropValue("axisLine", axisTick);
        customchartap.bindData(null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("selectcolumn")) {
            this.flag = false;
            this.getView().refresh();
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("selectcolumn");
        String valueStr = (String)this.getModel().getValue("selectcolumn");
        if (valueStr != null && !valueStr.trim().equals("")) {
            ArrayList<String> selectcolumnlist = new ArrayList<String>();
            selectcolumnlist.add(valueStr);
            if (itemInfo != null) {
                itemInfo.setValue(selectcolumnlist);
            } else {
                filterInfo.addFilterItem("selectcolumn", selectcolumnlist, "in");
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add("billtype");
            list.add("tasktype");
            list.add("handler");
            list.add("orgname");
            if (itemInfo != null) {
                itemInfo.setValue(list);
            } else {
                filterInfo.addFilterItem("selectcolumn", list, "in");
            }
        }
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        for (FilterColumn filterColumn : this.commonFilters) {
            FilterInfo oFilterInfo;
            FilterItemInfo oItemInfo;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"tasktypeid".equalsIgnoreCase(fieldName) || (oItemInfo = (oFilterInfo = queryParam.getFilter()).getFilterItem("sscid.id")) == null) continue;
            Object sscFilterValue = oItemInfo.getValue();
            QFilter idFilter = new QFilter("orgfield.id", "in", sscFilterValue);
            QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
            CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskScheduleTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscFilterValue, false);
        }
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String sscid = "";
        this.commonFilters = contInitEvent.getCommonFilterColumns();
        if (this.getPageCache().get(CacheKey.getSSCKey((Object)"rptTaskScheduleFirstRoad")) == null) {
            for (FilterColumn filterColumn : contInitEvent.getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("sscid.name".equalsIgnoreCase(fieldName)) {
                    List sscItems = commonFilterColumn.getComboItems();
                    Long orgId = RequestContext.get().getOrgId();
                    sscid = TaskRptHelper.getDefSscId(sscItems, orgId);
                    commonFilterColumn.setDefaultValue(sscid);
                    commonFilterColumn.setDefValue(sscid);
                    commonFilterColumn.setMustInput(true);
                    this.getPageCache().put(CacheKey.getSSCKey((Object)"rptTaskScheduleFirstRoad"), "true");
                    if (this.getPageCache().getAll().containsKey("rptTaskSchedule_sscid.id")) continue;
                    this.getPageCache().put("rptTaskSchedule_sscid.id", sscid);
                    continue;
                }
                if ("completetime".equalsIgnoreCase(fieldName)) {
                    filterColumn.setDefaultValue("10");
                    continue;
                }
                if (!"tasktypeid".equalsIgnoreCase(fieldName) || !StringUtils.isNotBlank((CharSequence)sscid)) continue;
                QFilter idFilter = new QFilter("orgfield.id", "=", (Object)Long.valueOf(sscid));
                QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskScheduleTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscid, false);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String currentFieldName;
        Map currentFilter = args.getCurrentCommonFilter();
        List currentFieldNames = (List)currentFilter.get("FieldName");
        if (currentFieldNames != null && !currentFieldNames.isEmpty() && "sscid.id".equalsIgnoreCase(currentFieldName = currentFieldNames.get(0).toString())) {
            List sscidValues = (List)currentFilter.get("Value");
            String sscid = "";
            if (sscidValues != null && !sscidValues.isEmpty()) {
                sscid = (String)sscidValues.get(0);
            }
            if (!sscid.equals(this.getPageCache().get("rptTaskSchedule_sscid.id"))) {
                this.getPageCache().put("rptTaskSchedule_sscid.id", sscid);
                Map filterValues = args.getSearchClickEvent().getFilterValues();
                List customFiterList = (List)filterValues.get("customfilter");
                for (Map filter : customFiterList) {
                    String fieldName;
                    List fieldNames = (List)filter.get("FieldName");
                    if (fieldNames == null || fieldNames.isEmpty() || !"tasktypeid.id".equalsIgnoreCase(fieldName = fieldNames.get(0).toString())) continue;
                    filter.replace("Value", Collections.singletonList(""));
                }
            }
            List filterItems = this.getQueryParam().getFilter().getFilterItems();
            Iterator iterator = filterItems.iterator();
            while (iterator.hasNext()) {
                FilterItemInfo next = (FilterItemInfo)iterator.next();
                String propName = next.getPropName();
                if (!"tasktypeid.id".equals(propName)) continue;
                iterator.remove();
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        if (this.flag) {
            Chart pieChart = (Chart)this.getControl("piechartap");
            Date[] dates = TaskScheduleParamHelper.getQueryDateRange(queryParam);
            DateRangeEnum dateType = DateRangeUtil.getDateRangeEnum(dates[0], dates[1]);
            if (dateType == null || dateType.getValue() < 0) {
                Map<String, Object> map = this.getData(queryParam);
                ItemValue[] data = (ItemValue[])map.get("data");
                int count = (Integer)map.get("count");
                this.setPieChat(pieChart, data, count);
                Integer[] bardata = TaskScheduleParamHelper.getBarChartData(queryParam, TaskPoolTypeEnum.Processing.getName());
                this.setBarData(bardata, TaskPoolTypeEnum.Processing.getName());
            } else {
                Map<String, Integer> result = TaskScheduleParamHelper.getChartDataFromTempTable(queryParam, dateType);
                int count = result.get("count");
                ItemValue[] dataItem = new ItemValue[3];
                if (count != 0) {
                    dataItem[0] = new ItemValue(TaskPoolTypeEnum.ToBeAllocated.getName(), (Number)result.get(TaskPoolTypeEnum.ToBeAllocated.getName()), TaskPoolTypeEnum.ToBeAllocated.getColor());
                    dataItem[1] = new ItemValue(TaskPoolTypeEnum.Processing.getName(), (Number)result.get(TaskPoolTypeEnum.Processing.getName()), TaskPoolTypeEnum.Processing.getColor());
                    dataItem[2] = new ItemValue(TaskPoolTypeEnum.Completed.getName(), (Number)result.get(TaskPoolTypeEnum.Completed.getName()), TaskPoolTypeEnum.Completed.getColor());
                } else {
                    Map<String, Object> map = this.getData(queryParam);
                    dataItem = (ItemValue[])map.get("data");
                    count = (Integer)map.get("count");
                }
                this.setPieChat(pieChart, dataItem, count);
                Integer[] bardata = TaskScheduleParamHelper.getBarChartDataFromTempTable(queryParam, TaskPoolTypeEnum.Processing.getName(), dateType);
                if (!this.isNotAllZero(bardata)) {
                    bardata = TaskScheduleParamHelper.getBarChartData(queryParam, TaskPoolTypeEnum.Processing.getName());
                }
                this.setBarData(bardata, TaskPoolTypeEnum.Processing.getName());
            }
        }
    }

    private void setPieChat(Chart pieChart, ItemValue[] data, int count) {
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u7edf\u8ba1", (String)"TaskScheduleFormRpt_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        series.setData(data);
        series.setRadius("45%", "80%");
        pieChart.setShowTooltip(true);
        pieChart.bindData(null);
        pieChart.setShowTitle(true);
        pieChart.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6570\uff1a%s", (String)"TaskScheduleFormRpt_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), count)));
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        pieChart.refresh();
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void setSplitLineColor(Axis axis, String color) {
        HashMap splitLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        splitLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("splitLine", splitLineMap);
    }

    public ItemValue[] getItemValue(Integer[] data) {
        ItemValue[] values = new ItemValue[data.length];
        ItemValue value = null;
        int size = data.length;
        for (int i = 0; i < size; ++i) {
            values[i] = value = new ItemValue((Number)data[i], barcolors[i]);
        }
        return values;
    }

    private Map<String, Object> getData(ReportQueryParam param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<ItemValue> list = new ArrayList<ItemValue>();
        List<Map<String, Integer>> result = TaskScheduleParamHelper.getPieChartData(param);
        int count = 0;
        list.add(new ItemValue(TaskPoolTypeEnum.ToBeAllocated.getName(), (Number)result.get(0).get("num"), TaskPoolTypeEnum.ToBeAllocated.getColor()));
        list.add(new ItemValue(TaskPoolTypeEnum.Processing.getName(), (Number)result.get(1).get("num"), TaskPoolTypeEnum.Processing.getColor()));
        list.add(new ItemValue(TaskPoolTypeEnum.Completed.getName(), (Number)result.get(2).get("num"), TaskPoolTypeEnum.Completed.getColor()));
        for (Map<String, Integer> map : result) {
            count += map.get("num").intValue();
        }
        resultMap.put("count", count);
        resultMap.put("data", list.toArray(new ItemValue[0]));
        return resultMap;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfoComm = filterInfo.getFilterItem("sscid.id");
        FilterItemInfo itemInfoSche = filterInfo.getFilterItem("sscid.name");
        if (itemInfoComm == null && itemInfoSche == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3", (String)"TaskScheduleFormRpt_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isNotAllZero(Integer[] data) {
        boolean isnotAllZero = false;
        for (Integer test : data) {
            if (test == 0) continue;
            isnotAllZero = true;
            break;
        }
        return isnotAllZero;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_taskschedule", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"TaskScheduleFormRpt_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

