/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DateTimeServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.rpt.RptConstant;

public class TaskScheduleParamHelper {
    public static DataSet getTableData(ReportQueryParam param) {
        DataSet dataTask;
        ORM orm = ORM.create();
        String selectField = TaskScheduleParamHelper.getSelectField(param);
        DataSet dataSet = null;
        List<QFilter> filterList = TaskScheduleParamHelper.getFiltersFromReport(param);
        DataSet dataTaskhis = orm.queryDataSet(TaskScheduleParamHelper.class.getName(), "task_taskhistory", selectField, filterList.toArray(new QFilter[0]));
        if (TaskScheduleParamHelper.ifShowToDealData(param)) {
            dataTask = orm.queryDataSet(TaskScheduleParamHelper.class.getName(), "task_task", selectField, filterList.toArray(new QFilter[0]));
        } else {
            filterList.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
            dataTask = orm.queryDataSet(TaskScheduleParamHelper.class.getName(), "task_task", selectField, filterList.toArray(new QFilter[0]));
        }
        dataSet = dataTaskhis.union(dataTask);
        List<String> groupBy = TaskScheduleParamHelper.getGroupBy(param);
        if (groupBy.size() > 0) {
            String[] group = new String[groupBy.size()];
            int i = 0;
            for (String str : groupBy) {
                group[i++] = str;
            }
            String[] field = TaskScheduleParamHelper.transformSelectFiled(selectField);
            dataSet = dataSet.select(field).groupBy(group).sum("cast(case when pooltype = '0' then 1 else 0 end as integer)", "todeal").sum("cast(case when pooltype = '1' then 1 else 0 end as integer)", "handling").sum("cast(case when pooltype = '2' then 1 else 0 end as integer)", "completed").finish();
            dataSet = dataSet.where("todeal+handling+completed>0");
            String[] field2 = TaskScheduleParamHelper.getSelectFiledList(dataSet);
            String[] orderBy = TaskScheduleParamHelper.getOrderBy(selectField);
            return dataSet.select(field2).orderBy(orderBy);
        }
        return dataSet;
    }

    public static DataSet getTaskDataByPoolType(ReportQueryParam param, int pooltype, QFilter[] filterArr) {
        ORM orm = ORM.create();
        DataSet dataSet = null;
        QFilter[] filters = TaskScheduleParamHelper.getFilters(param, filterArr);
        if (pooltype == 0) {
            String selectField = "id,pooltype,createtime";
            dataSet = orm.queryDataSet("ssc.task.taskscheduleQueryPlugin.getTask", "task_task", selectField, filters);
        } else if (pooltype == 1) {
            String selectField = "id,pooltype,receivetime";
            dataSet = orm.queryDataSet("ssc.task.taskscheduleQueryPlugin.getTask", "task_task", selectField, filters);
        } else if (pooltype == 2) {
            String selectField = "id,pooltype,completetime";
            dataSet = orm.queryDataSet("ssc.task.taskscheduleQueryPlugin.getHisTask", "task_taskhistory", selectField, filters);
        }
        return dataSet;
    }

    public static List<Map<String, Integer>> getPieChartData(ReportQueryParam param) {
        ORM orm = ORM.create();
        String selectField = TaskScheduleParamHelper.getSelectField(param);
        ArrayList<Map<String, Integer>> result = new ArrayList<Map<String, Integer>>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        QFilter[] filterTodeal = TaskScheduleParamHelper.getFilters(param, new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue()));
        DataSet dataTaskto = orm.queryDataSet("ssc.task.taskscheduleQueryPlugin.getTask", "task_task", selectField, filterTodeal);
        map.put("pooltype", 0);
        map.put("num", TaskScheduleParamHelper.getCount(dataTaskto));
        result.add(map);
        QFilter[] filterHandling = TaskScheduleParamHelper.getFilters(param, new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
        DataSet dataTaskHandling = orm.queryDataSet("ssc.task.taskscheduleQueryPlugin.getTask", "task_task", selectField, filterHandling);
        map = new HashMap();
        map.put("pooltype", 1);
        map.put("num", TaskScheduleParamHelper.getCount(dataTaskHandling));
        result.add(map);
        QFilter[] filterHis = TaskScheduleParamHelper.getFilters(param, new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue()));
        DataSet dataTaskHis = orm.queryDataSet("ssc.task.taskscheduleQueryPlugin.getHisTask", "task_taskhistory", selectField, filterHis);
        map = new HashMap();
        map.put("pooltype", 2);
        map.put("num", TaskScheduleParamHelper.getCount(dataTaskHis));
        result.add(map);
        return result;
    }

    private static int getCount(DataSet dataSet) {
        int count = 0;
        for (Row row : dataSet) {
            if (row.getString("pooltype") == null) continue;
            ++count;
        }
        dataSet.close();
        return count;
    }

    private static String getSelectField(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        StringBuilder sb = new StringBuilder("pooltype,");
        FilterItemInfo itemInfo = filterInfo.getFilterItem("selectcolumn");
        if (itemInfo != null) {
            List values = new ArrayList<String>();
            if ("in".equals(itemInfo.getCompareType().toLowerCase())) {
                values = (List)itemInfo.getValue();
            } else {
                values.add((String)itemInfo.getValue());
            }
            for (String str : values) {
                if ("handler".equals(str) || "all".equals(str)) {
                    sb.append("personid.id userid,");
                }
                if ("billtype".equals(str) || "all".equals(str)) {
                    sb.append("billtype.id,billtype.name billname,");
                }
                if ("tasktype".equals(str) || "all".equals(str)) {
                    sb.append("tasktypeid.id,tasktypeid.name tasktype,");
                }
                if (!"orgname".equals(str) && !"all".equals(str)) continue;
                sb.append("orgid.id,orgid.name orgname,");
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static List<String> getGroupBy(ReportQueryParam param) {
        ArrayList<String> groupBy = new ArrayList<String>();
        FilterInfo filterInfo = param.getFilter();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("selectcolumn");
        if (itemInfo != null) {
            List values = new ArrayList<String>();
            if ("in".equals(itemInfo.getCompareType().toLowerCase())) {
                values = (List)itemInfo.getValue();
            } else {
                values.add((String)itemInfo.getValue());
            }
            if (values.contains("handler") || values.contains("all")) {
                groupBy.add("userid");
            }
            if (values.contains("orgname") || values.contains("all")) {
                groupBy.add("orgid.id");
                groupBy.add("orgname");
            }
            if (values.contains("billtype") || values.contains("all")) {
                groupBy.add("billtype.id");
                groupBy.add("billname");
            }
            if (values.contains("tasktype") || values.contains("all")) {
                groupBy.add("tasktypeid.id");
                groupBy.add("tasktype");
            }
        }
        return groupBy;
    }

    public static List<AbstractReportColumn> getReportColumn(ReportQueryParam param, List<AbstractReportColumn> columns) {
        FilterInfo filterInfo = param.getFilter();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("selectcolumn");
        if (itemInfo != null) {
            List values = new ArrayList<String>();
            if ("in".equals(itemInfo.getCompareType().toLowerCase())) {
                values = (List)itemInfo.getValue();
            } else {
                values.add((String)itemInfo.getValue());
            }
            if (!values.contains("handler") && !values.contains("all")) {
                AbstractReportColumn column1 = columns.get(0);
                if (column1 instanceof ReportColumnGroup) {
                    columns.remove(column1);
                }
            } else {
                for (int i = 1; i <= 2; ++i) {
                    columns.remove(columns.get(1));
                }
            }
            for (String str : values) {
                if ("billtype".equals(str) || "all".equals(str)) {
                    ReportColumn billName = TaskScheduleParamHelper.createColumn(RptConstant.getBillName(), "billname");
                    columns.add(0, (AbstractReportColumn)billName);
                }
                if (str.equals("tasktype") || "all".equals(str)) {
                    ReportColumn taskType = TaskScheduleParamHelper.createColumn(RptConstant.getTasktypeName(), "tasktype");
                    columns.add(0, (AbstractReportColumn)taskType);
                }
                if (!str.equals("orgname") && !"all".equals(str)) continue;
                ReportColumn orgName = TaskScheduleParamHelper.createColumn(RptConstant.getOrgName(), "orgname");
                columns.add(0, (AbstractReportColumn)orgName);
            }
        }
        return columns;
    }

    private static ReportColumn createColumn(LocaleString caption, String fieldKey) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType("text");
        column.setWidth(new LocaleString("160px"));
        return column;
    }

    public static Integer[] getBarChartData(ReportQueryParam param, String type) {
        DataSet dataSet = null;
        Integer[] data = new Integer[7];
        Date[] dateDevide = TaskScheduleParamHelper.getBarChartDateRange();
        String[] groupBy = new String[]{"pooltype"};
        if (kd.ssc.task.common.TaskPoolTypeEnum.ToBeAllocated.getName().equals(type)) {
            QFilter[] qFilter = new QFilter[]{QFilter.of((String)"pooltype = '0'", (Object[])new Object[0])};
            dataSet = TaskScheduleParamHelper.getTaskDataByPoolType(param, 0, qFilter);
            if (dataSet != null) {
                String[] qFilterDevide = TaskScheduleParamHelper.devideStringFormat("createtime", dateDevide);
                data = TaskScheduleParamHelper.devideDataSetBydateRange(dataSet, groupBy, qFilterDevide);
            }
        } else if (kd.ssc.task.common.TaskPoolTypeEnum.Processing.getName().equals(type)) {
            QFilter[] qFilter = new QFilter[]{QFilter.of((String)"pooltype = '1'", (Object[])new Object[0])};
            dataSet = TaskScheduleParamHelper.getTaskDataByPoolType(param, 1, qFilter);
            if (dataSet != null) {
                String[] qFilterDevide = TaskScheduleParamHelper.devideStringFormat("receivetime", dateDevide);
                data = TaskScheduleParamHelper.devideDataSetBydateRange(dataSet, groupBy, qFilterDevide);
            }
        } else if (kd.ssc.task.common.TaskPoolTypeEnum.Completed.getName().equals(type)) {
            QFilter[] qFilter = new QFilter[]{QFilter.of((String)"pooltype = '2'", (Object[])new Object[0])};
            dataSet = TaskScheduleParamHelper.getTaskDataByPoolType(param, 2, qFilter);
            if (dataSet != null) {
                String[] qFilterDevide = TaskScheduleParamHelper.devideStringFormat("completetime", dateDevide);
                data = TaskScheduleParamHelper.devideDataSetBydateRange(dataSet, groupBy, qFilterDevide);
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                data[i] = 0;
            }
        }
        return data;
    }

    public static Date[] getBarChartDateRange() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date today = DateTimeServiceHelper.addUserTimeZoneDateTime((Date)calendar.getTime(), (int)0, (boolean)true);
        Date day_3 = DateTimeServiceHelper.addUserTimeZoneDateTime((Date)TaskScheduleParamHelper.minusDays(today, -3), (int)0, (boolean)true);
        Date day_7 = DateTimeServiceHelper.addUserTimeZoneDateTime((Date)TaskScheduleParamHelper.minusDays(today, -7), (int)0, (boolean)true);
        Date day_10 = DateTimeServiceHelper.addUserTimeZoneDateTime((Date)TaskScheduleParamHelper.minusDays(today, -10), (int)0, (boolean)true);
        Date day_15 = DateTimeServiceHelper.addUserTimeZoneDateTime((Date)TaskScheduleParamHelper.minusDays(today, -15), (int)0, (boolean)true);
        Date day_20 = DateTimeServiceHelper.addUserTimeZoneDateTime((Date)TaskScheduleParamHelper.minusDays(today, -20), (int)0, (boolean)true);
        Date day_30 = DateTimeServiceHelper.addUserTimeZoneDateTime((Date)TaskScheduleParamHelper.minusDays(today, -30), (int)0, (boolean)true);
        today = DateTimeServiceHelper.addUserTimeZoneDateTime((Date)TaskScheduleParamHelper.minusDays(today, 1), (int)0, (boolean)true);
        Date[] dateDevide = new Date[]{today, day_3, day_7, day_10, day_15, day_20, day_30};
        return dateDevide;
    }

    private static Date minusDays(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    private static Integer[] devideDataSetBydateRange(DataSet dataSet, String[] groupBy, String[] devideRule) {
        dataSet = dataSet.groupBy(groupBy).sum(devideRule[0], "qf1").sum(devideRule[1], "qf2").sum(devideRule[2], "qf3").sum(devideRule[3], "qf4").sum(devideRule[4], "qf5").sum(devideRule[5], "qf6").sum(devideRule[6], "qf7").finish();
        Integer[] data = new Integer[]{0, 0, 0, 0, 0, 0, 0};
        for (Row row : dataSet) {
            Integer[] integerArray = data;
            Integer.valueOf(integerArray[0] + row.getInteger("qf1"));
            integerArray = data;
            Integer.valueOf(integerArray[1] + row.getInteger("qf2"));
            integerArray = data;
            Integer.valueOf(integerArray[2] + row.getInteger("qf3"));
            integerArray = data;
            Integer.valueOf(integerArray[3] + row.getInteger("qf4"));
            integerArray = data;
            Integer.valueOf(integerArray[4] + row.getInteger("qf5"));
            integerArray = data;
            Integer.valueOf(integerArray[5] + row.getInteger("qf6"));
            integerArray = data;
            Integer.valueOf(integerArray[6] + row.getInteger("qf7"));
        }
        return data;
    }

    private static String[] devideStringFormat(String type, Date[] dates) {
        String typeTimeFilter = String.format("cast(year(%s) as integer)*10000+cast(month(%s) as integer)*100+cast(day(%s) as integer)", type, type, type);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String[] qFilterDevide = new String[]{String.format("cast(case when " + typeTimeFilter + " < %s and " + typeTimeFilter + " >= %s then 1 else 0 end as integer)", df.format(dates[0]), df.format(dates[1])), String.format("cast(case when " + typeTimeFilter + " < %s and " + typeTimeFilter + " >= %s then 1 else 0 end as integer)", df.format(dates[1]), df.format(dates[2])), String.format("cast(case when " + typeTimeFilter + " < %s and " + typeTimeFilter + " >= %s then 1 else 0 end as integer)", df.format(dates[2]), df.format(dates[3])), String.format("cast(case when " + typeTimeFilter + " < %s and " + typeTimeFilter + " >= %s then 1 else 0 end as integer)", df.format(dates[3]), df.format(dates[4])), String.format("cast(case when " + typeTimeFilter + " < %s and " + typeTimeFilter + " >= %s then 1 else 0 end as integer)", df.format(dates[4]), df.format(dates[5])), String.format("cast(case when " + typeTimeFilter + " < %s and " + typeTimeFilter + " >= %s then 1 else 0 end as integer)", df.format(dates[5]), df.format(dates[6])), String.format("cast(case when " + typeTimeFilter + " < %s then 1 else 0 end as integer)", df.format(dates[6]))};
        return qFilterDevide;
    }

    static Date[] getQueryDateRange(ReportQueryParam queryParam) {
        Date[] queryDateRange = new Date[2];
        FilterInfo filterInfo = queryParam.getFilter();
        List list = filterInfo.getFilterItems();
        int i = 0;
        for (FilterItemInfo item : list) {
            String propName = item.getPropName();
            if (!"completetime".equals(propName)) continue;
            queryDateRange[i] = item.getDate();
            if (++i < 2) continue;
            break;
        }
        return queryDateRange;
    }

    static DataSet getTableDataFromTempTable(ReportQueryParam param, DateRangeEnum dateType) {
        String selectField = TaskScheduleParamHelper.getSelectField(param);
        selectField = selectField + ",count";
        QFilter filter = QFilter.of((String)"datetype = ?", (Object[])new Object[]{dateType.getValue()});
        if (!TaskScheduleParamHelper.ifShowToDealData(param)) {
            filter.and(new QFilter("pooltype", "!=", (Object)0));
        }
        QFilter[] filters = TaskScheduleParamHelper.getFiltersTemp(param, filter);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ssc.task.taskscheduleQueryPlugin.getTable", (String)"task_progress_statistics", (String)selectField, (QFilter[])filters, null);
        List<String> groupBy = TaskScheduleParamHelper.getGroupBy(param);
        if (groupBy.size() > 0) {
            String[] group = new String[groupBy.size()];
            groupBy.toArray(group);
            String[] selectFields = TaskScheduleParamHelper.transformSelectFiled(selectField);
            dataSet = dataSet.select(selectFields).groupBy(group).sum("case when pooltype = 0 then count else 0 end", "todeal").sum("case when pooltype = 1 then count else 0 end", "handling").sum("case when pooltype = 2 then count else 0 end", "completed").finish();
            dataSet = dataSet.where("todeal+handling+completed>0");
            String[] field2 = TaskScheduleParamHelper.getSelectFiledList(dataSet);
            String[] orderBy = TaskScheduleParamHelper.getOrderBy(selectField);
            return dataSet.select(field2).orderBy(orderBy);
        }
        return null;
    }

    private static String[] transformSelectFiled(String selectField) {
        String[] selected = selectField.split(",");
        ArrayList<String> temp = new ArrayList<String>();
        for (String str : selected) {
            String[] s = str.split(" ");
            if (s.length == 2) {
                temp.add(s[1]);
                continue;
            }
            temp.add(s[0]);
        }
        String[] rtnArray = new String[temp.size()];
        temp.toArray(rtnArray);
        return rtnArray;
    }

    private static String[] getSelectFiledList(DataSet dataSet) {
        ArrayList<String> temp = new ArrayList<String>(10);
        temp.add("(1.0000d*todeal)/(todeal+handling+completed)*100 as todealpercent");
        temp.add("(1.0000d*handling)/(todeal+handling+completed)*100 as handlingpercent");
        temp.add("(1.0000d*completed)/(todeal+handling+completed)*100 as completedpercent");
        for (Field f : dataSet.getRowMeta().getFields()) {
            temp.add(f.getName());
        }
        temp.remove("pooltype");
        String[] rtnArray = new String[temp.size()];
        temp.toArray(rtnArray);
        return rtnArray;
    }

    private static String[] getOrderBy(String selectField) {
        ArrayList<String> orderby = new ArrayList<String>();
        if (selectField.contains("orgname")) {
            orderby.add("orgname");
        }
        if (selectField.contains("tasktype")) {
            orderby.add("tasktype");
        }
        if (selectField.contains("billname")) {
            orderby.add("billname");
        }
        if (selectField.contains("userid")) {
            orderby.add("userid");
        }
        String[] rtnArray = new String[orderby.size()];
        orderby.toArray(rtnArray);
        return rtnArray;
    }

    static Integer[] getBarChartDataFromTempTable(ReportQueryParam param, String type, DateRangeEnum dateType) {
        String selectFields = "statdaterange,count,pooltype";
        String[] groupBy = new String[]{"pooltype"};
        Integer[] data = new Integer[]{0, 0, 0, 0, 0, 0, 0};
        QFilter qFilter = QFilter.of((String)"datetype = ? ", (Object[])new Object[]{dateType.getValue()});
        if (kd.ssc.task.common.TaskPoolTypeEnum.ToBeAllocated.getName().equals(type)) {
            qFilter.and(QFilter.of((String)"pooltype = 0", (Object[])new Object[0]));
        } else if (kd.ssc.task.common.TaskPoolTypeEnum.Processing.getName().equals(type)) {
            qFilter.and(QFilter.of((String)"pooltype = 1", (Object[])new Object[0]));
        } else if (kd.ssc.task.common.TaskPoolTypeEnum.Completed.getName().equals(type)) {
            qFilter.and(QFilter.of((String)"pooltype = 2", (Object[])new Object[0]));
        } else {
            return data;
        }
        QFilter[] filters = TaskScheduleParamHelper.getFiltersTemp(param, qFilter);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ssc.task.taskscheduleQueryPlugin.getBarChart", (String)"task_chart_statistics", (String)selectFields, (QFilter[])filters, null);
        dataSet = dataSet.groupBy(groupBy).sum("case when statdaterange = 0 then count else 0 end", "count0").sum("case when statdaterange = 1 then count else 0 end", "count1").sum("case when statdaterange = 2 then count else 0 end", "count2").sum("case when statdaterange = 3 then count else 0 end", "count3").sum("case when statdaterange = 4 then count else 0 end", "count4").sum("case when statdaterange = 5 then count else 0 end", "count5").sum("case when statdaterange = 6 then count else 0 end", "count6").finish();
        for (Row row : dataSet) {
            Integer[] integerArray = data;
            Integer.valueOf(integerArray[0] + row.getInteger("count0"));
            integerArray = data;
            Integer.valueOf(integerArray[1] + row.getInteger("count1"));
            integerArray = data;
            Integer.valueOf(integerArray[2] + row.getInteger("count2"));
            integerArray = data;
            Integer.valueOf(integerArray[3] + row.getInteger("count3"));
            integerArray = data;
            Integer.valueOf(integerArray[4] + row.getInteger("count4"));
            integerArray = data;
            Integer.valueOf(integerArray[5] + row.getInteger("count5"));
            integerArray = data;
            Integer.valueOf(integerArray[6] + row.getInteger("count6"));
        }
        return data;
    }

    static Map<String, Integer> getChartDataFromTempTable(ReportQueryParam param, DateRangeEnum dateType) {
        Integer[] data = new Integer[]{0, 0, 0};
        QFilter qFilter = QFilter.of((String)"datetype = ? ", (Object[])new Object[]{dateType.getValue()});
        String selectFields = "count,pooltype";
        QFilter[] filters = TaskScheduleParamHelper.getFiltersTemp(param, qFilter);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ssc.task.taskscheduleQueryPlugin.getChart", (String)"task_chart_statistics", (String)selectFields, (QFilter[])filters, (String)"count");
        dataSet = dataSet.groupBy(null).sum("case when pooltype = 0 then count else 0 end", "tobeallocated").sum("case when pooltype = 1 then count else 0 end", "processing").sum("case when pooltype = 2 then count else 0 end", "completed").finish();
        for (Row row : dataSet) {
            Integer[] integerArray = data;
            Integer.valueOf(integerArray[0] + row.getInteger("tobeallocated"));
            integerArray = data;
            Integer.valueOf(integerArray[1] + row.getInteger("processing"));
            integerArray = data;
            Integer.valueOf(integerArray[2] + row.getInteger("completed"));
        }
        int count = data[0] + data[1] + data[2];
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(kd.ssc.task.common.TaskPoolTypeEnum.ToBeAllocated.getName(), data[0]);
        map.put(kd.ssc.task.common.TaskPoolTypeEnum.Processing.getName(), data[1]);
        map.put(kd.ssc.task.common.TaskPoolTypeEnum.Completed.getName(), data[2]);
        map.put("count", count);
        return map;
    }

    private static QFilter[] getFilters(ReportQueryParam param, QFilter ... filterArr) {
        List<QFilter> filterList = TaskScheduleParamHelper.getFiltersFromReport(param);
        filterList.addAll(Arrays.asList(filterArr));
        QFilter[] filters = new QFilter[filterList.size()];
        filterList.toArray(filters);
        return filters;
    }

    private static QFilter[] getFiltersTemp(ReportQueryParam param, QFilter ... filterArr) {
        List<QFilter> filterList = TaskScheduleParamHelper.getFiltersFromReportTemp(param);
        filterList.addAll(Arrays.asList(filterArr));
        QFilter[] filters = new QFilter[filterList.size()];
        filterList.toArray(filters);
        return filters;
    }

    private static List<QFilter> getFiltersFromReport(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        for (FilterItemInfo item : list) {
            String name = item.getPropName();
            if ("selectcolumn".equals(name)) continue;
            String compareType = item.getCompareType();
            String propName = item.getPropName();
            Object value = item.getValue();
            if ("completetime".equals(propName)) {
                filterList.add(new QFilter("createtime", compareType, value));
                continue;
            }
            filterList.add(new QFilter(propName, compareType, value));
        }
        filterList.add(new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
        filterList.add(new QFilter("autoprocess", "=", (Object)"0"));
        return filterList;
    }

    private static List<QFilter> getFiltersFromReportTemp(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        for (FilterItemInfo item : list) {
            String name = item.getPropName();
            if ("selectcolumn".equals(name)) continue;
            String compareType = item.getCompareType();
            String propName = item.getPropName();
            Object value = item.getValue();
            if ("completetime".equals(propName)) continue;
            filterList.add(new QFilter(propName, compareType, value));
        }
        return filterList;
    }

    private static boolean ifShowToDealData(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        List list = filterInfo.getFilterItems();
        for (FilterItemInfo item : list) {
            ArrayList value;
            String name = item.getPropName();
            if (!"selectcolumn".equals(name) || !(value = (ArrayList)item.getValue()).contains("handler") && !value.contains("all")) continue;
            return false;
        }
        return true;
    }
}

