/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartApproval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.smartApproval.enums.AlgriModelNameEnum;
import kd.ssc.task.util.SscLicenseUtil;

public class AlgorithmModeListPlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        SscLicenseUtil.checkFeatureLicense((String)"PRO_SSC_IAA", (PreOpenFormEventArgs)e);
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addBeforePackageDataListener(event -> {
            String name = "";
            String description = "";
            for (DynamicObject row : event.getPageData()) {
                if (AlgriModelNameEnum.UNPASS.getNumber().equals(row.getString("number"))) {
                    name = AlgriModelNameEnum.UNPASS.getBridge().loadKDString();
                    description = ResManager.loadKDString((String)"\u57fa\u4e8e\u8fc7\u53bb12\u4e2a\u6708\u7684\u5ba1\u6838\u4efb\u52a1\u7684\u6570\u636e\u8bad\u7ec3\uff0c\u9884\u6d4b\u5ba1\u6838\u4efb\u52a1\u7684\u901a\u8fc7\u3001\u4e0d\u901a\u8fc7\u4ee5\u53ca\u5bf9\u5e94\u6982\u7387\uff0c\u5e76\u4e14\u7ed9\u4e0e\u5ba1\u6838\u7ed3\u679c\u63a8\u8350\u3002\u540c\u65f6\uff0c\u672c\u7b97\u6cd5\u8fd8\u4f1a\u63a8\u8350\u5e76\u5c55\u793a\u9884\u6d4b\u6bcf\u4e00\u6761\u4efb\u52a1\u7684\u89e3\u6790\u8fc7\u7a0b\u548c\u5386\u53f2\u76f8\u4f3c\u5ba1\u6838\u4efb\u52a1\u4f9b\u5ba1\u6838\u4eba\u5458\u53c2\u8003\u3002", (String)"TaskDataUploadHelper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                } else if (AlgriModelNameEnum.WITHDRAWAL.getNumber().equals(row.getString("number"))) {
                    name = AlgriModelNameEnum.WITHDRAWAL.getBridge().loadKDString();
                    description = ResManager.loadKDString((String)"\u57fa\u4e8e\u8fc7\u53bb12\u4e2a\u6708\u7684\u5ba1\u6838\u4efb\u52a1\u6570\u636e\u8bad\u7ec3\uff0c\u5982\u679c\u5ba1\u6838\u4efb\u52a1\u9884\u6d4b\u7ed3\u679c\u4e3a\u201c\u4e0d\u901a\u8fc7\u201d\u5219\u4f1a\u6839\u636e\u591a\u9879\u76f8\u5173\u56e0\u7d20\u9884\u6d4b\u5e76\u63a8\u8350\u6982\u7387\u6700\u9ad8\u7684\u201c\u6279\u9000\u539f\u56e0\u201d\u9009\u9879\u3002", (String)"TaskDataUploadHelper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                } else if (AlgriModelNameEnum.OPERATION.getNumber().equals(row.getString("number"))) {
                    name = AlgriModelNameEnum.OPERATION.getBridge().loadKDString();
                    description = ResManager.loadKDString((String)"\u57fa\u4e8e\u8fc7\u53bb12\u4e2a\u6708\u7684\u5ba1\u6838\u4efb\u52a1\u6570\u636e\u8bad\u7ec3\uff0c\u672c\u7b97\u6cd5\u5c06\u6839\u636e\u9884\u6d4b\u7684\u5ba1\u6838\u7ed3\u679c\uff08\u901a\u8fc7/\u4e0d\u901a\u8fc7\uff09\u548c\u5176\u4ed6\u76f8\u5173\u56e0\u7d20\u63a8\u8350\u6bcf\u6761\u5ba1\u6838\u4efb\u52a1\u9ed8\u8ba4\u7684\u5ba1\u6279\u201c\u64cd\u4f5c\u7c7b\u578b\u201d\u9009\u9879\u3002", (String)"TaskDataUploadHelper_5", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                } else if (AlgriModelNameEnum.BREAKRULE.getNumber().equals(row.getString("number"))) {
                    name = AlgriModelNameEnum.BREAKRULE.getBridge().loadKDString();
                    description = ResManager.loadKDString((String)"\u57fa\u4e8e\u8fc7\u53bb12\u4e2a\u6708\u7684\u5ba1\u6838\u4efb\u52a1\u6570\u636e\u8bad\u7ec3\uff0c\u5982\u679c\u5ba1\u6838\u4efb\u52a1\u9884\u6d4b\u7ed3\u679c\u4e3a\u201c\u901a\u8fc7\u201d\u5219\u4f1a\u6839\u636e\u591a\u9879\u76f8\u5173\u56e0\u7d20\u9884\u6d4b\u5e76\u63a8\u8350\u6982\u7387\u6700\u9ad8\u7684\u201c\u4fe1\u7528\u6263\u5206\u9879\u201d\u9009\u9879\u3002", (String)"TaskDataUploadHelper_7", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                }
                row.set("name", (Object)name);
                row.set("description", (Object)description);
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        List<Long> lastTrainModeId = this.getLastTrainModIds();
        e.getQFilters().add(new QFilter("id", "in", lastTrainModeId));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String opKey = ((Donothing)source).getOperateKey();
            if ("config".equals(opKey)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("task_mapping_setting");
                showParameter.getOpenStyle().setTargetKey("tabap");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            } else if ("detail".equals(opKey)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("task_algri_mode_detail");
                showParameter.getOpenStyle().setTargetKey("tabap");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String number = ((Donothing)source).getListFocusRow().getNumber();
                AlgriModelNameEnum nameEnum = AlgriModelNameEnum.getByNumber((String)number);
                if (nameEnum != null) {
                    showParameter.setCaption(nameEnum.getBridge().loadKDString());
                }
                showParameter.setCustomParam("number", (Object)number);
                this.getView().showForm(showParameter);
            } else if ("syncdata".equals(opKey)) {
                this.syncApprovalInfoFromHisTask();
            }
        }
    }

    private void syncApprovalInfoFromHisTask() {
        DynamicObject[] approvalResults = BusinessDataServiceHelper.load((String)"task_approval_result", (String)"taskid,subject,billnumber,predictpass,breakrule,operation,withdrawal,realpass,realbreakrule,realoperation,realwithdrawal,realpredictresult,breakrulepredictresult,operationpredictresult,withdrawalpredictresult,newrealbreakrule,newrealwithdrawal", (QFilter[])new QFilter("realpass", "!=", (Object)" ").and(new QFilter("billnumber", "=", (Object)" ")).toArray(), null, (int)2000);
        if (approvalResults.length == 0) {
            this.getView().showSuccessNotification("There is no approval result need to be synchronized.");
            return;
        }
        Set taskIds = Arrays.stream(approvalResults).map(e -> e.getLong("taskid")).collect(Collectors.toSet());
        DynamicObjectCollection taskHis = QueryServiceHelper.query((String)"task_taskhistory", (String)"sourcetaskid,subject,billnumber", (QFilter[])new QFilter("sourcetaskid", "in", taskIds).toArray());
        Map<Long, DynamicObject> id2HisTask = taskHis.stream().collect(Collectors.toMap(e -> e.getLong("sourcetaskid"), e -> e, (a, b) -> a));
        ArrayList<DynamicObject> toBeUpdated = new ArrayList<DynamicObject>(approvalResults.length);
        for (DynamicObject approvalRes : approvalResults) {
            try {
                long id;
                DynamicObject hisTask = id2HisTask.get(approvalRes.getLong("taskid"));
                if (hisTask == null) continue;
                approvalRes.set("billnumber", (Object)hisTask.getString("billnumber"));
                approvalRes.set("subject", (Object)hisTask.getString("subject"));
                if ("1".equals(approvalRes.getString("realpass"))) {
                    approvalRes.set("realpredictresult", (Object)("1".equals(approvalRes.getString("predictpass")) ? "1" : "0"));
                    DynamicObjectCollection newrealbreakrule = approvalRes.getDynamicObjectCollection("newrealbreakrule");
                    if (newrealbreakrule.isEmpty()) {
                        approvalRes.set("breakrulepredictresult", (Object)"1");
                    } else {
                        String breakRulePredictRes = "0";
                        for (DynamicObject dynamicObject : newrealbreakrule) {
                            id = dynamicObject.getLong("fbasedataid_id");
                            if (!approvalRes.getString("breakrule").contains("\"" + id + "\"")) continue;
                            breakRulePredictRes = "1";
                            break;
                        }
                        approvalRes.set("breakrulepredictresult", (Object)breakRulePredictRes);
                    }
                } else if ("0".equals(approvalRes.getString("realpass"))) {
                    approvalRes.set("realpredictresult", (Object)("0".equals(approvalRes.getString("predictpass")) ? "1" : "0"));
                    DynamicObjectCollection newrealwithdrawal = approvalRes.getDynamicObjectCollection("newrealwithdrawal");
                    if (newrealwithdrawal.isEmpty()) {
                        approvalRes.set("withdrawalpredictresult", (Object)"1");
                    } else {
                        String withdrawalPredictRes = "0";
                        for (DynamicObject dynamicObject : newrealwithdrawal) {
                            id = dynamicObject.getLong("fbasedataid_id");
                            if (!approvalRes.getString("withdrawal").contains("\"" + id + "\"")) continue;
                            withdrawalPredictRes = "1";
                            break;
                        }
                        approvalRes.set("withdrawalpredictresult", (Object)withdrawalPredictRes);
                    }
                    String operation = approvalRes.getString("realoperation");
                    if (StringUtils.isBlank((CharSequence)operation) || approvalRes.getString("operation").contains("\"" + operation + "\"")) {
                        approvalRes.set("operationpredictresult", (Object)"1");
                    } else {
                        approvalRes.set("operationpredictresult", (Object)"0");
                    }
                }
                toBeUpdated.add(approvalRes);
            }
            catch (Exception e2) {
                this.getView().showTipNotification(String.format("Error on sync approval data, %s", e2.getMessage()));
            }
        }
        SaveServiceHelper.update((DynamicObject[])toBeUpdated.toArray(new DynamicObject[0]));
        this.getView().showSuccessNotification(String.format("%s rows have been synchronized.", toBeUpdated.size()));
    }

    private List<Long> getLastTrainModIds() {
        List<String> modelNumber = Arrays.asList("'" + AlgriModelNameEnum.UNPASS.getNumber() + "'", "'" + AlgriModelNameEnum.WITHDRAWAL.getNumber() + "'", "'" + AlgriModelNameEnum.BREAKRULE.getNumber() + "'", "'" + AlgriModelNameEnum.OPERATION.getNumber() + "'");
        ArrayList<Long> ids = new ArrayList<Long>(4);
        String sql = "select max(fid) as mid,fnumber from t_tk_approve_algorithm where fnumber in (" + StringUtils.join((Object[])modelNumber.toArray(new String[0]), (String)",") + ") group by fnumber";
        try (DataSet dt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"ssc"), (String)sql);){
            for (Row row : dt) {
                ids.add(row.getLong("mid"));
            }
        }
        return ids;
    }
}

